//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// ObjectDataTypesServer is a fake server for instances of the armautomation.ObjectDataTypesClient type.
type ObjectDataTypesServer struct {
	// NewListFieldsByModuleAndTypePager is the fake for method ObjectDataTypesClient.NewListFieldsByModuleAndTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFieldsByModuleAndTypePager func(resourceGroupName string, automationAccountName string, moduleName string, typeName string, options *armautomation.ObjectDataTypesClientListFieldsByModuleAndTypeOptions) (resp azfake.PagerResponder[armautomation.ObjectDataTypesClientListFieldsByModuleAndTypeResponse])

	// NewListFieldsByTypePager is the fake for method ObjectDataTypesClient.NewListFieldsByTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFieldsByTypePager func(resourceGroupName string, automationAccountName string, typeName string, options *armautomation.ObjectDataTypesClientListFieldsByTypeOptions) (resp azfake.PagerResponder[armautomation.ObjectDataTypesClientListFieldsByTypeResponse])
}

// NewObjectDataTypesServerTransport creates a new instance of ObjectDataTypesServerTransport with the provided implementation.
// The returned ObjectDataTypesServerTransport instance is connected to an instance of armautomation.ObjectDataTypesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewObjectDataTypesServerTransport(srv *ObjectDataTypesServer) *ObjectDataTypesServerTransport {
	return &ObjectDataTypesServerTransport{
		srv:                               srv,
		newListFieldsByModuleAndTypePager: newTracker[azfake.PagerResponder[armautomation.ObjectDataTypesClientListFieldsByModuleAndTypeResponse]](),
		newListFieldsByTypePager:          newTracker[azfake.PagerResponder[armautomation.ObjectDataTypesClientListFieldsByTypeResponse]](),
	}
}

// ObjectDataTypesServerTransport connects instances of armautomation.ObjectDataTypesClient to instances of ObjectDataTypesServer.
// Don't use this type directly, use NewObjectDataTypesServerTransport instead.
type ObjectDataTypesServerTransport struct {
	srv                               *ObjectDataTypesServer
	newListFieldsByModuleAndTypePager *tracker[azfake.PagerResponder[armautomation.ObjectDataTypesClientListFieldsByModuleAndTypeResponse]]
	newListFieldsByTypePager          *tracker[azfake.PagerResponder[armautomation.ObjectDataTypesClientListFieldsByTypeResponse]]
}

// Do implements the policy.Transporter interface for ObjectDataTypesServerTransport.
func (o *ObjectDataTypesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ObjectDataTypesClient.NewListFieldsByModuleAndTypePager":
		resp, err = o.dispatchNewListFieldsByModuleAndTypePager(req)
	case "ObjectDataTypesClient.NewListFieldsByTypePager":
		resp, err = o.dispatchNewListFieldsByTypePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *ObjectDataTypesServerTransport) dispatchNewListFieldsByModuleAndTypePager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListFieldsByModuleAndTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFieldsByModuleAndTypePager not implemented")}
	}
	newListFieldsByModuleAndTypePager := o.newListFieldsByModuleAndTypePager.get(req)
	if newListFieldsByModuleAndTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules/(?P<moduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/objectDataTypes/(?P<typeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fields`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		moduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moduleName")])
		if err != nil {
			return nil, err
		}
		typeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("typeName")])
		if err != nil {
			return nil, err
		}
		resp := o.srv.NewListFieldsByModuleAndTypePager(resourceGroupNameParam, automationAccountNameParam, moduleNameParam, typeNameParam, nil)
		newListFieldsByModuleAndTypePager = &resp
		o.newListFieldsByModuleAndTypePager.add(req, newListFieldsByModuleAndTypePager)
	}
	resp, err := server.PagerResponderNext(newListFieldsByModuleAndTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListFieldsByModuleAndTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFieldsByModuleAndTypePager) {
		o.newListFieldsByModuleAndTypePager.remove(req)
	}
	return resp, nil
}

func (o *ObjectDataTypesServerTransport) dispatchNewListFieldsByTypePager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListFieldsByTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFieldsByTypePager not implemented")}
	}
	newListFieldsByTypePager := o.newListFieldsByTypePager.get(req)
	if newListFieldsByTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/objectDataTypes/(?P<typeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fields`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		typeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("typeName")])
		if err != nil {
			return nil, err
		}
		resp := o.srv.NewListFieldsByTypePager(resourceGroupNameParam, automationAccountNameParam, typeNameParam, nil)
		newListFieldsByTypePager = &resp
		o.newListFieldsByTypePager.add(req, newListFieldsByTypePager)
	}
	resp, err := server.PagerResponderNext(newListFieldsByTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListFieldsByTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFieldsByTypePager) {
		o.newListFieldsByTypePager.remove(req)
	}
	return resp, nil
}
