//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteConnectionType.json
func ExampleConnectionTypeClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewConnectionTypeClient().Delete(ctx, "rg", "myAutomationAccount22", "myCT", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getConnectionType.json
func ExampleConnectionTypeClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectionTypeClient().Get(ctx, "rg", "myAutomationAccount22", "myCT", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectionType = armautomation.ConnectionType{
	// 	Name: to.Ptr("myCT"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount22/connectionTypes/myCT"),
	// 	Properties: &armautomation.ConnectionTypeProperties{
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T03:47:53.433Z"); return t}()),
	// 		FieldDefinitions: map[string]*armautomation.FieldDefinition{
	// 			"myBoolField": &armautomation.FieldDefinition{
	// 				Type: to.Ptr("bool"),
	// 				IsEncrypted: to.Ptr(false),
	// 				IsOptional: to.Ptr(false),
	// 			},
	// 			"myStringField": &armautomation.FieldDefinition{
	// 				Type: to.Ptr("string"),
	// 				IsEncrypted: to.Ptr(false),
	// 				IsOptional: to.Ptr(false),
	// 			},
	// 			"myStringFieldEncrypted": &armautomation.FieldDefinition{
	// 				Type: to.Ptr("string"),
	// 				IsEncrypted: to.Ptr(true),
	// 				IsOptional: to.Ptr(false),
	// 			},
	// 		},
	// 		IsGlobal: to.Ptr(false),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T03:47:53.557Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/createOrUpdateConnectionType.json
func ExampleConnectionTypeClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewConnectionTypeClient().CreateOrUpdate(ctx, "rg", "myAutomationAccount22", "myCT", armautomation.ConnectionTypeCreateOrUpdateParameters{
		Name: to.Ptr("myCT"),
		Properties: &armautomation.ConnectionTypeCreateOrUpdateProperties{
			FieldDefinitions: map[string]*armautomation.FieldDefinition{
				"myBoolField": {
					Type:        to.Ptr("bool"),
					IsEncrypted: to.Ptr(false),
					IsOptional:  to.Ptr(false),
				},
				"myStringField": {
					Type:        to.Ptr("string"),
					IsEncrypted: to.Ptr(false),
					IsOptional:  to.Ptr(false),
				},
				"myStringFieldEncrypted": {
					Type:        to.Ptr("string"),
					IsEncrypted: to.Ptr(true),
					IsOptional:  to.Ptr(false),
				},
			},
			IsGlobal: to.Ptr(false),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getAllConnectionTypes_First100.json
func ExampleConnectionTypeClient_NewListByAutomationAccountPager_getConnectionTypesFirst100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConnectionTypeClient().NewListByAutomationAccountPager("rg", "myAutomationAccount25", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectionTypeListResult = armautomation.ConnectionTypeListResult{
		// 	Value: []*armautomation.ConnectionType{
		// 		{
		// 			Name: to.Ptr("Azure"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/Azure"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2014-03-18T23:02:40.613Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"AutomationCertificateName": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"SubscriptionID": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2014-03-18T23:02:40.740Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzureClassicCertificate"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/AzureClassicCertificate"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-04-25T23:54:02.650Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"CertificateAssetName": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"SubscriptionId": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"SubscriptionName": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-04-25T23:54:03.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzureServicePrincipal"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/AzureServicePrincipal"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-03-16T23:08:41.853Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"ApplicationId": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"CertificateThumbprint": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"SubscriptionId": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"TenantId": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("System.String"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-03-16T23:08:42.407Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:14.430Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:14.510Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT0"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT0"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:14.837Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:14.853Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT1"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT1"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.040Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.057Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT10"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT10"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.120Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.150Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT100"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT100"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.730Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.760Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT101"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT101"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.963Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.993Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT102"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT102"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.197Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.213Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT103"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT103"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.417Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT104"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT104"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.633Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.650Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT105"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT105"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.837Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:37.883Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT106"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT106"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.073Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.087Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT107"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT107"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.277Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.290Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT108"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT108"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.493Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.510Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT109"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT109"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.697Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.713Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT11"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT11"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.337Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.383Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT110"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT110"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.930Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:38.947Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT111"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT111"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.150Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT112"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT112"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.353Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT113"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT113"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.557Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.573Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT114"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT114"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.777Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.790Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT115"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT115"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.980Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:39.993Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT116"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT116"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.180Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.197Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT117"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT117"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.417Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT118"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT118"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.633Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.650Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT119"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT119"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.837Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:40.853Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT12"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT12"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.587Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.603Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT120"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT120"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.040Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.057Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT121"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT121"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.260Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.277Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT122"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT122"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.480Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.557Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT123"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT123"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.743Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.760Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT124"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT124"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.947Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:41.963Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT125"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT125"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.180Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.197Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT126"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT126"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.383Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.400Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT127"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT127"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.603Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT128"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT128"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.823Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:42.837Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT129"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT129"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.027Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.040Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT13"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT13"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.790Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.807Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT130"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT130"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.243Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.260Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT131"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT131"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.447Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.463Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT132"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT132"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.650Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.667Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT133"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT133"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.870Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:43.887Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT134"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT134"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.073Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.087Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT135"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT135"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.290Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.307Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT136"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT136"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.493Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.510Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT137"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT137"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.760Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:44.807Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT138"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT138"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.010Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.027Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT139"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT139"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.213Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.230Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT14"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT14"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:17.993Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.010Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT140"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT140"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.433Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.463Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT141"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT141"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.650Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.667Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT142"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT142"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.883Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:45.917Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT143"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT143"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.103Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.133Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT144"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT144"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.340Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT145"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT145"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.540Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.557Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT146"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT146"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.760Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.777Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT147"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT147"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.963Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:46.980Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT148"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT148"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.197Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.213Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT149"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT149"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.417Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT15"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT15"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.213Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.227Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT150"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT150"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.637Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.650Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT151"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT151"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.853Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:47.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT152"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT152"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.103Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT153"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT153"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.370Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.400Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT154"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT154"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.590Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.667Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT155"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT155"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.887Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:48.930Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT156"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT156"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.120Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT157"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT157"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.370Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.400Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT158"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT158"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.603Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.637Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT159"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT159"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.840Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:49.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT16"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT16"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.417Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT160"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT160"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.090Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.103Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT161"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT161"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.290Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.307Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT162"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT162"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.493Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.510Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT163"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT163"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.697Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.713Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT164"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT164"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.917Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:50.933Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT165"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT165"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.120Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.137Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT166"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT166"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.340Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT167"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT167"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.540Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.557Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT168"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT168"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.743Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.760Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT169"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT169"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.980Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:51.980Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT17"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT17"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.620Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.633Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT170"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT170"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.213Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.230Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT171"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT171"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.417Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.433Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT172"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT172"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.637Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.650Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT173"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT173"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.840Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:52.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT174"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT174"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:53.057Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:53.073Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT175"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT175"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:53.260Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:53.290Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT18"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT18"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.820Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:18.837Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT19"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT19"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.040Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.057Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT2"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT2"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.260Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.273Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT20"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT20"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.243Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.260Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT21"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT21"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.463Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.477Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT22"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT22"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.667Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.680Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT23"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT23"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.883Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:19.900Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT24"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT24"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.103Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.120Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT25"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT25"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.400Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.417Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT26"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT26"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.650Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.667Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getAllConnectionTypes_Next100.json
func ExampleConnectionTypeClient_NewListByAutomationAccountPager_getConnectionTypesNext100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConnectionTypeClient().NewListByAutomationAccountPager("rg", "myAutomationAccount25", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectionTypeListResult = armautomation.ConnectionTypeListResult{
		// 	Value: []*armautomation.ConnectionType{
		// 		{
		// 			Name: to.Ptr("myCT27"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT27"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.870Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:20.883Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT28"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT28"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.070Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.087Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT29"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT29"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.290Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.307Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT3"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT3"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.477Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.493Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT30"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT30"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.523Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.540Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT31"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT31"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.727Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.743Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT32"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT32"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.930Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:21.947Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT33"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT33"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.133Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.150Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT34"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT34"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.353Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT35"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT35"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.570Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.587Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT36"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT36"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.773Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.790Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT37"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT37"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.977Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:22.993Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT38"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT38"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.197Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.213Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT39"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT39"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.417Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.447Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT4"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT4"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.680Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.697Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT40"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT40"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.633Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.650Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT41"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT41"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.853Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:23.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT42"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT42"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.057Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.070Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT43"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT43"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.260Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.273Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT44"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT44"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.477Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.493Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT45"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT45"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.680Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.697Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT46"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT46"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.883Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:24.900Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT47"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT47"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.103Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.120Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT48"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT48"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.307Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.320Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT49"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT49"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.523Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.540Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT5"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT5"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.900Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:15.917Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT50"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT50"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.727Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.743Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT51"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT51"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.930Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:25.947Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT52"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT52"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.133Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT53"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT53"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.353Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT54"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT54"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.570Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.587Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT55"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT55"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.773Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.790Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT56"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT56"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.977Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:26.993Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT57"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT57"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.197Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.213Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT58"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT58"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.477Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.493Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT59"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT59"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.680Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.697Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT6"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT6"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.133Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT60"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT60"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.917Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:27.947Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT61"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT61"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.133Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.150Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT62"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT62"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.337Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT63"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT63"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.587Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.587Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT64"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT64"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.790Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.807Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT65"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT65"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:28.993Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.010Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT66"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT66"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.197Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.213Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT67"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT67"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.417Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.463Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT68"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT68"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.650Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.697Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT69"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT69"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.883Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:29.900Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT7"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT7"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.400Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.447Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT70"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT70"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.087Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.120Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT71"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT71"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.320Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT72"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT72"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.557Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.570Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT73"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT73"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.773Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.790Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT74"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT74"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.980Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:30.980Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT75"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT75"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.180Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.200Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT76"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT76"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.383Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.400Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT77"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT77"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.587Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT78"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT78"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.837Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:31.853Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT79"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT79"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.057Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.057Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT8"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT8"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.633Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.680Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT80"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT80"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.260Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.277Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT81"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT81"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.493Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.510Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT82"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT82"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.730Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.743Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT83"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT83"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.930Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:32.947Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT84"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT84"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.133Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.197Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT85"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT85"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.400Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.417Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT86"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT86"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.603Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT87"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT87"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.820Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:33.837Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT88"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT88"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.027Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.040Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT89"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT89"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.230Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.243Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT9"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT9"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.883Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:16.917Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT90"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT90"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.430Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.480Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT91"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT91"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.667Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.713Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT92"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT92"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.900Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:34.947Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT93"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT93"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.133Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.150Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT94"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT94"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.370Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.417Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT95"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT95"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.603Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT96"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT96"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.823Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:35.837Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT97"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT97"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.027Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.040Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT98"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT98"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.243Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.290Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCT99"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount25/connectionTypes/myCT99"),
		// 			Properties: &armautomation.ConnectionTypeProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.493Z"); return t}()),
		// 				FieldDefinitions: map[string]*armautomation.FieldDefinition{
		// 					"myBoolField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("bool"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringField": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(false),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 					"myStringFieldEncrypted": &armautomation.FieldDefinition{
		// 						Type: to.Ptr("string"),
		// 						IsEncrypted: to.Ptr(true),
		// 						IsOptional: to.Ptr(false),
		// 					},
		// 				},
		// 				IsGlobal: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T06:25:36.527Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}
