//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armauthorization_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/authorization/resource-manager/Microsoft.Authorization/preview/2021-12-01-preview/examples/PostAccessReviewHistoryDefinitionInstance.json
func ExampleScopeAccessReviewHistoryDefinitionInstanceClient_GenerateDownloadURI() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armauthorization.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScopeAccessReviewHistoryDefinitionInstanceClient().GenerateDownloadURI(ctx, "subscriptions/129a304b-4aea-4b86-a9f7-ba7e2b23737a", "44724910-d7a5-4c29-b28f-db73e717165a", "9038f4f3-3d8d-43c3-8ede-669ea082c43b", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccessReviewHistoryInstance = armauthorization.AccessReviewHistoryInstance{
	// 	Name: to.Ptr("9038f4f3-3d8d-43c3-8ede-669ea082c43b"),
	// 	Type: to.Ptr("Microsoft.Authorization/accessReviewHistoryInstance"),
	// 	ID: to.Ptr("9038f4f3-3d8d-43c3-8ede-669ea082c43b"),
	// 	Properties: &armauthorization.AccessReviewHistoryInstanceProperties{
	// 		DisplayName: to.Ptr("Hello world name"),
	// 		DownloadURI: to.Ptr("https://dfermconsolreportusc.blob.core.windows.net/df-erm-reports/Hello world name-22be232e-a93d-42a3-8ac5-313cfd29a0eb.csv?sv=2015-04-05&ss=b&srt=o&sp=rl&st=2021-03-22T19:39:38.0000000Z&se=2021-03-23T19:41:38.0000000Z&spr=https&sig=84rlGCIgU4ToMn%2FFLncBXq95O8a8RsFlwQY1Knl%2Fo%2FI%3D"),
	// 		Expiration: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-22T00:28:33.690Z"); return t}()),
	// 		FulfilledDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-23T00:28:33.690Z"); return t}()),
	// 		ReviewHistoryPeriodEndDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-01T08:00:00.000Z"); return t}()),
	// 		ReviewHistoryPeriodStartDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T07:00:00.000Z"); return t}()),
	// 		RunDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-23T00:27:33.690Z"); return t}()),
	// 		Status: to.Ptr(armauthorization.AccessReviewHistoryDefinitionStatusRequested),
	// 	},
	// }
}
