//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// StaticSitesServer is a fake server for instances of the armappservice.StaticSitesClient type.
type StaticSitesServer struct {
	// BeginApproveOrRejectPrivateEndpointConnection is the fake for method StaticSitesClient.BeginApproveOrRejectPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginApproveOrRejectPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper armappservice.PrivateLinkConnectionApprovalRequestResource, options *armappservice.StaticSitesClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateBasicAuth is the fake for method StaticSitesClient.CreateOrUpdateBasicAuth
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateBasicAuth func(ctx context.Context, resourceGroupName string, name string, basicAuthName armappservice.BasicAuthName, basicAuthEnvelope armappservice.StaticSiteBasicAuthPropertiesARMResource, options *armappservice.StaticSitesClientCreateOrUpdateBasicAuthOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateOrUpdateBasicAuthResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateBuildDatabaseConnection is the fake for method StaticSitesClient.CreateOrUpdateBuildDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateBuildDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, databaseConnectionRequestEnvelope armappservice.DatabaseConnection, options *armappservice.StaticSitesClientCreateOrUpdateBuildDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateDatabaseConnection is the fake for method StaticSitesClient.CreateOrUpdateDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, databaseConnectionRequestEnvelope armappservice.DatabaseConnection, options *armappservice.StaticSitesClientCreateOrUpdateDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateOrUpdateDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateStaticSite is the fake for method StaticSitesClient.BeginCreateOrUpdateStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdateStaticSite func(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope armappservice.StaticSiteARMResource, options *armappservice.StaticSitesClientBeginCreateOrUpdateStaticSiteOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateStaticSiteAppSettings is the fake for method StaticSitesClient.CreateOrUpdateStaticSiteAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateStaticSiteAppSettings func(ctx context.Context, resourceGroupName string, name string, appSettings armappservice.StringDictionary, options *armappservice.StaticSitesClientCreateOrUpdateStaticSiteAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateStaticSiteBuildAppSettings is the fake for method StaticSitesClient.CreateOrUpdateStaticSiteBuildAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateStaticSiteBuildAppSettings func(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings armappservice.StringDictionary, options *armappservice.StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateStaticSiteBuildFunctionAppSettings is the fake for method StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateStaticSiteBuildFunctionAppSettings func(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings armappservice.StringDictionary, options *armappservice.StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateStaticSiteCustomDomain is the fake for method StaticSitesClient.BeginCreateOrUpdateStaticSiteCustomDomain
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdateStaticSiteCustomDomain func(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope armappservice.StaticSiteCustomDomainRequestPropertiesARMResource, options *armappservice.StaticSitesClientBeginCreateOrUpdateStaticSiteCustomDomainOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateStaticSiteFunctionAppSettings is the fake for method StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateStaticSiteFunctionAppSettings func(ctx context.Context, resourceGroupName string, name string, appSettings armappservice.StringDictionary, options *armappservice.StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse], errResp azfake.ErrorResponder)

	// CreateUserRolesInvitationLink is the fake for method StaticSitesClient.CreateUserRolesInvitationLink
	// HTTP status codes to indicate success: http.StatusOK
	CreateUserRolesInvitationLink func(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope armappservice.StaticSiteUserInvitationRequestResource, options *armappservice.StaticSitesClientCreateUserRolesInvitationLinkOptions) (resp azfake.Responder[armappservice.StaticSitesClientCreateUserRolesInvitationLinkResponse], errResp azfake.ErrorResponder)

	// BeginCreateZipDeploymentForStaticSite is the fake for method StaticSitesClient.BeginCreateZipDeploymentForStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateZipDeploymentForStaticSite func(ctx context.Context, resourceGroupName string, name string, staticSiteZipDeploymentEnvelope armappservice.StaticSiteZipDeploymentARMResource, options *armappservice.StaticSitesClientBeginCreateZipDeploymentForStaticSiteOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientCreateZipDeploymentForStaticSiteResponse], errResp azfake.ErrorResponder)

	// BeginCreateZipDeploymentForStaticSiteBuild is the fake for method StaticSitesClient.BeginCreateZipDeploymentForStaticSiteBuild
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateZipDeploymentForStaticSiteBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, staticSiteZipDeploymentEnvelope armappservice.StaticSiteZipDeploymentARMResource, options *armappservice.StaticSitesClientBeginCreateZipDeploymentForStaticSiteBuildOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse], errResp azfake.ErrorResponder)

	// DeleteBuildDatabaseConnection is the fake for method StaticSitesClient.DeleteBuildDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteBuildDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *armappservice.StaticSitesClientDeleteBuildDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientDeleteBuildDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// DeleteDatabaseConnection is the fake for method StaticSitesClient.DeleteDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *armappservice.StaticSitesClientDeleteDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientDeleteDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// BeginDeletePrivateEndpointConnection is the fake for method StaticSitesClient.BeginDeletePrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *armappservice.StaticSitesClientBeginDeletePrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientDeletePrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// BeginDeleteStaticSite is the fake for method StaticSitesClient.BeginDeleteStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeleteStaticSite func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientBeginDeleteStaticSiteOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteStaticSiteBuild is the fake for method StaticSitesClient.BeginDeleteStaticSiteBuild
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteStaticSiteBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientBeginDeleteStaticSiteBuildOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteBuildResponse], errResp azfake.ErrorResponder)

	// BeginDeleteStaticSiteCustomDomain is the fake for method StaticSitesClient.BeginDeleteStaticSiteCustomDomain
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeleteStaticSiteCustomDomain func(ctx context.Context, resourceGroupName string, name string, domainName string, options *armappservice.StaticSitesClientBeginDeleteStaticSiteCustomDomainOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteCustomDomainResponse], errResp azfake.ErrorResponder)

	// DeleteStaticSiteUser is the fake for method StaticSitesClient.DeleteStaticSiteUser
	// HTTP status codes to indicate success: http.StatusOK
	DeleteStaticSiteUser func(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, options *armappservice.StaticSitesClientDeleteStaticSiteUserOptions) (resp azfake.Responder[armappservice.StaticSitesClientDeleteStaticSiteUserResponse], errResp azfake.ErrorResponder)

	// BeginDetachStaticSite is the fake for method StaticSitesClient.BeginDetachStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDetachStaticSite func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientBeginDetachStaticSiteOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientDetachStaticSiteResponse], errResp azfake.ErrorResponder)

	// DetachUserProvidedFunctionAppFromStaticSite is the fake for method StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DetachUserProvidedFunctionAppFromStaticSite func(ctx context.Context, resourceGroupName string, name string, functionAppName string, options *armappservice.StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteOptions) (resp azfake.Responder[armappservice.StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse], errResp azfake.ErrorResponder)

	// DetachUserProvidedFunctionAppFromStaticSiteBuild is the fake for method StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSiteBuild
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DetachUserProvidedFunctionAppFromStaticSiteBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, options *armappservice.StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildOptions) (resp azfake.Responder[armappservice.StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse], errResp azfake.ErrorResponder)

	// GetBasicAuth is the fake for method StaticSitesClient.GetBasicAuth
	// HTTP status codes to indicate success: http.StatusOK
	GetBasicAuth func(ctx context.Context, resourceGroupName string, name string, basicAuthName armappservice.BasicAuthName, options *armappservice.StaticSitesClientGetBasicAuthOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetBasicAuthResponse], errResp azfake.ErrorResponder)

	// GetBuildDatabaseConnection is the fake for method StaticSitesClient.GetBuildDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetBuildDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *armappservice.StaticSitesClientGetBuildDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetBuildDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// GetBuildDatabaseConnectionWithDetails is the fake for method StaticSitesClient.GetBuildDatabaseConnectionWithDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetBuildDatabaseConnectionWithDetails func(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *armappservice.StaticSitesClientGetBuildDatabaseConnectionWithDetailsOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse], errResp azfake.ErrorResponder)

	// NewGetBuildDatabaseConnectionsPager is the fake for method StaticSitesClient.NewGetBuildDatabaseConnectionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetBuildDatabaseConnectionsPager func(resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientGetBuildDatabaseConnectionsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetBuildDatabaseConnectionsResponse])

	// NewGetBuildDatabaseConnectionsWithDetailsPager is the fake for method StaticSitesClient.NewGetBuildDatabaseConnectionsWithDetailsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetBuildDatabaseConnectionsWithDetailsPager func(resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientGetBuildDatabaseConnectionsWithDetailsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse])

	// GetDatabaseConnection is the fake for method StaticSitesClient.GetDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *armappservice.StaticSitesClientGetDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// GetDatabaseConnectionWithDetails is the fake for method StaticSitesClient.GetDatabaseConnectionWithDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetDatabaseConnectionWithDetails func(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *armappservice.StaticSitesClientGetDatabaseConnectionWithDetailsOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetDatabaseConnectionWithDetailsResponse], errResp azfake.ErrorResponder)

	// NewGetDatabaseConnectionsPager is the fake for method StaticSitesClient.NewGetDatabaseConnectionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetDatabaseConnectionsPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientGetDatabaseConnectionsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetDatabaseConnectionsResponse])

	// NewGetDatabaseConnectionsWithDetailsPager is the fake for method StaticSitesClient.NewGetDatabaseConnectionsWithDetailsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetDatabaseConnectionsWithDetailsPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientGetDatabaseConnectionsWithDetailsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetDatabaseConnectionsWithDetailsResponse])

	// GetLinkedBackend is the fake for method StaticSitesClient.GetLinkedBackend
	// HTTP status codes to indicate success: http.StatusOK
	GetLinkedBackend func(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, options *armappservice.StaticSitesClientGetLinkedBackendOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetLinkedBackendResponse], errResp azfake.ErrorResponder)

	// GetLinkedBackendForBuild is the fake for method StaticSitesClient.GetLinkedBackendForBuild
	// HTTP status codes to indicate success: http.StatusOK
	GetLinkedBackendForBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, options *armappservice.StaticSitesClientGetLinkedBackendForBuildOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetLinkedBackendForBuildResponse], errResp azfake.ErrorResponder)

	// NewGetLinkedBackendsPager is the fake for method StaticSitesClient.NewGetLinkedBackendsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetLinkedBackendsPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientGetLinkedBackendsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetLinkedBackendsResponse])

	// NewGetLinkedBackendsForBuildPager is the fake for method StaticSitesClient.NewGetLinkedBackendsForBuildPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetLinkedBackendsForBuildPager func(resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientGetLinkedBackendsForBuildOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetLinkedBackendsForBuildResponse])

	// GetPrivateEndpointConnection is the fake for method StaticSitesClient.GetPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *armappservice.StaticSitesClientGetPrivateEndpointConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// NewGetPrivateEndpointConnectionListPager is the fake for method StaticSitesClient.NewGetPrivateEndpointConnectionListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetPrivateEndpointConnectionListPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientGetPrivateEndpointConnectionListOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetPrivateEndpointConnectionListResponse])

	// GetPrivateLinkResources is the fake for method StaticSitesClient.GetPrivateLinkResources
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateLinkResources func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientGetPrivateLinkResourcesOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetPrivateLinkResourcesResponse], errResp azfake.ErrorResponder)

	// GetStaticSite is the fake for method StaticSitesClient.GetStaticSite
	// HTTP status codes to indicate success: http.StatusOK
	GetStaticSite func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientGetStaticSiteOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetStaticSiteResponse], errResp azfake.ErrorResponder)

	// GetStaticSiteBuild is the fake for method StaticSitesClient.GetStaticSiteBuild
	// HTTP status codes to indicate success: http.StatusOK
	GetStaticSiteBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientGetStaticSiteBuildOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetStaticSiteBuildResponse], errResp azfake.ErrorResponder)

	// NewGetStaticSiteBuildsPager is the fake for method StaticSitesClient.NewGetStaticSiteBuildsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetStaticSiteBuildsPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientGetStaticSiteBuildsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetStaticSiteBuildsResponse])

	// GetStaticSiteCustomDomain is the fake for method StaticSitesClient.GetStaticSiteCustomDomain
	// HTTP status codes to indicate success: http.StatusOK
	GetStaticSiteCustomDomain func(ctx context.Context, resourceGroupName string, name string, domainName string, options *armappservice.StaticSitesClientGetStaticSiteCustomDomainOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetStaticSiteCustomDomainResponse], errResp azfake.ErrorResponder)

	// NewGetStaticSitesByResourceGroupPager is the fake for method StaticSitesClient.NewGetStaticSitesByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetStaticSitesByResourceGroupPager func(resourceGroupName string, options *armappservice.StaticSitesClientGetStaticSitesByResourceGroupOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetStaticSitesByResourceGroupResponse])

	// GetUserProvidedFunctionAppForStaticSite is the fake for method StaticSitesClient.GetUserProvidedFunctionAppForStaticSite
	// HTTP status codes to indicate success: http.StatusOK
	GetUserProvidedFunctionAppForStaticSite func(ctx context.Context, resourceGroupName string, name string, functionAppName string, options *armappservice.StaticSitesClientGetUserProvidedFunctionAppForStaticSiteOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse], errResp azfake.ErrorResponder)

	// GetUserProvidedFunctionAppForStaticSiteBuild is the fake for method StaticSitesClient.GetUserProvidedFunctionAppForStaticSiteBuild
	// HTTP status codes to indicate success: http.StatusOK
	GetUserProvidedFunctionAppForStaticSiteBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, options *armappservice.StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildOptions) (resp azfake.Responder[armappservice.StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse], errResp azfake.ErrorResponder)

	// NewGetUserProvidedFunctionAppsForStaticSitePager is the fake for method StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSitePager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetUserProvidedFunctionAppsForStaticSitePager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse])

	// NewGetUserProvidedFunctionAppsForStaticSiteBuildPager is the fake for method StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSiteBuildPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetUserProvidedFunctionAppsForStaticSiteBuildPager func(resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse])

	// BeginLinkBackend is the fake for method StaticSitesClient.BeginLinkBackend
	// HTTP status codes to indicate success: http.StatusOK
	BeginLinkBackend func(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope armappservice.StaticSiteLinkedBackendARMResource, options *armappservice.StaticSitesClientBeginLinkBackendOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientLinkBackendResponse], errResp azfake.ErrorResponder)

	// BeginLinkBackendToBuild is the fake for method StaticSitesClient.BeginLinkBackendToBuild
	// HTTP status codes to indicate success: http.StatusOK
	BeginLinkBackendToBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope armappservice.StaticSiteLinkedBackendARMResource, options *armappservice.StaticSitesClientBeginLinkBackendToBuildOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientLinkBackendToBuildResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method StaticSitesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.StaticSitesClientListOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientListResponse])

	// NewListBasicAuthPager is the fake for method StaticSitesClient.NewListBasicAuthPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBasicAuthPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientListBasicAuthOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientListBasicAuthResponse])

	// ListStaticSiteAppSettings is the fake for method StaticSitesClient.ListStaticSiteAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	ListStaticSiteAppSettings func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientListStaticSiteAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientListStaticSiteAppSettingsResponse], errResp azfake.ErrorResponder)

	// ListStaticSiteBuildAppSettings is the fake for method StaticSitesClient.ListStaticSiteBuildAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	ListStaticSiteBuildAppSettings func(ctx context.Context, resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientListStaticSiteBuildAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientListStaticSiteBuildAppSettingsResponse], errResp azfake.ErrorResponder)

	// ListStaticSiteBuildFunctionAppSettings is the fake for method StaticSitesClient.ListStaticSiteBuildFunctionAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	ListStaticSiteBuildFunctionAppSettings func(ctx context.Context, resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientListStaticSiteBuildFunctionAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse], errResp azfake.ErrorResponder)

	// NewListStaticSiteBuildFunctionsPager is the fake for method StaticSitesClient.NewListStaticSiteBuildFunctionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListStaticSiteBuildFunctionsPager func(resourceGroupName string, name string, environmentName string, options *armappservice.StaticSitesClientListStaticSiteBuildFunctionsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteBuildFunctionsResponse])

	// ListStaticSiteConfiguredRoles is the fake for method StaticSitesClient.ListStaticSiteConfiguredRoles
	// HTTP status codes to indicate success: http.StatusOK
	ListStaticSiteConfiguredRoles func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientListStaticSiteConfiguredRolesOptions) (resp azfake.Responder[armappservice.StaticSitesClientListStaticSiteConfiguredRolesResponse], errResp azfake.ErrorResponder)

	// NewListStaticSiteCustomDomainsPager is the fake for method StaticSitesClient.NewListStaticSiteCustomDomainsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListStaticSiteCustomDomainsPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientListStaticSiteCustomDomainsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteCustomDomainsResponse])

	// ListStaticSiteFunctionAppSettings is the fake for method StaticSitesClient.ListStaticSiteFunctionAppSettings
	// HTTP status codes to indicate success: http.StatusOK
	ListStaticSiteFunctionAppSettings func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientListStaticSiteFunctionAppSettingsOptions) (resp azfake.Responder[armappservice.StaticSitesClientListStaticSiteFunctionAppSettingsResponse], errResp azfake.ErrorResponder)

	// NewListStaticSiteFunctionsPager is the fake for method StaticSitesClient.NewListStaticSiteFunctionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListStaticSiteFunctionsPager func(resourceGroupName string, name string, options *armappservice.StaticSitesClientListStaticSiteFunctionsOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteFunctionsResponse])

	// ListStaticSiteSecrets is the fake for method StaticSitesClient.ListStaticSiteSecrets
	// HTTP status codes to indicate success: http.StatusOK
	ListStaticSiteSecrets func(ctx context.Context, resourceGroupName string, name string, options *armappservice.StaticSitesClientListStaticSiteSecretsOptions) (resp azfake.Responder[armappservice.StaticSitesClientListStaticSiteSecretsResponse], errResp azfake.ErrorResponder)

	// NewListStaticSiteUsersPager is the fake for method StaticSitesClient.NewListStaticSiteUsersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListStaticSiteUsersPager func(resourceGroupName string, name string, authprovider string, options *armappservice.StaticSitesClientListStaticSiteUsersOptions) (resp azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteUsersResponse])

	// PreviewWorkflow is the fake for method StaticSitesClient.PreviewWorkflow
	// HTTP status codes to indicate success: http.StatusOK
	PreviewWorkflow func(ctx context.Context, location string, staticSitesWorkflowPreviewRequest armappservice.StaticSitesWorkflowPreviewRequest, options *armappservice.StaticSitesClientPreviewWorkflowOptions) (resp azfake.Responder[armappservice.StaticSitesClientPreviewWorkflowResponse], errResp azfake.ErrorResponder)

	// BeginRegisterUserProvidedFunctionAppWithStaticSite is the fake for method StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRegisterUserProvidedFunctionAppWithStaticSite func(ctx context.Context, resourceGroupName string, name string, functionAppName string, staticSiteUserProvidedFunctionEnvelope armappservice.StaticSiteUserProvidedFunctionAppARMResource, options *armappservice.StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse], errResp azfake.ErrorResponder)

	// BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild is the fake for method StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, staticSiteUserProvidedFunctionEnvelope armappservice.StaticSiteUserProvidedFunctionAppARMResource, options *armappservice.StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse], errResp azfake.ErrorResponder)

	// ResetStaticSiteAPIKey is the fake for method StaticSitesClient.ResetStaticSiteAPIKey
	// HTTP status codes to indicate success: http.StatusOK
	ResetStaticSiteAPIKey func(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope armappservice.StaticSiteResetPropertiesARMResource, options *armappservice.StaticSitesClientResetStaticSiteAPIKeyOptions) (resp azfake.Responder[armappservice.StaticSitesClientResetStaticSiteAPIKeyResponse], errResp azfake.ErrorResponder)

	// UnlinkBackend is the fake for method StaticSitesClient.UnlinkBackend
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	UnlinkBackend func(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, options *armappservice.StaticSitesClientUnlinkBackendOptions) (resp azfake.Responder[armappservice.StaticSitesClientUnlinkBackendResponse], errResp azfake.ErrorResponder)

	// UnlinkBackendFromBuild is the fake for method StaticSitesClient.UnlinkBackendFromBuild
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	UnlinkBackendFromBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, options *armappservice.StaticSitesClientUnlinkBackendFromBuildOptions) (resp azfake.Responder[armappservice.StaticSitesClientUnlinkBackendFromBuildResponse], errResp azfake.ErrorResponder)

	// UpdateBuildDatabaseConnection is the fake for method StaticSitesClient.UpdateBuildDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK
	UpdateBuildDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, databaseConnectionRequestEnvelope armappservice.DatabaseConnectionPatchRequest, options *armappservice.StaticSitesClientUpdateBuildDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientUpdateBuildDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// UpdateDatabaseConnection is the fake for method StaticSitesClient.UpdateDatabaseConnection
	// HTTP status codes to indicate success: http.StatusOK
	UpdateDatabaseConnection func(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, databaseConnectionRequestEnvelope armappservice.DatabaseConnectionPatchRequest, options *armappservice.StaticSitesClientUpdateDatabaseConnectionOptions) (resp azfake.Responder[armappservice.StaticSitesClientUpdateDatabaseConnectionResponse], errResp azfake.ErrorResponder)

	// UpdateStaticSite is the fake for method StaticSitesClient.UpdateStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	UpdateStaticSite func(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope armappservice.StaticSitePatchResource, options *armappservice.StaticSitesClientUpdateStaticSiteOptions) (resp azfake.Responder[armappservice.StaticSitesClientUpdateStaticSiteResponse], errResp azfake.ErrorResponder)

	// UpdateStaticSiteUser is the fake for method StaticSitesClient.UpdateStaticSiteUser
	// HTTP status codes to indicate success: http.StatusOK
	UpdateStaticSiteUser func(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope armappservice.StaticSiteUserARMResource, options *armappservice.StaticSitesClientUpdateStaticSiteUserOptions) (resp azfake.Responder[armappservice.StaticSitesClientUpdateStaticSiteUserResponse], errResp azfake.ErrorResponder)

	// BeginValidateBackend is the fake for method StaticSitesClient.BeginValidateBackend
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginValidateBackend func(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope armappservice.StaticSiteLinkedBackendARMResource, options *armappservice.StaticSitesClientBeginValidateBackendOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientValidateBackendResponse], errResp azfake.ErrorResponder)

	// BeginValidateBackendForBuild is the fake for method StaticSitesClient.BeginValidateBackendForBuild
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginValidateBackendForBuild func(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope armappservice.StaticSiteLinkedBackendARMResource, options *armappservice.StaticSitesClientBeginValidateBackendForBuildOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientValidateBackendForBuildResponse], errResp azfake.ErrorResponder)

	// BeginValidateCustomDomainCanBeAddedToStaticSite is the fake for method StaticSitesClient.BeginValidateCustomDomainCanBeAddedToStaticSite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidateCustomDomainCanBeAddedToStaticSite func(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope armappservice.StaticSiteCustomDomainRequestPropertiesARMResource, options *armappservice.StaticSitesClientBeginValidateCustomDomainCanBeAddedToStaticSiteOptions) (resp azfake.PollerResponder[armappservice.StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse], errResp azfake.ErrorResponder)
}

// NewStaticSitesServerTransport creates a new instance of StaticSitesServerTransport with the provided implementation.
// The returned StaticSitesServerTransport instance is connected to an instance of armappservice.StaticSitesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStaticSitesServerTransport(srv *StaticSitesServer) *StaticSitesServerTransport {
	return &StaticSitesServerTransport{
		srv: srv,
		beginApproveOrRejectPrivateEndpointConnection:           newTracker[azfake.PollerResponder[armappservice.StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse]](),
		beginCreateOrUpdateStaticSite:                           newTracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteResponse]](),
		beginCreateOrUpdateStaticSiteCustomDomain:               newTracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse]](),
		beginCreateZipDeploymentForStaticSite:                   newTracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateZipDeploymentForStaticSiteResponse]](),
		beginCreateZipDeploymentForStaticSiteBuild:              newTracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse]](),
		beginDeletePrivateEndpointConnection:                    newTracker[azfake.PollerResponder[armappservice.StaticSitesClientDeletePrivateEndpointConnectionResponse]](),
		beginDeleteStaticSite:                                   newTracker[azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteResponse]](),
		beginDeleteStaticSiteBuild:                              newTracker[azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteBuildResponse]](),
		beginDeleteStaticSiteCustomDomain:                       newTracker[azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteCustomDomainResponse]](),
		beginDetachStaticSite:                                   newTracker[azfake.PollerResponder[armappservice.StaticSitesClientDetachStaticSiteResponse]](),
		newGetBuildDatabaseConnectionsPager:                     newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetBuildDatabaseConnectionsResponse]](),
		newGetBuildDatabaseConnectionsWithDetailsPager:          newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse]](),
		newGetDatabaseConnectionsPager:                          newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetDatabaseConnectionsResponse]](),
		newGetDatabaseConnectionsWithDetailsPager:               newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetDatabaseConnectionsWithDetailsResponse]](),
		newGetLinkedBackendsPager:                               newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetLinkedBackendsResponse]](),
		newGetLinkedBackendsForBuildPager:                       newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetLinkedBackendsForBuildResponse]](),
		newGetPrivateEndpointConnectionListPager:                newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetPrivateEndpointConnectionListResponse]](),
		newGetStaticSiteBuildsPager:                             newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetStaticSiteBuildsResponse]](),
		newGetStaticSitesByResourceGroupPager:                   newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetStaticSitesByResourceGroupResponse]](),
		newGetUserProvidedFunctionAppsForStaticSitePager:        newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse]](),
		newGetUserProvidedFunctionAppsForStaticSiteBuildPager:   newTracker[azfake.PagerResponder[armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse]](),
		beginLinkBackend:                                        newTracker[azfake.PollerResponder[armappservice.StaticSitesClientLinkBackendResponse]](),
		beginLinkBackendToBuild:                                 newTracker[azfake.PollerResponder[armappservice.StaticSitesClientLinkBackendToBuildResponse]](),
		newListPager:                                            newTracker[azfake.PagerResponder[armappservice.StaticSitesClientListResponse]](),
		newListBasicAuthPager:                                   newTracker[azfake.PagerResponder[armappservice.StaticSitesClientListBasicAuthResponse]](),
		newListStaticSiteBuildFunctionsPager:                    newTracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteBuildFunctionsResponse]](),
		newListStaticSiteCustomDomainsPager:                     newTracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteCustomDomainsResponse]](),
		newListStaticSiteFunctionsPager:                         newTracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteFunctionsResponse]](),
		newListStaticSiteUsersPager:                             newTracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteUsersResponse]](),
		beginRegisterUserProvidedFunctionAppWithStaticSite:      newTracker[azfake.PollerResponder[armappservice.StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse]](),
		beginRegisterUserProvidedFunctionAppWithStaticSiteBuild: newTracker[azfake.PollerResponder[armappservice.StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse]](),
		beginValidateBackend:                                    newTracker[azfake.PollerResponder[armappservice.StaticSitesClientValidateBackendResponse]](),
		beginValidateBackendForBuild:                            newTracker[azfake.PollerResponder[armappservice.StaticSitesClientValidateBackendForBuildResponse]](),
		beginValidateCustomDomainCanBeAddedToStaticSite:         newTracker[azfake.PollerResponder[armappservice.StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse]](),
	}
}

// StaticSitesServerTransport connects instances of armappservice.StaticSitesClient to instances of StaticSitesServer.
// Don't use this type directly, use NewStaticSitesServerTransport instead.
type StaticSitesServerTransport struct {
	srv                                                     *StaticSitesServer
	beginApproveOrRejectPrivateEndpointConnection           *tracker[azfake.PollerResponder[armappservice.StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse]]
	beginCreateOrUpdateStaticSite                           *tracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteResponse]]
	beginCreateOrUpdateStaticSiteCustomDomain               *tracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse]]
	beginCreateZipDeploymentForStaticSite                   *tracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateZipDeploymentForStaticSiteResponse]]
	beginCreateZipDeploymentForStaticSiteBuild              *tracker[azfake.PollerResponder[armappservice.StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse]]
	beginDeletePrivateEndpointConnection                    *tracker[azfake.PollerResponder[armappservice.StaticSitesClientDeletePrivateEndpointConnectionResponse]]
	beginDeleteStaticSite                                   *tracker[azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteResponse]]
	beginDeleteStaticSiteBuild                              *tracker[azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteBuildResponse]]
	beginDeleteStaticSiteCustomDomain                       *tracker[azfake.PollerResponder[armappservice.StaticSitesClientDeleteStaticSiteCustomDomainResponse]]
	beginDetachStaticSite                                   *tracker[azfake.PollerResponder[armappservice.StaticSitesClientDetachStaticSiteResponse]]
	newGetBuildDatabaseConnectionsPager                     *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetBuildDatabaseConnectionsResponse]]
	newGetBuildDatabaseConnectionsWithDetailsPager          *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse]]
	newGetDatabaseConnectionsPager                          *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetDatabaseConnectionsResponse]]
	newGetDatabaseConnectionsWithDetailsPager               *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetDatabaseConnectionsWithDetailsResponse]]
	newGetLinkedBackendsPager                               *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetLinkedBackendsResponse]]
	newGetLinkedBackendsForBuildPager                       *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetLinkedBackendsForBuildResponse]]
	newGetPrivateEndpointConnectionListPager                *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetPrivateEndpointConnectionListResponse]]
	newGetStaticSiteBuildsPager                             *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetStaticSiteBuildsResponse]]
	newGetStaticSitesByResourceGroupPager                   *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetStaticSitesByResourceGroupResponse]]
	newGetUserProvidedFunctionAppsForStaticSitePager        *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse]]
	newGetUserProvidedFunctionAppsForStaticSiteBuildPager   *tracker[azfake.PagerResponder[armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse]]
	beginLinkBackend                                        *tracker[azfake.PollerResponder[armappservice.StaticSitesClientLinkBackendResponse]]
	beginLinkBackendToBuild                                 *tracker[azfake.PollerResponder[armappservice.StaticSitesClientLinkBackendToBuildResponse]]
	newListPager                                            *tracker[azfake.PagerResponder[armappservice.StaticSitesClientListResponse]]
	newListBasicAuthPager                                   *tracker[azfake.PagerResponder[armappservice.StaticSitesClientListBasicAuthResponse]]
	newListStaticSiteBuildFunctionsPager                    *tracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteBuildFunctionsResponse]]
	newListStaticSiteCustomDomainsPager                     *tracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteCustomDomainsResponse]]
	newListStaticSiteFunctionsPager                         *tracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteFunctionsResponse]]
	newListStaticSiteUsersPager                             *tracker[azfake.PagerResponder[armappservice.StaticSitesClientListStaticSiteUsersResponse]]
	beginRegisterUserProvidedFunctionAppWithStaticSite      *tracker[azfake.PollerResponder[armappservice.StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse]]
	beginRegisterUserProvidedFunctionAppWithStaticSiteBuild *tracker[azfake.PollerResponder[armappservice.StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse]]
	beginValidateBackend                                    *tracker[azfake.PollerResponder[armappservice.StaticSitesClientValidateBackendResponse]]
	beginValidateBackendForBuild                            *tracker[azfake.PollerResponder[armappservice.StaticSitesClientValidateBackendForBuildResponse]]
	beginValidateCustomDomainCanBeAddedToStaticSite         *tracker[azfake.PollerResponder[armappservice.StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse]]
}

// Do implements the policy.Transporter interface for StaticSitesServerTransport.
func (s *StaticSitesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StaticSitesClient.BeginApproveOrRejectPrivateEndpointConnection":
		resp, err = s.dispatchBeginApproveOrRejectPrivateEndpointConnection(req)
	case "StaticSitesClient.CreateOrUpdateBasicAuth":
		resp, err = s.dispatchCreateOrUpdateBasicAuth(req)
	case "StaticSitesClient.CreateOrUpdateBuildDatabaseConnection":
		resp, err = s.dispatchCreateOrUpdateBuildDatabaseConnection(req)
	case "StaticSitesClient.CreateOrUpdateDatabaseConnection":
		resp, err = s.dispatchCreateOrUpdateDatabaseConnection(req)
	case "StaticSitesClient.BeginCreateOrUpdateStaticSite":
		resp, err = s.dispatchBeginCreateOrUpdateStaticSite(req)
	case "StaticSitesClient.CreateOrUpdateStaticSiteAppSettings":
		resp, err = s.dispatchCreateOrUpdateStaticSiteAppSettings(req)
	case "StaticSitesClient.CreateOrUpdateStaticSiteBuildAppSettings":
		resp, err = s.dispatchCreateOrUpdateStaticSiteBuildAppSettings(req)
	case "StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings":
		resp, err = s.dispatchCreateOrUpdateStaticSiteBuildFunctionAppSettings(req)
	case "StaticSitesClient.BeginCreateOrUpdateStaticSiteCustomDomain":
		resp, err = s.dispatchBeginCreateOrUpdateStaticSiteCustomDomain(req)
	case "StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings":
		resp, err = s.dispatchCreateOrUpdateStaticSiteFunctionAppSettings(req)
	case "StaticSitesClient.CreateUserRolesInvitationLink":
		resp, err = s.dispatchCreateUserRolesInvitationLink(req)
	case "StaticSitesClient.BeginCreateZipDeploymentForStaticSite":
		resp, err = s.dispatchBeginCreateZipDeploymentForStaticSite(req)
	case "StaticSitesClient.BeginCreateZipDeploymentForStaticSiteBuild":
		resp, err = s.dispatchBeginCreateZipDeploymentForStaticSiteBuild(req)
	case "StaticSitesClient.DeleteBuildDatabaseConnection":
		resp, err = s.dispatchDeleteBuildDatabaseConnection(req)
	case "StaticSitesClient.DeleteDatabaseConnection":
		resp, err = s.dispatchDeleteDatabaseConnection(req)
	case "StaticSitesClient.BeginDeletePrivateEndpointConnection":
		resp, err = s.dispatchBeginDeletePrivateEndpointConnection(req)
	case "StaticSitesClient.BeginDeleteStaticSite":
		resp, err = s.dispatchBeginDeleteStaticSite(req)
	case "StaticSitesClient.BeginDeleteStaticSiteBuild":
		resp, err = s.dispatchBeginDeleteStaticSiteBuild(req)
	case "StaticSitesClient.BeginDeleteStaticSiteCustomDomain":
		resp, err = s.dispatchBeginDeleteStaticSiteCustomDomain(req)
	case "StaticSitesClient.DeleteStaticSiteUser":
		resp, err = s.dispatchDeleteStaticSiteUser(req)
	case "StaticSitesClient.BeginDetachStaticSite":
		resp, err = s.dispatchBeginDetachStaticSite(req)
	case "StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSite":
		resp, err = s.dispatchDetachUserProvidedFunctionAppFromStaticSite(req)
	case "StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSiteBuild":
		resp, err = s.dispatchDetachUserProvidedFunctionAppFromStaticSiteBuild(req)
	case "StaticSitesClient.GetBasicAuth":
		resp, err = s.dispatchGetBasicAuth(req)
	case "StaticSitesClient.GetBuildDatabaseConnection":
		resp, err = s.dispatchGetBuildDatabaseConnection(req)
	case "StaticSitesClient.GetBuildDatabaseConnectionWithDetails":
		resp, err = s.dispatchGetBuildDatabaseConnectionWithDetails(req)
	case "StaticSitesClient.NewGetBuildDatabaseConnectionsPager":
		resp, err = s.dispatchNewGetBuildDatabaseConnectionsPager(req)
	case "StaticSitesClient.NewGetBuildDatabaseConnectionsWithDetailsPager":
		resp, err = s.dispatchNewGetBuildDatabaseConnectionsWithDetailsPager(req)
	case "StaticSitesClient.GetDatabaseConnection":
		resp, err = s.dispatchGetDatabaseConnection(req)
	case "StaticSitesClient.GetDatabaseConnectionWithDetails":
		resp, err = s.dispatchGetDatabaseConnectionWithDetails(req)
	case "StaticSitesClient.NewGetDatabaseConnectionsPager":
		resp, err = s.dispatchNewGetDatabaseConnectionsPager(req)
	case "StaticSitesClient.NewGetDatabaseConnectionsWithDetailsPager":
		resp, err = s.dispatchNewGetDatabaseConnectionsWithDetailsPager(req)
	case "StaticSitesClient.GetLinkedBackend":
		resp, err = s.dispatchGetLinkedBackend(req)
	case "StaticSitesClient.GetLinkedBackendForBuild":
		resp, err = s.dispatchGetLinkedBackendForBuild(req)
	case "StaticSitesClient.NewGetLinkedBackendsPager":
		resp, err = s.dispatchNewGetLinkedBackendsPager(req)
	case "StaticSitesClient.NewGetLinkedBackendsForBuildPager":
		resp, err = s.dispatchNewGetLinkedBackendsForBuildPager(req)
	case "StaticSitesClient.GetPrivateEndpointConnection":
		resp, err = s.dispatchGetPrivateEndpointConnection(req)
	case "StaticSitesClient.NewGetPrivateEndpointConnectionListPager":
		resp, err = s.dispatchNewGetPrivateEndpointConnectionListPager(req)
	case "StaticSitesClient.GetPrivateLinkResources":
		resp, err = s.dispatchGetPrivateLinkResources(req)
	case "StaticSitesClient.GetStaticSite":
		resp, err = s.dispatchGetStaticSite(req)
	case "StaticSitesClient.GetStaticSiteBuild":
		resp, err = s.dispatchGetStaticSiteBuild(req)
	case "StaticSitesClient.NewGetStaticSiteBuildsPager":
		resp, err = s.dispatchNewGetStaticSiteBuildsPager(req)
	case "StaticSitesClient.GetStaticSiteCustomDomain":
		resp, err = s.dispatchGetStaticSiteCustomDomain(req)
	case "StaticSitesClient.NewGetStaticSitesByResourceGroupPager":
		resp, err = s.dispatchNewGetStaticSitesByResourceGroupPager(req)
	case "StaticSitesClient.GetUserProvidedFunctionAppForStaticSite":
		resp, err = s.dispatchGetUserProvidedFunctionAppForStaticSite(req)
	case "StaticSitesClient.GetUserProvidedFunctionAppForStaticSiteBuild":
		resp, err = s.dispatchGetUserProvidedFunctionAppForStaticSiteBuild(req)
	case "StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSitePager":
		resp, err = s.dispatchNewGetUserProvidedFunctionAppsForStaticSitePager(req)
	case "StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSiteBuildPager":
		resp, err = s.dispatchNewGetUserProvidedFunctionAppsForStaticSiteBuildPager(req)
	case "StaticSitesClient.BeginLinkBackend":
		resp, err = s.dispatchBeginLinkBackend(req)
	case "StaticSitesClient.BeginLinkBackendToBuild":
		resp, err = s.dispatchBeginLinkBackendToBuild(req)
	case "StaticSitesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "StaticSitesClient.NewListBasicAuthPager":
		resp, err = s.dispatchNewListBasicAuthPager(req)
	case "StaticSitesClient.ListStaticSiteAppSettings":
		resp, err = s.dispatchListStaticSiteAppSettings(req)
	case "StaticSitesClient.ListStaticSiteBuildAppSettings":
		resp, err = s.dispatchListStaticSiteBuildAppSettings(req)
	case "StaticSitesClient.ListStaticSiteBuildFunctionAppSettings":
		resp, err = s.dispatchListStaticSiteBuildFunctionAppSettings(req)
	case "StaticSitesClient.NewListStaticSiteBuildFunctionsPager":
		resp, err = s.dispatchNewListStaticSiteBuildFunctionsPager(req)
	case "StaticSitesClient.ListStaticSiteConfiguredRoles":
		resp, err = s.dispatchListStaticSiteConfiguredRoles(req)
	case "StaticSitesClient.NewListStaticSiteCustomDomainsPager":
		resp, err = s.dispatchNewListStaticSiteCustomDomainsPager(req)
	case "StaticSitesClient.ListStaticSiteFunctionAppSettings":
		resp, err = s.dispatchListStaticSiteFunctionAppSettings(req)
	case "StaticSitesClient.NewListStaticSiteFunctionsPager":
		resp, err = s.dispatchNewListStaticSiteFunctionsPager(req)
	case "StaticSitesClient.ListStaticSiteSecrets":
		resp, err = s.dispatchListStaticSiteSecrets(req)
	case "StaticSitesClient.NewListStaticSiteUsersPager":
		resp, err = s.dispatchNewListStaticSiteUsersPager(req)
	case "StaticSitesClient.PreviewWorkflow":
		resp, err = s.dispatchPreviewWorkflow(req)
	case "StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSite":
		resp, err = s.dispatchBeginRegisterUserProvidedFunctionAppWithStaticSite(req)
	case "StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild":
		resp, err = s.dispatchBeginRegisterUserProvidedFunctionAppWithStaticSiteBuild(req)
	case "StaticSitesClient.ResetStaticSiteAPIKey":
		resp, err = s.dispatchResetStaticSiteAPIKey(req)
	case "StaticSitesClient.UnlinkBackend":
		resp, err = s.dispatchUnlinkBackend(req)
	case "StaticSitesClient.UnlinkBackendFromBuild":
		resp, err = s.dispatchUnlinkBackendFromBuild(req)
	case "StaticSitesClient.UpdateBuildDatabaseConnection":
		resp, err = s.dispatchUpdateBuildDatabaseConnection(req)
	case "StaticSitesClient.UpdateDatabaseConnection":
		resp, err = s.dispatchUpdateDatabaseConnection(req)
	case "StaticSitesClient.UpdateStaticSite":
		resp, err = s.dispatchUpdateStaticSite(req)
	case "StaticSitesClient.UpdateStaticSiteUser":
		resp, err = s.dispatchUpdateStaticSiteUser(req)
	case "StaticSitesClient.BeginValidateBackend":
		resp, err = s.dispatchBeginValidateBackend(req)
	case "StaticSitesClient.BeginValidateBackendForBuild":
		resp, err = s.dispatchBeginValidateBackendForBuild(req)
	case "StaticSitesClient.BeginValidateCustomDomainCanBeAddedToStaticSite":
		resp, err = s.dispatchBeginValidateCustomDomainCanBeAddedToStaticSite(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginApproveOrRejectPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if s.srv.BeginApproveOrRejectPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginApproveOrRejectPrivateEndpointConnection not implemented")}
	}
	beginApproveOrRejectPrivateEndpointConnection := s.beginApproveOrRejectPrivateEndpointConnection.get(req)
	if beginApproveOrRejectPrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.PrivateLinkConnectionApprovalRequestResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginApproveOrRejectPrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginApproveOrRejectPrivateEndpointConnection = &respr
		s.beginApproveOrRejectPrivateEndpointConnection.add(req, beginApproveOrRejectPrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginApproveOrRejectPrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginApproveOrRejectPrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginApproveOrRejectPrivateEndpointConnection) {
		s.beginApproveOrRejectPrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateOrUpdateBasicAuth(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateBasicAuth == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateBasicAuth not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicAuth/(?P<basicAuthName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteBasicAuthPropertiesARMResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	basicAuthNameParam, err := parseWithCast(matches[regex.SubexpIndex("basicAuthName")], func(v string) (armappservice.BasicAuthName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armappservice.BasicAuthName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateBasicAuth(req.Context(), resourceGroupNameParam, nameParam, basicAuthNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteBasicAuthPropertiesARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateOrUpdateBuildDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateBuildDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateBuildDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.DatabaseConnection](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateBuildDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, databaseConnectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateOrUpdateDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.DatabaseConnection](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, databaseConnectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginCreateOrUpdateStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdateStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateStaticSite not implemented")}
	}
	beginCreateOrUpdateStaticSite := s.beginCreateOrUpdateStaticSite.get(req)
	if beginCreateOrUpdateStaticSite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdateStaticSite(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateStaticSite = &respr
		s.beginCreateOrUpdateStaticSite.add(req, beginCreateOrUpdateStaticSite)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateStaticSite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateOrUpdateStaticSite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateStaticSite) {
		s.beginCreateOrUpdateStaticSite.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateOrUpdateStaticSiteAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateStaticSiteAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateStaticSiteAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/appsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateStaticSiteAppSettings(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateOrUpdateStaticSiteBuildAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateStaticSiteBuildAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateStaticSiteBuildAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/appsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateStaticSiteBuildAppSettings(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateOrUpdateStaticSiteBuildFunctionAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateStaticSiteBuildFunctionAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateStaticSiteBuildFunctionAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/functionappsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateStaticSiteBuildFunctionAppSettings(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginCreateOrUpdateStaticSiteCustomDomain(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdateStaticSiteCustomDomain == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateStaticSiteCustomDomain not implemented")}
	}
	beginCreateOrUpdateStaticSiteCustomDomain := s.beginCreateOrUpdateStaticSiteCustomDomain.get(req)
	if beginCreateOrUpdateStaticSiteCustomDomain == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteCustomDomainRequestPropertiesARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdateStaticSiteCustomDomain(req.Context(), resourceGroupNameParam, nameParam, domainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateStaticSiteCustomDomain = &respr
		s.beginCreateOrUpdateStaticSiteCustomDomain.add(req, beginCreateOrUpdateStaticSiteCustomDomain)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateStaticSiteCustomDomain, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateOrUpdateStaticSiteCustomDomain.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateStaticSiteCustomDomain) {
		s.beginCreateOrUpdateStaticSiteCustomDomain.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateOrUpdateStaticSiteFunctionAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateStaticSiteFunctionAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateStaticSiteFunctionAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/config/functionappsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StringDictionary](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateStaticSiteFunctionAppSettings(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchCreateUserRolesInvitationLink(req *http.Request) (*http.Response, error) {
	if s.srv.CreateUserRolesInvitationLink == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateUserRolesInvitationLink not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/createUserInvitation`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteUserInvitationRequestResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateUserRolesInvitationLink(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteUserInvitationResponseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginCreateZipDeploymentForStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateZipDeploymentForStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateZipDeploymentForStaticSite not implemented")}
	}
	beginCreateZipDeploymentForStaticSite := s.beginCreateZipDeploymentForStaticSite.get(req)
	if beginCreateZipDeploymentForStaticSite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/zipdeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteZipDeploymentARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateZipDeploymentForStaticSite(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateZipDeploymentForStaticSite = &respr
		s.beginCreateZipDeploymentForStaticSite.add(req, beginCreateZipDeploymentForStaticSite)
	}

	resp, err := server.PollerResponderNext(beginCreateZipDeploymentForStaticSite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateZipDeploymentForStaticSite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateZipDeploymentForStaticSite) {
		s.beginCreateZipDeploymentForStaticSite.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginCreateZipDeploymentForStaticSiteBuild(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateZipDeploymentForStaticSiteBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateZipDeploymentForStaticSiteBuild not implemented")}
	}
	beginCreateZipDeploymentForStaticSiteBuild := s.beginCreateZipDeploymentForStaticSiteBuild.get(req)
	if beginCreateZipDeploymentForStaticSiteBuild == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/zipdeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteZipDeploymentARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateZipDeploymentForStaticSiteBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateZipDeploymentForStaticSiteBuild = &respr
		s.beginCreateZipDeploymentForStaticSiteBuild.add(req, beginCreateZipDeploymentForStaticSiteBuild)
	}

	resp, err := server.PollerResponderNext(beginCreateZipDeploymentForStaticSiteBuild, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateZipDeploymentForStaticSiteBuild.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateZipDeploymentForStaticSiteBuild) {
		s.beginCreateZipDeploymentForStaticSiteBuild.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchDeleteBuildDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteBuildDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteBuildDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteBuildDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, databaseConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchDeleteDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, databaseConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginDeletePrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeletePrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePrivateEndpointConnection not implemented")}
	}
	beginDeletePrivateEndpointConnection := s.beginDeletePrivateEndpointConnection.get(req)
	if beginDeletePrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeletePrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePrivateEndpointConnection = &respr
		s.beginDeletePrivateEndpointConnection.add(req, beginDeletePrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginDeletePrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeletePrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePrivateEndpointConnection) {
		s.beginDeletePrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginDeleteStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteStaticSite not implemented")}
	}
	beginDeleteStaticSite := s.beginDeleteStaticSite.get(req)
	if beginDeleteStaticSite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteStaticSite(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteStaticSite = &respr
		s.beginDeleteStaticSite.add(req, beginDeleteStaticSite)
	}

	resp, err := server.PollerResponderNext(beginDeleteStaticSite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginDeleteStaticSite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteStaticSite) {
		s.beginDeleteStaticSite.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginDeleteStaticSiteBuild(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteStaticSiteBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteStaticSiteBuild not implemented")}
	}
	beginDeleteStaticSiteBuild := s.beginDeleteStaticSiteBuild.get(req)
	if beginDeleteStaticSiteBuild == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteStaticSiteBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteStaticSiteBuild = &respr
		s.beginDeleteStaticSiteBuild.add(req, beginDeleteStaticSiteBuild)
	}

	resp, err := server.PollerResponderNext(beginDeleteStaticSiteBuild, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteStaticSiteBuild.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteStaticSiteBuild) {
		s.beginDeleteStaticSiteBuild.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginDeleteStaticSiteCustomDomain(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteStaticSiteCustomDomain == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteStaticSiteCustomDomain not implemented")}
	}
	beginDeleteStaticSiteCustomDomain := s.beginDeleteStaticSiteCustomDomain.get(req)
	if beginDeleteStaticSiteCustomDomain == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteStaticSiteCustomDomain(req.Context(), resourceGroupNameParam, nameParam, domainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteStaticSiteCustomDomain = &respr
		s.beginDeleteStaticSiteCustomDomain.add(req, beginDeleteStaticSiteCustomDomain)
	}

	resp, err := server.PollerResponderNext(beginDeleteStaticSiteCustomDomain, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginDeleteStaticSiteCustomDomain.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteStaticSiteCustomDomain) {
		s.beginDeleteStaticSiteCustomDomain.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchDeleteStaticSiteUser(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteStaticSiteUser == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteStaticSiteUser not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authproviders/(?P<authprovider>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	authproviderParam, err := url.PathUnescape(matches[regex.SubexpIndex("authprovider")])
	if err != nil {
		return nil, err
	}
	useridParam, err := url.PathUnescape(matches[regex.SubexpIndex("userid")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteStaticSiteUser(req.Context(), resourceGroupNameParam, nameParam, authproviderParam, useridParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginDetachStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDetachStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDetachStaticSite not implemented")}
	}
	beginDetachStaticSite := s.beginDetachStaticSite.get(req)
	if beginDetachStaticSite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detach`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDetachStaticSite(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDetachStaticSite = &respr
		s.beginDetachStaticSite.add(req, beginDetachStaticSite)
	}

	resp, err := server.PollerResponderNext(beginDetachStaticSite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginDetachStaticSite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDetachStaticSite) {
		s.beginDetachStaticSite.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchDetachUserProvidedFunctionAppFromStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.DetachUserProvidedFunctionAppFromStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method DetachUserProvidedFunctionAppFromStaticSite not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps/(?P<functionAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionAppName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DetachUserProvidedFunctionAppFromStaticSite(req.Context(), resourceGroupNameParam, nameParam, functionAppNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchDetachUserProvidedFunctionAppFromStaticSiteBuild(req *http.Request) (*http.Response, error) {
	if s.srv.DetachUserProvidedFunctionAppFromStaticSiteBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method DetachUserProvidedFunctionAppFromStaticSiteBuild not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps/(?P<functionAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	functionAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionAppName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DetachUserProvidedFunctionAppFromStaticSiteBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, functionAppNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetBasicAuth(req *http.Request) (*http.Response, error) {
	if s.srv.GetBasicAuth == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBasicAuth not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicAuth/(?P<basicAuthName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	basicAuthNameParam, err := parseWithCast(matches[regex.SubexpIndex("basicAuthName")], func(v string) (armappservice.BasicAuthName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armappservice.BasicAuthName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetBasicAuth(req.Context(), resourceGroupNameParam, nameParam, basicAuthNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteBasicAuthPropertiesARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetBuildDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.GetBuildDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBuildDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetBuildDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, databaseConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetBuildDatabaseConnectionWithDetails(req *http.Request) (*http.Response, error) {
	if s.srv.GetBuildDatabaseConnectionWithDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBuildDatabaseConnectionWithDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/show`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetBuildDatabaseConnectionWithDetails(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, databaseConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetBuildDatabaseConnectionsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetBuildDatabaseConnectionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetBuildDatabaseConnectionsPager not implemented")}
	}
	newGetBuildDatabaseConnectionsPager := s.newGetBuildDatabaseConnectionsPager.get(req)
	if newGetBuildDatabaseConnectionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetBuildDatabaseConnectionsPager(resourceGroupNameParam, nameParam, environmentNameParam, nil)
		newGetBuildDatabaseConnectionsPager = &resp
		s.newGetBuildDatabaseConnectionsPager.add(req, newGetBuildDatabaseConnectionsPager)
		server.PagerResponderInjectNextLinks(newGetBuildDatabaseConnectionsPager, req, func(page *armappservice.StaticSitesClientGetBuildDatabaseConnectionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetBuildDatabaseConnectionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetBuildDatabaseConnectionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetBuildDatabaseConnectionsPager) {
		s.newGetBuildDatabaseConnectionsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetBuildDatabaseConnectionsWithDetailsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetBuildDatabaseConnectionsWithDetailsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetBuildDatabaseConnectionsWithDetailsPager not implemented")}
	}
	newGetBuildDatabaseConnectionsWithDetailsPager := s.newGetBuildDatabaseConnectionsWithDetailsPager.get(req)
	if newGetBuildDatabaseConnectionsWithDetailsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/showDatabaseConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetBuildDatabaseConnectionsWithDetailsPager(resourceGroupNameParam, nameParam, environmentNameParam, nil)
		newGetBuildDatabaseConnectionsWithDetailsPager = &resp
		s.newGetBuildDatabaseConnectionsWithDetailsPager.add(req, newGetBuildDatabaseConnectionsWithDetailsPager)
		server.PagerResponderInjectNextLinks(newGetBuildDatabaseConnectionsWithDetailsPager, req, func(page *armappservice.StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetBuildDatabaseConnectionsWithDetailsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetBuildDatabaseConnectionsWithDetailsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetBuildDatabaseConnectionsWithDetailsPager) {
		s.newGetBuildDatabaseConnectionsWithDetailsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.GetDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, databaseConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetDatabaseConnectionWithDetails(req *http.Request) (*http.Response, error) {
	if s.srv.GetDatabaseConnectionWithDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDatabaseConnectionWithDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/show`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetDatabaseConnectionWithDetails(req.Context(), resourceGroupNameParam, nameParam, databaseConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetDatabaseConnectionsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetDatabaseConnectionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetDatabaseConnectionsPager not implemented")}
	}
	newGetDatabaseConnectionsPager := s.newGetDatabaseConnectionsPager.get(req)
	if newGetDatabaseConnectionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetDatabaseConnectionsPager(resourceGroupNameParam, nameParam, nil)
		newGetDatabaseConnectionsPager = &resp
		s.newGetDatabaseConnectionsPager.add(req, newGetDatabaseConnectionsPager)
		server.PagerResponderInjectNextLinks(newGetDatabaseConnectionsPager, req, func(page *armappservice.StaticSitesClientGetDatabaseConnectionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetDatabaseConnectionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetDatabaseConnectionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetDatabaseConnectionsPager) {
		s.newGetDatabaseConnectionsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetDatabaseConnectionsWithDetailsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetDatabaseConnectionsWithDetailsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetDatabaseConnectionsWithDetailsPager not implemented")}
	}
	newGetDatabaseConnectionsWithDetailsPager := s.newGetDatabaseConnectionsWithDetailsPager.get(req)
	if newGetDatabaseConnectionsWithDetailsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/showDatabaseConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetDatabaseConnectionsWithDetailsPager(resourceGroupNameParam, nameParam, nil)
		newGetDatabaseConnectionsWithDetailsPager = &resp
		s.newGetDatabaseConnectionsWithDetailsPager.add(req, newGetDatabaseConnectionsWithDetailsPager)
		server.PagerResponderInjectNextLinks(newGetDatabaseConnectionsWithDetailsPager, req, func(page *armappservice.StaticSitesClientGetDatabaseConnectionsWithDetailsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetDatabaseConnectionsWithDetailsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetDatabaseConnectionsWithDetailsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetDatabaseConnectionsWithDetailsPager) {
		s.newGetDatabaseConnectionsWithDetailsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetLinkedBackend(req *http.Request) (*http.Response, error) {
	if s.srv.GetLinkedBackend == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLinkedBackend not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetLinkedBackend(req.Context(), resourceGroupNameParam, nameParam, linkedBackendNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteLinkedBackendARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetLinkedBackendForBuild(req *http.Request) (*http.Response, error) {
	if s.srv.GetLinkedBackendForBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLinkedBackendForBuild not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetLinkedBackendForBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, linkedBackendNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteLinkedBackendARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetLinkedBackendsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetLinkedBackendsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetLinkedBackendsPager not implemented")}
	}
	newGetLinkedBackendsPager := s.newGetLinkedBackendsPager.get(req)
	if newGetLinkedBackendsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetLinkedBackendsPager(resourceGroupNameParam, nameParam, nil)
		newGetLinkedBackendsPager = &resp
		s.newGetLinkedBackendsPager.add(req, newGetLinkedBackendsPager)
		server.PagerResponderInjectNextLinks(newGetLinkedBackendsPager, req, func(page *armappservice.StaticSitesClientGetLinkedBackendsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetLinkedBackendsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetLinkedBackendsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetLinkedBackendsPager) {
		s.newGetLinkedBackendsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetLinkedBackendsForBuildPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetLinkedBackendsForBuildPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetLinkedBackendsForBuildPager not implemented")}
	}
	newGetLinkedBackendsForBuildPager := s.newGetLinkedBackendsForBuildPager.get(req)
	if newGetLinkedBackendsForBuildPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetLinkedBackendsForBuildPager(resourceGroupNameParam, nameParam, environmentNameParam, nil)
		newGetLinkedBackendsForBuildPager = &resp
		s.newGetLinkedBackendsForBuildPager.add(req, newGetLinkedBackendsForBuildPager)
		server.PagerResponderInjectNextLinks(newGetLinkedBackendsForBuildPager, req, func(page *armappservice.StaticSitesClientGetLinkedBackendsForBuildResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetLinkedBackendsForBuildPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetLinkedBackendsForBuildPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetLinkedBackendsForBuildPager) {
		s.newGetLinkedBackendsForBuildPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if s.srv.GetPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateEndpointConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetPrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RemotePrivateEndpointConnectionARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetPrivateEndpointConnectionListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetPrivateEndpointConnectionListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetPrivateEndpointConnectionListPager not implemented")}
	}
	newGetPrivateEndpointConnectionListPager := s.newGetPrivateEndpointConnectionListPager.get(req)
	if newGetPrivateEndpointConnectionListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetPrivateEndpointConnectionListPager(resourceGroupNameParam, nameParam, nil)
		newGetPrivateEndpointConnectionListPager = &resp
		s.newGetPrivateEndpointConnectionListPager.add(req, newGetPrivateEndpointConnectionListPager)
		server.PagerResponderInjectNextLinks(newGetPrivateEndpointConnectionListPager, req, func(page *armappservice.StaticSitesClientGetPrivateEndpointConnectionListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetPrivateEndpointConnectionListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetPrivateEndpointConnectionListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetPrivateEndpointConnectionListPager) {
		s.newGetPrivateEndpointConnectionListPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetPrivateLinkResources(req *http.Request) (*http.Response, error) {
	if s.srv.GetPrivateLinkResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateLinkResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetPrivateLinkResources(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResourcesWrapper, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.GetStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetStaticSite not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetStaticSite(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetStaticSiteBuild(req *http.Request) (*http.Response, error) {
	if s.srv.GetStaticSiteBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetStaticSiteBuild not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetStaticSiteBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteBuildARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetStaticSiteBuildsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetStaticSiteBuildsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetStaticSiteBuildsPager not implemented")}
	}
	newGetStaticSiteBuildsPager := s.newGetStaticSiteBuildsPager.get(req)
	if newGetStaticSiteBuildsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetStaticSiteBuildsPager(resourceGroupNameParam, nameParam, nil)
		newGetStaticSiteBuildsPager = &resp
		s.newGetStaticSiteBuildsPager.add(req, newGetStaticSiteBuildsPager)
		server.PagerResponderInjectNextLinks(newGetStaticSiteBuildsPager, req, func(page *armappservice.StaticSitesClientGetStaticSiteBuildsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetStaticSiteBuildsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetStaticSiteBuildsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetStaticSiteBuildsPager) {
		s.newGetStaticSiteBuildsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetStaticSiteCustomDomain(req *http.Request) (*http.Response, error) {
	if s.srv.GetStaticSiteCustomDomain == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetStaticSiteCustomDomain not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetStaticSiteCustomDomain(req.Context(), resourceGroupNameParam, nameParam, domainNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteCustomDomainOverviewARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetStaticSitesByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetStaticSitesByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetStaticSitesByResourceGroupPager not implemented")}
	}
	newGetStaticSitesByResourceGroupPager := s.newGetStaticSitesByResourceGroupPager.get(req)
	if newGetStaticSitesByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetStaticSitesByResourceGroupPager(resourceGroupNameParam, nil)
		newGetStaticSitesByResourceGroupPager = &resp
		s.newGetStaticSitesByResourceGroupPager.add(req, newGetStaticSitesByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newGetStaticSitesByResourceGroupPager, req, func(page *armappservice.StaticSitesClientGetStaticSitesByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetStaticSitesByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetStaticSitesByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetStaticSitesByResourceGroupPager) {
		s.newGetStaticSitesByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetUserProvidedFunctionAppForStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.GetUserProvidedFunctionAppForStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUserProvidedFunctionAppForStaticSite not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps/(?P<functionAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	functionAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionAppName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetUserProvidedFunctionAppForStaticSite(req.Context(), resourceGroupNameParam, nameParam, functionAppNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteUserProvidedFunctionAppARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchGetUserProvidedFunctionAppForStaticSiteBuild(req *http.Request) (*http.Response, error) {
	if s.srv.GetUserProvidedFunctionAppForStaticSiteBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUserProvidedFunctionAppForStaticSiteBuild not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps/(?P<functionAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	functionAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionAppName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetUserProvidedFunctionAppForStaticSiteBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, functionAppNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteUserProvidedFunctionAppARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetUserProvidedFunctionAppsForStaticSitePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetUserProvidedFunctionAppsForStaticSitePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetUserProvidedFunctionAppsForStaticSitePager not implemented")}
	}
	newGetUserProvidedFunctionAppsForStaticSitePager := s.newGetUserProvidedFunctionAppsForStaticSitePager.get(req)
	if newGetUserProvidedFunctionAppsForStaticSitePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetUserProvidedFunctionAppsForStaticSitePager(resourceGroupNameParam, nameParam, nil)
		newGetUserProvidedFunctionAppsForStaticSitePager = &resp
		s.newGetUserProvidedFunctionAppsForStaticSitePager.add(req, newGetUserProvidedFunctionAppsForStaticSitePager)
		server.PagerResponderInjectNextLinks(newGetUserProvidedFunctionAppsForStaticSitePager, req, func(page *armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetUserProvidedFunctionAppsForStaticSitePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetUserProvidedFunctionAppsForStaticSitePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetUserProvidedFunctionAppsForStaticSitePager) {
		s.newGetUserProvidedFunctionAppsForStaticSitePager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewGetUserProvidedFunctionAppsForStaticSiteBuildPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewGetUserProvidedFunctionAppsForStaticSiteBuildPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetUserProvidedFunctionAppsForStaticSiteBuildPager not implemented")}
	}
	newGetUserProvidedFunctionAppsForStaticSiteBuildPager := s.newGetUserProvidedFunctionAppsForStaticSiteBuildPager.get(req)
	if newGetUserProvidedFunctionAppsForStaticSiteBuildPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewGetUserProvidedFunctionAppsForStaticSiteBuildPager(resourceGroupNameParam, nameParam, environmentNameParam, nil)
		newGetUserProvidedFunctionAppsForStaticSiteBuildPager = &resp
		s.newGetUserProvidedFunctionAppsForStaticSiteBuildPager.add(req, newGetUserProvidedFunctionAppsForStaticSiteBuildPager)
		server.PagerResponderInjectNextLinks(newGetUserProvidedFunctionAppsForStaticSiteBuildPager, req, func(page *armappservice.StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetUserProvidedFunctionAppsForStaticSiteBuildPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newGetUserProvidedFunctionAppsForStaticSiteBuildPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetUserProvidedFunctionAppsForStaticSiteBuildPager) {
		s.newGetUserProvidedFunctionAppsForStaticSiteBuildPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginLinkBackend(req *http.Request) (*http.Response, error) {
	if s.srv.BeginLinkBackend == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginLinkBackend not implemented")}
	}
	beginLinkBackend := s.beginLinkBackend.get(req)
	if beginLinkBackend == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteLinkedBackendARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginLinkBackend(req.Context(), resourceGroupNameParam, nameParam, linkedBackendNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginLinkBackend = &respr
		s.beginLinkBackend.add(req, beginLinkBackend)
	}

	resp, err := server.PollerResponderNext(beginLinkBackend, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.beginLinkBackend.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginLinkBackend) {
		s.beginLinkBackend.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginLinkBackendToBuild(req *http.Request) (*http.Response, error) {
	if s.srv.BeginLinkBackendToBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginLinkBackendToBuild not implemented")}
	}
	beginLinkBackendToBuild := s.beginLinkBackendToBuild.get(req)
	if beginLinkBackendToBuild == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteLinkedBackendARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginLinkBackendToBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, linkedBackendNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginLinkBackendToBuild = &respr
		s.beginLinkBackendToBuild.add(req, beginLinkBackendToBuild)
	}

	resp, err := server.PollerResponderNext(beginLinkBackendToBuild, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.beginLinkBackendToBuild.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginLinkBackendToBuild) {
		s.beginLinkBackendToBuild.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListPager(nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.StaticSitesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewListBasicAuthPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBasicAuthPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBasicAuthPager not implemented")}
	}
	newListBasicAuthPager := s.newListBasicAuthPager.get(req)
	if newListBasicAuthPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/basicAuth`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListBasicAuthPager(resourceGroupNameParam, nameParam, nil)
		newListBasicAuthPager = &resp
		s.newListBasicAuthPager.add(req, newListBasicAuthPager)
		server.PagerResponderInjectNextLinks(newListBasicAuthPager, req, func(page *armappservice.StaticSitesClientListBasicAuthResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBasicAuthPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBasicAuthPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBasicAuthPager) {
		s.newListBasicAuthPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchListStaticSiteAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.ListStaticSiteAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListStaticSiteAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAppSettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListStaticSiteAppSettings(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchListStaticSiteBuildAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.ListStaticSiteBuildAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListStaticSiteBuildAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAppSettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListStaticSiteBuildAppSettings(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchListStaticSiteBuildFunctionAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.ListStaticSiteBuildFunctionAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListStaticSiteBuildFunctionAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFunctionAppSettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListStaticSiteBuildFunctionAppSettings(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewListStaticSiteBuildFunctionsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListStaticSiteBuildFunctionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListStaticSiteBuildFunctionsPager not implemented")}
	}
	newListStaticSiteBuildFunctionsPager := s.newListStaticSiteBuildFunctionsPager.get(req)
	if newListStaticSiteBuildFunctionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListStaticSiteBuildFunctionsPager(resourceGroupNameParam, nameParam, environmentNameParam, nil)
		newListStaticSiteBuildFunctionsPager = &resp
		s.newListStaticSiteBuildFunctionsPager.add(req, newListStaticSiteBuildFunctionsPager)
		server.PagerResponderInjectNextLinks(newListStaticSiteBuildFunctionsPager, req, func(page *armappservice.StaticSitesClientListStaticSiteBuildFunctionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListStaticSiteBuildFunctionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListStaticSiteBuildFunctionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListStaticSiteBuildFunctionsPager) {
		s.newListStaticSiteBuildFunctionsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchListStaticSiteConfiguredRoles(req *http.Request) (*http.Response, error) {
	if s.srv.ListStaticSiteConfiguredRoles == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListStaticSiteConfiguredRoles not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listConfiguredRoles`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListStaticSiteConfiguredRoles(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewListStaticSiteCustomDomainsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListStaticSiteCustomDomainsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListStaticSiteCustomDomainsPager not implemented")}
	}
	newListStaticSiteCustomDomainsPager := s.newListStaticSiteCustomDomainsPager.get(req)
	if newListStaticSiteCustomDomainsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListStaticSiteCustomDomainsPager(resourceGroupNameParam, nameParam, nil)
		newListStaticSiteCustomDomainsPager = &resp
		s.newListStaticSiteCustomDomainsPager.add(req, newListStaticSiteCustomDomainsPager)
		server.PagerResponderInjectNextLinks(newListStaticSiteCustomDomainsPager, req, func(page *armappservice.StaticSitesClientListStaticSiteCustomDomainsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListStaticSiteCustomDomainsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListStaticSiteCustomDomainsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListStaticSiteCustomDomainsPager) {
		s.newListStaticSiteCustomDomainsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchListStaticSiteFunctionAppSettings(req *http.Request) (*http.Response, error) {
	if s.srv.ListStaticSiteFunctionAppSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListStaticSiteFunctionAppSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFunctionAppSettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListStaticSiteFunctionAppSettings(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewListStaticSiteFunctionsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListStaticSiteFunctionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListStaticSiteFunctionsPager not implemented")}
	}
	newListStaticSiteFunctionsPager := s.newListStaticSiteFunctionsPager.get(req)
	if newListStaticSiteFunctionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/functions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListStaticSiteFunctionsPager(resourceGroupNameParam, nameParam, nil)
		newListStaticSiteFunctionsPager = &resp
		s.newListStaticSiteFunctionsPager.add(req, newListStaticSiteFunctionsPager)
		server.PagerResponderInjectNextLinks(newListStaticSiteFunctionsPager, req, func(page *armappservice.StaticSitesClientListStaticSiteFunctionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListStaticSiteFunctionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListStaticSiteFunctionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListStaticSiteFunctionsPager) {
		s.newListStaticSiteFunctionsPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchListStaticSiteSecrets(req *http.Request) (*http.Response, error) {
	if s.srv.ListStaticSiteSecrets == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListStaticSiteSecrets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSecrets`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListStaticSiteSecrets(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StringDictionary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchNewListStaticSiteUsersPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListStaticSiteUsersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListStaticSiteUsersPager not implemented")}
	}
	newListStaticSiteUsersPager := s.newListStaticSiteUsersPager.get(req)
	if newListStaticSiteUsersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authproviders/(?P<authprovider>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listUsers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		authproviderParam, err := url.PathUnescape(matches[regex.SubexpIndex("authprovider")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListStaticSiteUsersPager(resourceGroupNameParam, nameParam, authproviderParam, nil)
		newListStaticSiteUsersPager = &resp
		s.newListStaticSiteUsersPager.add(req, newListStaticSiteUsersPager)
		server.PagerResponderInjectNextLinks(newListStaticSiteUsersPager, req, func(page *armappservice.StaticSitesClientListStaticSiteUsersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListStaticSiteUsersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListStaticSiteUsersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListStaticSiteUsersPager) {
		s.newListStaticSiteUsersPager.remove(req)
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchPreviewWorkflow(req *http.Request) (*http.Response, error) {
	if s.srv.PreviewWorkflow == nil {
		return nil, &nonRetriableError{errors.New("fake for method PreviewWorkflow not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/previewStaticSiteWorkflowFile`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSitesWorkflowPreviewRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.PreviewWorkflow(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSitesWorkflowPreview, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginRegisterUserProvidedFunctionAppWithStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.BeginRegisterUserProvidedFunctionAppWithStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRegisterUserProvidedFunctionAppWithStaticSite not implemented")}
	}
	beginRegisterUserProvidedFunctionAppWithStaticSite := s.beginRegisterUserProvidedFunctionAppWithStaticSite.get(req)
	if beginRegisterUserProvidedFunctionAppWithStaticSite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps/(?P<functionAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteUserProvidedFunctionAppARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		functionAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionAppName")])
		if err != nil {
			return nil, err
		}
		isForcedUnescaped, err := url.QueryUnescape(qp.Get("isForced"))
		if err != nil {
			return nil, err
		}
		isForcedParam, err := parseOptional(isForcedUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armappservice.StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions
		if isForcedParam != nil {
			options = &armappservice.StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions{
				IsForced: isForcedParam,
			}
		}
		respr, errRespr := s.srv.BeginRegisterUserProvidedFunctionAppWithStaticSite(req.Context(), resourceGroupNameParam, nameParam, functionAppNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRegisterUserProvidedFunctionAppWithStaticSite = &respr
		s.beginRegisterUserProvidedFunctionAppWithStaticSite.add(req, beginRegisterUserProvidedFunctionAppWithStaticSite)
	}

	resp, err := server.PollerResponderNext(beginRegisterUserProvidedFunctionAppWithStaticSite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginRegisterUserProvidedFunctionAppWithStaticSite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRegisterUserProvidedFunctionAppWithStaticSite) {
		s.beginRegisterUserProvidedFunctionAppWithStaticSite.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginRegisterUserProvidedFunctionAppWithStaticSiteBuild(req *http.Request) (*http.Response, error) {
	if s.srv.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild not implemented")}
	}
	beginRegisterUserProvidedFunctionAppWithStaticSiteBuild := s.beginRegisterUserProvidedFunctionAppWithStaticSiteBuild.get(req)
	if beginRegisterUserProvidedFunctionAppWithStaticSiteBuild == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userProvidedFunctionApps/(?P<functionAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteUserProvidedFunctionAppARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		functionAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("functionAppName")])
		if err != nil {
			return nil, err
		}
		isForcedUnescaped, err := url.QueryUnescape(qp.Get("isForced"))
		if err != nil {
			return nil, err
		}
		isForcedParam, err := parseOptional(isForcedUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armappservice.StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions
		if isForcedParam != nil {
			options = &armappservice.StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions{
				IsForced: isForcedParam,
			}
		}
		respr, errRespr := s.srv.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, functionAppNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRegisterUserProvidedFunctionAppWithStaticSiteBuild = &respr
		s.beginRegisterUserProvidedFunctionAppWithStaticSiteBuild.add(req, beginRegisterUserProvidedFunctionAppWithStaticSiteBuild)
	}

	resp, err := server.PollerResponderNext(beginRegisterUserProvidedFunctionAppWithStaticSiteBuild, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginRegisterUserProvidedFunctionAppWithStaticSiteBuild.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRegisterUserProvidedFunctionAppWithStaticSiteBuild) {
		s.beginRegisterUserProvidedFunctionAppWithStaticSiteBuild.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchResetStaticSiteAPIKey(req *http.Request) (*http.Response, error) {
	if s.srv.ResetStaticSiteAPIKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetStaticSiteAPIKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetapikey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteResetPropertiesARMResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ResetStaticSiteAPIKey(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchUnlinkBackend(req *http.Request) (*http.Response, error) {
	if s.srv.UnlinkBackend == nil {
		return nil, &nonRetriableError{errors.New("fake for method UnlinkBackend not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
	if err != nil {
		return nil, err
	}
	isCleaningAuthConfigUnescaped, err := url.QueryUnescape(qp.Get("isCleaningAuthConfig"))
	if err != nil {
		return nil, err
	}
	isCleaningAuthConfigParam, err := parseOptional(isCleaningAuthConfigUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.StaticSitesClientUnlinkBackendOptions
	if isCleaningAuthConfigParam != nil {
		options = &armappservice.StaticSitesClientUnlinkBackendOptions{
			IsCleaningAuthConfig: isCleaningAuthConfigParam,
		}
	}
	respr, errRespr := s.srv.UnlinkBackend(req.Context(), resourceGroupNameParam, nameParam, linkedBackendNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchUnlinkBackendFromBuild(req *http.Request) (*http.Response, error) {
	if s.srv.UnlinkBackendFromBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method UnlinkBackendFromBuild not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
	if err != nil {
		return nil, err
	}
	isCleaningAuthConfigUnescaped, err := url.QueryUnescape(qp.Get("isCleaningAuthConfig"))
	if err != nil {
		return nil, err
	}
	isCleaningAuthConfigParam, err := parseOptional(isCleaningAuthConfigUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.StaticSitesClientUnlinkBackendFromBuildOptions
	if isCleaningAuthConfigParam != nil {
		options = &armappservice.StaticSitesClientUnlinkBackendFromBuildOptions{
			IsCleaningAuthConfig: isCleaningAuthConfigParam,
		}
	}
	respr, errRespr := s.srv.UnlinkBackendFromBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, linkedBackendNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchUpdateBuildDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.UpdateBuildDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateBuildDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.DatabaseConnectionPatchRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.UpdateBuildDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, databaseConnectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchUpdateDatabaseConnection(req *http.Request) (*http.Response, error) {
	if s.srv.UpdateDatabaseConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateDatabaseConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseConnections/(?P<databaseConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.DatabaseConnectionPatchRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	databaseConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.UpdateDatabaseConnection(req.Context(), resourceGroupNameParam, nameParam, databaseConnectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchUpdateStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.UpdateStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateStaticSite not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSitePatchResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.UpdateStaticSite(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchUpdateStaticSiteUser(req *http.Request) (*http.Response, error) {
	if s.srv.UpdateStaticSiteUser == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateStaticSiteUser not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authproviders/(?P<authprovider>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteUserARMResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	authproviderParam, err := url.PathUnescape(matches[regex.SubexpIndex("authprovider")])
	if err != nil {
		return nil, err
	}
	useridParam, err := url.PathUnescape(matches[regex.SubexpIndex("userid")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.UpdateStaticSiteUser(req.Context(), resourceGroupNameParam, nameParam, authproviderParam, useridParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StaticSiteUserARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginValidateBackend(req *http.Request) (*http.Response, error) {
	if s.srv.BeginValidateBackend == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateBackend not implemented")}
	}
	beginValidateBackend := s.beginValidateBackend.get(req)
	if beginValidateBackend == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteLinkedBackendARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginValidateBackend(req.Context(), resourceGroupNameParam, nameParam, linkedBackendNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateBackend = &respr
		s.beginValidateBackend.add(req, beginValidateBackend)
	}

	resp, err := server.PollerResponderNext(beginValidateBackend, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginValidateBackend.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateBackend) {
		s.beginValidateBackend.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginValidateBackendForBuild(req *http.Request) (*http.Response, error) {
	if s.srv.BeginValidateBackendForBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateBackendForBuild not implemented")}
	}
	beginValidateBackendForBuild := s.beginValidateBackendForBuild.get(req)
	if beginValidateBackendForBuild == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedBackends/(?P<linkedBackendName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteLinkedBackendARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
		if err != nil {
			return nil, err
		}
		linkedBackendNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkedBackendName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginValidateBackendForBuild(req.Context(), resourceGroupNameParam, nameParam, environmentNameParam, linkedBackendNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateBackendForBuild = &respr
		s.beginValidateBackendForBuild.add(req, beginValidateBackendForBuild)
	}

	resp, err := server.PollerResponderNext(beginValidateBackendForBuild, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginValidateBackendForBuild.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateBackendForBuild) {
		s.beginValidateBackendForBuild.remove(req)
	}

	return resp, nil
}

func (s *StaticSitesServerTransport) dispatchBeginValidateCustomDomainCanBeAddedToStaticSite(req *http.Request) (*http.Response, error) {
	if s.srv.BeginValidateCustomDomainCanBeAddedToStaticSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateCustomDomainCanBeAddedToStaticSite not implemented")}
	}
	beginValidateCustomDomainCanBeAddedToStaticSite := s.beginValidateCustomDomainCanBeAddedToStaticSite.get(req)
	if beginValidateCustomDomainCanBeAddedToStaticSite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/staticSites/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.StaticSiteCustomDomainRequestPropertiesARMResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginValidateCustomDomainCanBeAddedToStaticSite(req.Context(), resourceGroupNameParam, nameParam, domainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateCustomDomainCanBeAddedToStaticSite = &respr
		s.beginValidateCustomDomainCanBeAddedToStaticSite.add(req, beginValidateCustomDomainCanBeAddedToStaticSite)
	}

	resp, err := server.PollerResponderNext(beginValidateCustomDomainCanBeAddedToStaticSite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginValidateCustomDomainCanBeAddedToStaticSite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateCustomDomainCanBeAddedToStaticSite) {
		s.beginValidateCustomDomainCanBeAddedToStaticSite.remove(req)
	}

	return resp, nil
}
