//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// EnvironmentsClient contains the methods for the AppServiceEnvironments group.
// Don't use this type directly, use NewEnvironmentsClient() instead.
type EnvironmentsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewEnvironmentsClient creates a new instance of EnvironmentsClient with the specified values.
//   - subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewEnvironmentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*EnvironmentsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &EnvironmentsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions contains the optional parameters for the
//     EnvironmentsClient.BeginApproveOrRejectPrivateEndpointConnection method.
func (client *EnvironmentsClient) BeginApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*runtime.Poller[EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.approveOrRejectPrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) approveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginApproveOrRejectPrivateEndpointConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.approveOrRejectPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// approveOrRejectPrivateEndpointConnectionCreateRequest creates the ApproveOrRejectPrivateEndpointConnection request.
func (client *EnvironmentsClient) approveOrRejectPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, privateEndpointWrapper); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginChangeVnet - Description for Move an App Service Environment to a different VNET.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - vnetInfo - Details for the new virtual network.
//   - options - EnvironmentsClientBeginChangeVnetOptions contains the optional parameters for the EnvironmentsClient.BeginChangeVnet
//     method.
func (client *EnvironmentsClient) BeginChangeVnet(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile, options *EnvironmentsClientBeginChangeVnetOptions) (*runtime.Poller[*runtime.Pager[EnvironmentsClientChangeVnetResponse]], error) {
	pager := runtime.NewPager(runtime.PagingHandler[EnvironmentsClientChangeVnetResponse]{
		More: func(page EnvironmentsClientChangeVnetResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientChangeVnetResponse) (EnvironmentsClientChangeVnetResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.BeginChangeVnet")
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), *page.NextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.changeVnetCreateRequest(ctx, resourceGroupName, name, vnetInfo, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientChangeVnetResponse{}, err
			}
			return client.changeVnetHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
	if options == nil || options.ResumeToken == "" {
		resp, err := client.changeVnet(ctx, resourceGroupName, name, vnetInfo, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[*runtime.Pager[EnvironmentsClientChangeVnetResponse]]{
			Response: &pager,
			Tracer:   client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[*runtime.Pager[EnvironmentsClientChangeVnetResponse]]{
			Response: &pager,
			Tracer:   client.internal.Tracer(),
		})
	}
}

// ChangeVnet - Description for Move an App Service Environment to a different VNET.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) changeVnet(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile, options *EnvironmentsClientBeginChangeVnetOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginChangeVnet"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.changeVnetCreateRequest(ctx, resourceGroupName, name, vnetInfo, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// changeVnetCreateRequest creates the ChangeVnet request.
func (client *EnvironmentsClient) changeVnetCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile, options *EnvironmentsClientBeginChangeVnetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/changeVirtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, vnetInfo); err != nil {
		return nil, err
	}
	return req, nil
}

// changeVnetHandleResponse handles the ChangeVnet response.
func (client *EnvironmentsClient) changeVnetHandleResponse(resp *http.Response) (EnvironmentsClientChangeVnetResponse, error) {
	result := EnvironmentsClientChangeVnetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientChangeVnetResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Description for Create or update an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - hostingEnvironmentEnvelope - Configuration details of the App Service Environment.
//   - options - EnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdate
//     method.
func (client *EnvironmentsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentResource, options *EnvironmentsClientBeginCreateOrUpdateOptions) (*runtime.Poller[EnvironmentsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, name, hostingEnvironmentEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[EnvironmentsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[EnvironmentsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Description for Create or update an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) createOrUpdate(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentResource, options *EnvironmentsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, name, hostingEnvironmentEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *EnvironmentsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentResource, options *EnvironmentsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, hostingEnvironmentEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateOrUpdateMultiRolePool - Description for Create or update a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - multiRolePoolEnvelope - Properties of the multi-role pool.
//   - options - EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdateMultiRolePool
//     method.
func (client *EnvironmentsClient) BeginCreateOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions) (*runtime.Poller[EnvironmentsClientCreateOrUpdateMultiRolePoolResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateMultiRolePool(ctx, resourceGroupName, name, multiRolePoolEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[EnvironmentsClientCreateOrUpdateMultiRolePoolResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[EnvironmentsClientCreateOrUpdateMultiRolePoolResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateMultiRolePool - Description for Create or update a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) createOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginCreateOrUpdateMultiRolePool"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateMultiRolePoolCreateRequest(ctx, resourceGroupName, name, multiRolePoolEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateMultiRolePoolCreateRequest creates the CreateOrUpdateMultiRolePool request.
func (client *EnvironmentsClient) createOrUpdateMultiRolePoolCreateRequest(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, multiRolePoolEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateOrUpdateWorkerPool - Description for Create or update a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - workerPoolName - Name of the worker pool.
//   - workerPoolEnvelope - Properties of the worker pool.
//   - options - EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdateWorkerPool
//     method.
func (client *EnvironmentsClient) BeginCreateOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions) (*runtime.Poller[EnvironmentsClientCreateOrUpdateWorkerPoolResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateWorkerPool(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[EnvironmentsClientCreateOrUpdateWorkerPoolResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[EnvironmentsClientCreateOrUpdateWorkerPoolResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateWorkerPool - Description for Create or update a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) createOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginCreateOrUpdateWorkerPool"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateWorkerPoolCreateRequest(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateWorkerPoolCreateRequest creates the CreateOrUpdateWorkerPool request.
func (client *EnvironmentsClient) createOrUpdateWorkerPoolCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, workerPoolEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Description for Delete an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientBeginDeleteOptions contains the optional parameters for the EnvironmentsClient.BeginDelete
//     method.
func (client *EnvironmentsClient) BeginDelete(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginDeleteOptions) (*runtime.Poller[EnvironmentsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[EnvironmentsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[EnvironmentsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Description for Delete an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) deleteOperation(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *EnvironmentsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.ForceDelete != nil {
		reqQP.Set("forceDelete", strconv.FormatBool(*options.ForceDelete))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteAseCustomDNSSuffixConfiguration - Delete Custom Dns Suffix configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.DeleteAseCustomDNSSuffixConfiguration
//     method.
func (client *EnvironmentsClient) DeleteAseCustomDNSSuffixConfiguration(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions) (EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.DeleteAseCustomDNSSuffixConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAseCustomDNSSuffixConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, err
	}
	resp, err := client.deleteAseCustomDNSSuffixConfigurationHandleResponse(httpResp)
	return resp, err
}

// deleteAseCustomDNSSuffixConfigurationCreateRequest creates the DeleteAseCustomDNSSuffixConfiguration request.
func (client *EnvironmentsClient) deleteAseCustomDNSSuffixConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAseCustomDNSSuffixConfigurationHandleResponse handles the DeleteAseCustomDNSSuffixConfiguration response.
func (client *EnvironmentsClient) deleteAseCustomDNSSuffixConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse, error) {
	result := EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Interface); err != nil {
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, err
	}
	return result, nil
}

// BeginDeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the EnvironmentsClient.BeginDeletePrivateEndpointConnection
//     method.
func (client *EnvironmentsClient) BeginDeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions) (*runtime.Poller[EnvironmentsClientDeletePrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deletePrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[EnvironmentsClientDeletePrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[EnvironmentsClientDeletePrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) deletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginDeletePrivateEndpointConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deletePrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deletePrivateEndpointConnectionCreateRequest creates the DeletePrivateEndpointConnection request.
func (client *EnvironmentsClient) deletePrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Description for Get the properties of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetOptions contains the optional parameters for the EnvironmentsClient.Get method.
func (client *EnvironmentsClient) Get(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetOptions) (EnvironmentsClientGetResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *EnvironmentsClient) getCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *EnvironmentsClient) getHandleResponse(resp *http.Response) (EnvironmentsClientGetResponse, error) {
	result := EnvironmentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentResource); err != nil {
		return EnvironmentsClientGetResponse{}, err
	}
	return result, nil
}

// GetAseCustomDNSSuffixConfiguration - Get Custom Dns Suffix configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.GetAseCustomDNSSuffixConfiguration
//     method.
func (client *EnvironmentsClient) GetAseCustomDNSSuffixConfiguration(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions) (EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetAseCustomDNSSuffixConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAseCustomDNSSuffixConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, err
	}
	resp, err := client.getAseCustomDNSSuffixConfigurationHandleResponse(httpResp)
	return resp, err
}

// getAseCustomDNSSuffixConfigurationCreateRequest creates the GetAseCustomDNSSuffixConfiguration request.
func (client *EnvironmentsClient) getAseCustomDNSSuffixConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAseCustomDNSSuffixConfigurationHandleResponse handles the GetAseCustomDNSSuffixConfiguration response.
func (client *EnvironmentsClient) getAseCustomDNSSuffixConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse, error) {
	result := EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CustomDNSSuffixConfiguration); err != nil {
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, err
	}
	return result, nil
}

// GetAseV3NetworkingConfiguration - Description for Get networking configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetAseV3NetworkingConfigurationOptions contains the optional parameters for the EnvironmentsClient.GetAseV3NetworkingConfiguration
//     method.
func (client *EnvironmentsClient) GetAseV3NetworkingConfiguration(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseV3NetworkingConfigurationOptions) (EnvironmentsClientGetAseV3NetworkingConfigurationResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetAseV3NetworkingConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAseV3NetworkingConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, err
	}
	resp, err := client.getAseV3NetworkingConfigurationHandleResponse(httpResp)
	return resp, err
}

// getAseV3NetworkingConfigurationCreateRequest creates the GetAseV3NetworkingConfiguration request.
func (client *EnvironmentsClient) getAseV3NetworkingConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseV3NetworkingConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/networking"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAseV3NetworkingConfigurationHandleResponse handles the GetAseV3NetworkingConfiguration response.
func (client *EnvironmentsClient) getAseV3NetworkingConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientGetAseV3NetworkingConfigurationResponse, error) {
	result := EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AseV3NetworkingConfiguration); err != nil {
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, err
	}
	return result, nil
}

// GetDiagnosticsItem - Description for Get a diagnostics item for an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - diagnosticsName - Name of the diagnostics item.
//   - options - EnvironmentsClientGetDiagnosticsItemOptions contains the optional parameters for the EnvironmentsClient.GetDiagnosticsItem
//     method.
func (client *EnvironmentsClient) GetDiagnosticsItem(ctx context.Context, resourceGroupName string, name string, diagnosticsName string, options *EnvironmentsClientGetDiagnosticsItemOptions) (EnvironmentsClientGetDiagnosticsItemResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetDiagnosticsItem"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDiagnosticsItemCreateRequest(ctx, resourceGroupName, name, diagnosticsName, options)
	if err != nil {
		return EnvironmentsClientGetDiagnosticsItemResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetDiagnosticsItemResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetDiagnosticsItemResponse{}, err
	}
	resp, err := client.getDiagnosticsItemHandleResponse(httpResp)
	return resp, err
}

// getDiagnosticsItemCreateRequest creates the GetDiagnosticsItem request.
func (client *EnvironmentsClient) getDiagnosticsItemCreateRequest(ctx context.Context, resourceGroupName string, name string, diagnosticsName string, options *EnvironmentsClientGetDiagnosticsItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if diagnosticsName == "" {
		return nil, errors.New("parameter diagnosticsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticsName}", url.PathEscape(diagnosticsName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDiagnosticsItemHandleResponse handles the GetDiagnosticsItem response.
func (client *EnvironmentsClient) getDiagnosticsItemHandleResponse(resp *http.Response) (EnvironmentsClientGetDiagnosticsItemResponse, error) {
	result := EnvironmentsClientGetDiagnosticsItemResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostingEnvironmentDiagnostics); err != nil {
		return EnvironmentsClientGetDiagnosticsItemResponse{}, err
	}
	return result, nil
}

// NewGetInboundNetworkDependenciesEndpointsPager - Description for Get the network endpoints of all inbound dependencies
// of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions contains the optional parameters for the EnvironmentsClient.NewGetInboundNetworkDependenciesEndpointsPager
//     method.
func (client *EnvironmentsClient) NewGetInboundNetworkDependenciesEndpointsPager(resourceGroupName string, name string, options *EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions) *runtime.Pager[EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse]{
		More: func(page EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse) (EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewGetInboundNetworkDependenciesEndpointsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getInboundNetworkDependenciesEndpointsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}, err
			}
			return client.getInboundNetworkDependenciesEndpointsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getInboundNetworkDependenciesEndpointsCreateRequest creates the GetInboundNetworkDependenciesEndpoints request.
func (client *EnvironmentsClient) getInboundNetworkDependenciesEndpointsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/inboundNetworkDependenciesEndpoints"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInboundNetworkDependenciesEndpointsHandleResponse handles the GetInboundNetworkDependenciesEndpoints response.
func (client *EnvironmentsClient) getInboundNetworkDependenciesEndpointsHandleResponse(resp *http.Response) (EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse, error) {
	result := EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InboundEnvironmentEndpointCollection); err != nil {
		return EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}, err
	}
	return result, nil
}

// GetMultiRolePool - Description for Get properties of a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.GetMultiRolePool
//     method.
func (client *EnvironmentsClient) GetMultiRolePool(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetMultiRolePoolOptions) (EnvironmentsClientGetMultiRolePoolResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetMultiRolePool"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getMultiRolePoolCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetMultiRolePoolResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetMultiRolePoolResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetMultiRolePoolResponse{}, err
	}
	resp, err := client.getMultiRolePoolHandleResponse(httpResp)
	return resp, err
}

// getMultiRolePoolCreateRequest creates the GetMultiRolePool request.
func (client *EnvironmentsClient) getMultiRolePoolCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetMultiRolePoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMultiRolePoolHandleResponse handles the GetMultiRolePool response.
func (client *EnvironmentsClient) getMultiRolePoolHandleResponse(resp *http.Response) (EnvironmentsClientGetMultiRolePoolResponse, error) {
	result := EnvironmentsClientGetMultiRolePoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientGetMultiRolePoolResponse{}, err
	}
	return result, nil
}

// NewGetOutboundNetworkDependenciesEndpointsPager - Description for Get the network endpoints of all outbound dependencies
// of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the EnvironmentsClient.NewGetOutboundNetworkDependenciesEndpointsPager
//     method.
func (client *EnvironmentsClient) NewGetOutboundNetworkDependenciesEndpointsPager(resourceGroupName string, name string, options *EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions) *runtime.Pager[EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse]{
		More: func(page EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse) (EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewGetOutboundNetworkDependenciesEndpointsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getOutboundNetworkDependenciesEndpointsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}, err
			}
			return client.getOutboundNetworkDependenciesEndpointsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getOutboundNetworkDependenciesEndpointsCreateRequest creates the GetOutboundNetworkDependenciesEndpoints request.
func (client *EnvironmentsClient) getOutboundNetworkDependenciesEndpointsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/outboundNetworkDependenciesEndpoints"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOutboundNetworkDependenciesEndpointsHandleResponse handles the GetOutboundNetworkDependenciesEndpoints response.
func (client *EnvironmentsClient) getOutboundNetworkDependenciesEndpointsHandleResponse(resp *http.Response) (EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse, error) {
	result := EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OutboundEnvironmentEndpointCollection); err != nil {
		return EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}, err
	}
	return result, nil
}

// GetPrivateEndpointConnection - Description for Gets a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - privateEndpointConnectionName - Name of the private endpoint connection.
//   - options - EnvironmentsClientGetPrivateEndpointConnectionOptions contains the optional parameters for the EnvironmentsClient.GetPrivateEndpointConnection
//     method.
func (client *EnvironmentsClient) GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientGetPrivateEndpointConnectionOptions) (EnvironmentsClientGetPrivateEndpointConnectionResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetPrivateEndpointConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, err
	}
	resp, err := client.getPrivateEndpointConnectionHandleResponse(httpResp)
	return resp, err
}

// getPrivateEndpointConnectionCreateRequest creates the GetPrivateEndpointConnection request.
func (client *EnvironmentsClient) getPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientGetPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionHandleResponse handles the GetPrivateEndpointConnection response.
func (client *EnvironmentsClient) getPrivateEndpointConnectionHandleResponse(resp *http.Response) (EnvironmentsClientGetPrivateEndpointConnectionResponse, error) {
	result := EnvironmentsClientGetPrivateEndpointConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemotePrivateEndpointConnectionARMResource); err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, err
	}
	return result, nil
}

// NewGetPrivateEndpointConnectionListPager - Description for Gets the list of private endpoints associated with a hosting
// environment
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetPrivateEndpointConnectionListOptions contains the optional parameters for the EnvironmentsClient.NewGetPrivateEndpointConnectionListPager
//     method.
func (client *EnvironmentsClient) NewGetPrivateEndpointConnectionListPager(resourceGroupName string, name string, options *EnvironmentsClientGetPrivateEndpointConnectionListOptions) *runtime.Pager[EnvironmentsClientGetPrivateEndpointConnectionListResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientGetPrivateEndpointConnectionListResponse]{
		More: func(page EnvironmentsClientGetPrivateEndpointConnectionListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientGetPrivateEndpointConnectionListResponse) (EnvironmentsClientGetPrivateEndpointConnectionListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewGetPrivateEndpointConnectionListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getPrivateEndpointConnectionListCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientGetPrivateEndpointConnectionListResponse{}, err
			}
			return client.getPrivateEndpointConnectionListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getPrivateEndpointConnectionListCreateRequest creates the GetPrivateEndpointConnectionList request.
func (client *EnvironmentsClient) getPrivateEndpointConnectionListCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetPrivateEndpointConnectionListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionListHandleResponse handles the GetPrivateEndpointConnectionList response.
func (client *EnvironmentsClient) getPrivateEndpointConnectionListHandleResponse(resp *http.Response) (EnvironmentsClientGetPrivateEndpointConnectionListResponse, error) {
	result := EnvironmentsClientGetPrivateEndpointConnectionListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateEndpointConnectionCollection); err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionListResponse{}, err
	}
	return result, nil
}

// GetPrivateLinkResources - Description for Gets the private link resources
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetPrivateLinkResourcesOptions contains the optional parameters for the EnvironmentsClient.GetPrivateLinkResources
//     method.
func (client *EnvironmentsClient) GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetPrivateLinkResourcesOptions) (EnvironmentsClientGetPrivateLinkResourcesResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetPrivateLinkResources"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getPrivateLinkResourcesCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, err
	}
	resp, err := client.getPrivateLinkResourcesHandleResponse(httpResp)
	return resp, err
}

// getPrivateLinkResourcesCreateRequest creates the GetPrivateLinkResources request.
func (client *EnvironmentsClient) getPrivateLinkResourcesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetPrivateLinkResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateLinkResources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateLinkResourcesHandleResponse handles the GetPrivateLinkResources response.
func (client *EnvironmentsClient) getPrivateLinkResourcesHandleResponse(resp *http.Response) (EnvironmentsClientGetPrivateLinkResourcesResponse, error) {
	result := EnvironmentsClientGetPrivateLinkResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResourcesWrapper); err != nil {
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, err
	}
	return result, nil
}

// GetVipInfo - Description for Get IP addresses assigned to an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientGetVipInfoOptions contains the optional parameters for the EnvironmentsClient.GetVipInfo method.
func (client *EnvironmentsClient) GetVipInfo(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetVipInfoOptions) (EnvironmentsClientGetVipInfoResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetVipInfo"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getVipInfoCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetVipInfoResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetVipInfoResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetVipInfoResponse{}, err
	}
	resp, err := client.getVipInfoHandleResponse(httpResp)
	return resp, err
}

// getVipInfoCreateRequest creates the GetVipInfo request.
func (client *EnvironmentsClient) getVipInfoCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetVipInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVipInfoHandleResponse handles the GetVipInfo response.
func (client *EnvironmentsClient) getVipInfoHandleResponse(resp *http.Response) (EnvironmentsClientGetVipInfoResponse, error) {
	result := EnvironmentsClientGetVipInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResponse); err != nil {
		return EnvironmentsClientGetVipInfoResponse{}, err
	}
	return result, nil
}

// GetWorkerPool - Description for Get properties of a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - workerPoolName - Name of the worker pool.
//   - options - EnvironmentsClientGetWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.GetWorkerPool
//     method.
func (client *EnvironmentsClient) GetWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientGetWorkerPoolOptions) (EnvironmentsClientGetWorkerPoolResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.GetWorkerPool"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getWorkerPoolCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
	if err != nil {
		return EnvironmentsClientGetWorkerPoolResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientGetWorkerPoolResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientGetWorkerPoolResponse{}, err
	}
	resp, err := client.getWorkerPoolHandleResponse(httpResp)
	return resp, err
}

// getWorkerPoolCreateRequest creates the GetWorkerPool request.
func (client *EnvironmentsClient) getWorkerPoolCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientGetWorkerPoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getWorkerPoolHandleResponse handles the GetWorkerPool response.
func (client *EnvironmentsClient) getWorkerPoolHandleResponse(resp *http.Response) (EnvironmentsClientGetWorkerPoolResponse, error) {
	result := EnvironmentsClientGetWorkerPoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientGetWorkerPoolResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for Get all App Service Environments for a subscription.
//
// Generated from API version 2023-01-01
//   - options - EnvironmentsClientListOptions contains the optional parameters for the EnvironmentsClient.NewListPager method.
func (client *EnvironmentsClient) NewListPager(options *EnvironmentsClientListOptions) *runtime.Pager[EnvironmentsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListResponse]{
		More: func(page EnvironmentsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListResponse) (EnvironmentsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *EnvironmentsClient) listCreateRequest(ctx context.Context, options *EnvironmentsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *EnvironmentsClient) listHandleResponse(resp *http.Response) (EnvironmentsClientListResponse, error) {
	result := EnvironmentsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentCollection); err != nil {
		return EnvironmentsClientListResponse{}, err
	}
	return result, nil
}

// NewListAppServicePlansPager - Description for Get all App Service plans in an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListAppServicePlansOptions contains the optional parameters for the EnvironmentsClient.NewListAppServicePlansPager
//     method.
func (client *EnvironmentsClient) NewListAppServicePlansPager(resourceGroupName string, name string, options *EnvironmentsClientListAppServicePlansOptions) *runtime.Pager[EnvironmentsClientListAppServicePlansResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListAppServicePlansResponse]{
		More: func(page EnvironmentsClientListAppServicePlansResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListAppServicePlansResponse) (EnvironmentsClientListAppServicePlansResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListAppServicePlansPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAppServicePlansCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListAppServicePlansResponse{}, err
			}
			return client.listAppServicePlansHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAppServicePlansCreateRequest creates the ListAppServicePlans request.
func (client *EnvironmentsClient) listAppServicePlansCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListAppServicePlansOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAppServicePlansHandleResponse handles the ListAppServicePlans response.
func (client *EnvironmentsClient) listAppServicePlansHandleResponse(resp *http.Response) (EnvironmentsClientListAppServicePlansResponse, error) {
	result := EnvironmentsClientListAppServicePlansResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PlanCollection); err != nil {
		return EnvironmentsClientListAppServicePlansResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Description for Get all App Service Environments in a resource group.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - options - EnvironmentsClientListByResourceGroupOptions contains the optional parameters for the EnvironmentsClient.NewListByResourceGroupPager
//     method.
func (client *EnvironmentsClient) NewListByResourceGroupPager(resourceGroupName string, options *EnvironmentsClientListByResourceGroupOptions) *runtime.Pager[EnvironmentsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListByResourceGroupResponse]{
		More: func(page EnvironmentsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListByResourceGroupResponse) (EnvironmentsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *EnvironmentsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *EnvironmentsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *EnvironmentsClient) listByResourceGroupHandleResponse(resp *http.Response) (EnvironmentsClientListByResourceGroupResponse, error) {
	result := EnvironmentsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentCollection); err != nil {
		return EnvironmentsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListCapacitiesPager - Description for Get the used, available, and total worker capacity an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListCapacitiesOptions contains the optional parameters for the EnvironmentsClient.NewListCapacitiesPager
//     method.
func (client *EnvironmentsClient) NewListCapacitiesPager(resourceGroupName string, name string, options *EnvironmentsClientListCapacitiesOptions) *runtime.Pager[EnvironmentsClientListCapacitiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListCapacitiesResponse]{
		More: func(page EnvironmentsClientListCapacitiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListCapacitiesResponse) (EnvironmentsClientListCapacitiesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListCapacitiesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCapacitiesCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListCapacitiesResponse{}, err
			}
			return client.listCapacitiesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCapacitiesCreateRequest creates the ListCapacities request.
func (client *EnvironmentsClient) listCapacitiesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListCapacitiesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCapacitiesHandleResponse handles the ListCapacities response.
func (client *EnvironmentsClient) listCapacitiesHandleResponse(resp *http.Response) (EnvironmentsClientListCapacitiesResponse, error) {
	result := EnvironmentsClientListCapacitiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StampCapacityCollection); err != nil {
		return EnvironmentsClientListCapacitiesResponse{}, err
	}
	return result, nil
}

// ListDiagnostics - Description for Get diagnostic information for an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListDiagnosticsOptions contains the optional parameters for the EnvironmentsClient.ListDiagnostics
//     method.
func (client *EnvironmentsClient) ListDiagnostics(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListDiagnosticsOptions) (EnvironmentsClientListDiagnosticsResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.ListDiagnostics"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listDiagnosticsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientListDiagnosticsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientListDiagnosticsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientListDiagnosticsResponse{}, err
	}
	resp, err := client.listDiagnosticsHandleResponse(httpResp)
	return resp, err
}

// listDiagnosticsCreateRequest creates the ListDiagnostics request.
func (client *EnvironmentsClient) listDiagnosticsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListDiagnosticsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDiagnosticsHandleResponse handles the ListDiagnostics response.
func (client *EnvironmentsClient) listDiagnosticsHandleResponse(resp *http.Response) (EnvironmentsClientListDiagnosticsResponse, error) {
	result := EnvironmentsClientListDiagnosticsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostingEnvironmentDiagnosticsArray); err != nil {
		return EnvironmentsClientListDiagnosticsResponse{}, err
	}
	return result, nil
}

// NewListMultiRoleMetricDefinitionsPager - Description for Get metric definitions for a multi-role pool of an App Service
// Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListMultiRoleMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.NewListMultiRoleMetricDefinitionsPager
//     method.
func (client *EnvironmentsClient) NewListMultiRoleMetricDefinitionsPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListMultiRoleMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRoleMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListMultiRoleMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRoleMetricDefinitionsResponse) (EnvironmentsClientListMultiRoleMetricDefinitionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListMultiRoleMetricDefinitionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listMultiRoleMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}, err
			}
			return client.listMultiRoleMetricDefinitionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMultiRoleMetricDefinitionsCreateRequest creates the ListMultiRoleMetricDefinitions request.
func (client *EnvironmentsClient) listMultiRoleMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRoleMetricDefinitionsHandleResponse handles the ListMultiRoleMetricDefinitions response.
func (client *EnvironmentsClient) listMultiRoleMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRoleMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListMultiRolePoolInstanceMetricDefinitionsPager - Description for Get metric definitions for a specific instance of
// a multi-role pool of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - instance - Name of the instance in the multi-role pool.
//   - options - EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions contains the optional parameters for the
//     EnvironmentsClient.NewListMultiRolePoolInstanceMetricDefinitionsPager method.
func (client *EnvironmentsClient) NewListMultiRolePoolInstanceMetricDefinitionsPager(resourceGroupName string, name string, instance string, options *EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse) (EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListMultiRolePoolInstanceMetricDefinitionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listMultiRolePoolInstanceMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, instance, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}, err
			}
			return client.listMultiRolePoolInstanceMetricDefinitionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMultiRolePoolInstanceMetricDefinitionsCreateRequest creates the ListMultiRolePoolInstanceMetricDefinitions request.
func (client *EnvironmentsClient) listMultiRolePoolInstanceMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, instance string, options *EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instance == "" {
		return nil, errors.New("parameter instance cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instance}", url.PathEscape(instance))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRolePoolInstanceMetricDefinitionsHandleResponse handles the ListMultiRolePoolInstanceMetricDefinitions response.
func (client *EnvironmentsClient) listMultiRolePoolInstanceMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListMultiRolePoolSKUsPager - Description for Get available SKUs for scaling a multi-role pool.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListMultiRolePoolSKUsOptions contains the optional parameters for the EnvironmentsClient.NewListMultiRolePoolSKUsPager
//     method.
func (client *EnvironmentsClient) NewListMultiRolePoolSKUsPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolSKUsOptions) *runtime.Pager[EnvironmentsClientListMultiRolePoolSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRolePoolSKUsResponse]{
		More: func(page EnvironmentsClientListMultiRolePoolSKUsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRolePoolSKUsResponse) (EnvironmentsClientListMultiRolePoolSKUsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListMultiRolePoolSKUsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listMultiRolePoolSKUsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListMultiRolePoolSKUsResponse{}, err
			}
			return client.listMultiRolePoolSKUsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMultiRolePoolSKUsCreateRequest creates the ListMultiRolePoolSKUs request.
func (client *EnvironmentsClient) listMultiRolePoolSKUsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRolePoolSKUsHandleResponse handles the ListMultiRolePoolSKUs response.
func (client *EnvironmentsClient) listMultiRolePoolSKUsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRolePoolSKUsResponse, error) {
	result := EnvironmentsClientListMultiRolePoolSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUInfoCollection); err != nil {
		return EnvironmentsClientListMultiRolePoolSKUsResponse{}, err
	}
	return result, nil
}

// NewListMultiRolePoolsPager - Description for Get all multi-role pools.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListMultiRolePoolsOptions contains the optional parameters for the EnvironmentsClient.NewListMultiRolePoolsPager
//     method.
func (client *EnvironmentsClient) NewListMultiRolePoolsPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolsOptions) *runtime.Pager[EnvironmentsClientListMultiRolePoolsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRolePoolsResponse]{
		More: func(page EnvironmentsClientListMultiRolePoolsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRolePoolsResponse) (EnvironmentsClientListMultiRolePoolsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListMultiRolePoolsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listMultiRolePoolsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListMultiRolePoolsResponse{}, err
			}
			return client.listMultiRolePoolsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMultiRolePoolsCreateRequest creates the ListMultiRolePools request.
func (client *EnvironmentsClient) listMultiRolePoolsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRolePoolsHandleResponse handles the ListMultiRolePools response.
func (client *EnvironmentsClient) listMultiRolePoolsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRolePoolsResponse, error) {
	result := EnvironmentsClientListMultiRolePoolsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolCollection); err != nil {
		return EnvironmentsClientListMultiRolePoolsResponse{}, err
	}
	return result, nil
}

// NewListMultiRoleUsagesPager - Description for Get usage metrics for a multi-role pool of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListMultiRoleUsagesOptions contains the optional parameters for the EnvironmentsClient.NewListMultiRoleUsagesPager
//     method.
func (client *EnvironmentsClient) NewListMultiRoleUsagesPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleUsagesOptions) *runtime.Pager[EnvironmentsClientListMultiRoleUsagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRoleUsagesResponse]{
		More: func(page EnvironmentsClientListMultiRoleUsagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRoleUsagesResponse) (EnvironmentsClientListMultiRoleUsagesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListMultiRoleUsagesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listMultiRoleUsagesCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListMultiRoleUsagesResponse{}, err
			}
			return client.listMultiRoleUsagesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMultiRoleUsagesCreateRequest creates the ListMultiRoleUsages request.
func (client *EnvironmentsClient) listMultiRoleUsagesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleUsagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRoleUsagesHandleResponse handles the ListMultiRoleUsages response.
func (client *EnvironmentsClient) listMultiRoleUsagesHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRoleUsagesResponse, error) {
	result := EnvironmentsClientListMultiRoleUsagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UsageCollection); err != nil {
		return EnvironmentsClientListMultiRoleUsagesResponse{}, err
	}
	return result, nil
}

// ListOperations - Description for List all currently running operations on the App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListOperationsOptions contains the optional parameters for the EnvironmentsClient.ListOperations
//     method.
func (client *EnvironmentsClient) ListOperations(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListOperationsOptions) (EnvironmentsClientListOperationsResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.ListOperations"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listOperationsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientListOperationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientListOperationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientListOperationsResponse{}, err
	}
	resp, err := client.listOperationsHandleResponse(httpResp)
	return resp, err
}

// listOperationsCreateRequest creates the ListOperations request.
func (client *EnvironmentsClient) listOperationsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListOperationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOperationsHandleResponse handles the ListOperations response.
func (client *EnvironmentsClient) listOperationsHandleResponse(resp *http.Response) (EnvironmentsClientListOperationsResponse, error) {
	result := EnvironmentsClientListOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationArray); err != nil {
		return EnvironmentsClientListOperationsResponse{}, err
	}
	return result, nil
}

// NewListUsagesPager - Description for Get global usage metrics of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListUsagesOptions contains the optional parameters for the EnvironmentsClient.NewListUsagesPager
//     method.
func (client *EnvironmentsClient) NewListUsagesPager(resourceGroupName string, name string, options *EnvironmentsClientListUsagesOptions) *runtime.Pager[EnvironmentsClientListUsagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListUsagesResponse]{
		More: func(page EnvironmentsClientListUsagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListUsagesResponse) (EnvironmentsClientListUsagesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListUsagesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listUsagesCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListUsagesResponse{}, err
			}
			return client.listUsagesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listUsagesCreateRequest creates the ListUsages request.
func (client *EnvironmentsClient) listUsagesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListUsagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listUsagesHandleResponse handles the ListUsages response.
func (client *EnvironmentsClient) listUsagesHandleResponse(resp *http.Response) (EnvironmentsClientListUsagesResponse, error) {
	result := EnvironmentsClientListUsagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmUsageQuotaCollection); err != nil {
		return EnvironmentsClientListUsagesResponse{}, err
	}
	return result, nil
}

// NewListWebAppsPager - Description for Get all apps in an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListWebAppsOptions contains the optional parameters for the EnvironmentsClient.NewListWebAppsPager
//     method.
func (client *EnvironmentsClient) NewListWebAppsPager(resourceGroupName string, name string, options *EnvironmentsClientListWebAppsOptions) *runtime.Pager[EnvironmentsClientListWebAppsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWebAppsResponse]{
		More: func(page EnvironmentsClientListWebAppsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWebAppsResponse) (EnvironmentsClientListWebAppsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListWebAppsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWebAppsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListWebAppsResponse{}, err
			}
			return client.listWebAppsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWebAppsCreateRequest creates the ListWebApps request.
func (client *EnvironmentsClient) listWebAppsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListWebAppsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.PropertiesToInclude != nil {
		reqQP.Set("propertiesToInclude", *options.PropertiesToInclude)
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebAppsHandleResponse handles the ListWebApps response.
func (client *EnvironmentsClient) listWebAppsHandleResponse(resp *http.Response) (EnvironmentsClientListWebAppsResponse, error) {
	result := EnvironmentsClientListWebAppsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientListWebAppsResponse{}, err
	}
	return result, nil
}

// NewListWebWorkerMetricDefinitionsPager - Description for Get metric definitions for a worker pool of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - workerPoolName - Name of the worker pool.
//   - options - EnvironmentsClientListWebWorkerMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.NewListWebWorkerMetricDefinitionsPager
//     method.
func (client *EnvironmentsClient) NewListWebWorkerMetricDefinitionsPager(resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListWebWorkerMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWebWorkerMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListWebWorkerMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWebWorkerMetricDefinitionsResponse) (EnvironmentsClientListWebWorkerMetricDefinitionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListWebWorkerMetricDefinitionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWebWorkerMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}, err
			}
			return client.listWebWorkerMetricDefinitionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWebWorkerMetricDefinitionsCreateRequest creates the ListWebWorkerMetricDefinitions request.
func (client *EnvironmentsClient) listWebWorkerMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebWorkerMetricDefinitionsHandleResponse handles the ListWebWorkerMetricDefinitions response.
func (client *EnvironmentsClient) listWebWorkerMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListWebWorkerMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListWebWorkerUsagesPager - Description for Get usage metrics for a worker pool of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - workerPoolName - Name of the worker pool.
//   - options - EnvironmentsClientListWebWorkerUsagesOptions contains the optional parameters for the EnvironmentsClient.NewListWebWorkerUsagesPager
//     method.
func (client *EnvironmentsClient) NewListWebWorkerUsagesPager(resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerUsagesOptions) *runtime.Pager[EnvironmentsClientListWebWorkerUsagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWebWorkerUsagesResponse]{
		More: func(page EnvironmentsClientListWebWorkerUsagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWebWorkerUsagesResponse) (EnvironmentsClientListWebWorkerUsagesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListWebWorkerUsagesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWebWorkerUsagesCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListWebWorkerUsagesResponse{}, err
			}
			return client.listWebWorkerUsagesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWebWorkerUsagesCreateRequest creates the ListWebWorkerUsages request.
func (client *EnvironmentsClient) listWebWorkerUsagesCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerUsagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebWorkerUsagesHandleResponse handles the ListWebWorkerUsages response.
func (client *EnvironmentsClient) listWebWorkerUsagesHandleResponse(resp *http.Response) (EnvironmentsClientListWebWorkerUsagesResponse, error) {
	result := EnvironmentsClientListWebWorkerUsagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UsageCollection); err != nil {
		return EnvironmentsClientListWebWorkerUsagesResponse{}, err
	}
	return result, nil
}

// NewListWorkerPoolInstanceMetricDefinitionsPager - Description for Get metric definitions for a specific instance of a worker
// pool of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - workerPoolName - Name of the worker pool.
//   - instance - Name of the instance in the worker pool.
//   - options - EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.NewListWorkerPoolInstanceMetricDefinitionsPager
//     method.
func (client *EnvironmentsClient) NewListWorkerPoolInstanceMetricDefinitionsPager(resourceGroupName string, name string, workerPoolName string, instance string, options *EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse) (EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListWorkerPoolInstanceMetricDefinitionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWorkerPoolInstanceMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, workerPoolName, instance, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}, err
			}
			return client.listWorkerPoolInstanceMetricDefinitionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWorkerPoolInstanceMetricDefinitionsCreateRequest creates the ListWorkerPoolInstanceMetricDefinitions request.
func (client *EnvironmentsClient) listWorkerPoolInstanceMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, options *EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if instance == "" {
		return nil, errors.New("parameter instance cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instance}", url.PathEscape(instance))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWorkerPoolInstanceMetricDefinitionsHandleResponse handles the ListWorkerPoolInstanceMetricDefinitions response.
func (client *EnvironmentsClient) listWorkerPoolInstanceMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListWorkerPoolSKUsPager - Description for Get available SKUs for scaling a worker pool.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - workerPoolName - Name of the worker pool.
//   - options - EnvironmentsClientListWorkerPoolSKUsOptions contains the optional parameters for the EnvironmentsClient.NewListWorkerPoolSKUsPager
//     method.
func (client *EnvironmentsClient) NewListWorkerPoolSKUsPager(resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWorkerPoolSKUsOptions) *runtime.Pager[EnvironmentsClientListWorkerPoolSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWorkerPoolSKUsResponse]{
		More: func(page EnvironmentsClientListWorkerPoolSKUsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWorkerPoolSKUsResponse) (EnvironmentsClientListWorkerPoolSKUsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListWorkerPoolSKUsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWorkerPoolSKUsCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListWorkerPoolSKUsResponse{}, err
			}
			return client.listWorkerPoolSKUsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWorkerPoolSKUsCreateRequest creates the ListWorkerPoolSKUs request.
func (client *EnvironmentsClient) listWorkerPoolSKUsCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWorkerPoolSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWorkerPoolSKUsHandleResponse handles the ListWorkerPoolSKUs response.
func (client *EnvironmentsClient) listWorkerPoolSKUsHandleResponse(resp *http.Response) (EnvironmentsClientListWorkerPoolSKUsResponse, error) {
	result := EnvironmentsClientListWorkerPoolSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUInfoCollection); err != nil {
		return EnvironmentsClientListWorkerPoolSKUsResponse{}, err
	}
	return result, nil
}

// NewListWorkerPoolsPager - Description for Get all worker pools of an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientListWorkerPoolsOptions contains the optional parameters for the EnvironmentsClient.NewListWorkerPoolsPager
//     method.
func (client *EnvironmentsClient) NewListWorkerPoolsPager(resourceGroupName string, name string, options *EnvironmentsClientListWorkerPoolsOptions) *runtime.Pager[EnvironmentsClientListWorkerPoolsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWorkerPoolsResponse]{
		More: func(page EnvironmentsClientListWorkerPoolsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWorkerPoolsResponse) (EnvironmentsClientListWorkerPoolsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.NewListWorkerPoolsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWorkerPoolsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientListWorkerPoolsResponse{}, err
			}
			return client.listWorkerPoolsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWorkerPoolsCreateRequest creates the ListWorkerPools request.
func (client *EnvironmentsClient) listWorkerPoolsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListWorkerPoolsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWorkerPoolsHandleResponse handles the ListWorkerPools response.
func (client *EnvironmentsClient) listWorkerPoolsHandleResponse(resp *http.Response) (EnvironmentsClientListWorkerPoolsResponse, error) {
	result := EnvironmentsClientListWorkerPoolsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolCollection); err != nil {
		return EnvironmentsClientListWorkerPoolsResponse{}, err
	}
	return result, nil
}

// Reboot - Description for Reboot all machines in an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientRebootOptions contains the optional parameters for the EnvironmentsClient.Reboot method.
func (client *EnvironmentsClient) Reboot(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientRebootOptions) (EnvironmentsClientRebootResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.Reboot"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.rebootCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientRebootResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientRebootResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientRebootResponse{}, err
	}
	return EnvironmentsClientRebootResponse{}, nil
}

// rebootCreateRequest creates the Reboot request.
func (client *EnvironmentsClient) rebootCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientRebootOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginResume - Description for Resume an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientBeginResumeOptions contains the optional parameters for the EnvironmentsClient.BeginResume
//     method.
func (client *EnvironmentsClient) BeginResume(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginResumeOptions) (*runtime.Poller[*runtime.Pager[EnvironmentsClientResumeResponse]], error) {
	pager := runtime.NewPager(runtime.PagingHandler[EnvironmentsClientResumeResponse]{
		More: func(page EnvironmentsClientResumeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientResumeResponse) (EnvironmentsClientResumeResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.BeginResume")
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), *page.NextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.resumeCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientResumeResponse{}, err
			}
			return client.resumeHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
	if options == nil || options.ResumeToken == "" {
		resp, err := client.resume(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[*runtime.Pager[EnvironmentsClientResumeResponse]]{
			Response: &pager,
			Tracer:   client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[*runtime.Pager[EnvironmentsClientResumeResponse]]{
			Response: &pager,
			Tracer:   client.internal.Tracer(),
		})
	}
}

// Resume - Description for Resume an App Service Environment.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) resume(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginResumeOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginResume"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.resumeCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// resumeCreateRequest creates the Resume request.
func (client *EnvironmentsClient) resumeCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginResumeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// resumeHandleResponse handles the Resume response.
func (client *EnvironmentsClient) resumeHandleResponse(resp *http.Response) (EnvironmentsClientResumeResponse, error) {
	result := EnvironmentsClientResumeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientResumeResponse{}, err
	}
	return result, nil
}

// BeginSuspend - Description for Suspend an App Service Environment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientBeginSuspendOptions contains the optional parameters for the EnvironmentsClient.BeginSuspend
//     method.
func (client *EnvironmentsClient) BeginSuspend(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginSuspendOptions) (*runtime.Poller[*runtime.Pager[EnvironmentsClientSuspendResponse]], error) {
	pager := runtime.NewPager(runtime.PagingHandler[EnvironmentsClientSuspendResponse]{
		More: func(page EnvironmentsClientSuspendResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientSuspendResponse) (EnvironmentsClientSuspendResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EnvironmentsClient.BeginSuspend")
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), *page.NextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.suspendCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return EnvironmentsClientSuspendResponse{}, err
			}
			return client.suspendHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
	if options == nil || options.ResumeToken == "" {
		resp, err := client.suspend(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[*runtime.Pager[EnvironmentsClientSuspendResponse]]{
			Response: &pager,
			Tracer:   client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[*runtime.Pager[EnvironmentsClientSuspendResponse]]{
			Response: &pager,
			Tracer:   client.internal.Tracer(),
		})
	}
}

// Suspend - Description for Suspend an App Service Environment.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) suspend(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginSuspendOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginSuspend"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.suspendCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// suspendCreateRequest creates the Suspend request.
func (client *EnvironmentsClient) suspendCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginSuspendOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// suspendHandleResponse handles the Suspend response.
func (client *EnvironmentsClient) suspendHandleResponse(resp *http.Response) (EnvironmentsClientSuspendResponse, error) {
	result := EnvironmentsClientSuspendResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientSuspendResponse{}, err
	}
	return result, nil
}

// TestUpgradeAvailableNotification - Send a test notification that an upgrade is available for this App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientTestUpgradeAvailableNotificationOptions contains the optional parameters for the EnvironmentsClient.TestUpgradeAvailableNotification
//     method.
func (client *EnvironmentsClient) TestUpgradeAvailableNotification(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientTestUpgradeAvailableNotificationOptions) (EnvironmentsClientTestUpgradeAvailableNotificationResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.TestUpgradeAvailableNotification"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.testUpgradeAvailableNotificationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, err
	}
	return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, nil
}

// testUpgradeAvailableNotificationCreateRequest creates the TestUpgradeAvailableNotification request.
func (client *EnvironmentsClient) testUpgradeAvailableNotificationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientTestUpgradeAvailableNotificationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/testUpgradeAvailableNotification"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Update - Description for Create or update an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - hostingEnvironmentEnvelope - Configuration details of the App Service Environment.
//   - options - EnvironmentsClientUpdateOptions contains the optional parameters for the EnvironmentsClient.Update method.
func (client *EnvironmentsClient) Update(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentPatchResource, options *EnvironmentsClientUpdateOptions) (EnvironmentsClientUpdateResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, name, hostingEnvironmentEnvelope, options)
	if err != nil {
		return EnvironmentsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *EnvironmentsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentPatchResource, options *EnvironmentsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, hostingEnvironmentEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *EnvironmentsClient) updateHandleResponse(resp *http.Response) (EnvironmentsClientUpdateResponse, error) {
	result := EnvironmentsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentResource); err != nil {
		return EnvironmentsClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateAseCustomDNSSuffixConfiguration - Update Custom Dns Suffix configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.UpdateAseCustomDNSSuffixConfiguration
//     method.
func (client *EnvironmentsClient) UpdateAseCustomDNSSuffixConfiguration(ctx context.Context, resourceGroupName string, name string, customDNSSuffixConfiguration CustomDNSSuffixConfiguration, options *EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions) (EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.UpdateAseCustomDNSSuffixConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateAseCustomDNSSuffixConfigurationCreateRequest(ctx, resourceGroupName, name, customDNSSuffixConfiguration, options)
	if err != nil {
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, err
	}
	resp, err := client.updateAseCustomDNSSuffixConfigurationHandleResponse(httpResp)
	return resp, err
}

// updateAseCustomDNSSuffixConfigurationCreateRequest creates the UpdateAseCustomDNSSuffixConfiguration request.
func (client *EnvironmentsClient) updateAseCustomDNSSuffixConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, customDNSSuffixConfiguration CustomDNSSuffixConfiguration, options *EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, customDNSSuffixConfiguration); err != nil {
		return nil, err
	}
	return req, nil
}

// updateAseCustomDNSSuffixConfigurationHandleResponse handles the UpdateAseCustomDNSSuffixConfiguration response.
func (client *EnvironmentsClient) updateAseCustomDNSSuffixConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse, error) {
	result := EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CustomDNSSuffixConfiguration); err != nil {
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, err
	}
	return result, nil
}

// UpdateAseNetworkingConfiguration - Description for Update networking configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientUpdateAseNetworkingConfigurationOptions contains the optional parameters for the EnvironmentsClient.UpdateAseNetworkingConfiguration
//     method.
func (client *EnvironmentsClient) UpdateAseNetworkingConfiguration(ctx context.Context, resourceGroupName string, name string, aseNetworkingConfiguration AseV3NetworkingConfiguration, options *EnvironmentsClientUpdateAseNetworkingConfigurationOptions) (EnvironmentsClientUpdateAseNetworkingConfigurationResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.UpdateAseNetworkingConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateAseNetworkingConfigurationCreateRequest(ctx, resourceGroupName, name, aseNetworkingConfiguration, options)
	if err != nil {
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, err
	}
	resp, err := client.updateAseNetworkingConfigurationHandleResponse(httpResp)
	return resp, err
}

// updateAseNetworkingConfigurationCreateRequest creates the UpdateAseNetworkingConfiguration request.
func (client *EnvironmentsClient) updateAseNetworkingConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, aseNetworkingConfiguration AseV3NetworkingConfiguration, options *EnvironmentsClientUpdateAseNetworkingConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/networking"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, aseNetworkingConfiguration); err != nil {
		return nil, err
	}
	return req, nil
}

// updateAseNetworkingConfigurationHandleResponse handles the UpdateAseNetworkingConfiguration response.
func (client *EnvironmentsClient) updateAseNetworkingConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientUpdateAseNetworkingConfigurationResponse, error) {
	result := EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AseV3NetworkingConfiguration); err != nil {
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, err
	}
	return result, nil
}

// UpdateMultiRolePool - Description for Create or update a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - multiRolePoolEnvelope - Properties of the multi-role pool.
//   - options - EnvironmentsClientUpdateMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.UpdateMultiRolePool
//     method.
func (client *EnvironmentsClient) UpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateMultiRolePoolOptions) (EnvironmentsClientUpdateMultiRolePoolResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.UpdateMultiRolePool"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateMultiRolePoolCreateRequest(ctx, resourceGroupName, name, multiRolePoolEnvelope, options)
	if err != nil {
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, err
	}
	resp, err := client.updateMultiRolePoolHandleResponse(httpResp)
	return resp, err
}

// updateMultiRolePoolCreateRequest creates the UpdateMultiRolePool request.
func (client *EnvironmentsClient) updateMultiRolePoolCreateRequest(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateMultiRolePoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, multiRolePoolEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateMultiRolePoolHandleResponse handles the UpdateMultiRolePool response.
func (client *EnvironmentsClient) updateMultiRolePoolHandleResponse(resp *http.Response) (EnvironmentsClientUpdateMultiRolePoolResponse, error) {
	result := EnvironmentsClientUpdateMultiRolePoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, err
	}
	return result, nil
}

// UpdateWorkerPool - Description for Create or update a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - workerPoolName - Name of the worker pool.
//   - workerPoolEnvelope - Properties of the worker pool.
//   - options - EnvironmentsClientUpdateWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.UpdateWorkerPool
//     method.
func (client *EnvironmentsClient) UpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateWorkerPoolOptions) (EnvironmentsClientUpdateWorkerPoolResponse, error) {
	var err error
	const operationName = "EnvironmentsClient.UpdateWorkerPool"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateWorkerPoolCreateRequest(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope, options)
	if err != nil {
		return EnvironmentsClientUpdateWorkerPoolResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EnvironmentsClientUpdateWorkerPoolResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return EnvironmentsClientUpdateWorkerPoolResponse{}, err
	}
	resp, err := client.updateWorkerPoolHandleResponse(httpResp)
	return resp, err
}

// updateWorkerPoolCreateRequest creates the UpdateWorkerPool request.
func (client *EnvironmentsClient) updateWorkerPoolCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateWorkerPoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, workerPoolEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateWorkerPoolHandleResponse handles the UpdateWorkerPool response.
func (client *EnvironmentsClient) updateWorkerPoolHandleResponse(resp *http.Response) (EnvironmentsClientUpdateWorkerPoolResponse, error) {
	result := EnvironmentsClientUpdateWorkerPoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientUpdateWorkerPoolResponse{}, err
	}
	return result, nil
}

// BeginUpgrade - Description for Initiate an upgrade of an App Service Environment if one is available.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service Environment.
//   - options - EnvironmentsClientBeginUpgradeOptions contains the optional parameters for the EnvironmentsClient.BeginUpgrade
//     method.
func (client *EnvironmentsClient) BeginUpgrade(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginUpgradeOptions) (*runtime.Poller[EnvironmentsClientUpgradeResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.upgrade(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[EnvironmentsClientUpgradeResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[EnvironmentsClientUpgradeResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Upgrade - Description for Initiate an upgrade of an App Service Environment if one is available.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *EnvironmentsClient) upgrade(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginUpgradeOptions) (*http.Response, error) {
	var err error
	const operationName = "EnvironmentsClient.BeginUpgrade"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.upgradeCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// upgradeCreateRequest creates the Upgrade request.
func (client *EnvironmentsClient) upgradeCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginUpgradeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/upgrade"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
