//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/ListAppServiceCertificateOrdersBySubscription.json
func ExampleCertificateOrdersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCertificateOrdersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CertificateOrderCollection = armappservice.CertificateOrderCollection{
		// 	Value: []*armappservice.CertificateOrder{
		// 		{
		// 			Name: to.Ptr("SampleCertificateOrderName"),
		// 			Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName"),
		// 			Location: to.Ptr("Global"),
		// 			Properties: &armappservice.CertificateOrderProperties{
		// 				AppServiceCertificateNotRenewableReasons: []*armappservice.ResourceNotRenewableReason{
		// 					to.Ptr(armappservice.ResourceNotRenewableReasonExpirationNotInRenewalTimeRange)},
		// 					AutoRenew: to.Ptr(true),
		// 					Certificates: map[string]*armappservice.Certificate{
		// 						"SampleCertName1": &armappservice.Certificate{
		// 							KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
		// 							KeyVaultSecretName: to.Ptr("SampleSecretName1"),
		// 							ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
		// 						},
		// 						"SampleCertName2": &armappservice.Certificate{
		// 							KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
		// 							KeyVaultSecretName: to.Ptr("SampleSecretName2"),
		// 							ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
		// 						},
		// 					},
		// 					Contact: &armappservice.CertificateOrderContact{
		// 						Email: to.Ptr("contact@email.com"),
		// 						NameFirst: to.Ptr("SampleFirstName"),
		// 						NameLast: to.Ptr("SampleLastName"),
		// 						Phone: to.Ptr("1-224-550-332"),
		// 					},
		// 					Csr: to.Ptr("xdf!x|"),
		// 					DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
		// 					DomainVerificationToken: to.Ptr("awe4163Br6d32r"),
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
		// 					Intermediate: &armappservice.CertificateDetails{
		// 						Issuer: to.Ptr("CACert"),
		// 						NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
		// 						NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
		// 						SerialNumber: to.Ptr("k45kad0024"),
		// 						SignatureAlgorithm: to.Ptr("SHA"),
		// 						Subject: to.Ptr("CN=IntermediateCertSubjectName"),
		// 						Thumbprint: to.Ptr("RF3D7411A44163B6D32B3343559B03E175886EBFE"),
		// 						Version: to.Ptr[int32](5589220),
		// 					},
		// 					IsPrivateKeyExternal: to.Ptr(false),
		// 					KeySize: to.Ptr[int32](2048),
		// 					LastCertificateIssuanceTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
		// 					NextAutoRenewalTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
		// 					ProductType: to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
		// 					ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
		// 					Root: &armappservice.CertificateDetails{
		// 						Issuer: to.Ptr("CACert"),
		// 						NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
		// 						NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
		// 						SerialNumber: to.Ptr("jkskd890ajdd00124"),
		// 						SignatureAlgorithm: to.Ptr("SHA"),
		// 						Subject: to.Ptr("CN=RootCertSubjectName"),
		// 						Thumbprint: to.Ptr("ZD3D7411A44163B6D32B3343559B03E175886EBFE"),
		// 						Version: to.Ptr[int32](3430921),
		// 					},
		// 					SerialNumber: to.Ptr("12324325325"),
		// 					SignedCertificate: &armappservice.CertificateDetails{
		// 						Issuer: to.Ptr("CACert"),
		// 						NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
		// 						NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
		// 						SerialNumber: to.Ptr("sds12424k"),
		// 						SignatureAlgorithm: to.Ptr("SHA"),
		// 						Subject: to.Ptr("CN=CertSubjectName"),
		// 						Thumbprint: to.Ptr("FE703D7411A44163B6D32B3AD9B03E175886EBFE"),
		// 						Version: to.Ptr[int32](1232490),
		// 					},
		// 					Status: to.Ptr(armappservice.CertificateOrderStatusIssued),
		// 					ValidityInYears: to.Ptr[int32](2),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/ValidateAppServiceCertificatePurchaseInformationBySubscription.json
func ExampleCertificateOrdersClient_ValidatePurchaseInformation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().ValidatePurchaseInformation(ctx, armappservice.CertificateOrder{
		Location: to.Ptr("Global"),
		Properties: &armappservice.CertificateOrderProperties{
			AutoRenew: to.Ptr(true),
			Certificates: map[string]*armappservice.Certificate{
				"SampleCertName1": {
					KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
					KeyVaultSecretName: to.Ptr("SampleSecretName1"),
				},
				"SampleCertName2": {
					KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
					KeyVaultSecretName: to.Ptr("SampleSecretName2"),
				},
			},
			DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
			KeySize:           to.Ptr[int32](2048),
			ProductType:       to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
			ValidityInYears:   to.Ptr[int32](2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/ListAppServiceCertificateOrdersByResourceGroup.json
func ExampleCertificateOrdersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCertificateOrdersClient().NewListByResourceGroupPager("testrg123", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CertificateOrderCollection = armappservice.CertificateOrderCollection{
		// 	Value: []*armappservice.CertificateOrder{
		// 		{
		// 			Name: to.Ptr("SampleCertificateOrderName"),
		// 			Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName"),
		// 			Location: to.Ptr("Global"),
		// 			Properties: &armappservice.CertificateOrderProperties{
		// 				AppServiceCertificateNotRenewableReasons: []*armappservice.ResourceNotRenewableReason{
		// 					to.Ptr(armappservice.ResourceNotRenewableReasonExpirationNotInRenewalTimeRange)},
		// 					AutoRenew: to.Ptr(true),
		// 					Certificates: map[string]*armappservice.Certificate{
		// 						"SampleCertName1": &armappservice.Certificate{
		// 							KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
		// 							KeyVaultSecretName: to.Ptr("SampleSecretName1"),
		// 							ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
		// 						},
		// 						"SampleCertName2": &armappservice.Certificate{
		// 							KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
		// 							KeyVaultSecretName: to.Ptr("SampleSecretName2"),
		// 							ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
		// 						},
		// 					},
		// 					Contact: &armappservice.CertificateOrderContact{
		// 						Email: to.Ptr("contact@email.com"),
		// 						NameFirst: to.Ptr("SampleFirstName"),
		// 						NameLast: to.Ptr("SampleLastName"),
		// 						Phone: to.Ptr("1-224-550-332"),
		// 					},
		// 					Csr: to.Ptr("xdf!x|"),
		// 					DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
		// 					DomainVerificationToken: to.Ptr("awe4163Br6d32r"),
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
		// 					Intermediate: &armappservice.CertificateDetails{
		// 						Issuer: to.Ptr("CACert"),
		// 						NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
		// 						NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
		// 						SerialNumber: to.Ptr("k45kad0024"),
		// 						SignatureAlgorithm: to.Ptr("SHA"),
		// 						Subject: to.Ptr("CN=IntermediateCertSubjectName"),
		// 						Thumbprint: to.Ptr("RF3D7411A44163B6D32B3343559B03E175886EBFE"),
		// 						Version: to.Ptr[int32](5589220),
		// 					},
		// 					IsPrivateKeyExternal: to.Ptr(false),
		// 					KeySize: to.Ptr[int32](2048),
		// 					LastCertificateIssuanceTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
		// 					NextAutoRenewalTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
		// 					ProductType: to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
		// 					ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
		// 					Root: &armappservice.CertificateDetails{
		// 						Issuer: to.Ptr("CACert"),
		// 						NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
		// 						NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
		// 						SerialNumber: to.Ptr("jkskd890ajdd00124"),
		// 						SignatureAlgorithm: to.Ptr("SHA"),
		// 						Subject: to.Ptr("CN=RootCertSubjectName"),
		// 						Thumbprint: to.Ptr("ZD3D7411A44163B6D32B3343559B03E175886EBFE"),
		// 						Version: to.Ptr[int32](3430921),
		// 					},
		// 					SerialNumber: to.Ptr("12324325325"),
		// 					SignedCertificate: &armappservice.CertificateDetails{
		// 						Issuer: to.Ptr("CACert"),
		// 						NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
		// 						NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
		// 						SerialNumber: to.Ptr("sds12424k"),
		// 						SignatureAlgorithm: to.Ptr("SHA"),
		// 						Subject: to.Ptr("CN=CertSubjectName"),
		// 						Thumbprint: to.Ptr("FE703D7411A44163B6D32B3AD9B03E175886EBFE"),
		// 						Version: to.Ptr[int32](123249),
		// 					},
		// 					Status: to.Ptr(armappservice.CertificateOrderStatusIssued),
		// 					ValidityInYears: to.Ptr[int32](2),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/GetAppServiceCertificateOrder.json
func ExampleCertificateOrdersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersClient().Get(ctx, "testrg123", "SampleCertificateOrderName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateOrder = armappservice.CertificateOrder{
	// 	Name: to.Ptr("SampleCertificateOrderName"),
	// 	Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName"),
	// 	Location: to.Ptr("Global"),
	// 	Properties: &armappservice.CertificateOrderProperties{
	// 		AppServiceCertificateNotRenewableReasons: []*armappservice.ResourceNotRenewableReason{
	// 			to.Ptr(armappservice.ResourceNotRenewableReasonExpirationNotInRenewalTimeRange)},
	// 			AutoRenew: to.Ptr(true),
	// 			Certificates: map[string]*armappservice.Certificate{
	// 				"SampleCertName1": &armappservice.Certificate{
	// 					KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 					KeyVaultSecretName: to.Ptr("SampleSecretName1"),
	// 					ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 				},
	// 				"SampleCertName2": &armappservice.Certificate{
	// 					KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 					KeyVaultSecretName: to.Ptr("SampleSecretName2"),
	// 					ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 				},
	// 			},
	// 			Contact: &armappservice.CertificateOrderContact{
	// 				Email: to.Ptr("contact@email.com"),
	// 				NameFirst: to.Ptr("SampleFirstName"),
	// 				NameLast: to.Ptr("SampleLastName"),
	// 				Phone: to.Ptr("1-224-550-332"),
	// 			},
	// 			Csr: to.Ptr("xdf!x|"),
	// 			DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
	// 			DomainVerificationToken: to.Ptr("awe4163Br6d32r"),
	// 			ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 			Intermediate: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("k45kad0024"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=IntermediateCertSubjectName"),
	// 				Thumbprint: to.Ptr("RF3D7411A44163B6D32B3343559B03E175886EBFE"),
	// 				Version: to.Ptr[int32](5589220),
	// 			},
	// 			IsPrivateKeyExternal: to.Ptr(false),
	// 			KeySize: to.Ptr[int32](2048),
	// 			LastCertificateIssuanceTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
	// 			NextAutoRenewalTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 			ProductType: to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
	// 			ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
	// 			Root: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("jkskd890ajdd00124"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=RootCertSubjectName"),
	// 				Thumbprint: to.Ptr("ZD3D7411A44163B6D32B3343559B03E175886EBFE"),
	// 				Version: to.Ptr[int32](3430921),
	// 			},
	// 			SerialNumber: to.Ptr("12324325325"),
	// 			SignedCertificate: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("sds12424k"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=CertSubjectName"),
	// 				Thumbprint: to.Ptr("FE703D7411A44163B6D32B3AD9B03E175886EBFE"),
	// 				Version: to.Ptr[int32](1232490),
	// 			},
	// 			Status: to.Ptr(armappservice.CertificateOrderStatusIssued),
	// 			ValidityInYears: to.Ptr[int32](2),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/CreateAppServiceCertificateOrder.json
func ExampleCertificateOrdersClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCertificateOrdersClient().BeginCreateOrUpdate(ctx, "testrg123", "SampleCertificateOrderName", armappservice.CertificateOrder{
		Location: to.Ptr("Global"),
		Properties: &armappservice.CertificateOrderProperties{
			AutoRenew: to.Ptr(true),
			Certificates: map[string]*armappservice.Certificate{
				"SampleCertName1": {
					KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
					KeyVaultSecretName: to.Ptr("SampleSecretName1"),
				},
				"SampleCertName2": {
					KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
					KeyVaultSecretName: to.Ptr("SampleSecretName2"),
				},
			},
			DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
			KeySize:           to.Ptr[int32](2048),
			ProductType:       to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
			ValidityInYears:   to.Ptr[int32](2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateOrder = armappservice.CertificateOrder{
	// 	Name: to.Ptr("SampleCertificateOrderName"),
	// 	Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName"),
	// 	Location: to.Ptr("Global"),
	// 	Properties: &armappservice.CertificateOrderProperties{
	// 		AppServiceCertificateNotRenewableReasons: []*armappservice.ResourceNotRenewableReason{
	// 			to.Ptr(armappservice.ResourceNotRenewableReasonExpirationNotInRenewalTimeRange)},
	// 			AutoRenew: to.Ptr(true),
	// 			Certificates: map[string]*armappservice.Certificate{
	// 				"SampleCertName1": &armappservice.Certificate{
	// 					KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 					KeyVaultSecretName: to.Ptr("SampleSecretName1"),
	// 					ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 				},
	// 				"SampleCertName2": &armappservice.Certificate{
	// 					KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 					KeyVaultSecretName: to.Ptr("SampleSecretName2"),
	// 					ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 				},
	// 			},
	// 			Contact: &armappservice.CertificateOrderContact{
	// 				Email: to.Ptr("contact@email.com"),
	// 				NameFirst: to.Ptr("SampleFirstName"),
	// 				NameLast: to.Ptr("SampleLastName"),
	// 				Phone: to.Ptr("1-224-550-332"),
	// 			},
	// 			Csr: to.Ptr("xdf!x|"),
	// 			DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
	// 			DomainVerificationToken: to.Ptr("awe4163Br6d32r"),
	// 			ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 			Intermediate: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("k45kad0024"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=IntermediateCertSubjectName"),
	// 				Thumbprint: to.Ptr("RF3D7411A44163B6D32B3343559B03E175886EBFE"),
	// 				Version: to.Ptr[int32](5589220),
	// 			},
	// 			IsPrivateKeyExternal: to.Ptr(false),
	// 			KeySize: to.Ptr[int32](2048),
	// 			LastCertificateIssuanceTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
	// 			NextAutoRenewalTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 			ProductType: to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
	// 			ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
	// 			Root: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("jkskd890ajdd00124"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=RootCertSubjectName"),
	// 				Thumbprint: to.Ptr("ZD3D7411A44163B6D32B3343559B03E175886EBFE"),
	// 				Version: to.Ptr[int32](3430921),
	// 			},
	// 			SerialNumber: to.Ptr("12324325325"),
	// 			SignedCertificate: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("sds12424k"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=CertSubjectName"),
	// 				Thumbprint: to.Ptr("FE703D7411A44163B6D32B3AD9B03E175886EBFE"),
	// 				Version: to.Ptr[int32](1232490),
	// 			},
	// 			Status: to.Ptr(armappservice.CertificateOrderStatusIssued),
	// 			ValidityInYears: to.Ptr[int32](2),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/DeleteAppServiceCertificateOrder.json
func ExampleCertificateOrdersClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().Delete(ctx, "testrg123", "SampleCertificateOrderName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/UpdateAppServiceCertificateOrder.json
func ExampleCertificateOrdersClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersClient().Update(ctx, "testrg123", "SampleCertificateOrderName", armappservice.CertificateOrderPatchResource{
		Properties: &armappservice.CertificateOrderPatchResourceProperties{
			AutoRenew: to.Ptr(true),
			Certificates: map[string]*armappservice.Certificate{
				"SampleCertName1": {
					KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
					KeyVaultSecretName: to.Ptr("SampleSecretName1"),
				},
				"SampleCertName2": {
					KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
					KeyVaultSecretName: to.Ptr("SampleSecretName2"),
				},
			},
			DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
			KeySize:           to.Ptr[int32](2048),
			ProductType:       to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
			ValidityInYears:   to.Ptr[int32](2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateOrder = armappservice.CertificateOrder{
	// 	Name: to.Ptr("SampleCertificateOrderName"),
	// 	Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName"),
	// 	Location: to.Ptr("Global"),
	// 	Properties: &armappservice.CertificateOrderProperties{
	// 		AppServiceCertificateNotRenewableReasons: []*armappservice.ResourceNotRenewableReason{
	// 			to.Ptr(armappservice.ResourceNotRenewableReasonExpirationNotInRenewalTimeRange)},
	// 			AutoRenew: to.Ptr(true),
	// 			Certificates: map[string]*armappservice.Certificate{
	// 				"SampleCertName1": &armappservice.Certificate{
	// 					KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 					KeyVaultSecretName: to.Ptr("SampleSecretName1"),
	// 					ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 				},
	// 				"SampleCertName2": &armappservice.Certificate{
	// 					KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 					KeyVaultSecretName: to.Ptr("SampleSecretName2"),
	// 					ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 				},
	// 			},
	// 			Contact: &armappservice.CertificateOrderContact{
	// 				Email: to.Ptr("contact@email.com"),
	// 				NameFirst: to.Ptr("SampleFirstName"),
	// 				NameLast: to.Ptr("SampleLastName"),
	// 				Phone: to.Ptr("1-224-550-332"),
	// 			},
	// 			Csr: to.Ptr("xdf!x|"),
	// 			DistinguishedName: to.Ptr("CN=SampleCustomDomain.com"),
	// 			DomainVerificationToken: to.Ptr("awe4163Br6d32r"),
	// 			ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 			Intermediate: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("k45kad0024"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=IntermediateCertSubjectName"),
	// 				Thumbprint: to.Ptr("RF3D7411A44163B6D32B3343559B03E175886EBFE"),
	// 				Version: to.Ptr[int32](5589220),
	// 			},
	// 			IsPrivateKeyExternal: to.Ptr(false),
	// 			KeySize: to.Ptr[int32](2048),
	// 			LastCertificateIssuanceTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
	// 			NextAutoRenewalTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 			ProductType: to.Ptr(armappservice.CertificateProductTypeStandardDomainValidatedSSL),
	// 			ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
	// 			Root: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("jkskd890ajdd00124"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=RootCertSubjectName"),
	// 				Thumbprint: to.Ptr("ZD3D7411A44163B6D32B3343559B03E175886EBFE"),
	// 				Version: to.Ptr[int32](3430921),
	// 			},
	// 			SerialNumber: to.Ptr("12324325325"),
	// 			SignedCertificate: &armappservice.CertificateDetails{
	// 				Issuer: to.Ptr("CACert"),
	// 				NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 				NotBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
	// 				SerialNumber: to.Ptr("sds12424k"),
	// 				SignatureAlgorithm: to.Ptr("SHA"),
	// 				Subject: to.Ptr("CN=CertSubjectName"),
	// 				Thumbprint: to.Ptr("FE703D7411A44163B6D32B3AD9B03E175886EBFE"),
	// 				Version: to.Ptr[int32](1232490),
	// 			},
	// 			Status: to.Ptr(armappservice.CertificateOrderStatusIssued),
	// 			ValidityInYears: to.Ptr[int32](2),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/ListCertificatesByAppServiceCertificateOrder.json
func ExampleCertificateOrdersClient_NewListCertificatesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCertificateOrdersClient().NewListCertificatesPager("testrg123", "SampleCertificateOrderName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CertificateCollection = armappservice.CertificateCollection{
		// 	Value: []*armappservice.CertificateResource{
		// 		{
		// 			Name: to.Ptr("SampleCertName1"),
		// 			Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders/certificates"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName/certificates/SampleCertName1"),
		// 			Location: to.Ptr("Global"),
		// 			Properties: &armappservice.Certificate{
		// 				KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
		// 				KeyVaultSecretName: to.Ptr("SampleSecretName1"),
		// 				ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleCertName2"),
		// 			Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders/certificates"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName/certificates/SampleCertName2"),
		// 			Location: to.Ptr("Global"),
		// 			Properties: &armappservice.Certificate{
		// 				KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
		// 				KeyVaultSecretName: to.Ptr("SampleCertName2"),
		// 				ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/GetAppServiceCertificate.json
func ExampleCertificateOrdersClient_GetCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersClient().GetCertificate(ctx, "testrg123", "SampleCertificateOrderName", "SampleCertName1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateResource = armappservice.CertificateResource{
	// 	Name: to.Ptr("SampleCertName1"),
	// 	Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders/certificates"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName/certificates/SampleCertName1"),
	// 	Location: to.Ptr("Global"),
	// 	Properties: &armappservice.Certificate{
	// 		KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 		KeyVaultSecretName: to.Ptr("SampleSecretName1"),
	// 		ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/CreateAppServiceCertificate.json
func ExampleCertificateOrdersClient_BeginCreateOrUpdateCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCertificateOrdersClient().BeginCreateOrUpdateCertificate(ctx, "testrg123", "SampleCertificateOrderName", "SampleCertName1", armappservice.CertificateResource{
		Location: to.Ptr("Global"),
		Properties: &armappservice.Certificate{
			KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
			KeyVaultSecretName: to.Ptr("SampleSecretName1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateResource = armappservice.CertificateResource{
	// 	Name: to.Ptr("SampleCertName1"),
	// 	Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders/certificates"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName/certificates/SampleCertName1"),
	// 	Location: to.Ptr("Global"),
	// 	Properties: &armappservice.Certificate{
	// 		KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 		KeyVaultSecretName: to.Ptr("SampleSecretName1"),
	// 		ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/DeleteAppServiceCertificate.json
func ExampleCertificateOrdersClient_DeleteCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().DeleteCertificate(ctx, "testrg123", "SampleCertificateOrderName", "SampleCertName1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/UpdateAppServiceCertificate.json
func ExampleCertificateOrdersClient_UpdateCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersClient().UpdateCertificate(ctx, "testrg123", "SampleCertificateOrderName", "SampleCertName1", armappservice.CertificatePatchResource{
		Properties: &armappservice.Certificate{
			KeyVaultID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
			KeyVaultSecretName: to.Ptr("SampleSecretName1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateResource = armappservice.CertificateResource{
	// 	Name: to.Ptr("SampleCertName1"),
	// 	Type: to.Ptr("Microsoft.CertificateRegistration/certificateOrders/certificates"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName/certificates/SampleCertName1"),
	// 	Location: to.Ptr("Global"),
	// 	Properties: &armappservice.Certificate{
	// 		KeyVaultID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
	// 		KeyVaultSecretName: to.Ptr("SampleSecretName1"),
	// 		ProvisioningState: to.Ptr(armappservice.KeyVaultSecretStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/ReissueAppServiceCertificateOrder.json
func ExampleCertificateOrdersClient_Reissue() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().Reissue(ctx, "testrg123", "SampleCertificateOrderName", armappservice.ReissueCertificateOrderRequest{
		Properties: &armappservice.ReissueCertificateOrderRequestProperties{
			Csr:                        to.Ptr("CSR1223238Value"),
			DelayExistingRevokeInHours: to.Ptr[int32](2),
			IsPrivateKeyExternal:       to.Ptr(false),
			KeySize:                    to.Ptr[int32](2048),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/RenewAppServiceCertificateOrder.json
func ExampleCertificateOrdersClient_Renew() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().Renew(ctx, "testrg123", "SampleCertificateOrderName", armappservice.RenewCertificateOrderRequest{
		Properties: &armappservice.RenewCertificateOrderRequestProperties{
			Csr:                  to.Ptr("CSR1223238Value"),
			IsPrivateKeyExternal: to.Ptr(false),
			KeySize:              to.Ptr[int32](2048),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/ResendAppServiceCertificateOrderEmail.json
func ExampleCertificateOrdersClient_ResendEmail() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().ResendEmail(ctx, "testrg123", "SampleCertificateOrderName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/ResendDomainOwnershipVerificationEmail.json
func ExampleCertificateOrdersClient_ResendRequestEmails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().ResendRequestEmails(ctx, "testrg123", "SampleCertificateOrderName", armappservice.NameIdentifier{
		Name: to.Ptr("Domain name"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/RetrieveSiteSeal.json
func ExampleCertificateOrdersClient_RetrieveSiteSeal() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersClient().RetrieveSiteSeal(ctx, "testrg123", "SampleCertOrder", armappservice.SiteSealRequest{
		LightTheme: to.Ptr(true),
		Locale:     to.Ptr("en-us"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteSeal = armappservice.SiteSeal{
	// 	HTML: to.Ptr("<html>SiteSeal</html>"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/VerifyDomainOwnership.json
func ExampleCertificateOrdersClient_VerifyDomainOwnership() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCertificateOrdersClient().VerifyDomainOwnership(ctx, "testrg123", "SampleCertificateOrderName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/RetrieveCertificateOrderActions.json
func ExampleCertificateOrdersClient_RetrieveCertificateActions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersClient().RetrieveCertificateActions(ctx, "testrg123", "SampleCertOrder", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateOrderActionArray = []*armappservice.CertificateOrderAction{
	// 	{
	// 		ActionType: to.Ptr(armappservice.CertificateOrderActionTypeFraudDetected),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 	},
	// 	{
	// 		ActionType: to.Ptr(armappservice.CertificateOrderActionTypeCertificateRevoked),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 	},
	// 	{
	// 		ActionType: to.Ptr(armappservice.CertificateOrderActionTypeCertificateIssued),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// }}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/RetrieveCertificateEmailHistory.json
func ExampleCertificateOrdersClient_RetrieveCertificateEmailHistory() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersClient().RetrieveCertificateEmailHistory(ctx, "testrg123", "SampleCertOrder", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CertificateEmailArray = []*armappservice.CertificateEmail{
	// 	{
	// 		EmailID: to.Ptr("customer@email.com"),
	// 		TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-12T23:40:25.000Z"); return t}()),
	// 	},
	// 	{
	// 		EmailID: to.Ptr("customer@email.com"),
	// 		TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-12T23:40:25.000Z"); return t}()),
	// }}
}
