//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappcontainers

import "time"

// AllowedAudiencesValidation - The configuration settings of the Allowed Audiences validation flow.
type AllowedAudiencesValidation struct {
	// The configuration settings of the allowed list of audiences from which to validate the JWT token.
	AllowedAudiences []*string
}

// AllowedPrincipals - The configuration settings of the Azure Active Directory allowed principals.
type AllowedPrincipals struct {
	// The list of the allowed groups.
	Groups []*string

	// The list of the allowed identities.
	Identities []*string
}

// AppInsightsConfiguration - Configuration of Application Insights
type AppInsightsConfiguration struct {
	// Application Insights connection string
	ConnectionString *string
}

// AppLogsConfiguration - Configuration of application logs
type AppLogsConfiguration struct {
	// Logs destination, can be 'log-analytics', 'azure-monitor' or 'none'
	Destination *string

	// Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
	LogAnalyticsConfiguration *LogAnalyticsConfiguration
}

// AppRegistration - The configuration settings of the app registration for providers that have app ids and app secrets
type AppRegistration struct {
	// The App ID of the app used for login.
	AppID *string

	// The app setting name that contains the app secret.
	AppSecretSettingName *string
}

// AppResiliency - Configuration to setup App Resiliency
type AppResiliency struct {
	// App Resiliency resource specific properties
	Properties *AppResiliencyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AppResiliencyCollection - Collection of AppResiliency policies
type AppResiliencyCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AppResiliency

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// AppResiliencyProperties - App Resiliency resource specific properties
type AppResiliencyProperties struct {
	// Policy that defines circuit breaker conditions
	CircuitBreakerPolicy *CircuitBreakerPolicy

	// Defines parameters for http connection pooling
	HTTPConnectionPool *HTTPConnectionPool

	// Policy that defines http request retry conditions
	HTTPRetryPolicy *HTTPRetryPolicy

	// Defines parameters for tcp connection pooling
	TCPConnectionPool *TCPConnectionPool

	// Policy that defines tcp request retry conditions
	TCPRetryPolicy *TCPRetryPolicy

	// Policy to set request timeouts
	TimeoutPolicy *TimeoutPolicy
}

// Apple - The configuration settings of the Apple provider.
type Apple struct {
	// false if the Apple provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the Apple registration.
	Registration *AppleRegistration
}

// AppleRegistration - The configuration settings of the registration for the Apple provider
type AppleRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string
}

// AuthConfig - Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
type AuthConfig struct {
	// AuthConfig resource specific properties
	Properties *AuthConfigProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AuthConfigCollection - AuthConfig collection ARM resource.
type AuthConfigCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AuthConfig

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// AuthConfigProperties - AuthConfig resource specific properties
type AuthConfigProperties struct {
	// The configuration settings of the secrets references of encryption key and signing key for ContainerApp Service Authentication/Authorization.
	EncryptionSettings *EncryptionSettings

	// The configuration settings that determines the validation flow of users using Service Authentication/Authorization.
	GlobalValidation *GlobalValidation

	// The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp
	// Service Authentication/Authorization.
	HTTPSettings *HTTPSettings

	// The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
	IdentityProviders *IdentityProviders

	// The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
	Login *Login

	// The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
	Platform *AuthPlatform
}

// AuthPlatform - The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
type AuthPlatform struct {
	// true if the Authentication / Authorization feature is enabled for the current app; otherwise, false.
	Enabled *bool

	// The RuntimeVersion of the Authentication / Authorization feature in use for the current app. The setting in this value
	// can control the behavior of certain features in the Authentication /
	// Authorization module.
	RuntimeVersion *string
}

// AvailableOperations - Available operations of the service
type AvailableOperations struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of available operation details
	Value []*OperationDetail
}

// AvailableWorkloadProfile - A workload profile with specific hardware configure to run container apps.
type AvailableWorkloadProfile struct {
	// Region of the workload profile.
	Location *string

	// Revision resource specific properties
	Properties *AvailableWorkloadProfileProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AvailableWorkloadProfileProperties - Revision resource specific properties
type AvailableWorkloadProfileProperties struct {
	// indicates whether the profile is default for the location.
	Applicability *Applicability

	// Used to categorize workload profiles.
	Category *string

	// Number of cores in CPU.
	Cores *int32

	// The everyday name of the workload profile.
	DisplayName *string

	// Number of GPUs.
	Gpus *int32

	// Memory in GiB.
	MemoryGiB *int32
}

// AvailableWorkloadProfilesCollection - Collection of available workload profiles in the location.
type AvailableWorkloadProfilesCollection struct {
	// REQUIRED; Collection of workload profiles.
	Value []*AvailableWorkloadProfile

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// AzureActiveDirectory - The configuration settings of the Azure Active directory provider.
type AzureActiveDirectory struct {
	// false if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling. This is an internal
	// flag primarily intended to support the Azure Management Portal. Users
	// should not read or write to this property.
	IsAutoProvisioned *bool

	// The configuration settings of the Azure Active Directory login flow.
	Login *AzureActiveDirectoryLogin

	// The configuration settings of the Azure Active Directory app registration.
	Registration *AzureActiveDirectoryRegistration

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AzureActiveDirectoryValidation
}

// AzureActiveDirectoryLogin - The configuration settings of the Azure Active Directory login flow.
type AzureActiveDirectoryLogin struct {
	// true if the www-authenticate provider should be omitted from the request; otherwise, false.
	DisableWWWAuthenticate *bool

	// Login parameters to send to the OpenID Connect authorization endpoint when a user logs in. Each parameter must be in the
	// form "key=value".
	LoginParameters []*string
}

// AzureActiveDirectoryRegistration - The configuration settings of the Azure Active Directory app registration.
type AzureActiveDirectoryRegistration struct {
	// The Client ID of this relying party application, known as the clientid. This setting is required for enabling OpenID Connection
	// authentication with Azure Active Directory or other 3rd party OpenID
	// Connect providers. More information on OpenID Connect: http://openid.net/specs/openid-connect-core-10.html
	ClientID *string

	// An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property
	// acts as a replacement for the Client Secret Certificate Thumbprint. It is
	// also optional.
	ClientSecretCertificateIssuer *string

	// An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing
	// purposes. This property acts as a replacement for the Client Secret Certificate
	// Thumbprint. It is also optional.
	ClientSecretCertificateSubjectAlternativeName *string

	// An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts
	// as a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string

	// The app setting name that contains the client secret of the relying party application.
	ClientSecretSettingName *string

	// The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application. When using Azure
	// Active Directory, this value is the URI of the directory tenant, e.g.
	// https://login.microsoftonline.com/v2.0/{tenant-guid}/. This URI is a case-sensitive identifier for the token issuer. More
	// information on OpenID Connect Discovery:
	// http://openid.net/specs/openid-connect-discovery-1_0.html
	OpenIDIssuer *string
}

// AzureActiveDirectoryValidation - The configuration settings of the Azure Active Directory token validation flow.
type AzureActiveDirectoryValidation struct {
	// The list of audiences that can make successful authentication/authorization requests.
	AllowedAudiences []*string

	// The configuration settings of the default authorization policy.
	DefaultAuthorizationPolicy *DefaultAuthorizationPolicy

	// The configuration settings of the checks that should be made while validating the JWT Claims.
	JwtClaimChecks *JwtClaimChecks
}

// AzureCredentials - Container App credentials.
type AzureCredentials struct {
	// Client Id.
	ClientID *string

	// Client Secret.
	ClientSecret *string

	// Kind of auth github does for deploying the template
	Kind *string

	// Subscription Id.
	SubscriptionID *string

	// Tenant Id.
	TenantID *string
}

// AzureFileProperties - Azure File Properties.
type AzureFileProperties struct {
	// Access mode for storage
	AccessMode *AccessMode

	// Storage account key for azure file.
	AccountKey *string

	// Storage account name for azure file.
	AccountName *string

	// Azure file share name.
	ShareName *string
}

// AzureStaticWebApps - The configuration settings of the Azure Static Web Apps provider.
type AzureStaticWebApps struct {
	// false if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the Azure Static Web Apps registration.
	Registration *AzureStaticWebAppsRegistration
}

// AzureStaticWebAppsRegistration - The configuration settings of the registration for the Azure Static Web Apps provider
type AzureStaticWebAppsRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string
}

// BaseContainer - Container App base container definition.
type BaseContainer struct {
	// Container start command arguments.
	Args []*string

	// Container start command.
	Command []*string

	// Container environment variables.
	Env []*EnvironmentVar

	// Container image tag.
	Image *string

	// Custom container name.
	Name *string

	// Container resource requirements.
	Resources *ContainerResources

	// Container volume mounts.
	VolumeMounts []*VolumeMount
}

// BillingMeter - Billing meter.
type BillingMeter struct {
	// Region for the billing meter.
	Location *string

	// Revision resource specific properties
	Properties *BillingMeterProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BillingMeterCollection - Collection of billing meters.
type BillingMeterCollection struct {
	// REQUIRED; Collection of billing meters.
	Value []*BillingMeter
}

// BillingMeterProperties - Revision resource specific properties
type BillingMeterProperties struct {
	// Used to categorize billing meters.
	Category *string

	// The everyday name of the billing meter.
	DisplayName *string

	// Billing meter type.
	MeterType *string
}

// BlobStorageTokenStore - The configuration settings of the storage of the tokens if blob storage is used.
type BlobStorageTokenStore struct {
	// REQUIRED; The name of the app secrets containing the SAS URL of the blob storage containing the tokens.
	SasURLSettingName *string
}

// BuildCollection - The response of a BuildResource list operation.
type BuildCollection struct {
	// REQUIRED; The BuildResource items on this page
	Value []*BuildResource

	// The link to the next page of items
	NextLink *string
}

// BuildConfiguration - Configuration of the build.
type BuildConfiguration struct {
	// Base OS used to build and run the app.
	BaseOs *string

	// List of environment variables to be passed to the build, secrets should not be used in environment variable.
	EnvironmentVariables []*EnvironmentVariable

	// Platform to be used to build and run the app.
	Platform *string

	// Platform version to be used to build and run the app.
	PlatformVersion *string

	// List of steps to perform before the build.
	PreBuildSteps []*PreBuildStep
}

// BuildProperties - The build properties.
type BuildProperties struct {
	// Configuration of the build.
	Configuration *BuildConfiguration

	// Container registry that the final image will be uploaded to.
	DestinationContainerRegistry *ContainerRegistryWithCustomImage

	// READ-ONLY; Status of the build once it has been provisioned.
	BuildStatus *BuildStatus

	// READ-ONLY; Endpoint from which the build logs can be streamed.
	LogStreamEndpoint *string

	// READ-ONLY; Build provisioning state.
	ProvisioningState *BuildProvisioningState

	// READ-ONLY; Endpoint to use to retrieve an authentication token for log streaming and uploading source code.
	TokenEndpoint *string

	// READ-ONLY; Endpoint to which the source code should be uploaded.
	UploadEndpoint *string
}

// BuildResource - Information pertaining to an individual build.
type BuildResource struct {
	// The resource-specific properties for this resource.
	Properties *BuildProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BuildToken - Build Auth Token.
type BuildToken struct {
	// READ-ONLY; Token expiration date.
	Expires *time.Time

	// READ-ONLY; Authentication token.
	Token *string
}

// BuilderCollection - The response of a BuilderResource list operation.
type BuilderCollection struct {
	// REQUIRED; The BuilderResource items on this page
	Value []*BuilderResource

	// The link to the next page of items
	NextLink *string
}

// BuilderProperties - The builder properties.
type BuilderProperties struct {
	// REQUIRED; Resource ID of the container apps environment that the builder is associated with.
	EnvironmentID *string

	// List of mappings of container registries and the managed identity used to connect to it.
	ContainerRegistries []*ContainerRegistry

	// READ-ONLY; Provisioning state of a builder resource.
	ProvisioningState *BuilderProvisioningState
}

// BuilderResource - Information about the SourceToCloud builder resource.
type BuilderResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The managed service identities assigned to this resource.
	Identity *ManagedServiceIdentity

	// The resource-specific properties for this resource.
	Properties *BuilderProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BuilderResourceUpdate - The type used for update operations of the BuilderResource.
type BuilderResourceUpdate struct {
	// The managed service identities assigned to this resource.
	Identity *ManagedServiceIdentity

	// The updatable properties of the BuilderResource.
	Properties *BuilderResourceUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// BuilderResourceUpdateProperties - The updatable properties of the BuilderResource.
type BuilderResourceUpdateProperties struct {
	// Resource ID of the container apps environment that the builder is associated with.
	EnvironmentID *string
}

// Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
type Certificate struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Certificate resource specific properties
	Properties *CertificateProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CertificateCollection - Collection of Certificates.
type CertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Certificate

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// CertificateKeyVaultProperties - Properties for a certificate stored in a Key Vault.
type CertificateKeyVaultProperties struct {
	// Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity.
	Identity *string

	// URL pointing to the Azure Key Vault secret that holds the certificate.
	KeyVaultURL *string
}

// CertificatePatch - A certificate to update
type CertificatePatch struct {
	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// CertificateProperties - Certificate resource specific properties
type CertificateProperties struct {
	// Properties for a certificate stored in a Key Vault.
	CertificateKeyVaultProperties *CertificateKeyVaultProperties

	// The type of the certificate. Allowed values are ServerSSLCertificate and ImagePullTrustedCA
	CertificateType *CertificateType

	// Certificate password.
	Password *string

	// PFX or PEM blob
	Value []byte

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time

	// READ-ONLY; Certificate issuer.
	Issuer *string

	// READ-ONLY; Provisioning state of the certificate.
	ProvisioningState *CertificateProvisioningState

	// READ-ONLY; Public key hash.
	PublicKeyHash *string

	// READ-ONLY; Subject alternative names the certificate applies to.
	SubjectAlternativeNames []*string

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string

	// READ-ONLY; Is the certificate valid?.
	Valid *bool
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string

	// The resource type.
	Type *string
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string

	// Indicates if the resource name is available.
	NameAvailable *bool

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason
}

// CircuitBreakerPolicy - Policy that defines circuit breaker conditions
type CircuitBreakerPolicy struct {
	// Number of consecutive errors before the circuit breaker opens
	ConsecutiveErrors *int32

	// The time interval, in seconds, between endpoint checks. This can result in opening the circuit breaker if the check fails
	// as well as closing the circuit breaker if the check succeeds. Defaults to 10s.
	IntervalInSeconds *int32

	// Maximum percentage of hosts that will be ejected after failure threshold has been met
	MaxEjectionPercent *int32
}

// ClientRegistration - The configuration settings of the app registration for providers that have client ids and client secrets
type ClientRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string
}

// Configuration - Non versioned Container App configuration properties that define the mutable settings of a Container app
type Configuration struct {
	// ActiveRevisionsMode controls how active revisions are handled for the Container app:Multiple: multiple revisions can be
	// active.Single: Only one revision can be active at a time. Revision weights can
	// not be used in this mode. If no value if provided, this is the default.
	ActiveRevisionsMode *ActiveRevisionsMode

	// Dapr configuration for the Container App.
	Dapr *Dapr

	// Ingress configurations.
	Ingress *Ingress

	// Optional. Max inactive revisions a Container App can have.
	MaxInactiveRevisions *int32

	// Collection of private container registry credentials for containers used by the Container app
	Registries []*RegistryCredentials

	// Collection of secrets used by a Container app
	Secrets []*Secret

	// Container App to be a dev Container App Service
	Service *Service
}

// ConnectedEnvironment - An environment for Kubernetes cluster specialized for web workloads by Azure App Service
type ConnectedEnvironment struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The complex type of the extended location.
	ExtendedLocation *ExtendedLocation

	// ConnectedEnvironment resource specific properties
	Properties *ConnectedEnvironmentProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConnectedEnvironmentCollection - Collection of connectedEnvironments
type ConnectedEnvironmentCollection struct {
	// Collection of resources.
	Value []*ConnectedEnvironment

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ConnectedEnvironmentProperties - ConnectedEnvironment resource specific properties
type ConnectedEnvironmentProperties struct {
	// Custom domain configuration for the environment
	CustomDomainConfiguration *CustomDomainConfiguration

	// Application Insights connection string used by Dapr to export Service to Service communication telemetry
	DaprAIConnectionString *string

	// Static IP of the connectedEnvironment
	StaticIP *string

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string

	// READ-ONLY; Provisioning state of the Kubernetes Environment.
	ProvisioningState *ConnectedEnvironmentProvisioningState
}

// ConnectedEnvironmentStorage - Storage resource for connectedEnvironment.
type ConnectedEnvironmentStorage struct {
	// Storage properties
	Properties *ConnectedEnvironmentStorageProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConnectedEnvironmentStorageProperties - Storage properties
type ConnectedEnvironmentStorageProperties struct {
	// Azure file properties
	AzureFile *AzureFileProperties
}

// ConnectedEnvironmentStoragesCollection - Collection of Storage for Environments
type ConnectedEnvironmentStoragesCollection struct {
	// REQUIRED; Collection of storage resources.
	Value []*ConnectedEnvironmentStorage
}

// Container App container definition
type Container struct {
	// Container start command arguments.
	Args []*string

	// Container start command.
	Command []*string

	// Container environment variables.
	Env []*EnvironmentVar

	// Container image tag.
	Image *string

	// Custom container name.
	Name *string

	// List of probes for the container.
	Probes []*ContainerAppProbe

	// Container resource requirements.
	Resources *ContainerResources

	// Container volume mounts.
	VolumeMounts []*VolumeMount
}

// ContainerApp - Container App.
type ContainerApp struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The complex type of the extended location.
	ExtendedLocation *ExtendedLocation

	// managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials
	// in code.
	Identity *ManagedServiceIdentity

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string

	// ContainerApp resource specific properties
	Properties *ContainerAppProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ContainerAppAuthToken - Container App Auth Token.
type ContainerAppAuthToken struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Container App auth token resource specific properties
	Properties *ContainerAppAuthTokenProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ContainerAppAuthTokenProperties - Container App auth token resource specific properties
type ContainerAppAuthTokenProperties struct {
	// READ-ONLY; Token expiration date.
	Expires *time.Time

	// READ-ONLY; Auth token value.
	Token *string
}

// ContainerAppCollection - Container App collection ARM resource.
type ContainerAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerApp

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ContainerAppJobExecutions - Container App executions collection ARM resource.
type ContainerAppJobExecutions struct {
	// REQUIRED; Collection of resources.
	Value []*JobExecution

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ContainerAppProbe - Probe describes a health check to be performed against a container to determine whether it is alive
// or ready to receive traffic.
type ContainerAppProbe struct {
	// Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value
	// is 1. Maximum value is 10.
	FailureThreshold *int32

	// HTTPGet specifies the http request to perform.
	HTTPGet *ContainerAppProbeHTTPGet

	// Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value
	// is 60.
	InitialDelaySeconds *int32

	// How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
	PeriodSeconds *int32

	// Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for
	// liveness and startup. Minimum value is 1. Maximum value is 10.
	SuccessThreshold *int32

	// TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
	TCPSocket *ContainerAppProbeTCPSocket

	// Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration
	// in seconds after the processes running in the pod are sent a termination signal
	// and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup
	// time for your process. If this value is nil, the pod's
	// terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must
	// be non-negative integer. The value zero indicates stop immediately via the
	// kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature
	// gate. Maximum value is 3600 seconds (1 hour)
	TerminationGracePeriodSeconds *int64

	// Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
	TimeoutSeconds *int32

	// The type of probe.
	Type *Type
}

// ContainerAppProbeHTTPGet - HTTPGet specifies the http request to perform.
type ContainerAppProbeHTTPGet struct {
	// REQUIRED; Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an
	// IANASVCNAME.
	Port *int32

	// Custom headers to set in the request. HTTP allows repeated headers.
	HTTPHeaders []*ContainerAppProbeHTTPGetHTTPHeadersItem

	// Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
	Host *string

	// Path to access on the HTTP server.
	Path *string

	// Scheme to use for connecting to the host. Defaults to HTTP.
	Scheme *Scheme
}

// ContainerAppProbeHTTPGetHTTPHeadersItem - HTTPHeader describes a custom header to be used in HTTP probes
type ContainerAppProbeHTTPGetHTTPHeadersItem struct {
	// REQUIRED; The header field name
	Name *string

	// REQUIRED; The header field value
	Value *string
}

// ContainerAppProbeTCPSocket - TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
type ContainerAppProbeTCPSocket struct {
	// REQUIRED; Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an
	// IANASVCNAME.
	Port *int32

	// Optional: Host name to connect to, defaults to the pod IP.
	Host *string
}

// ContainerAppProperties - ContainerApp resource specific properties
type ContainerAppProperties struct {
	// Non versioned Container App configuration properties.
	Configuration *Configuration

	// Resource ID of environment.
	EnvironmentID *string

	// Deprecated. Resource ID of the Container App's environment.
	ManagedEnvironmentID *string

	// Container App versioned application definition.
	Template *Template

	// Workload profile name to pin for container app execution.
	WorkloadProfileName *string

	// READ-ONLY; Id used to verify domain name ownership
	CustomDomainVerificationID *string

	// READ-ONLY; The endpoint of the eventstream of the container app.
	EventStreamEndpoint *string

	// READ-ONLY; Name of the latest ready revision of the Container App.
	LatestReadyRevisionName *string

	// READ-ONLY; Fully Qualified Domain Name of the latest revision of the Container App.
	LatestRevisionFqdn *string

	// READ-ONLY; Name of the latest revision of the Container App.
	LatestRevisionName *string

	// READ-ONLY; Outbound IP Addresses for container app.
	OutboundIPAddresses []*string

	// READ-ONLY; Provisioning state of the Container App.
	ProvisioningState *ContainerAppProvisioningState
}

// ContainerAppSecret - Container App Secret.
type ContainerAppSecret struct {
	// READ-ONLY; Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity.
	Identity *string

	// READ-ONLY; Azure Key Vault URL pointing to the secret referenced by the container app.
	KeyVaultURL *string

	// READ-ONLY; Secret Name.
	Name *string

	// READ-ONLY; Secret Value.
	Value *string
}

// ContainerRegistry - Model representing a mapping from a container registry to the identity used to connect to it.
type ContainerRegistry struct {
	// REQUIRED; Login server of the container registry.
	ContainerRegistryServer *string

	// REQUIRED; Resource ID of the managed identity.
	IdentityResourceID *string
}

// ContainerRegistryWithCustomImage - Container registry that the final image will be uploaded to.
type ContainerRegistryWithCustomImage struct {
	// REQUIRED; Login server of the container registry that the final image should be uploaded to. Builder resource needs to
	// have this container registry defined along with an identity to use to access it.
	Server *string

	// Full name that the final image should be uploaded as, including both image name and tag.
	Image *string
}

// ContainerResources - Container App container resource requirements.
type ContainerResources struct {
	// Required CPU in cores, e.g. 0.5
	CPU *float64

	// Required memory, e.g. "250Mb"
	Memory *string

	// READ-ONLY; Ephemeral Storage, e.g. "1Gi"
	EphemeralStorage *string
}

// CookieExpiration - The configuration settings of the session cookie's expiration.
type CookieExpiration struct {
	// The convention used when determining the session cookie's expiration.
	Convention *CookieExpirationConvention

	// The time after the request is made when the session cookie should expire.
	TimeToExpiration *string
}

// CorsPolicy - Cross-Origin-Resource-Sharing policy
type CorsPolicy struct {
	// REQUIRED; Specifies the content for the access-control-allow-origins header
	AllowedOrigins []*string

	// Specifies whether the resource allows credentials
	AllowCredentials *bool

	// Specifies the content for the access-control-allow-headers header
	AllowedHeaders []*string

	// Specifies the content for the access-control-allow-methods header
	AllowedMethods []*string

	// Specifies the content for the access-control-expose-headers header
	ExposeHeaders []*string

	// Specifies the content for the access-control-max-age header
	MaxAge *int32
}

// CustomDomain - Custom Domain of a Container App
type CustomDomain struct {
	// REQUIRED; Hostname.
	Name *string

	// Custom Domain binding type.
	BindingType *BindingType

	// Resource Id of the Certificate to be bound to this hostname. Must exist in the Managed Environment.
	CertificateID *string
}

// CustomDomainConfiguration - Configuration properties for apps environment custom domain
type CustomDomainConfiguration struct {
	// Certificate stored in Azure Key Vault.
	CertificateKeyVaultProperties *CertificateKeyVaultProperties

	// Certificate password
	CertificatePassword *string

	// PFX or PEM blob
	CertificateValue []byte

	// Dns suffix for the environment domain
	DNSSuffix *string

	// READ-ONLY; Id used to verify domain name ownership
	CustomDomainVerificationID *string

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string
}

// CustomHostnameAnalysisResult - Custom domain analysis.
type CustomHostnameAnalysisResult struct {
	// A records visible for this hostname.
	ARecords []*string

	// Alternate CName records visible for this hostname.
	AlternateCNameRecords []*string

	// Alternate TXT records visible for this hostname.
	AlternateTxtRecords []*string

	// CName records visible for this hostname.
	CNameRecords []*string

	// TXT records visible for this hostname.
	TxtRecords []*string

	// READ-ONLY; true if there is a conflict on the Container App's managed environment level custom domain; otherwise, false.
	ConflictWithEnvironmentCustomDomain *bool

	// READ-ONLY; Name of the conflicting Container App on the Managed Environment if it's within the same subscription.
	ConflictingContainerAppResourceID *string

	// READ-ONLY; Raw failure information if DNS verification fails.
	CustomDomainVerificationFailureInfo *CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo

	// READ-ONLY; DNS verification test result.
	CustomDomainVerificationTest *DNSVerificationTestResult

	// READ-ONLY; true if there is a conflict on the Container App's managed environment; otherwise, false.
	HasConflictOnManagedEnvironment *bool

	// READ-ONLY; Host name that was analyzed
	HostName *string

	// READ-ONLY; true if hostname is already verified; otherwise, false.
	IsHostnameAlreadyVerified *bool
}

// CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo - Raw failure information if DNS verification fails.
type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo struct {
	// Details or the error
	Details []*CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem

	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string

	// READ-ONLY; Detailed error description and debugging information.
	Message *string

	// READ-ONLY; Detailed error description and debugging information.
	Target *string
}

// CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem - Detailed errors.
type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem struct {
	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string

	// READ-ONLY; Detailed error description and debugging information.
	Message *string

	// READ-ONLY; Detailed error description and debugging information.
	Target *string
}

// CustomOpenIDConnectProvider - The configuration settings of the custom Open ID Connect provider.
type CustomOpenIDConnectProvider struct {
	// false if the custom Open ID provider provider should not be enabled; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow of the custom Open ID Connect provider.
	Login *OpenIDConnectLogin

	// The configuration settings of the app registration for the custom Open ID Connect provider.
	Registration *OpenIDConnectRegistration
}

// CustomScaleRule - Container App container Custom scaling rule.
type CustomScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth

	// Metadata properties to describe custom scale rule.
	Metadata map[string]*string

	// Type of the custom scale rule eg: azure-servicebus, redis etc.
	Type *string
}

// Dapr - Container App Dapr configuration.
type Dapr struct {
	// Dapr application identifier
	AppID *string

	// Tells Dapr which port your application is listening on
	AppPort *int32

	// Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
	AppProtocol *AppProtocol

	// Enables API logging for the Dapr sidecar
	EnableAPILogging *bool

	// Boolean indicating if the Dapr side car is enabled
	Enabled *bool

	// Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is
	// 4 MB.
	HTTPMaxRequestSize *int32

	// Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
	HTTPReadBufferSize *int32

	// Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
	LogLevel *LogLevel
}

// DaprComponent - Dapr Component.
type DaprComponent struct {
	// Dapr Component resource specific properties
	Properties *DaprComponentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DaprComponentProperties - Dapr Component resource specific properties
type DaprComponentProperties struct {
	// Component type
	ComponentType *string

	// Boolean describing if the component errors are ignores
	IgnoreErrors *bool

	// Initialization timeout
	InitTimeout *string

	// Component metadata
	Metadata []*DaprMetadata

	// Names of container apps that can use this Dapr component
	Scopes []*string

	// Name of a Dapr component to retrieve component secrets from
	SecretStoreComponent *string

	// Collection of secrets used by a Dapr component
	Secrets []*Secret

	// List of container app services that are bound to the Dapr component
	ServiceComponentBind []*DaprComponentServiceBinding

	// Component version
	Version *string
}

// DaprComponentResiliencyPoliciesCollection - Dapr Component Resiliency Policies ARM resource.
type DaprComponentResiliencyPoliciesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DaprComponentResiliencyPolicy

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DaprComponentResiliencyPolicy - Dapr Component Resiliency Policy.
type DaprComponentResiliencyPolicy struct {
	// Dapr Component Resiliency Policy resource specific properties
	Properties *DaprComponentResiliencyPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration - Dapr Component Resiliency Policy Circuit Breaker Policy
// Configuration.
type DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration struct {
	// The number of consecutive errors before the circuit is opened.
	ConsecutiveErrors *int32

	// The optional interval in seconds after which the error count resets to 0. An interval of 0 will never reset. If not specified,
	// the timeoutInSeconds value will be used.
	IntervalInSeconds *int32

	// The interval in seconds until a retry attempt is made after the circuit is opened.
	TimeoutInSeconds *int32
}

// DaprComponentResiliencyPolicyConfiguration - Dapr Component Resiliency Policy Configuration.
type DaprComponentResiliencyPolicyConfiguration struct {
	// The optional circuit breaker policy configuration
	CircuitBreakerPolicy *DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration

	// The optional HTTP retry policy configuration
	HTTPRetryPolicy *DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration

	// The optional timeout policy configuration
	TimeoutPolicy *DaprComponentResiliencyPolicyTimeoutPolicyConfiguration
}

// DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration - Dapr Component Resiliency Policy HTTP Retry Backoff Configuration.
type DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration struct {
	// The optional initial delay in milliseconds before an operation is retried
	InitialDelayInMilliseconds *int32

	// The optional maximum time interval in milliseconds between retry attempts
	MaxIntervalInMilliseconds *int32
}

// DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration - Dapr Component Resiliency Policy HTTP Retry Policy Configuration.
type DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration struct {
	// The optional maximum number of retries
	MaxRetries *int32

	// The optional retry backoff configuration
	RetryBackOff *DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration
}

// DaprComponentResiliencyPolicyProperties - Dapr Component Resiliency Policy resource specific properties
type DaprComponentResiliencyPolicyProperties struct {
	// The optional inbound component resiliency policy configuration
	InboundPolicy *DaprComponentResiliencyPolicyConfiguration

	// The optional outbound component resiliency policy configuration
	OutboundPolicy *DaprComponentResiliencyPolicyConfiguration
}

// DaprComponentResiliencyPolicyTimeoutPolicyConfiguration - Dapr Component Resiliency Policy Timeout Policy Configuration.
type DaprComponentResiliencyPolicyTimeoutPolicyConfiguration struct {
	// The optional response timeout in seconds
	ResponseTimeoutInSeconds *int32
}

// DaprComponentServiceBinding - Configuration to bind a Dapr Component to a dev ContainerApp Service
type DaprComponentServiceBinding struct {
	// Service bind metadata
	Metadata *DaprServiceBindMetadata

	// Name of the service bind
	Name *string

	// Resource id of the target service
	ServiceID *string
}

// DaprComponentsCollection - Dapr Components ARM resource.
type DaprComponentsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DaprComponent

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DaprConfiguration - Configuration properties Dapr component
type DaprConfiguration struct {
	// READ-ONLY; The version of Dapr
	Version *string
}

// DaprMetadata - Dapr component metadata.
type DaprMetadata struct {
	// Metadata property name.
	Name *string

	// Name of the Dapr Component secret from which to pull the metadata property value.
	SecretRef *string

	// Metadata property value.
	Value *string
}

// DaprSecret - Dapr component Secret for ListSecrets Action
type DaprSecret struct {
	// READ-ONLY; Secret Name.
	Name *string

	// READ-ONLY; Secret Value.
	Value *string
}

// DaprSecretsCollection - Dapr component Secrets Collection for ListSecrets Action.
type DaprSecretsCollection struct {
	// REQUIRED; Collection of secrets used by a Dapr component
	Value []*DaprSecret
}

// DaprServiceBindMetadata - Dapr component metadata.
type DaprServiceBindMetadata struct {
	// Service bind metadata property name.
	Name *string

	// Service bind metadata property value.
	Value *string
}

// DaprSubscription - Dapr PubSub Event Subscription.
type DaprSubscription struct {
	// Dapr PubSub Event Subscription resource specific properties
	Properties *DaprSubscriptionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DaprSubscriptionBulkSubscribeOptions - Dapr PubSub Bulk Subscription Options.
type DaprSubscriptionBulkSubscribeOptions struct {
	// Enable bulk subscription
	Enabled *bool

	// Maximum duration in milliseconds to wait before a bulk message is sent to the app.
	MaxAwaitDurationMs *int32

	// Maximum number of messages to deliver in a bulk message.
	MaxMessagesCount *int32
}

// DaprSubscriptionProperties - Dapr PubSub Event Subscription resource specific properties
type DaprSubscriptionProperties struct {
	// Bulk subscription options
	BulkSubscribe *DaprSubscriptionBulkSubscribeOptions

	// Deadletter topic name
	DeadLetterTopic *string

	// Subscription metadata
	Metadata map[string]*string

	// Dapr PubSub component name
	PubsubName *string

	// Subscription routes
	Routes *DaprSubscriptionRoutes

	// Application scopes to restrict the subscription to specific apps.
	Scopes []*string

	// Topic name
	Topic *string
}

// DaprSubscriptionRouteRule - Dapr Pubsub Event Subscription Route Rule is used to specify the condition for sending a message
// to a specific path.
type DaprSubscriptionRouteRule struct {
	// The optional CEL expression used to match the event. If the match is not specified, then the route is considered the default.
	// The rules are tested in the order specified, so they should be define from
	// most-to-least specific. The default route should appear last in the list.
	Match *string

	// The path for events that match this rule
	Path *string
}

// DaprSubscriptionRoutes - Dapr PubSub Event Subscription Routes configuration.
type DaprSubscriptionRoutes struct {
	// The default path to deliver events that do not match any of the rules.
	Default *string

	// The list of Dapr PubSub Event Subscription Route Rules.
	Rules []*DaprSubscriptionRouteRule
}

// DaprSubscriptionsCollection - Dapr Subscriptions ARM resource.
type DaprSubscriptionsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DaprSubscription

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DataDogConfiguration - Configuration of datadog
type DataDogConfiguration struct {
	// The data dog api key
	Key *string

	// The data dog site
	Site *string
}

// DefaultAuthorizationPolicy - The configuration settings of the Azure Active Directory default authorization policy.
type DefaultAuthorizationPolicy struct {
	// The configuration settings of the Azure Active Directory allowed applications.
	AllowedApplications []*string

	// The configuration settings of the Azure Active Directory allowed principals.
	AllowedPrincipals *AllowedPrincipals
}

// DefaultErrorResponse - App Service error response.
type DefaultErrorResponse struct {
	// READ-ONLY; Error model.
	Error *DefaultErrorResponseError
}

// DefaultErrorResponseError - Error model.
type DefaultErrorResponseError struct {
	// Details or the error
	Details []*DefaultErrorResponseErrorDetailsItem

	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string

	// READ-ONLY; More information to debug error.
	Innererror *string

	// READ-ONLY; Detailed error description and debugging information.
	Message *string

	// READ-ONLY; Detailed error description and debugging information.
	Target *string
}

// DefaultErrorResponseErrorDetailsItem - Detailed errors.
type DefaultErrorResponseErrorDetailsItem struct {
	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string

	// READ-ONLY; Detailed error description and debugging information.
	Message *string

	// READ-ONLY; Detailed error description and debugging information.
	Target *string
}

// DestinationsConfiguration - Configuration of Open Telemetry destinations
type DestinationsConfiguration struct {
	// Open telemetry datadog destination configuration
	DataDogConfiguration *DataDogConfiguration

	// Open telemetry otlp configurations
	OtlpConfigurations []*OtlpConfiguration
}

// DiagnosticDataProviderMetadata - Details of a diagnostics data provider
type DiagnosticDataProviderMetadata struct {
	// Collection of properties
	PropertyBag []*DiagnosticDataProviderMetadataPropertyBagItem

	// Name of data provider
	ProviderName *string
}

// DiagnosticDataProviderMetadataPropertyBagItem - Property details
type DiagnosticDataProviderMetadataPropertyBagItem struct {
	// Property name
	Name *string

	// Property value
	Value *string
}

// DiagnosticDataTableResponseColumn - Diagnostics data column
type DiagnosticDataTableResponseColumn struct {
	// Column name
	ColumnName *string

	// Column type
	ColumnType *string

	// Data type of the column
	DataType *string
}

// DiagnosticDataTableResponseObject - Diagnostics data table
type DiagnosticDataTableResponseObject struct {
	// Columns in the table
	Columns []*DiagnosticDataTableResponseColumn

	// Rows in the table
	Rows []any

	// Table name
	TableName *string
}

// DiagnosticRendering - Rendering details of a diagnostics table
type DiagnosticRendering struct {
	// Description of the table
	Description *string

	// Flag if the table should be rendered
	IsVisible *bool

	// Title of the table
	Title *string

	// Rendering type
	Type *int32
}

// DiagnosticSupportTopic - Support topic information
type DiagnosticSupportTopic struct {
	// READ-ONLY; Unique topic identifier
	ID *string

	// READ-ONLY; PES identifier
	PesID *string
}

// Diagnostics data for a resource.
type Diagnostics struct {
	// Diagnostics resource specific properties
	Properties *DiagnosticsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DiagnosticsCollection - Diagnostics data collection for a resource.
type DiagnosticsCollection struct {
	// REQUIRED; Collection of diagnostic data.
	Value []*Diagnostics

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DiagnosticsDataAPIResponse - Diagnostics data returned from a detector
type DiagnosticsDataAPIResponse struct {
	// Details of the table response
	RenderingProperties *DiagnosticRendering

	// Table response
	Table *DiagnosticDataTableResponseObject
}

// DiagnosticsDefinition - Metadata of the diagnostics response
type DiagnosticsDefinition struct {
	// List of analysis types
	AnalysisTypes []*string

	// List of support topics
	SupportTopicList []*DiagnosticSupportTopic

	// READ-ONLY; Authors' names of the detector
	Author *string

	// READ-ONLY; Category of the detector
	Category *string

	// READ-ONLY; Details of the diagnostics info
	Description *string

	// READ-ONLY; Unique detector name
	ID *string

	// READ-ONLY; Display Name of the detector
	Name *string

	// READ-ONLY; Authors' names of the detector
	Score *float32

	// READ-ONLY; Authors' names of the detector
	Type *string
}

// DiagnosticsProperties - Diagnostics resource specific properties
type DiagnosticsProperties struct {
	// List of data providers' metadata.
	DataProviderMetadata *DiagnosticDataProviderMetadata

	// Set of data collections associated with the response.
	Dataset []*DiagnosticsDataAPIResponse

	// Metadata of the diagnostics response.
	Metadata *DiagnosticsDefinition

	// Status of the diagnostics response.
	Status *DiagnosticsStatus
}

// DiagnosticsStatus - Rendering details of a diagnostics table
type DiagnosticsStatus struct {
	// Diagnostic message
	Message *string

	// Status
	StatusID *int32
}

// DotNetComponent - .NET Component.
type DotNetComponent struct {
	// .NET Component resource specific properties
	Properties *DotNetComponentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DotNetComponentConfigurationProperty - Configuration properties for a .NET Component
type DotNetComponentConfigurationProperty struct {
	// The name of the property
	PropertyName *string

	// The value of the property
	Value *string
}

// DotNetComponentProperties - .NET Component resource specific properties
type DotNetComponentProperties struct {
	// Type of the .NET Component.
	ComponentType *DotNetComponentType

	// List of .NET Components configuration properties
	Configurations []*DotNetComponentConfigurationProperty

	// List of .NET Components that are bound to the .NET component
	ServiceBinds []*DotNetComponentServiceBind

	// READ-ONLY; Provisioning state of the .NET Component.
	ProvisioningState *DotNetComponentProvisioningState
}

// DotNetComponentServiceBind - Configuration to bind a .NET Component to another .NET Component
type DotNetComponentServiceBind struct {
	// Name of the service bind
	Name *string

	// Resource id of the target service
	ServiceID *string
}

// DotNetComponentsCollection - .NET Components ARM resource.
type DotNetComponentsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DotNetComponent

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// EncryptionSettings - The configuration settings of the secrets references of encryption key and signing key for ContainerApp
// Service Authentication/Authorization.
type EncryptionSettings struct {
	// The secret name which is referenced for EncryptionKey.
	ContainerAppAuthEncryptionSecretName *string

	// The secret name which is referenced for SigningKey.
	ContainerAppAuthSigningSecretName *string
}

// EnvironmentAuthToken - Environment Auth Token.
type EnvironmentAuthToken struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Environment auth token resource specific properties
	Properties *EnvironmentAuthTokenProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EnvironmentAuthTokenProperties - Environment auth token resource specific properties
type EnvironmentAuthTokenProperties struct {
	// READ-ONLY; Token expiration date.
	Expires *time.Time

	// READ-ONLY; Auth token value.
	Token *string
}

// EnvironmentVar - Container App container environment variable.
type EnvironmentVar struct {
	// Environment variable name.
	Name *string

	// Name of the Container App secret from which to pull the environment variable value.
	SecretRef *string

	// Non-secret environment variable value.
	Value *string
}

// EnvironmentVariable - Model representing an environment variable.
type EnvironmentVariable struct {
	// REQUIRED; Environment variable name.
	Name *string

	// REQUIRED; Environment variable value.
	Value *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string

	// The type of the extended location.
	Type *ExtendedLocationTypes
}

// Facebook - The configuration settings of the Facebook provider.
type Facebook struct {
	// false if the Facebook provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The version of the Facebook api to be used while logging in.
	GraphAPIVersion *string

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the app registration for the Facebook provider.
	Registration *AppRegistration
}

// ForwardProxy - The configuration settings of a forward proxy used to make the requests.
type ForwardProxy struct {
	// The convention used to determine the url of the request made.
	Convention *ForwardProxyConvention

	// The name of the header containing the host of the request.
	CustomHostHeaderName *string

	// The name of the header containing the scheme of the request.
	CustomProtoHeaderName *string
}

// GitHub - The configuration settings of the GitHub provider.
type GitHub struct {
	// false if the GitHub provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the app registration for the GitHub provider.
	Registration *ClientRegistration
}

// GithubActionConfiguration - Configuration properties that define the mutable settings of a Container App SourceControl
type GithubActionConfiguration struct {
	// AzureCredentials configurations.
	AzureCredentials *AzureCredentials

	// List of environment variables to be passed to the build.
	BuildEnvironmentVariables []*EnvironmentVariable

	// Context path
	ContextPath *string

	// One time Github PAT to configure github environment
	GithubPersonalAccessToken *string

	// Image name
	Image *string

	// Operation system
	OS *string

	// Code or Image
	PublishType *string

	// Registry configurations.
	RegistryInfo *RegistryInfo

	// Runtime stack
	RuntimeStack *string

	// Runtime version
	RuntimeVersion *string
}

// GlobalValidation - The configuration settings that determines the validation flow of users using ContainerApp Service Authentication/Authorization.
type GlobalValidation struct {
	// The paths for which unauthenticated flow would not be redirected to the login page.
	ExcludedPaths []*string

	// The default authentication provider to use when multiple providers are configured. This setting is only needed if multiple
	// providers are configured and the unauthenticated client action is set to
	// "RedirectToLoginPage".
	RedirectToProvider *string

	// The action to take when an unauthenticated client attempts to access the app.
	UnauthenticatedClientAction *UnauthenticatedClientActionV2
}

// Google - The configuration settings of the Google provider.
type Google struct {
	// false if the Google provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the app registration for the Google provider.
	Registration *ClientRegistration

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AllowedAudiencesValidation
}

// HTTPConnectionPool - Defines parameters for http connection pooling
type HTTPConnectionPool struct {
	// Maximum number of pending http1 requests allowed
	HTTP1MaxPendingRequests *int32

	// Maximum number of http2 requests allowed
	HTTP2MaxRequests *int32
}

// HTTPGet - Model representing a http get request.
type HTTPGet struct {
	// REQUIRED; URL to make HTTP GET request against.
	URL *string

	// Name of the file that the request should be saved to.
	FileName *string

	// List of headers to send with the request.
	Headers []*string
}

// HTTPRetryPolicy - Policy that defines http request retry conditions
type HTTPRetryPolicy struct {
	// Conditions that must be met for a request to be retried
	Matches *HTTPRetryPolicyMatches

	// Maximum number of times a request will retry
	MaxRetries *int32

	// Settings for retry backoff characteristics
	RetryBackOff *HTTPRetryPolicyRetryBackOff
}

// HTTPRetryPolicyMatches - Conditions that must be met for a request to be retried
type HTTPRetryPolicyMatches struct {
	// Errors that can trigger a retry
	Errors []*string

	// Additional http status codes that can trigger a retry
	HTTPStatusCodes []*int32

	// Headers that must be present for a request to be retried
	Headers []*HeaderMatch
}

// HTTPRetryPolicyRetryBackOff - Settings for retry backoff characteristics
type HTTPRetryPolicyRetryBackOff struct {
	// Initial delay, in milliseconds, before retrying a request
	InitialDelayInMilliseconds *int64

	// Maximum interval, in milliseconds, between retries
	MaxIntervalInMilliseconds *int64
}

// HTTPScaleRule - Container App container Http scaling rule.
type HTTPScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth

	// Metadata properties to describe http scale rule.
	Metadata map[string]*string
}

// HTTPSettings - The configuration settings of the HTTP requests for authentication and authorization requests made against
// ContainerApp Service Authentication/Authorization.
type HTTPSettings struct {
	// The configuration settings of a forward proxy used to make the requests.
	ForwardProxy *ForwardProxy

	// false if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, true.
	RequireHTTPS *bool

	// The configuration settings of the paths HTTP requests.
	Routes *HTTPSettingsRoutes
}

// HTTPSettingsRoutes - The configuration settings of the paths HTTP requests.
type HTTPSettingsRoutes struct {
	// The prefix that should precede all the authentication/authorization paths.
	APIPrefix *string
}

// Header of otlp configuration
type Header struct {
	// The key of otlp configuration header
	Key *string

	// The value of otlp configuration header
	Value *string
}

// HeaderMatch - Conditions required to match a header
type HeaderMatch struct {
	// Name of the header
	Header *string

	// Type of match to perform
	Match *HeaderMatchMatch
}

// HeaderMatchMatch - Type of match to perform
type HeaderMatchMatch struct {
	// Exact value of the header
	ExactMatch *string

	// Prefix value of the header
	PrefixMatch *string

	// Regex value of the header
	RegexMatch *string

	// Suffix value of the header
	SuffixMatch *string
}

// IPSecurityRestrictionRule - Rule to restrict incoming IP address.
type IPSecurityRestrictionRule struct {
	// REQUIRED; Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
	Action *Action

	// REQUIRED; CIDR notation to match incoming IP address
	IPAddressRange *string

	// REQUIRED; Name for the IP restriction rule.
	Name *string

	// Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
	Description *string
}

// IdentityProviders - The configuration settings of each of the identity providers used to configure ContainerApp Service
// Authentication/Authorization.
type IdentityProviders struct {
	// The configuration settings of the Apple provider.
	Apple *Apple

	// The configuration settings of the Azure Active directory provider.
	AzureActiveDirectory *AzureActiveDirectory

	// The configuration settings of the Azure Static Web Apps provider.
	AzureStaticWebApps *AzureStaticWebApps

	// The map of the name of the alias of each custom Open ID Connect provider to the configuration settings of the custom Open
	// ID Connect provider.
	CustomOpenIDConnectProviders map[string]*CustomOpenIDConnectProvider

	// The configuration settings of the Facebook provider.
	Facebook *Facebook

	// The configuration settings of the GitHub provider.
	GitHub *GitHub

	// The configuration settings of the Google provider.
	Google *Google

	// The configuration settings of the Twitter provider.
	Twitter *Twitter
}

// Ingress - Container App Ingress configuration.
type Ingress struct {
	// Settings to expose additional ports on container app
	AdditionalPortMappings []*IngressPortMapping

	// Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS
	// connections
	AllowInsecure *bool

	// Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept
	// indicates server forwards client certificate but does not require a client
	// certificate. Require indicates server requires a client certificate.
	ClientCertificateMode *IngressClientCertificateMode

	// CORS policy for container app
	CorsPolicy *CorsPolicy

	// custom domain bindings for Container Apps' hostnames.
	CustomDomains []*CustomDomain

	// Exposed Port in containers for TCP traffic from ingress
	ExposedPort *int32

	// Bool indicating if app exposes an external http endpoint
	External *bool

	// Rules to restrict incoming IP address.
	IPSecurityRestrictions []*IPSecurityRestrictionRule

	// Sticky Sessions for Single Revision Mode
	StickySessions *IngressStickySessions

	// Target Port in containers for traffic from ingress
	TargetPort *int32

	// Whether an http app listens on http or https
	TargetPortHTTPScheme *IngressTargetPortHTTPScheme

	// Traffic weights for app's revisions
	Traffic []*TrafficWeight

	// Ingress transport protocol
	Transport *IngressTransportMethod

	// READ-ONLY; Hostname.
	Fqdn *string
}

// IngressPortMapping - Port mappings of container app ingress
type IngressPortMapping struct {
	// REQUIRED; Specifies whether the app port is accessible outside of the environment
	External *bool

	// REQUIRED; Specifies the port user's container listens on
	TargetPort *int32

	// Specifies the exposed port for the target port. If not specified, it defaults to target port
	ExposedPort *int32
}

// IngressStickySessions - Sticky Sessions for Single Revision Mode
type IngressStickySessions struct {
	// Sticky Session Affinity
	Affinity *Affinity
}

// InitContainer - Container App init container definition
type InitContainer struct {
	// Container start command arguments.
	Args []*string

	// Container start command.
	Command []*string

	// Container environment variables.
	Env []*EnvironmentVar

	// Container image tag.
	Image *string

	// Custom container name.
	Name *string

	// Container resource requirements.
	Resources *ContainerResources

	// Container volume mounts.
	VolumeMounts []*VolumeMount
}

// JavaComponent - Java Component.
type JavaComponent struct {
	// Java Component resource specific properties
	Properties *JavaComponentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// JavaComponentConfigurationProperty - Configuration properties for a Java Component
type JavaComponentConfigurationProperty struct {
	// The name of the property
	PropertyName *string

	// The value of the property
	Value *string
}

// JavaComponentProperties - Java Component resource specific properties
type JavaComponentProperties struct {
	// Type of the Java Component.
	ComponentType *JavaComponentType

	// List of Java Components configuration properties
	Configurations []*JavaComponentConfigurationProperty

	// List of Java Components that are bound to the Java component
	ServiceBinds []*JavaComponentServiceBind

	// READ-ONLY; Provisioning state of the Java Component.
	ProvisioningState *JavaComponentProvisioningState
}

// JavaComponentServiceBind - Configuration to bind a Java Component to another Java Component
type JavaComponentServiceBind struct {
	// Name of the service bind
	Name *string

	// Resource id of the target service
	ServiceID *string
}

// JavaComponentsCollection - Java Components ARM resource.
type JavaComponentsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*JavaComponent

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// Job - Container App Job
type Job struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The complex type of the extended location.
	ExtendedLocation *ExtendedLocation

	// Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials
	// in code.
	Identity *ManagedServiceIdentity

	// Container Apps Job resource specific properties.
	Properties *JobProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// JobConfiguration - Non versioned Container Apps Job configuration properties
type JobConfiguration struct {
	// REQUIRED; Maximum number of seconds a replica is allowed to run.
	ReplicaTimeout *int32

	// REQUIRED; Trigger type of the job
	TriggerType *TriggerType

	// Trigger configuration of an event driven job.
	EventTriggerConfig *JobConfigurationEventTriggerConfig

	// Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set
	// to 1 by default
	ManualTriggerConfig *JobConfigurationManualTriggerConfig

	// Collection of private container registry credentials used by a Container apps job
	Registries []*RegistryCredentials

	// Maximum number of retries before failing the job.
	ReplicaRetryLimit *int32

	// Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set
	// to 1 by default
	ScheduleTriggerConfig *JobConfigurationScheduleTriggerConfig

	// Collection of secrets used by a Container Apps Job
	Secrets []*Secret
}

// JobConfigurationEventTriggerConfig - Trigger configuration of an event driven job.
type JobConfigurationEventTriggerConfig struct {
	// Number of parallel replicas of a job that can run at a given time.
	Parallelism *int32

	// Minimum number of successful replica completions before overall job completion.
	ReplicaCompletionCount *int32

	// Scaling configurations for event driven jobs.
	Scale *JobScale
}

// JobConfigurationManualTriggerConfig - Manual trigger configuration for a single execution job. Properties replicaCompletionCount
// and parallelism would be set to 1 by default
type JobConfigurationManualTriggerConfig struct {
	// Number of parallel replicas of a job that can run at a given time.
	Parallelism *int32

	// Minimum number of successful replica completions before overall job completion.
	ReplicaCompletionCount *int32
}

// JobConfigurationScheduleTriggerConfig - Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties
// completions and parallelism would be set to 1 by default
type JobConfigurationScheduleTriggerConfig struct {
	// REQUIRED; Cron formatted repeating schedule ("* * * * *") of a Cron Job.
	CronExpression *string

	// Number of parallel replicas of a job that can run at a given time.
	Parallelism *int32

	// Minimum number of successful replica completions before overall job completion.
	ReplicaCompletionCount *int32
}

// JobExecution - Container Apps Job execution.
type JobExecution struct {
	// Job execution Id.
	ID *string

	// Job execution Name.
	Name *string

	// Container Apps Job execution specific properties.
	Properties *JobExecutionProperties

	// Job execution type
	Type *string
}

// JobExecutionBase - Container App's Job execution name.
type JobExecutionBase struct {
	// Job execution Id.
	ID *string

	// Job execution name.
	Name *string
}

// JobExecutionContainer - Container Apps Jobs execution container definition.
type JobExecutionContainer struct {
	// Container start command arguments.
	Args []*string

	// Container start command.
	Command []*string

	// Container environment variables.
	Env []*EnvironmentVar

	// Container image tag.
	Image *string

	// Custom container name.
	Name *string

	// Container resource requirements.
	Resources *ContainerResources
}

// JobExecutionNamesCollection - Container App executions names list.
type JobExecutionNamesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*JobExecutionBase
}

// JobExecutionProperties - Container Apps Job execution specific properties.
type JobExecutionProperties struct {
	// Job execution end time.
	EndTime *time.Time

	// Job execution start time.
	StartTime *time.Time

	// Job's execution container.
	Template *JobExecutionTemplate

	// READ-ONLY; Current running State of the job
	Status *JobExecutionRunningState
}

// JobExecutionTemplate - Job's execution template, containing container configuration for a job's execution
type JobExecutionTemplate struct {
	// List of container definitions for the Container Apps Job.
	Containers []*JobExecutionContainer

	// List of specialized containers that run before job containers.
	InitContainers []*JobExecutionContainer
}

// JobPatchProperties - Container Apps Job resource specific properties.
type JobPatchProperties struct {
	// The complex type of the extended location.
	ExtendedLocation *ExtendedLocation

	// Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials
	// in code.
	Identity   *ManagedServiceIdentity
	Properties *JobPatchPropertiesProperties

	// Resource tags.
	Tags map[string]*string
}

type JobPatchPropertiesProperties struct {
	// Container Apps Job configuration properties.
	Configuration *JobConfiguration

	// Resource ID of environment.
	EnvironmentID *string

	// The endpoint of the eventstream of the container apps job.
	EventStreamEndpoint *string

	// Outbound IP Addresses of a container apps job.
	OutboundIPAddresses []*string

	// Container Apps job definition.
	Template *JobTemplate
}

// JobProperties - Container Apps Job resource specific properties.
type JobProperties struct {
	// Container Apps Job configuration properties.
	Configuration *JobConfiguration

	// Resource ID of environment.
	EnvironmentID *string

	// Container Apps job definition.
	Template *JobTemplate

	// Workload profile name to pin for container apps job execution.
	WorkloadProfileName *string

	// READ-ONLY; The endpoint of the eventstream of the container apps job.
	EventStreamEndpoint *string

	// READ-ONLY; Outbound IP Addresses of a container apps job.
	OutboundIPAddresses []*string

	// READ-ONLY; Provisioning state of the Container Apps Job.
	ProvisioningState *JobProvisioningState
}

// JobScale - Scaling configurations for event driven jobs.
type JobScale struct {
	// Maximum number of job executions that are created for a trigger, default 100.
	MaxExecutions *int32

	// Minimum number of job executions that are created for a trigger, default 0
	MinExecutions *int32

	// Interval to check each event source in seconds. Defaults to 30s
	PollingInterval *int32

	// Scaling rules.
	Rules []*JobScaleRule
}

// JobScaleRule - Scaling rule.
type JobScaleRule struct {
	// Authentication secrets for the scale rule.
	Auth []*ScaleRuleAuth

	// Metadata properties to describe the scale rule.
	Metadata any

	// Scale Rule Name
	Name *string

	// Type of the scale rule eg: azure-servicebus, redis etc.
	Type *string
}

// JobSecretsCollection - Container Apps Job Secrets Collection ARM resource.
type JobSecretsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Secret
}

// JobTemplate - Container Apps Job versioned application definition. Defines the desired state of an immutable revision.
// Any changes to this section Will result in a new revision being created
type JobTemplate struct {
	// List of container definitions for the Container App.
	Containers []*Container

	// List of specialized containers that run before app containers.
	InitContainers []*InitContainer

	// List of volume definitions for the Container App.
	Volumes []*Volume
}

// JobsCollection - Container Apps Jobs collection ARM resource.
type JobsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Job

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// JwtClaimChecks - The configuration settings of the checks that should be made while validating the JWT Claims.
type JwtClaimChecks struct {
	// The list of the allowed client applications.
	AllowedClientApplications []*string

	// The list of the allowed groups.
	AllowedGroups []*string
}

// KedaConfiguration - Configuration properties Keda component
type KedaConfiguration struct {
	// READ-ONLY; The version of Keda
	Version *string
}

type ListUsagesResult struct {
	// The URI to fetch the next page of compute resource usage information. Call ListNext() with this to fetch the next page
	// of compute resource usage information.
	NextLink *string

	// The list of compute resource usages.
	Value []*Usage
}

// LogAnalyticsConfiguration - Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
type LogAnalyticsConfiguration struct {
	// Log analytics customer id
	CustomerID *string

	// Boolean indicating whether to parse json string log into dynamic json columns
	DynamicJSONColumns *bool

	// Log analytics customer key
	SharedKey *string
}

// Login - The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
type Login struct {
	// External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part
	// of the URL is ignored. This is an advanced setting typically only needed by
	// Windows Store application backends. Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls []*string

	// The configuration settings of the session cookie's expiration.
	CookieExpiration *CookieExpiration

	// The configuration settings of the nonce used in the login flow.
	Nonce *Nonce

	// true if the fragments from the request are preserved after the login request is made; otherwise, false.
	PreserveURLFragmentsForLogins *bool

	// The routes that specify the endpoints used for login and logout requests.
	Routes *LoginRoutes

	// The configuration settings of the token store.
	TokenStore *TokenStore
}

// LoginRoutes - The routes that specify the endpoints used for login and logout requests.
type LoginRoutes struct {
	// The endpoint at which a logout request should be made.
	LogoutEndpoint *string
}

// LoginScopes - The configuration settings of the login flow, including the scopes that should be requested.
type LoginScopes struct {
	// A list of the scopes that should be requested while authenticating.
	Scopes []*string
}

// LogsConfiguration - Configuration of Open Telemetry logs
type LogsConfiguration struct {
	// Open telemetry logs destinations
	Destinations []*string
}

// ManagedCertificate - Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment
type ManagedCertificate struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Certificate resource specific properties
	Properties *ManagedCertificateProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedCertificateCollection - Collection of Managed Certificates.
type ManagedCertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ManagedCertificate

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ManagedCertificatePatch - A managed certificate to update
type ManagedCertificatePatch struct {
	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// ManagedCertificateProperties - Certificate resource specific properties
type ManagedCertificateProperties struct {
	// Selected type of domain control validation for managed certificates.
	DomainControlValidation *ManagedCertificateDomainControlValidation

	// Subject name of the certificate.
	SubjectName *string

	// READ-ONLY; Any error occurred during the certificate provision.
	Error *string

	// READ-ONLY; Provisioning state of the certificate.
	ProvisioningState *CertificateProvisioningState

	// READ-ONLY; A TXT token used for DNS TXT domain control validation when issuing this type of managed certificates.
	ValidationToken *string
}

// ManagedEnvironment - An environment for hosting container apps
type ManagedEnvironment struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Managed identities for the Managed Environment to interact with other Azure services without maintaining any secrets or
	// credentials in code.
	Identity *ManagedServiceIdentity

	// Kind of the Environment.
	Kind *string

	// Managed environment resource specific properties
	Properties *ManagedEnvironmentProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedEnvironmentProperties - Managed environment resource specific properties
type ManagedEnvironmentProperties struct {
	// Environment level Application Insights configuration
	AppInsightsConfiguration *AppInsightsConfiguration

	// Cluster configuration which enables the log daemon to export app logs to a destination. Currently only "log-analytics"
	// is supported
	AppLogsConfiguration *AppLogsConfiguration

	// Custom domain configuration for the environment
	CustomDomainConfiguration *CustomDomainConfiguration

	// Application Insights connection string used by Dapr to export Service to Service communication telemetry
	DaprAIConnectionString *string

	// Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
	DaprAIInstrumentationKey *string

	// The configuration of Dapr component.
	DaprConfiguration *DaprConfiguration

	// Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. If a
	// subnet ID is provided, this resource group will be created in the same
	// subscription as the subnet.
	InfrastructureResourceGroup *string

	// The configuration of Keda component.
	KedaConfiguration *KedaConfiguration

	// Environment Open Telemetry configuration
	OpenTelemetryConfiguration *OpenTelemetryConfiguration

	// Peer authentication settings for the Managed Environment
	PeerAuthentication *ManagedEnvironmentPropertiesPeerAuthentication

	// Vnet configuration for the environment
	VnetConfiguration *VnetConfiguration

	// Workload profiles configured for the Managed Environment.
	WorkloadProfiles []*WorkloadProfile

	// Whether or not this Managed Environment is zone-redundant.
	ZoneRedundant *bool

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string

	// READ-ONLY; The endpoint of the eventstream of the Environment.
	EventStreamEndpoint *string

	// READ-ONLY; Provisioning state of the Environment.
	ProvisioningState *EnvironmentProvisioningState

	// READ-ONLY; Static IP of the Environment
	StaticIP *string
}

// ManagedEnvironmentPropertiesPeerAuthentication - Peer authentication settings for the Managed Environment
type ManagedEnvironmentPropertiesPeerAuthentication struct {
	// Mutual TLS authentication settings for the Managed Environment
	Mtls *Mtls
}

// ManagedEnvironmentStorage - Storage resource for managedEnvironment.
type ManagedEnvironmentStorage struct {
	// Storage properties
	Properties *ManagedEnvironmentStorageProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedEnvironmentStorageProperties - Storage properties
type ManagedEnvironmentStorageProperties struct {
	// Azure file properties
	AzureFile *AzureFileProperties

	// NFS Azure file properties
	NfsAzureFile *NfsAzureFileProperties
}

// ManagedEnvironmentStoragesCollection - Collection of Storage for Environments
type ManagedEnvironmentStoragesCollection struct {
	// REQUIRED; Collection of storage resources.
	Value []*ManagedEnvironmentStorage
}

// ManagedEnvironmentsCollection - Collection of Environments
type ManagedEnvironmentsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ManagedEnvironment

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// MetricsConfiguration - Configuration of Open Telemetry metrics
type MetricsConfiguration struct {
	// Open telemetry metrics destinations
	Destinations []*string
}

// Mtls - Configuration properties for mutual TLS authentication
type Mtls struct {
	// Boolean indicating whether the mutual TLS authentication is enabled
	Enabled *bool
}

// NfsAzureFileProperties - NFS Azure File Properties.
type NfsAzureFileProperties struct {
	// Access mode for storage
	AccessMode *AccessMode

	// Server for NFS azure file.
	Server *string

	// NFS Azure file share name.
	ShareName *string
}

// Nonce - The configuration settings of the nonce used in the login flow.
type Nonce struct {
	// The time after the request is made when the nonce should expire.
	NonceExpirationInterval *string

	// false if the nonce should not be validated while completing the login flow; otherwise, true.
	ValidateNonce *bool
}

// OpenIDConnectClientCredential - The authentication client credentials of the custom Open ID Connect provider.
type OpenIDConnectClientCredential struct {
	// The app setting that contains the client secret for the custom Open ID Connect provider.
	ClientSecretSettingName *string

	// The method that should be used to authenticate the user.
	Method *string
}

// OpenIDConnectConfig - The configuration settings of the endpoints used for the custom Open ID Connect provider.
type OpenIDConnectConfig struct {
	// The endpoint to be used to make an authorization request.
	AuthorizationEndpoint *string

	// The endpoint that provides the keys necessary to validate the token.
	CertificationURI *string

	// The endpoint that issues the token.
	Issuer *string

	// The endpoint to be used to request a token.
	TokenEndpoint *string

	// The endpoint that contains all the configuration endpoints for the provider.
	WellKnownOpenIDConfiguration *string
}

// OpenIDConnectLogin - The configuration settings of the login flow of the custom Open ID Connect provider.
type OpenIDConnectLogin struct {
	// The name of the claim that contains the users name.
	NameClaimType *string

	// A list of the scopes that should be requested while authenticating.
	Scopes []*string
}

// OpenIDConnectRegistration - The configuration settings of the app registration for the custom Open ID Connect provider.
type OpenIDConnectRegistration struct {
	// The authentication credentials of the custom Open ID Connect provider.
	ClientCredential *OpenIDConnectClientCredential

	// The client id of the custom Open ID Connect provider.
	ClientID *string

	// The configuration settings of the endpoints used for the custom Open ID Connect provider.
	OpenIDConnectConfiguration *OpenIDConnectConfig
}

// OpenTelemetryConfiguration - Configuration of Open Telemetry
type OpenTelemetryConfiguration struct {
	// Open telemetry destinations configuration
	DestinationsConfiguration *DestinationsConfiguration

	// Open telemetry logs configuration
	LogsConfiguration *LogsConfiguration

	// Open telemetry metrics configuration
	MetricsConfiguration *MetricsConfiguration

	// Open telemetry trace configuration
	TracesConfiguration *TracesConfiguration
}

// OperationDetail - Operation detail payload
type OperationDetail struct {
	// Display of the operation
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Name of the operation
	Name *string

	// Origin of the operation
	Origin *string
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string

	// Localized friendly name for the operation
	Operation *string

	// Resource provider of the operation
	Provider *string

	// Resource of the operation
	Resource *string
}

// OtlpConfiguration - Configuration of otlp
type OtlpConfiguration struct {
	// The endpoint of otlp configuration
	Endpoint *string

	// Headers of otlp configurations
	Headers []*Header

	// Boolean indicating if otlp configuration is insecure
	Insecure *bool

	// The name of otlp configuration
	Name *string
}

// PreBuildStep - Model representing a pre-build step.
type PreBuildStep struct {
	// Description of the pre-build step.
	Description *string

	// Http get request to send before the build.
	HTTPGet *HTTPGet

	// List of custom commands to run.
	Scripts []*string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// QueueScaleRule - Container App container Azure Queue based scaling rule.
type QueueScaleRule struct {
	// Authentication secrets for the queue scale rule.
	Auth []*ScaleRuleAuth

	// Queue length.
	QueueLength *int32

	// Queue name.
	QueueName *string
}

// RegistryCredentials - Container App Private Registry
type RegistryCredentials struct {
	// A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned
	// identity Resource ID. For system-assigned identities, use 'system'
	Identity *string

	// The name of the Secret that contains the registry login password
	PasswordSecretRef *string

	// Container Registry Server
	Server *string

	// Container Registry Username
	Username *string
}

// RegistryInfo - Container App registry information.
type RegistryInfo struct {
	// registry secret.
	RegistryPassword *string

	// registry server Url.
	RegistryURL *string

	// registry username.
	RegistryUserName *string
}

// Replica - Container App Revision Replica.
type Replica struct {
	// Replica resource specific properties
	Properties *ReplicaProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ReplicaCollection - Container App Revision Replicas collection ARM resource.
type ReplicaCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Replica
}

// ReplicaContainer - Container object under Container App Revision Replica.
type ReplicaContainer struct {
	// The Id of the Container
	ContainerID *string

	// The Name of the Container
	Name *string

	// The container ready status
	Ready *bool

	// The container restart count
	RestartCount *int32

	// The container start status
	Started *bool

	// READ-ONLY; Container exec endpoint
	ExecEndpoint *string

	// READ-ONLY; Log Stream endpoint
	LogStreamEndpoint *string

	// READ-ONLY; Current running state of the container
	RunningState *ContainerAppContainerRunningState

	// READ-ONLY; The details of container current running state
	RunningStateDetails *string
}

// ReplicaProperties - Replica resource specific properties
type ReplicaProperties struct {
	// The containers collection under a replica.
	Containers []*ReplicaContainer

	// The init containers collection under a replica.
	InitContainers []*ReplicaContainer

	// READ-ONLY; Timestamp describing when the pod was created by controller
	CreatedTime *time.Time

	// READ-ONLY; Current running state of the replica
	RunningState *ContainerAppReplicaRunningState

	// READ-ONLY; The details of replica current running state
	RunningStateDetails *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Revision - Container App Revision.
type Revision struct {
	// Revision resource specific properties
	Properties *RevisionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RevisionCollection - Container App Revisions collection ARM resource.
type RevisionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Revision

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// RevisionProperties - Revision resource specific properties
type RevisionProperties struct {
	// READ-ONLY; Boolean describing if the Revision is Active
	Active *bool

	// READ-ONLY; Timestamp describing when the revision was created by controller
	CreatedTime *time.Time

	// READ-ONLY; Fully qualified domain name of the revision
	Fqdn *string

	// READ-ONLY; Current health State of the revision
	HealthState *RevisionHealthState

	// READ-ONLY; Timestamp describing when the revision was last active. Only meaningful when revision is inactive
	LastActiveTime *time.Time

	// READ-ONLY; Optional Field - Platform Error Message
	ProvisioningError *string

	// READ-ONLY; Current provisioning State of the revision
	ProvisioningState *RevisionProvisioningState

	// READ-ONLY; Number of pods currently running for this revision
	Replicas *int32

	// READ-ONLY; Current running state of the revision
	RunningState *RevisionRunningState

	// READ-ONLY; Container App Revision Template with all possible settings and the defaults if user did not provide them. The
	// defaults are populated as they were at the creation time
	Template *Template

	// READ-ONLY; Traffic weight assigned to this revision
	TrafficWeight *int32
}

// Scale - Container App scaling configurations.
type Scale struct {
	// Optional. Maximum number of container replicas. Defaults to 10 if not set.
	MaxReplicas *int32

	// Optional. Minimum number of container replicas.
	MinReplicas *int32

	// Scaling rules.
	Rules []*ScaleRule
}

// ScaleRule - Container App container scaling rule.
type ScaleRule struct {
	// Azure Queue based scaling.
	AzureQueue *QueueScaleRule

	// Custom scale rule.
	Custom *CustomScaleRule

	// HTTP requests based scaling.
	HTTP *HTTPScaleRule

	// Scale Rule Name
	Name *string

	// Tcp requests based scaling.
	TCP *TCPScaleRule
}

// ScaleRuleAuth - Auth Secrets for Scale Rule
type ScaleRuleAuth struct {
	// Name of the secret from which to pull the auth params.
	SecretRef *string

	// Trigger Parameter that uses the secret
	TriggerParameter *string
}

// Secret definition.
type Secret struct {
	// Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity.
	Identity *string

	// Azure Key Vault URL pointing to the secret referenced by the container app.
	KeyVaultURL *string

	// Secret Name.
	Name *string

	// Secret Value.
	Value *string
}

// SecretVolumeItem - Secret to be added to volume.
type SecretVolumeItem struct {
	// Path to project secret to. If no path is provided, path defaults to name of secret listed in secretRef.
	Path *string

	// Name of the Container App secret from which to pull the secret value.
	SecretRef *string
}

// SecretsCollection - Container App Secrets Collection ARM resource.
type SecretsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerAppSecret
}

// Service - Container App to be a dev service
type Service struct {
	// REQUIRED; Dev ContainerApp service type
	Type *string
}

// ServiceBind - Configuration to bind a ContainerApp to a dev ContainerApp Service
type ServiceBind struct {
	// Type of the client to be used to connect to the service
	ClientType *string

	// Customized keys for customizing injected values to the app
	CustomizedKeys map[string]*string

	// Name of the service bind
	Name *string

	// Resource id of the target service
	ServiceID *string
}

// SourceControl - Container App SourceControl.
type SourceControl struct {
	// SourceControl resource specific properties
	Properties *SourceControlProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SourceControlCollection - SourceControl collection ARM resource.
type SourceControlCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SourceControl

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SourceControlProperties - SourceControl resource specific properties
type SourceControlProperties struct {
	// The branch which will trigger the auto deployment
	Branch *string

	// Container App Revision Template with all possible settings and the defaults if user did not provide them. The defaults
	// are populated as they were at the creation time
	GithubActionConfiguration *GithubActionConfiguration

	// The repo url which will be integrated to ContainerApp.
	RepoURL *string

	// READ-ONLY; Current provisioning State of the operation
	OperationState *SourceControlOperationState
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TCPConnectionPool - Defines parameters for tcp connection pooling
type TCPConnectionPool struct {
	// Maximum number of tcp connections allowed
	MaxConnections *int32
}

// TCPRetryPolicy - Policy that defines tcp request retry conditions
type TCPRetryPolicy struct {
	// Maximum number of attempts to connect to the tcp service
	MaxConnectAttempts *int32
}

// TCPScaleRule - Container App container Tcp scaling rule.
type TCPScaleRule struct {
	// Authentication secrets for the tcp scale rule.
	Auth []*ScaleRuleAuth

	// Metadata properties to describe tcp scale rule.
	Metadata map[string]*string
}

// Template - Container App versioned application definition. Defines the desired state of an immutable revision. Any changes
// to this section Will result in a new revision being created
type Template struct {
	// List of container definitions for the Container App.
	Containers []*Container

	// List of specialized containers that run before app containers.
	InitContainers []*InitContainer

	// User friendly suffix that is appended to the revision name
	RevisionSuffix *string

	// Scaling properties for the Container App.
	Scale *Scale

	// List of container app services bound to the app
	ServiceBinds []*ServiceBind

	// Optional duration in seconds the Container App Instance needs to terminate gracefully. Value must be non-negative integer.
	// The value zero indicates stop immediately via the kill signal (no opportunity
	// to shut down). If this value is nil, the default grace period will be used instead. Set this value longer than the expected
	// cleanup time for your process. Defaults to 30 seconds.
	TerminationGracePeriodSeconds *int64

	// List of volume definitions for the Container App.
	Volumes []*Volume
}

// TimeoutPolicy - Policy to set request timeouts
type TimeoutPolicy struct {
	// Timeout, in seconds, for a request to initiate a connection
	ConnectionTimeoutInSeconds *int32

	// Timeout, in seconds, for a request to respond
	ResponseTimeoutInSeconds *int32
}

// TokenStore - The configuration settings of the token store.
type TokenStore struct {
	// The configuration settings of the storage of the tokens if blob storage is used.
	AzureBlobStorage *BlobStorageTokenStore

	// true to durably store platform-specific security tokens that are obtained during login flows; otherwise, false. The default
	// is false.
	Enabled *bool

	// The number of hours after session token expiration that a session token can be used to call the token refresh API. The
	// default is 72 hours.
	TokenRefreshExtensionHours *float64
}

// TracesConfiguration - Configuration of Open Telemetry traces
type TracesConfiguration struct {
	// Open telemetry traces destinations
	Destinations []*string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TrafficWeight - Traffic weight assigned to a revision
type TrafficWeight struct {
	// Associates a traffic label with a revision
	Label *string

	// Indicates that the traffic weight belongs to a latest stable revision
	LatestRevision *bool

	// Name of a revision
	RevisionName *string

	// Traffic weight assigned to a revision
	Weight *int32
}

// Twitter - The configuration settings of the Twitter provider.
type Twitter struct {
	// false if the Twitter provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the app registration for the Twitter provider.
	Registration *TwitterRegistration
}

// TwitterRegistration - The configuration settings of the app registration for the Twitter provider.
type TwitterRegistration struct {
	// The OAuth 1.0a consumer key of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	ConsumerKey *string

	// The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	ConsumerSecretSettingName *string
}

// Usage - Describes Compute Resource Usage.
type Usage struct {
	// REQUIRED; The current usage of the resource.
	CurrentValue *float32

	// REQUIRED; The maximum permitted usage of the resource.
	Limit *float32

	// REQUIRED; The name of the type of usage.
	Name *UsageName

	// REQUIRED; An enum describing the unit of usage measurement.
	Unit *string
}

// UsageName - The Usage Names.
type UsageName struct {
	// The localized name of the resource.
	LocalizedValue *string

	// The name of the resource.
	Value *string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// VnetConfiguration - Configuration properties for apps environment to join a Virtual Network
type VnetConfiguration struct {
	// CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
	DockerBridgeCidr *string

	// Resource ID of a subnet for infrastructure components. Must not overlap with any other provided IP ranges.
	InfrastructureSubnetID *string

	// Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP
	// resource. They must provide infrastructureSubnetId if enabling this property
	Internal *bool

	// IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other
	// provided IP ranges.
	PlatformReservedCidr *string

	// An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
	PlatformReservedDNSIP *string
}

// Volume definitions for the Container App.
type Volume struct {
	// Mount options used while mounting the Azure file share or NFS Azure file share. Must be a comma-separated string.
	MountOptions *string

	// Volume name.
	Name *string

	// List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
	Secrets []*SecretVolumeItem

	// Name of storage resource. No need to provide for EmptyDir and Secret.
	StorageName *string

	// Storage type for the volume. If not provided, use EmptyDir.
	StorageType *StorageType
}

// VolumeMount - Volume mount for the Container App.
type VolumeMount struct {
	// Path within the container at which the volume should be mounted.Must not contain ':'.
	MountPath *string

	// Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
	SubPath *string

	// This must match the Name of a Volume.
	VolumeName *string
}

// WorkloadProfile - Workload profile to scope container app execution.
type WorkloadProfile struct {
	// REQUIRED; Workload profile type for the workloads to run on.
	Name *string

	// REQUIRED; Workload profile type for the workloads to run on.
	WorkloadProfileType *string

	// The maximum capacity.
	MaximumCount *int32

	// The minimum capacity.
	MinimumCount *int32
}

// WorkloadProfileStates - Collection of all the workload Profile States for a Managed Environment..
type WorkloadProfileStates struct {
	// Workload Profile resource specific properties.
	Properties *WorkloadProfileStatesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkloadProfileStatesCollection - Collection of workloadProfileStates
type WorkloadProfileStatesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WorkloadProfileStates

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// WorkloadProfileStatesProperties - Workload Profile resource specific properties.
type WorkloadProfileStatesProperties struct {
	// Current count of nodes.
	CurrentCount *int32

	// Maximum count of nodes.
	MaximumCount *int32

	// Minimum count of instances.
	MinimumCount *int32
}
