//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappcontainers

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// BuildsByBuilderResourceClient contains the methods for the BuildsByBuilderResource group.
// Don't use this type directly, use NewBuildsByBuilderResourceClient() instead.
type BuildsByBuilderResourceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewBuildsByBuilderResourceClient creates a new instance of BuildsByBuilderResourceClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewBuildsByBuilderResourceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BuildsByBuilderResourceClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &BuildsByBuilderResourceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListPager - List BuildResource resources by BuilderResource
//
// Generated from API version 2023-11-02-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - builderName - The name of the builder.
//   - options - BuildsByBuilderResourceClientListOptions contains the optional parameters for the BuildsByBuilderResourceClient.NewListPager
//     method.
func (client *BuildsByBuilderResourceClient) NewListPager(resourceGroupName string, builderName string, options *BuildsByBuilderResourceClientListOptions) *runtime.Pager[BuildsByBuilderResourceClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[BuildsByBuilderResourceClientListResponse]{
		More: func(page BuildsByBuilderResourceClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BuildsByBuilderResourceClientListResponse) (BuildsByBuilderResourceClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "BuildsByBuilderResourceClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, builderName, options)
			}, nil)
			if err != nil {
				return BuildsByBuilderResourceClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *BuildsByBuilderResourceClient) listCreateRequest(ctx context.Context, resourceGroupName string, builderName string, options *BuildsByBuilderResourceClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/builders/{builderName}/builds"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if builderName == "" {
		return nil, errors.New("parameter builderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{builderName}", url.PathEscape(builderName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-02-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *BuildsByBuilderResourceClient) listHandleResponse(resp *http.Response) (BuildsByBuilderResourceClientListResponse, error) {
	result := BuildsByBuilderResourceClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildCollection); err != nil {
		return BuildsByBuilderResourceClientListResponse{}, err
	}
	return result, nil
}
