//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcomplianceautomation/armappcomplianceautomation"
	"net/http"
	"net/url"
	"strconv"
)

// ReportsServer is a fake server for instances of the armappcomplianceautomation.ReportsClient type.
type ReportsServer struct {
	// NewListPager is the fake for method ReportsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappcomplianceautomation.ReportsClientListOptions) (resp azfake.PagerResponder[armappcomplianceautomation.ReportsClientListResponse])
}

// NewReportsServerTransport creates a new instance of ReportsServerTransport with the provided implementation.
// The returned ReportsServerTransport instance is connected to an instance of armappcomplianceautomation.ReportsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReportsServerTransport(srv *ReportsServer) *ReportsServerTransport {
	return &ReportsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armappcomplianceautomation.ReportsClientListResponse]](),
	}
}

// ReportsServerTransport connects instances of armappcomplianceautomation.ReportsClient to instances of ReportsServer.
// Don't use this type directly, use NewReportsServerTransport instead.
type ReportsServerTransport struct {
	srv          *ReportsServer
	newListPager *tracker[azfake.PagerResponder[armappcomplianceautomation.ReportsClientListResponse]]
}

// Do implements the policy.Transporter interface for ReportsServerTransport.
func (r *ReportsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReportsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		offerGUIDUnescaped, err := url.QueryUnescape(qp.Get("offerGuid"))
		if err != nil {
			return nil, err
		}
		offerGUIDParam := getOptional(offerGUIDUnescaped)
		reportCreatorTenantIDUnescaped, err := url.QueryUnescape(qp.Get("reportCreatorTenantId"))
		if err != nil {
			return nil, err
		}
		reportCreatorTenantIDParam := getOptional(reportCreatorTenantIDUnescaped)
		var options *armappcomplianceautomation.ReportsClientListOptions
		if skipTokenParam != nil || topParam != nil || selectParam != nil || offerGUIDParam != nil || reportCreatorTenantIDParam != nil {
			options = &armappcomplianceautomation.ReportsClientListOptions{
				SkipToken:             skipTokenParam,
				Top:                   topParam,
				Select:                selectParam,
				OfferGUID:             offerGUIDParam,
				ReportCreatorTenantID: reportCreatorTenantIDParam,
			}
		}
		resp := r.srv.NewListPager(options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappcomplianceautomation.ReportsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}
