//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementHeadSignUpSettings.json
func ExampleSignUpSettingsClient_GetEntityTag() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSignUpSettingsClient().GetEntityTag(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementPortalSettingsGetSignUp.json
func ExampleSignUpSettingsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSignUpSettingsClient().Get(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PortalSignupSettings = armapimanagement.PortalSignupSettings{
	// 	Name: to.Ptr("signup"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/portalsettings"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/portalsettings/signup"),
	// 	Properties: &armapimanagement.PortalSignupSettingsProperties{
	// 		Enabled: to.Ptr(true),
	// 		TermsOfService: &armapimanagement.TermsOfServiceProperties{
	// 			ConsentRequired: to.Ptr(true),
	// 			Enabled: to.Ptr(true),
	// 			Text: to.Ptr("Terms of service text."),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementPortalSettingsUpdateSignUp.json
func ExampleSignUpSettingsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSignUpSettingsClient().Update(ctx, "rg1", "apimService1", "*", armapimanagement.PortalSignupSettings{
		Properties: &armapimanagement.PortalSignupSettingsProperties{
			Enabled: to.Ptr(true),
			TermsOfService: &armapimanagement.TermsOfServiceProperties{
				ConsentRequired: to.Ptr(true),
				Enabled:         to.Ptr(true),
				Text:            to.Ptr("Terms of service text."),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementPortalSettingsPutSignUp.json
func ExampleSignUpSettingsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSignUpSettingsClient().CreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.PortalSignupSettings{
		Properties: &armapimanagement.PortalSignupSettingsProperties{
			Enabled: to.Ptr(true),
			TermsOfService: &armapimanagement.TermsOfServiceProperties{
				ConsentRequired: to.Ptr(true),
				Enabled:         to.Ptr(true),
				Text:            to.Ptr("Terms of service text."),
			},
		},
	}, &armapimanagement.SignUpSettingsClientCreateOrUpdateOptions{IfMatch: to.Ptr("*")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PortalSignupSettings = armapimanagement.PortalSignupSettings{
	// 	Name: to.Ptr("signup"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/portalsettings"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/portalsettings/signup"),
	// 	Properties: &armapimanagement.PortalSignupSettingsProperties{
	// 		Enabled: to.Ptr(true),
	// 		TermsOfService: &armapimanagement.TermsOfServiceProperties{
	// 			ConsentRequired: to.Ptr(true),
	// 			Enabled: to.Ptr(true),
	// 			Text: to.Ptr("Terms of service text."),
	// 		},
	// 	},
	// }
}
