//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListIdentityProviders.json
func ExampleIdentityProviderClient_NewListByServicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIdentityProviderClient().NewListByServicePager("rg1", "apimService1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IdentityProviderList = armapimanagement.IdentityProviderList{
		// 	Count: to.Ptr[int64](3),
		// 	Value: []*armapimanagement.IdentityProviderContract{
		// 		{
		// 			Name: to.Ptr("Google"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/identityProviders"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/identityProviders/Google"),
		// 			Properties: &armapimanagement.IdentityProviderContractProperties{
		// 				Type: to.Ptr(armapimanagement.IdentityProviderTypeGoogle),
		// 				ClientID: to.Ptr("googleId"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Aad"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/identityProviders"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/identityProviders/Aad"),
		// 			Properties: &armapimanagement.IdentityProviderContractProperties{
		// 				Type: to.Ptr(armapimanagement.IdentityProviderTypeAAD),
		// 				AllowedTenants: []*string{
		// 					to.Ptr("samiraad.onmicrosoft.com")},
		// 					ClientID: to.Ptr("aadapplicationid"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("AadB2C"),
		// 				Type: to.Ptr("Microsoft.ApiManagement/service/identityProviders"),
		// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/identityProviders/AadB2C"),
		// 				Properties: &armapimanagement.IdentityProviderContractProperties{
		// 					Type: to.Ptr(armapimanagement.IdentityProviderTypeAADB2C),
		// 					AllowedTenants: []*string{
		// 						to.Ptr("samirtestbc.onmicrosoft.com")},
		// 						SigninPolicyName: to.Ptr("B2C_1_Signin_Default"),
		// 						SignupPolicyName: to.Ptr("B2C_1_Signup_Default"),
		// 						ClientID: to.Ptr("aadb2clientId"),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementHeadIdentityProvider.json
func ExampleIdentityProviderClient_GetEntityTag() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIdentityProviderClient().GetEntityTag(ctx, "rg1", "apimService1", armapimanagement.IdentityProviderTypeAADB2C, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementGetIdentityProvider.json
func ExampleIdentityProviderClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIdentityProviderClient().Get(ctx, "rg1", "apimService1", armapimanagement.IdentityProviderTypeAADB2C, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IdentityProviderContract = armapimanagement.IdentityProviderContract{
	// 	Name: to.Ptr("AadB2C"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/identityProviders"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/identityProviders/AadB2C"),
	// 	Properties: &armapimanagement.IdentityProviderContractProperties{
	// 		Type: to.Ptr(armapimanagement.IdentityProviderTypeAADB2C),
	// 		AllowedTenants: []*string{
	// 			to.Ptr("contosoaadb2c.onmicrosoft.com"),
	// 			to.Ptr("contoso2aadb2c.onmicrosoft.com")},
	// 			Authority: to.Ptr("login.microsoftonline.com"),
	// 			SigninPolicyName: to.Ptr("B2C_1_policy-signin"),
	// 			SigninTenant: to.Ptr("contosoaadb2c.onmicrosoft.com"),
	// 			SignupPolicyName: to.Ptr("B2C_1_policy-signup"),
	// 			ClientID: to.Ptr("f02dafe2-b8b8-48ec-a38e-27e5c16c51e5"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateIdentityProvider.json
func ExampleIdentityProviderClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIdentityProviderClient().CreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.IdentityProviderTypeFacebook, armapimanagement.IdentityProviderCreateContract{
		Properties: &armapimanagement.IdentityProviderCreateContractProperties{
			ClientID:     to.Ptr("facebookid"),
			ClientSecret: to.Ptr("facebookapplicationsecret"),
		},
	}, &armapimanagement.IdentityProviderClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IdentityProviderContract = armapimanagement.IdentityProviderContract{
	// 	Name: to.Ptr("Facebook"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/identityProviders"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/identityProviders/Facebook"),
	// 	Properties: &armapimanagement.IdentityProviderContractProperties{
	// 		Type: to.Ptr(armapimanagement.IdentityProviderTypeFacebook),
	// 		ClientID: to.Ptr("facebookid"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementUpdateIdentityProvider.json
func ExampleIdentityProviderClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIdentityProviderClient().Update(ctx, "rg1", "apimService1", armapimanagement.IdentityProviderTypeFacebook, "*", armapimanagement.IdentityProviderUpdateParameters{
		Properties: &armapimanagement.IdentityProviderUpdateProperties{
			ClientID:     to.Ptr("updatedfacebookid"),
			ClientSecret: to.Ptr("updatedfacebooksecret"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IdentityProviderContract = armapimanagement.IdentityProviderContract{
	// 	Name: to.Ptr("AadB2C"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/identityProviders"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/identityProviders/AadB2C"),
	// 	Properties: &armapimanagement.IdentityProviderContractProperties{
	// 		Type: to.Ptr(armapimanagement.IdentityProviderTypeAADB2C),
	// 		AllowedTenants: []*string{
	// 			to.Ptr("contosoaadb2c.onmicrosoft.com"),
	// 			to.Ptr("contoso2aadb2c.onmicrosoft.com")},
	// 			Authority: to.Ptr("login.microsoftonline.com"),
	// 			SigninPolicyName: to.Ptr("B2C_1_policy-signin"),
	// 			SigninTenant: to.Ptr("contosoaadb2c.onmicrosoft.com"),
	// 			SignupPolicyName: to.Ptr("B2C_1_policy-signup"),
	// 			ClientID: to.Ptr("f02dafe2-b8b8-48ec-a38e-27e5c16c51e5"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementDeleteIdentityProvider.json
func ExampleIdentityProviderClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIdentityProviderClient().Delete(ctx, "rg1", "apimService1", armapimanagement.IdentityProviderTypeAAD, "*", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementIdentityProviderListSecrets.json
func ExampleIdentityProviderClient_ListSecrets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIdentityProviderClient().ListSecrets(ctx, "rg1", "apimService1", armapimanagement.IdentityProviderTypeAADB2C, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ClientSecretContract = armapimanagement.ClientSecretContract{
	// 	ClientSecret: to.Ptr("XXXXXXX"),
	// }
}
