//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// OperationServer is a fake server for instances of the armapimanagement.OperationClient type.
type OperationServer struct {
	// NewListByTagsPager is the fake for method OperationClient.NewListByTagsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTagsPager func(resourceGroupName string, serviceName string, apiID string, options *armapimanagement.OperationClientListByTagsOptions) (resp azfake.PagerResponder[armapimanagement.OperationClientListByTagsResponse])
}

// NewOperationServerTransport creates a new instance of OperationServerTransport with the provided implementation.
// The returned OperationServerTransport instance is connected to an instance of armapimanagement.OperationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOperationServerTransport(srv *OperationServer) *OperationServerTransport {
	return &OperationServerTransport{
		srv:                srv,
		newListByTagsPager: newTracker[azfake.PagerResponder[armapimanagement.OperationClientListByTagsResponse]](),
	}
}

// OperationServerTransport connects instances of armapimanagement.OperationClient to instances of OperationServer.
// Don't use this type directly, use NewOperationServerTransport instead.
type OperationServerTransport struct {
	srv                *OperationServer
	newListByTagsPager *tracker[azfake.PagerResponder[armapimanagement.OperationClientListByTagsResponse]]
}

// Do implements the policy.Transporter interface for OperationServerTransport.
func (o *OperationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OperationClient.NewListByTagsPager":
		resp, err = o.dispatchNewListByTagsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OperationServerTransport) dispatchNewListByTagsPager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListByTagsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTagsPager not implemented")}
	}
	newListByTagsPager := o.newListByTagsPager.get(req)
	if newListByTagsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationsByTags`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		includeNotTaggedOperationsUnescaped, err := url.QueryUnescape(qp.Get("includeNotTaggedOperations"))
		if err != nil {
			return nil, err
		}
		includeNotTaggedOperationsParam, err := parseOptional(includeNotTaggedOperationsUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.OperationClientListByTagsOptions
		if filterParam != nil || topParam != nil || skipParam != nil || includeNotTaggedOperationsParam != nil {
			options = &armapimanagement.OperationClientListByTagsOptions{
				Filter:                     filterParam,
				Top:                        topParam,
				Skip:                       skipParam,
				IncludeNotTaggedOperations: includeNotTaggedOperationsParam,
			}
		}
		resp := o.srv.NewListByTagsPager(resourceGroupNameParam, serviceNameParam, apiIDParam, options)
		newListByTagsPager = &resp
		o.newListByTagsPager.add(req, newListByTagsPager)
		server.PagerResponderInjectNextLinks(newListByTagsPager, req, func(page *armapimanagement.OperationClientListByTagsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTagsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListByTagsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTagsPager) {
		o.newListByTagsPager.remove(req)
	}
	return resp, nil
}
