//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenaiassistants

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
)

// MarshalJSON implements the json.Marshaller interface for type Assistant.
func (a Assistant) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeUnix(objectMap, "created_at", a.CreatedAt)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "file_ids", a.FileIDs)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "instructions", a.Instructions)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "model", a.DeploymentName)
	populate(objectMap, "name", a.Name)
	objectMap["object"] = "assistant"
	populate(objectMap, "tools", a.Tools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Assistant.
func (a *Assistant) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &a.CreatedAt)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "file_ids":
			err = unpopulate(val, "FileIDs", &a.FileIDs)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &a.Instructions)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &a.DeploymentName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &a.Object)
			delete(rawMsg, key)
		case "tools":
			a.Tools, err = unmarshalToolDefinitionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantCreationBody.
func (a AssistantCreationBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "file_ids", a.FileIDs)
	populate(objectMap, "instructions", a.Instructions)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "model", a.DeploymentName)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "tools", a.Tools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantCreationBody.
func (a *AssistantCreationBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "file_ids":
			err = unpopulate(val, "FileIDs", &a.FileIDs)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &a.Instructions)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &a.DeploymentName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "tools":
			a.Tools, err = unmarshalToolDefinitionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantDeletionStatus.
func (a AssistantDeletionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleted", a.Deleted)
	populate(objectMap, "id", a.ID)
	objectMap["object"] = "assistant.deleted"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantDeletionStatus.
func (a *AssistantDeletionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleted":
			err = unpopulate(val, "Deleted", &a.Deleted)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &a.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantFile.
func (a AssistantFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assistant_id", a.AssistantID)
	populateTimeUnix(objectMap, "created_at", a.CreatedAt)
	populate(objectMap, "id", a.ID)
	objectMap["object"] = "assistant.file"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantFile.
func (a *AssistantFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assistant_id":
			err = unpopulate(val, "AssistantID", &a.AssistantID)
			delete(rawMsg, key)
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &a.CreatedAt)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &a.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantFileDeletionStatus.
func (a AssistantFileDeletionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleted", a.Deleted)
	populate(objectMap, "id", a.ID)
	objectMap["object"] = "assistant.file.deleted"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantFileDeletionStatus.
func (a *AssistantFileDeletionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleted":
			err = unpopulate(val, "Deleted", &a.Deleted)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &a.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantThread.
func (a AssistantThread) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeUnix(objectMap, "created_at", a.CreatedAt)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "metadata", a.Metadata)
	objectMap["object"] = "thread"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantThread.
func (a *AssistantThread) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &a.CreatedAt)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &a.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantThreadCreationOptions.
func (a AssistantThreadCreationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messages", a.Messages)
	populate(objectMap, "metadata", a.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantThreadCreationOptions.
func (a *AssistantThreadCreationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messages":
			err = unpopulate(val, "Messages", &a.Messages)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeInterpreterToolDefinition.
func (c CodeInterpreterToolDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "code_interpreter"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeInterpreterToolDefinition.
func (c *CodeInterpreterToolDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateAndRunThreadOptions.
func (c CreateAndRunThreadOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assistant_id", c.AssistantID)
	populate(objectMap, "instructions", c.Instructions)
	populate(objectMap, "metadata", c.Metadata)
	populate(objectMap, "model", c.DeploymentName)
	populate(objectMap, "thread", c.Thread)
	populate(objectMap, "tools", c.Tools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateAndRunThreadOptions.
func (c *CreateAndRunThreadOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assistant_id":
			err = unpopulate(val, "AssistantID", &c.AssistantID)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &c.Instructions)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &c.Metadata)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &c.DeploymentName)
			delete(rawMsg, key)
		case "thread":
			err = unpopulate(val, "Thread", &c.Thread)
			delete(rawMsg, key)
		case "tools":
			c.Tools, err = unmarshalToolDefinitionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateRunBody.
func (c CreateRunBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additional_instructions", c.AdditionalInstructions)
	populate(objectMap, "assistant_id", c.AssistantID)
	populate(objectMap, "instructions", c.Instructions)
	populate(objectMap, "metadata", c.Metadata)
	populate(objectMap, "model", c.DeploymentName)
	populate(objectMap, "tools", c.Tools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateRunBody.
func (c *CreateRunBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additional_instructions":
			err = unpopulate(val, "AdditionalInstructions", &c.AdditionalInstructions)
			delete(rawMsg, key)
		case "assistant_id":
			err = unpopulate(val, "AssistantID", &c.AssistantID)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &c.Instructions)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &c.Metadata)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &c.DeploymentName)
			delete(rawMsg, key)
		case "tools":
			c.Tools, err = unmarshalToolDefinitionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileDeletionStatus.
func (f FileDeletionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleted", f.Deleted)
	populate(objectMap, "id", f.ID)
	objectMap["object"] = "file"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileDeletionStatus.
func (f *FileDeletionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleted":
			err = unpopulate(val, "Deleted", &f.Deleted)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &f.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileListResponse.
func (f FileListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", f.Data)
	objectMap["object"] = "list"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileListResponse.
func (f *FileListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &f.Data)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &f.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionDefinition.
func (f FunctionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "name", f.Name)
	populateAny(objectMap, "parameters", f.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionDefinition.
func (f *FunctionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &f.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionToolDefinition.
func (f FunctionToolDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", f.Function)
	objectMap["type"] = "function"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionToolDefinition.
func (f *FunctionToolDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &f.Function)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageContent.
func (m MessageContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = m.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageContent.
func (m *MessageContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageFile.
func (m MessageFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeUnix(objectMap, "created_at", m.CreatedAt)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "message_id", m.MessageID)
	objectMap["object"] = "thread.message.file"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageFile.
func (m *MessageFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &m.CreatedAt)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "message_id":
			err = unpopulate(val, "MessageID", &m.MessageID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &m.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageImageFileContent.
func (m MessageImageFileContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "image_file", m.ImageFile)
	objectMap["type"] = "image_file"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageImageFileContent.
func (m *MessageImageFileContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "image_file":
			err = unpopulate(val, "ImageFile", &m.ImageFile)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageImageFileDetails.
func (m MessageImageFileDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "file_id", m.FileID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageImageFileDetails.
func (m *MessageImageFileDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "file_id":
			err = unpopulate(val, "FileID", &m.FileID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageTextAnnotation.
func (m MessageTextAnnotation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end_index", m.EndIndex)
	populate(objectMap, "start_index", m.StartIndex)
	populate(objectMap, "text", m.Text)
	objectMap["type"] = m.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageTextAnnotation.
func (m *MessageTextAnnotation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end_index":
			err = unpopulate(val, "EndIndex", &m.EndIndex)
			delete(rawMsg, key)
		case "start_index":
			err = unpopulate(val, "StartIndex", &m.StartIndex)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &m.Text)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageTextContent.
func (m MessageTextContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "text", m.Text)
	objectMap["type"] = "text"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageTextContent.
func (m *MessageTextContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "text":
			err = unpopulate(val, "Text", &m.Text)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageTextDetails.
func (m MessageTextDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", m.Annotations)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageTextDetails.
func (m *MessageTextDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			m.Annotations, err = unmarshalMessageTextAnnotationClassificationArray(val)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageTextFileCitationAnnotation.
func (m MessageTextFileCitationAnnotation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end_index", m.EndIndex)
	populate(objectMap, "file_citation", m.FileCitation)
	populate(objectMap, "start_index", m.StartIndex)
	populate(objectMap, "text", m.Text)
	objectMap["type"] = "file_citation"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageTextFileCitationAnnotation.
func (m *MessageTextFileCitationAnnotation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end_index":
			err = unpopulate(val, "EndIndex", &m.EndIndex)
			delete(rawMsg, key)
		case "file_citation":
			err = unpopulate(val, "FileCitation", &m.FileCitation)
			delete(rawMsg, key)
		case "start_index":
			err = unpopulate(val, "StartIndex", &m.StartIndex)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &m.Text)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageTextFileCitationDetails.
func (m MessageTextFileCitationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "file_id", m.FileID)
	populate(objectMap, "quote", m.Quote)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageTextFileCitationDetails.
func (m *MessageTextFileCitationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "file_id":
			err = unpopulate(val, "FileID", &m.FileID)
			delete(rawMsg, key)
		case "quote":
			err = unpopulate(val, "Quote", &m.Quote)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageTextFilePathAnnotation.
func (m MessageTextFilePathAnnotation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end_index", m.EndIndex)
	populate(objectMap, "file_path", m.FilePath)
	populate(objectMap, "start_index", m.StartIndex)
	populate(objectMap, "text", m.Text)
	objectMap["type"] = "file_path"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageTextFilePathAnnotation.
func (m *MessageTextFilePathAnnotation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end_index":
			err = unpopulate(val, "EndIndex", &m.EndIndex)
			delete(rawMsg, key)
		case "file_path":
			err = unpopulate(val, "FilePath", &m.FilePath)
			delete(rawMsg, key)
		case "start_index":
			err = unpopulate(val, "StartIndex", &m.StartIndex)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &m.Text)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageTextFilePathDetails.
func (m MessageTextFilePathDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "file_id", m.FileID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageTextFilePathDetails.
func (m *MessageTextFilePathDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "file_id":
			err = unpopulate(val, "FileID", &m.FileID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenAIFile.
func (o OpenAIFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bytes", o.Bytes)
	populateTimeUnix(objectMap, "created_at", o.CreatedAt)
	populate(objectMap, "filename", o.Filename)
	populate(objectMap, "id", o.ID)
	objectMap["object"] = "file"
	populate(objectMap, "purpose", o.Purpose)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenAIFile.
func (o *OpenAIFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytes":
			err = unpopulate(val, "Bytes", &o.Bytes)
			delete(rawMsg, key)
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &o.CreatedAt)
			delete(rawMsg, key)
		case "filename":
			err = unpopulate(val, "Filename", &o.Filename)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &o.Object)
			delete(rawMsg, key)
		case "purpose":
			err = unpopulate(val, "Purpose", &o.Purpose)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMessageBody.
func (p UpdateMessageBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadata", p.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMessageBody.
func (p *UpdateMessageBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubmitToolOutputsToRunBody.
func (p SubmitToolOutputsToRunBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tool_outputs", p.ToolOutputs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubmitToolOutputsToRunBody.
func (p *SubmitToolOutputsToRunBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tool_outputs":
			err = unpopulate(val, "ToolOutputs", &p.ToolOutputs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageFilesPage.
func (p MessageFilesPage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "first_id", p.FirstID)
	populate(objectMap, "has_more", p.HasMore)
	populate(objectMap, "last_id", p.LastID)
	objectMap["object"] = "list"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageFilesPage.
func (p *MessageFilesPage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "first_id":
			err = unpopulate(val, "FirstID", &p.FirstID)
			delete(rawMsg, key)
		case "has_more":
			err = unpopulate(val, "HasMore", &p.HasMore)
			delete(rawMsg, key)
		case "last_id":
			err = unpopulate(val, "LastID", &p.LastID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &p.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantsPage.
func (p AssistantsPage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "first_id", p.FirstID)
	populate(objectMap, "has_more", p.HasMore)
	populate(objectMap, "last_id", p.LastID)
	objectMap["object"] = "list"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantsPage.
func (p *AssistantsPage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "first_id":
			err = unpopulate(val, "FirstID", &p.FirstID)
			delete(rawMsg, key)
		case "has_more":
			err = unpopulate(val, "HasMore", &p.HasMore)
			delete(rawMsg, key)
		case "last_id":
			err = unpopulate(val, "LastID", &p.LastID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &p.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateAssistantFileBody.
func (p CreateAssistantFileBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "file_id", p.FileID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateAssistantFileBody.
func (p *CreateAssistantFileBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "file_id":
			err = unpopulate(val, "FileID", &p.FileID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessagesPage.
func (p MessagesPage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "first_id", p.FirstID)
	populate(objectMap, "has_more", p.HasMore)
	populate(objectMap, "last_id", p.LastID)
	objectMap["object"] = "list"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessagesPage.
func (p *MessagesPage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "first_id":
			err = unpopulate(val, "FirstID", &p.FirstID)
			delete(rawMsg, key)
		case "has_more":
			err = unpopulate(val, "HasMore", &p.HasMore)
			delete(rawMsg, key)
		case "last_id":
			err = unpopulate(val, "LastID", &p.LastID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &p.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateRunBody.
func (p UpdateRunBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadata", p.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateRunBody.
func (p *UpdateRunBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateThreadBody.
func (p UpdateThreadBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadata", p.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateThreadBody.
func (p *UpdateThreadBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreadRunsPage.
func (p ThreadRunsPage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "first_id", p.FirstID)
	populate(objectMap, "has_more", p.HasMore)
	populate(objectMap, "last_id", p.LastID)
	objectMap["object"] = "list"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreadRunsPage.
func (p *ThreadRunsPage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "first_id":
			err = unpopulate(val, "FirstID", &p.FirstID)
			delete(rawMsg, key)
		case "has_more":
			err = unpopulate(val, "HasMore", &p.HasMore)
			delete(rawMsg, key)
		case "last_id":
			err = unpopulate(val, "LastID", &p.LastID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &p.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepsPage.
func (p RunStepsPage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "first_id", p.FirstID)
	populate(objectMap, "has_more", p.HasMore)
	populate(objectMap, "last_id", p.LastID)
	objectMap["object"] = "list"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepsPage.
func (p *RunStepsPage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "first_id":
			err = unpopulate(val, "FirstID", &p.FirstID)
			delete(rawMsg, key)
		case "has_more":
			err = unpopulate(val, "HasMore", &p.HasMore)
			delete(rawMsg, key)
		case "last_id":
			err = unpopulate(val, "LastID", &p.LastID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &p.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateMessageBody.
func (p CreateMessageBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", p.Content)
	populate(objectMap, "file_ids", p.FileIDs)
	populate(objectMap, "metadata", p.Metadata)
	populate(objectMap, "role", p.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateMessageBody.
func (p *CreateMessageBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &p.Content)
			delete(rawMsg, key)
		case "file_ids":
			err = unpopulate(val, "FileIDs", &p.FileIDs)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &p.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssistantFilesPage.
func (p AssistantFilesPage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "first_id", p.FirstID)
	populate(objectMap, "has_more", p.HasMore)
	populate(objectMap, "last_id", p.LastID)
	objectMap["object"] = "list"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssistantFilesPage.
func (p *AssistantFilesPage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "first_id":
			err = unpopulate(val, "FirstID", &p.FirstID)
			delete(rawMsg, key)
		case "has_more":
			err = unpopulate(val, "HasMore", &p.HasMore)
			delete(rawMsg, key)
		case "last_id":
			err = unpopulate(val, "LastID", &p.LastID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &p.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequiredAction.
func (r RequiredAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequiredAction.
func (r *RequiredAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequiredFunctionToolCall.
func (r RequiredFunctionToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", r.Function)
	populate(objectMap, "id", r.ID)
	objectMap["type"] = "function"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequiredFunctionToolCall.
func (r *RequiredFunctionToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &r.Function)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequiredFunctionToolCallDetails.
func (r RequiredFunctionToolCallDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", r.Arguments)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequiredFunctionToolCallDetails.
func (r *RequiredFunctionToolCallDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &r.Arguments)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequiredToolCall.
func (r RequiredToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequiredToolCall.
func (r *RequiredToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetrievalToolDefinition.
func (r RetrievalToolDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "retrieval"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetrievalToolDefinition.
func (r *RetrievalToolDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunError.
func (r RunError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "message", r.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunError.
func (r *RunError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStep.
func (r RunStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assistant_id", r.AssistantID)
	populateTimeUnix(objectMap, "cancelled_at", r.CancelledAt)
	populateTimeUnix(objectMap, "completed_at", r.CompletedAt)
	populateTimeUnix(objectMap, "created_at", r.CreatedAt)
	populateTimeUnix(objectMap, "expired_at", r.ExpiredAt)
	populateTimeUnix(objectMap, "failed_at", r.FailedAt)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "last_error", r.LastError)
	populate(objectMap, "metadata", r.Metadata)
	objectMap["object"] = "thread.run.step"
	populate(objectMap, "run_id", r.RunID)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "step_details", r.StepDetails)
	populate(objectMap, "thread_id", r.ThreadID)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStep.
func (r *RunStep) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assistant_id":
			err = unpopulate(val, "AssistantID", &r.AssistantID)
			delete(rawMsg, key)
		case "cancelled_at":
			err = unpopulateTimeUnix(val, "CancelledAt", &r.CancelledAt)
			delete(rawMsg, key)
		case "completed_at":
			err = unpopulateTimeUnix(val, "CompletedAt", &r.CompletedAt)
			delete(rawMsg, key)
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &r.CreatedAt)
			delete(rawMsg, key)
		case "expired_at":
			err = unpopulateTimeUnix(val, "ExpiredAt", &r.ExpiredAt)
			delete(rawMsg, key)
		case "failed_at":
			err = unpopulateTimeUnix(val, "FailedAt", &r.FailedAt)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "last_error":
			err = unpopulate(val, "LastError", &r.LastError)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &r.Metadata)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &r.Object)
			delete(rawMsg, key)
		case "run_id":
			err = unpopulate(val, "RunID", &r.RunID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "step_details":
			r.StepDetails, err = unmarshalRunStepDetailsClassification(val)
			delete(rawMsg, key)
		case "thread_id":
			err = unpopulate(val, "ThreadID", &r.ThreadID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepCodeInterpreterImageOutput.
func (r RunStepCodeInterpreterImageOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "image", r.Image)
	objectMap["type"] = "image"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepCodeInterpreterImageOutput.
func (r *RunStepCodeInterpreterImageOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "image":
			err = unpopulate(val, "Image", &r.Image)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepCodeInterpreterImageReference.
func (r RunStepCodeInterpreterImageReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "file_id", r.FileID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepCodeInterpreterImageReference.
func (r *RunStepCodeInterpreterImageReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "file_id":
			err = unpopulate(val, "FileID", &r.FileID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepCodeInterpreterLogOutput.
func (r RunStepCodeInterpreterLogOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logs", r.Logs)
	objectMap["type"] = "logs"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepCodeInterpreterLogOutput.
func (r *RunStepCodeInterpreterLogOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logs":
			err = unpopulate(val, "Logs", &r.Logs)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepCodeInterpreterToolCall.
func (r RunStepCodeInterpreterToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code_interpreter", r.CodeInterpreter)
	populate(objectMap, "id", r.ID)
	objectMap["type"] = "code_interpreter"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepCodeInterpreterToolCall.
func (r *RunStepCodeInterpreterToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code_interpreter":
			err = unpopulate(val, "CodeInterpreter", &r.CodeInterpreter)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepCodeInterpreterToolCallDetails.
func (r RunStepCodeInterpreterToolCallDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "input", r.Input)
	populate(objectMap, "outputs", r.Outputs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepCodeInterpreterToolCallDetails.
func (r *RunStepCodeInterpreterToolCallDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "input":
			err = unpopulate(val, "Input", &r.Input)
			delete(rawMsg, key)
		case "outputs":
			r.Outputs, err = unmarshalRunStepCodeInterpreterToolCallOutputClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepCodeInterpreterToolCallOutput.
func (r RunStepCodeInterpreterToolCallOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepCodeInterpreterToolCallOutput.
func (r *RunStepCodeInterpreterToolCallOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepDetails.
func (r RunStepDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepDetails.
func (r *RunStepDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepError.
func (r RunStepError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "message", r.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepError.
func (r *RunStepError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepFunctionToolCall.
func (r RunStepFunctionToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", r.Function)
	populate(objectMap, "id", r.ID)
	objectMap["type"] = "function"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepFunctionToolCall.
func (r *RunStepFunctionToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &r.Function)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepFunctionToolCallDetails.
func (r RunStepFunctionToolCallDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", r.Arguments)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "output", r.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepFunctionToolCallDetails.
func (r *RunStepFunctionToolCallDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &r.Arguments)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &r.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepLastError.
func (r RunStepLastError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "message", r.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepLastError.
func (r *RunStepLastError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepMessageCreationDetails.
func (r RunStepMessageCreationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message_creation", r.MessageCreation)
	objectMap["type"] = RunStepTypeMessageCreation
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepMessageCreationDetails.
func (r *RunStepMessageCreationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message_creation":
			err = unpopulate(val, "MessageCreation", &r.MessageCreation)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepMessageCreationReference.
func (r RunStepMessageCreationReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message_id", r.MessageID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepMessageCreationReference.
func (r *RunStepMessageCreationReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message_id":
			err = unpopulate(val, "MessageID", &r.MessageID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepRetrievalToolCall.
func (r RunStepRetrievalToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "retrieval", r.Retrieval)
	objectMap["type"] = "retrieval"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepRetrievalToolCall.
func (r *RunStepRetrievalToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "retrieval":
			err = unpopulate(val, "Retrieval", &r.Retrieval)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepToolCall.
func (r RunStepToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepToolCall.
func (r *RunStepToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunStepToolCallDetails.
func (r RunStepToolCallDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tool_calls", r.ToolCalls)
	objectMap["type"] = RunStepTypeToolCalls
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunStepToolCallDetails.
func (r *RunStepToolCallDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tool_calls":
			r.ToolCalls, err = unmarshalRunStepToolCallClassificationArray(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubmitToolOutputsAction.
func (s SubmitToolOutputsAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "submit_tool_outputs", s.SubmitToolOutputs)
	objectMap["type"] = "submit_tool_outputs"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubmitToolOutputsAction.
func (s *SubmitToolOutputsAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "submit_tool_outputs":
			err = unpopulate(val, "SubmitToolOutputs", &s.SubmitToolOutputs)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubmitToolOutputsDetails.
func (s SubmitToolOutputsDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tool_calls", s.ToolCalls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubmitToolOutputsDetails.
func (s *SubmitToolOutputsDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tool_calls":
			s.ToolCalls, err = unmarshalRequiredToolCallClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreadDeletionStatus.
func (t ThreadDeletionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleted", t.Deleted)
	populate(objectMap, "id", t.ID)
	objectMap["object"] = "thread.deleted"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreadDeletionStatus.
func (t *ThreadDeletionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleted":
			err = unpopulate(val, "Deleted", &t.Deleted)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &t.Object)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreadInitializationMessage.
func (t ThreadInitializationMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", t.Content)
	populate(objectMap, "file_ids", t.FileIDs)
	populate(objectMap, "metadata", t.Metadata)
	populate(objectMap, "role", t.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreadInitializationMessage.
func (t *ThreadInitializationMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &t.Content)
			delete(rawMsg, key)
		case "file_ids":
			err = unpopulate(val, "FileIDs", &t.FileIDs)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &t.Metadata)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &t.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreadMessage.
func (t ThreadMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assistant_id", t.AssistantID)
	populate(objectMap, "content", t.Content)
	populateTimeUnix(objectMap, "created_at", t.CreatedAt)
	populate(objectMap, "file_ids", t.FileIDs)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "metadata", t.Metadata)
	objectMap["object"] = "thread.message"
	populate(objectMap, "role", t.Role)
	populate(objectMap, "run_id", t.RunID)
	populate(objectMap, "thread_id", t.ThreadID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreadMessage.
func (t *ThreadMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assistant_id":
			err = unpopulate(val, "AssistantID", &t.AssistantID)
			delete(rawMsg, key)
		case "content":
			t.Content, err = unmarshalMessageContentClassificationArray(val)
			delete(rawMsg, key)
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &t.CreatedAt)
			delete(rawMsg, key)
		case "file_ids":
			err = unpopulate(val, "FileIDs", &t.FileIDs)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &t.Metadata)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &t.Object)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &t.Role)
			delete(rawMsg, key)
		case "run_id":
			err = unpopulate(val, "RunID", &t.RunID)
			delete(rawMsg, key)
		case "thread_id":
			err = unpopulate(val, "ThreadID", &t.ThreadID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreadRun.
func (t ThreadRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assistant_id", t.AssistantID)
	populateTimeUnix(objectMap, "cancelled_at", t.CancelledAt)
	populateTimeUnix(objectMap, "completed_at", t.CompletedAt)
	populateTimeUnix(objectMap, "created_at", t.CreatedAt)
	populateTimeUnix(objectMap, "expires_at", t.ExpiresAt)
	populateTimeUnix(objectMap, "failed_at", t.FailedAt)
	populate(objectMap, "file_ids", t.FileIDs)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "instructions", t.Instructions)
	populate(objectMap, "last_error", t.LastError)
	populate(objectMap, "metadata", t.Metadata)
	populate(objectMap, "model", t.DeploymentName)
	objectMap["object"] = "thread.run"
	populate(objectMap, "required_action", t.RequiredAction)
	populateTimeUnix(objectMap, "started_at", t.StartedAt)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "thread_id", t.ThreadID)
	populate(objectMap, "tools", t.Tools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreadRun.
func (t *ThreadRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assistant_id":
			err = unpopulate(val, "AssistantID", &t.AssistantID)
			delete(rawMsg, key)
		case "cancelled_at":
			err = unpopulateTimeUnix(val, "CancelledAt", &t.CancelledAt)
			delete(rawMsg, key)
		case "completed_at":
			err = unpopulateTimeUnix(val, "CompletedAt", &t.CompletedAt)
			delete(rawMsg, key)
		case "created_at":
			err = unpopulateTimeUnix(val, "CreatedAt", &t.CreatedAt)
			delete(rawMsg, key)
		case "expires_at":
			err = unpopulateTimeUnix(val, "ExpiresAt", &t.ExpiresAt)
			delete(rawMsg, key)
		case "failed_at":
			err = unpopulateTimeUnix(val, "FailedAt", &t.FailedAt)
			delete(rawMsg, key)
		case "file_ids":
			err = unpopulate(val, "FileIDs", &t.FileIDs)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &t.Instructions)
			delete(rawMsg, key)
		case "last_error":
			err = unpopulate(val, "LastError", &t.LastError)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &t.Metadata)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &t.DeploymentName)
			delete(rawMsg, key)
		case "object":
			err = unpopulate(val, "Object", &t.Object)
			delete(rawMsg, key)
		case "required_action":
			t.RequiredAction, err = unmarshalRequiredActionClassification(val)
			delete(rawMsg, key)
		case "started_at":
			err = unpopulateTimeUnix(val, "StartedAt", &t.StartedAt)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "thread_id":
			err = unpopulate(val, "ThreadID", &t.ThreadID)
			delete(rawMsg, key)
		case "tools":
			t.Tools, err = unmarshalToolDefinitionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreadRunLastError.
func (t ThreadRunLastError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", t.Code)
	populate(objectMap, "message", t.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreadRunLastError.
func (t *ThreadRunLastError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &t.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &t.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ToolDefinition.
func (t ToolDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = t.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ToolDefinition.
func (t *ToolDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ToolOutput.
func (t ToolOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "output", t.Output)
	populate(objectMap, "tool_call_id", t.ToolCallID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ToolOutput.
func (t *ToolOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "output":
			err = unpopulate(val, "Output", &t.Output)
			delete(rawMsg, key)
		case "tool_call_id":
			err = unpopulate(val, "ToolCallID", &t.ToolCallID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateAssistantBody.
func (u UpdateAssistantBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", u.Description)
	populate(objectMap, "file_ids", u.FileIDs)
	populate(objectMap, "instructions", u.Instructions)
	populate(objectMap, "metadata", u.Metadata)
	populate(objectMap, "model", u.DeploymentName)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "tools", u.Tools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateAssistantBody.
func (u *UpdateAssistantBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "file_ids":
			err = unpopulate(val, "FileIDs", &u.FileIDs)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &u.Instructions)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &u.Metadata)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &u.DeploymentName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "tools":
			u.Tools, err = unmarshalToolDefinitionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
