//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armresources

import "time"

// Alias - The alias type.
type Alias struct {
	// The default path for an alias.
	DefaultPath *string `json:"defaultPath,omitempty"`

	// The default pattern for an alias.
	DefaultPattern *AliasPattern `json:"defaultPattern,omitempty"`

	// The alias name.
	Name *string `json:"name,omitempty"`

	// The paths for an alias.
	Paths []*AliasPath `json:"paths,omitempty"`

	// The type of the alias.
	Type *AliasType `json:"type,omitempty"`
}

// AliasPath - The type of the paths for alias.
type AliasPath struct {
	// The API versions.
	APIVersions []*string `json:"apiVersions,omitempty"`

	// The path of an alias.
	Path *string `json:"path,omitempty"`

	// The pattern for an alias path.
	Pattern *AliasPattern `json:"pattern,omitempty"`
}

// AliasPattern - The type of the pattern for an alias path.
type AliasPattern struct {
	// The alias pattern phrase.
	Phrase *string `json:"phrase,omitempty"`

	// The type of alias pattern
	Type *AliasPatternType `json:"type,omitempty"`

	// The alias pattern variable.
	Variable *string `json:"variable,omitempty"`
}

// BasicDependency - Deployment dependency information.
type BasicDependency struct {
	// The ID of the dependency.
	ID *string `json:"id,omitempty"`

	// The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`

	// The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// ClientBeginCreateOrUpdateByIDOptions contains the optional parameters for the Client.BeginCreateOrUpdateByID method.
type ClientBeginCreateOrUpdateByIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginCreateOrUpdateOptions contains the optional parameters for the Client.BeginCreateOrUpdate method.
type ClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginDeleteByIDOptions contains the optional parameters for the Client.BeginDeleteByID method.
type ClientBeginDeleteByIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginDeleteOptions contains the optional parameters for the Client.BeginDelete method.
type ClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginMoveResourcesOptions contains the optional parameters for the Client.BeginMoveResources method.
type ClientBeginMoveResourcesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginUpdateByIDOptions contains the optional parameters for the Client.BeginUpdateByID method.
type ClientBeginUpdateByIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginUpdateOptions contains the optional parameters for the Client.BeginUpdate method.
type ClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginValidateMoveResourcesOptions contains the optional parameters for the Client.BeginValidateMoveResources method.
type ClientBeginValidateMoveResourcesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientCheckExistenceByIDOptions contains the optional parameters for the Client.CheckExistenceByID method.
type ClientCheckExistenceByIDOptions struct {
	// placeholder for future optional parameters
}

// ClientCheckExistenceOptions contains the optional parameters for the Client.CheckExistence method.
type ClientCheckExistenceOptions struct {
	// placeholder for future optional parameters
}

// ClientGetByIDOptions contains the optional parameters for the Client.GetByID method.
type ClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListByResourceGroupOptions contains the optional parameters for the Client.NewListByResourceGroupPager method.
type ClientListByResourceGroupOptions struct {
	// Comma-separated list of additional properties to be included in the response. Valid values include createdTime, changedTime
	// and provisioningState. For example, $expand=createdTime,changedTime.
	Expand *string
	// The filter to apply on the operation.
	// The properties you can use for eq (equals) or ne (not equals) are: location, resourceType, name, resourceGroup, identity,
	// identity/principalId, plan, plan/publisher, plan/product, plan/name,
	// plan/version, and plan/promotionCode.
	// For example, to filter by a resource type, use: $filter=resourceType eq 'Microsoft.Network/virtualNetworks'
	// You can use substringof(value, property) in the filter. The properties you can use for substring are: name and resourceGroup.
	// For example, to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo', name)
	// You can link more than one substringof together by adding and/or operators.
	// You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1'
	// and tagValue eq 'Value1'. When you filter by a tag name and value, the tags for
	// each resource are not returned in the results.
	// You can use some properties together when filtering. The combinations you can use are: substringof and/or resourceType,
	// plan and plan/publisher and plan/name, identity and identity/principalId.
	Filter *string
	// The number of results to return. If null is passed, returns all resources.
	Top *int32
}

// ClientListOptions contains the optional parameters for the Client.NewListPager method.
type ClientListOptions struct {
	// Comma-separated list of additional properties to be included in the response. Valid values include createdTime, changedTime
	// and provisioningState. For example, $expand=createdTime,changedTime.
	Expand *string
	// The filter to apply on the operation.
	// The properties you can use for eq (equals) or ne (not equals) are: location, resourceType, name, resourceGroup, identity,
	// identity/principalId, plan, plan/publisher, plan/product, plan/name,
	// plan/version, and plan/promotionCode.
	// For example, to filter by a resource type, use: $filter=resourceType eq 'Microsoft.Network/virtualNetworks'
	// You can use substringof(value, property) in the filter. The properties you can use for substring are: name and resourceGroup.
	// For example, to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo', name)
	// You can link more than one substringof together by adding and/or operators.
	// You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1'
	// and tagValue eq 'Value1'. When you filter by a tag name and value, the tags for
	// each resource are not returned in the results.
	// You can use some properties together when filtering. The combinations you can use are: substringof and/or resourceType,
	// plan and plan/publisher and plan/name, identity and identity/principalId.
	Filter *string
	// The number of results to return. If null is passed, returns all resources.
	Top *int32
}

// DebugSetting - The debug setting.
type DebugSetting struct {
	// Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent,
	// or both requestContent and responseContent separated by a comma. The default is
	// none. When setting this value, carefully consider the type of information you are passing in during deployment. By logging
	// information about the request or response, you could potentially expose
	// sensitive data that is retrieved through the deployment operations.
	DetailLevel *string `json:"detailLevel,omitempty"`
}

// Dependency - Deployment dependency information.
type Dependency struct {
	// The list of dependencies.
	DependsOn []*BasicDependency `json:"dependsOn,omitempty"`

	// The ID of the dependency.
	ID *string `json:"id,omitempty"`

	// The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`

	// The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// Deployment operation parameters.
type Deployment struct {
	// REQUIRED; The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`

	// The location to store the deployment data.
	Location *string `json:"location,omitempty"`

	// Deployment tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// DeploymentExportResult - The deployment export result.
type DeploymentExportResult struct {
	// The template content.
	Template any `json:"template,omitempty"`
}

// DeploymentExtended - Deployment information.
type DeploymentExtended struct {
	// the location of the deployment.
	Location *string `json:"location,omitempty"`

	// Deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`

	// Deployment tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the deployment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the deployment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the deployment.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeploymentExtendedFilter - Deployment filter.
type DeploymentExtendedFilter struct {
	// The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// DeploymentListResult - List of deployments.
type DeploymentListResult struct {
	// An array of deployments.
	Value []*DeploymentExtended `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeploymentOperation - Deployment operation information.
type DeploymentOperation struct {
	// Deployment properties.
	Properties *DeploymentOperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Full deployment operation ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Deployment operation ID.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`
}

// DeploymentOperationProperties - Deployment operation properties.
type DeploymentOperationProperties struct {
	// READ-ONLY; The duration of the operation.
	Duration *string `json:"duration,omitempty" azure:"ro"`

	// READ-ONLY; The name of the current provisioning operation.
	ProvisioningOperation *ProvisioningOperation `json:"provisioningOperation,omitempty" azure:"ro"`

	// READ-ONLY; The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The HTTP request message.
	Request *HTTPMessage `json:"request,omitempty" azure:"ro"`

	// READ-ONLY; The HTTP response message.
	Response *HTTPMessage `json:"response,omitempty" azure:"ro"`

	// READ-ONLY; Deployment operation service request id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty" azure:"ro"`

	// READ-ONLY; Operation status code.
	StatusCode *string `json:"statusCode,omitempty" azure:"ro"`

	// READ-ONLY; Operation status message.
	StatusMessage any `json:"statusMessage,omitempty" azure:"ro"`

	// READ-ONLY; The target resource.
	TargetResource *TargetResource `json:"targetResource,omitempty" azure:"ro"`

	// READ-ONLY; The date and time of the operation.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`
}

// DeploymentOperationsClientGetAtManagementGroupScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtManagementGroupScope
// method.
type DeploymentOperationsClientGetAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetAtScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtScope
// method.
type DeploymentOperationsClientGetAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetAtSubscriptionScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtSubscriptionScope
// method.
type DeploymentOperationsClientGetAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetAtTenantScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtTenantScope
// method.
type DeploymentOperationsClientGetAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetOptions contains the optional parameters for the DeploymentOperationsClient.Get method.
type DeploymentOperationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientListAtManagementGroupScopeOptions contains the optional parameters for the DeploymentOperationsClient.NewListAtManagementGroupScopePager
// method.
type DeploymentOperationsClientListAtManagementGroupScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListAtScopeOptions contains the optional parameters for the DeploymentOperationsClient.NewListAtScopePager
// method.
type DeploymentOperationsClientListAtScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListAtSubscriptionScopeOptions contains the optional parameters for the DeploymentOperationsClient.NewListAtSubscriptionScopePager
// method.
type DeploymentOperationsClientListAtSubscriptionScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListAtTenantScopeOptions contains the optional parameters for the DeploymentOperationsClient.NewListAtTenantScopePager
// method.
type DeploymentOperationsClientListAtTenantScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListOptions contains the optional parameters for the DeploymentOperationsClient.NewListPager
// method.
type DeploymentOperationsClientListOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsListResult - List of deployment operations.
type DeploymentOperationsListResult struct {
	// An array of deployment operations.
	Value []*DeploymentOperation `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeploymentProperties - Deployment properties.
type DeploymentProperties struct {
	// REQUIRED; The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode,
	// resources are deployed without deleting existing resources that are not included in
	// the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included
	// in the template are deleted. Be careful when using Complete mode as you may
	// unintentionally delete resources.
	Mode *DeploymentMode `json:"mode,omitempty"`

	// The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`

	// The deployment on error behavior.
	OnErrorDeployment *OnErrorDeployment `json:"onErrorDeployment,omitempty"`

	// Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide
	// the parameter values directly in the request rather than link to an existing
	// parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or
	// a well formed JSON string.
	Parameters any `json:"parameters,omitempty"`

	// The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink
	// property or the parameters property, but not both.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`

	// The template content. You use this element when you want to pass the template syntax directly in the request rather than
	// link to an existing template. It can be a JObject or well-formed JSON string.
	// Use either the templateLink property or the template property, but not both.
	Template any `json:"template,omitempty"`

	// The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
}

// DeploymentPropertiesExtended - Deployment properties with additional details.
type DeploymentPropertiesExtended struct {
	// READ-ONLY; The correlation ID of the deployment.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty" azure:"ro"`

	// READ-ONLY; The list of deployment dependencies.
	Dependencies []*Dependency `json:"dependencies,omitempty" azure:"ro"`

	// READ-ONLY; The duration of the template deployment.
	Duration *string `json:"duration,omitempty" azure:"ro"`

	// READ-ONLY; The deployment error.
	Error *ErrorResponse `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The deployment mode. Possible values are Incremental and Complete.
	Mode *DeploymentMode `json:"mode,omitempty" azure:"ro"`

	// READ-ONLY; The deployment on error behavior.
	OnErrorDeployment *OnErrorDeploymentExtended `json:"onErrorDeployment,omitempty" azure:"ro"`

	// READ-ONLY; Array of provisioned resources.
	OutputResources []*ResourceReference `json:"outputResources,omitempty" azure:"ro"`

	// READ-ONLY; Key/value pairs that represent deployment output.
	Outputs any `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Deployment parameters.
	Parameters any `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The URI referencing the parameters.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of resource providers needed for the deployment.
	Providers []*Provider `json:"providers,omitempty" azure:"ro"`

	// READ-ONLY; The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hash produced for the template.
	TemplateHash *string `json:"templateHash,omitempty" azure:"ro"`

	// READ-ONLY; The URI referencing the template.
	TemplateLink *TemplateLink `json:"templateLink,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of the template deployment.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; Array of validated resources.
	ValidatedResources []*ResourceReference `json:"validatedResources,omitempty" azure:"ro"`
}

// DeploymentValidateResult - Information from validate template deployment response.
type DeploymentValidateResult struct {
	// The template deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`

	// READ-ONLY; The deployment validation error.
	Error *ErrorResponse `json:"error,omitempty" azure:"ro"`
}

// DeploymentWhatIf - Deployment What-if operation parameters.
type DeploymentWhatIf struct {
	// REQUIRED; The deployment properties.
	Properties *DeploymentWhatIfProperties `json:"properties,omitempty"`

	// The location to store the deployment data.
	Location *string `json:"location,omitempty"`
}

// DeploymentWhatIfProperties - Deployment What-if properties.
type DeploymentWhatIfProperties struct {
	// REQUIRED; The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode,
	// resources are deployed without deleting existing resources that are not included in
	// the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included
	// in the template are deleted. Be careful when using Complete mode as you may
	// unintentionally delete resources.
	Mode *DeploymentMode `json:"mode,omitempty"`

	// The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`

	// The deployment on error behavior.
	OnErrorDeployment *OnErrorDeployment `json:"onErrorDeployment,omitempty"`

	// Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide
	// the parameter values directly in the request rather than link to an existing
	// parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or
	// a well formed JSON string.
	Parameters any `json:"parameters,omitempty"`

	// The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink
	// property or the parameters property, but not both.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`

	// The template content. You use this element when you want to pass the template syntax directly in the request rather than
	// link to an existing template. It can be a JObject or well-formed JSON string.
	// Use either the templateLink property or the template property, but not both.
	Template any `json:"template,omitempty"`

	// The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`

	// Optional What-If operation settings.
	WhatIfSettings *DeploymentWhatIfSettings `json:"whatIfSettings,omitempty"`
}

// DeploymentWhatIfSettings - Deployment What-If operation settings.
type DeploymentWhatIfSettings struct {
	// The format of the What-If results
	ResultFormat *WhatIfResultFormat `json:"resultFormat,omitempty"`
}

// DeploymentsClientBeginCreateOrUpdateAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtManagementGroupScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtManagementGroupScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginCreateOrUpdateAtScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginCreateOrUpdateAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtSubscriptionScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtSubscriptionScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginCreateOrUpdateAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtTenantScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtTenantScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginCreateOrUpdateOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdate
// method.
type DeploymentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDeleteAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtManagementGroupScope
// method.
type DeploymentsClientBeginDeleteAtManagementGroupScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDeleteAtScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtScope
// method.
type DeploymentsClientBeginDeleteAtScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDeleteAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtSubscriptionScope
// method.
type DeploymentsClientBeginDeleteAtSubscriptionScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDeleteAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtTenantScope
// method.
type DeploymentsClientBeginDeleteAtTenantScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDeleteOptions contains the optional parameters for the DeploymentsClient.BeginDelete method.
type DeploymentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginValidateAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtManagementGroupScope
// method.
type DeploymentsClientBeginValidateAtManagementGroupScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginValidateAtScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtScope
// method.
type DeploymentsClientBeginValidateAtScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginValidateAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtSubscriptionScope
// method.
type DeploymentsClientBeginValidateAtSubscriptionScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginValidateAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtTenantScope
// method.
type DeploymentsClientBeginValidateAtTenantScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginValidateOptions contains the optional parameters for the DeploymentsClient.BeginValidate method.
type DeploymentsClientBeginValidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginWhatIfAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginWhatIfAtManagementGroupScope
// method.
type DeploymentsClientBeginWhatIfAtManagementGroupScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginWhatIfAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginWhatIfAtSubscriptionScope
// method.
type DeploymentsClientBeginWhatIfAtSubscriptionScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginWhatIfAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginWhatIfAtTenantScope
// method.
type DeploymentsClientBeginWhatIfAtTenantScopeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginWhatIfOptions contains the optional parameters for the DeploymentsClient.BeginWhatIf method.
type DeploymentsClientBeginWhatIfOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientCalculateTemplateHashOptions contains the optional parameters for the DeploymentsClient.CalculateTemplateHash
// method.
type DeploymentsClientCalculateTemplateHashOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtManagementGroupScope
// method.
type DeploymentsClientCancelAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtScope method.
type DeploymentsClientCancelAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtSubscriptionScope
// method.
type DeploymentsClientCancelAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtTenantScope
// method.
type DeploymentsClientCancelAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelOptions contains the optional parameters for the DeploymentsClient.Cancel method.
type DeploymentsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtManagementGroupScope
// method.
type DeploymentsClientCheckExistenceAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtScope
// method.
type DeploymentsClientCheckExistenceAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtSubscriptionScope
// method.
type DeploymentsClientCheckExistenceAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtTenantScope
// method.
type DeploymentsClientCheckExistenceAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceOptions contains the optional parameters for the DeploymentsClient.CheckExistence method.
type DeploymentsClientCheckExistenceOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtManagementGroupScope
// method.
type DeploymentsClientExportTemplateAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtScope
// method.
type DeploymentsClientExportTemplateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtSubscriptionScope
// method.
type DeploymentsClientExportTemplateAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtTenantScope
// method.
type DeploymentsClientExportTemplateAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateOptions contains the optional parameters for the DeploymentsClient.ExportTemplate method.
type DeploymentsClientExportTemplateOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.GetAtManagementGroupScope
// method.
type DeploymentsClientGetAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtScopeOptions contains the optional parameters for the DeploymentsClient.GetAtScope method.
type DeploymentsClientGetAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.GetAtSubscriptionScope
// method.
type DeploymentsClientGetAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.GetAtTenantScope method.
type DeploymentsClientGetAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetOptions contains the optional parameters for the DeploymentsClient.Get method.
type DeploymentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientListAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.NewListAtManagementGroupScopePager
// method.
type DeploymentsClientListAtManagementGroupScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListAtScopeOptions contains the optional parameters for the DeploymentsClient.NewListAtScopePager method.
type DeploymentsClientListAtScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.NewListAtSubscriptionScopePager
// method.
type DeploymentsClientListAtSubscriptionScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.NewListAtTenantScopePager
// method.
type DeploymentsClientListAtTenantScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListByResourceGroupOptions contains the optional parameters for the DeploymentsClient.NewListByResourceGroupPager
// method.
type DeploymentsClientListByResourceGroupOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ExportTemplateRequest - Export resource group template request parameters.
type ExportTemplateRequest struct {
	// The export template options. A CSV-formatted list containing zero or more of the following: 'IncludeParameterDefaultValue',
	// 'IncludeComments', 'SkipResourceNameParameterization',
	// 'SkipAllParameterization'
	Options *string `json:"options,omitempty"`

	// The IDs of the resources to filter the export by. To export all resources, supply an array with single entry '*'.
	Resources []*string `json:"resources,omitempty"`
}

// GenericResource - Resource information.
type GenericResource struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`

	// The resource properties.
	Properties any `json:"properties,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GenericResourceExpanded - Resource information.
type GenericResourceExpanded struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`

	// The resource properties.
	Properties any `json:"properties,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The changed time of the resource. This is only present if requested via the $expand query parameter.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The created time of the resource. This is only present if requested via the $expand query parameter.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource. This is only present if requested via the $expand query parameter.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GenericResourceFilter - Resource filter.
type GenericResourceFilter struct {
	// The resource type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The tag name.
	Tagname *string `json:"tagname,omitempty"`

	// The tag value.
	Tagvalue *string `json:"tagvalue,omitempty"`
}

// HTTPMessage - HTTP message.
type HTTPMessage struct {
	// HTTP message content.
	Content any `json:"content,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*IdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

type IdentityUserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// MoveInfo - Parameters of move resources.
type MoveInfo struct {
	// The IDs of the resources.
	Resources []*string `json:"resources,omitempty"`

	// The target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// OnErrorDeployment - Deployment on error behavior.
type OnErrorDeployment struct {
	// The deployment to be used on error case.
	DeploymentName *string `json:"deploymentName,omitempty"`

	// The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
	Type *OnErrorDeploymentType `json:"type,omitempty"`
}

// OnErrorDeploymentExtended - Deployment on error behavior with additional details.
type OnErrorDeploymentExtended struct {
	// The deployment to be used on error case.
	DeploymentName *string `json:"deploymentName,omitempty"`

	// The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
	Type *OnErrorDeploymentType `json:"type,omitempty"`

	// READ-ONLY; The state of the provisioning for the on error deployment.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// Operation - Microsoft.Resources operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Resources
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Resources operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Microsoft.Resources operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ParametersLink - Entity representing the reference to the deployment parameters.
type ParametersLink struct {
	// REQUIRED; The URI of the parameters file.
	URI *string `json:"uri,omitempty"`

	// If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// Plan for the resource.
type Plan struct {
	// The plan ID.
	Name *string `json:"name,omitempty"`

	// The offer ID.
	Product *string `json:"product,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// The plan's version.
	Version *string `json:"version,omitempty"`
}

// Provider - Resource provider information.
type Provider struct {
	// The namespace of the resource provider.
	Namespace *string `json:"namespace,omitempty"`

	// READ-ONLY; The provider ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The registration policy of the resource provider.
	RegistrationPolicy *string `json:"registrationPolicy,omitempty" azure:"ro"`

	// READ-ONLY; The registration state of the resource provider.
	RegistrationState *string `json:"registrationState,omitempty" azure:"ro"`

	// READ-ONLY; The collection of provider resource types.
	ResourceTypes []*ProviderResourceType `json:"resourceTypes,omitempty" azure:"ro"`
}

// ProviderListResult - List of resource providers.
type ProviderListResult struct {
	// An array of resource providers.
	Value []*Provider `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProviderResourceType - Resource type managed by the resource provider.
type ProviderResourceType struct {
	// The API version.
	APIVersions []*string `json:"apiVersions,omitempty"`

	// The aliases that are supported by this resource type.
	Aliases []*Alias `json:"aliases,omitempty"`

	// The additional capabilities offered by this resource type.
	Capabilities *string `json:"capabilities,omitempty"`

	// The collection of locations where this resource type can be created.
	Locations []*string `json:"locations,omitempty"`

	// The properties.
	Properties map[string]*string `json:"properties,omitempty"`

	// The resource type.
	ResourceType *string        `json:"resourceType,omitempty"`
	ZoneMappings []*ZoneMapping `json:"zoneMappings,omitempty"`
}

// ProvidersClientGetAtTenantScopeOptions contains the optional parameters for the ProvidersClient.GetAtTenantScope method.
type ProvidersClientGetAtTenantScopeOptions struct {
	// The $expand query parameter. For example, to include property aliases in response, use $expand=resourceTypes/aliases.
	Expand *string
}

// ProvidersClientGetOptions contains the optional parameters for the ProvidersClient.Get method.
type ProvidersClientGetOptions struct {
	// The $expand query parameter. For example, to include property aliases in response, use $expand=resourceTypes/aliases.
	Expand *string
}

// ProvidersClientListAtTenantScopeOptions contains the optional parameters for the ProvidersClient.NewListAtTenantScopePager
// method.
type ProvidersClientListAtTenantScopeOptions struct {
	// The properties to include in the results. For example, use &$expand=metadata in the query string to retrieve resource provider
	// metadata. To include property aliases in response, use
	// $expand=resourceTypes/aliases.
	Expand *string
	// The number of results to return. If null is passed returns all providers.
	Top *int32
}

// ProvidersClientListOptions contains the optional parameters for the ProvidersClient.NewListPager method.
type ProvidersClientListOptions struct {
	// The properties to include in the results. For example, use &$expand=metadata in the query string to retrieve resource provider
	// metadata. To include property aliases in response, use
	// $expand=resourceTypes/aliases.
	Expand *string
	// The number of results to return. If null is passed returns all deployments.
	Top *int32
}

// ProvidersClientRegisterOptions contains the optional parameters for the ProvidersClient.Register method.
type ProvidersClientRegisterOptions struct {
	// placeholder for future optional parameters
}

// ProvidersClientUnregisterOptions contains the optional parameters for the ProvidersClient.Unregister method.
type ProvidersClientUnregisterOptions struct {
	// placeholder for future optional parameters
}

// Resource - Specified resource.
type Resource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceGroup - Resource group information.
type ResourceGroup struct {
	// REQUIRED; The location of the resource group. It cannot be changed after the resource group has been created. It must be
	// one of the supported Azure locations.
	Location *string `json:"location,omitempty"`

	// The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The resource group properties.
	Properties *ResourceGroupProperties `json:"properties,omitempty"`

	// The tags attached to the resource group.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the resource group.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource group.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource group.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceGroupExportResult - Resource group export result.
type ResourceGroupExportResult struct {
	// The template export error.
	Error *ErrorResponse `json:"error,omitempty"`

	// The template content.
	Template any `json:"template,omitempty"`
}

// ResourceGroupFilter - Resource group filter.
type ResourceGroupFilter struct {
	// The tag name.
	TagName *string `json:"tagName,omitempty"`

	// The tag value.
	TagValue *string `json:"tagValue,omitempty"`
}

// ResourceGroupListResult - List of resource groups.
type ResourceGroupListResult struct {
	// An array of resource groups.
	Value []*ResourceGroup `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceGroupPatchable - Resource group information.
type ResourceGroupPatchable struct {
	// The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The name of the resource group.
	Name *string `json:"name,omitempty"`

	// The resource group properties.
	Properties *ResourceGroupProperties `json:"properties,omitempty"`

	// The tags attached to the resource group.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ResourceGroupProperties - The resource group properties.
type ResourceGroupProperties struct {
	// READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ResourceGroupsClientBeginDeleteOptions contains the optional parameters for the ResourceGroupsClient.BeginDelete method.
type ResourceGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ResourceGroupsClientBeginExportTemplateOptions contains the optional parameters for the ResourceGroupsClient.BeginExportTemplate
// method.
type ResourceGroupsClientBeginExportTemplateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ResourceGroupsClientCheckExistenceOptions contains the optional parameters for the ResourceGroupsClient.CheckExistence
// method.
type ResourceGroupsClientCheckExistenceOptions struct {
	// placeholder for future optional parameters
}

// ResourceGroupsClientCreateOrUpdateOptions contains the optional parameters for the ResourceGroupsClient.CreateOrUpdate
// method.
type ResourceGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ResourceGroupsClientGetOptions contains the optional parameters for the ResourceGroupsClient.Get method.
type ResourceGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourceGroupsClientListOptions contains the optional parameters for the ResourceGroupsClient.NewListPager method.
type ResourceGroupsClientListOptions struct {
	// The filter to apply on the operation.
	// You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1'
	// and tagValue eq 'Value1'
	Filter *string
	// The number of results to return. If null is passed, returns all resource groups.
	Top *int32
}

// ResourceGroupsClientUpdateOptions contains the optional parameters for the ResourceGroupsClient.Update method.
type ResourceGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ResourceListResult - List of resource groups.
type ResourceListResult struct {
	// An array of resources.
	Value []*GenericResourceExpanded `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceProviderOperationDisplayProperties - Resource provider operation's display properties.
type ResourceProviderOperationDisplayProperties struct {
	// Operation description.
	Description *string `json:"description,omitempty"`

	// Resource provider operation.
	Operation *string `json:"operation,omitempty"`

	// Operation provider.
	Provider *string `json:"provider,omitempty"`

	// Operation description.
	Publisher *string `json:"publisher,omitempty"`

	// Operation resource.
	Resource *string `json:"resource,omitempty"`
}

// ResourceReference - The resource Id model.
type ResourceReference struct {
	// READ-ONLY; The fully qualified resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SKU for the resource.
type SKU struct {
	// The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// The SKU family.
	Family *string `json:"family,omitempty"`

	// The SKU model.
	Model *string `json:"model,omitempty"`

	// The SKU name.
	Name *string `json:"name,omitempty"`

	// The SKU size.
	Size *string `json:"size,omitempty"`

	// The SKU tier.
	Tier *string `json:"tier,omitempty"`
}

// ScopedDeployment - Deployment operation parameters.
type ScopedDeployment struct {
	// REQUIRED; The location to store the deployment data.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`

	// Deployment tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ScopedDeploymentWhatIf - Deployment What-if operation parameters.
type ScopedDeploymentWhatIf struct {
	// REQUIRED; The location to store the deployment data.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The deployment properties.
	Properties *DeploymentWhatIfProperties `json:"properties,omitempty"`
}

// SubResource - Sub-resource.
type SubResource struct {
	// Resource ID
	ID *string `json:"id,omitempty"`
}

// TagCount - Tag count.
type TagCount struct {
	// Type of count.
	Type *string `json:"type,omitempty"`

	// Value of count.
	Value *int32 `json:"value,omitempty"`
}

// TagDetails - Tag details.
type TagDetails struct {
	// The total number of resources that use the resource tag. When a tag is initially created and has no associated resources,
	// the value is 0.
	Count *TagCount `json:"count,omitempty"`

	// The tag name.
	TagName *string `json:"tagName,omitempty"`

	// The list of tag values.
	Values []*TagValue `json:"values,omitempty"`

	// READ-ONLY; The tag name ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// TagValue - Tag information.
type TagValue struct {
	// The tag value count.
	Count *TagCount `json:"count,omitempty"`

	// The tag value.
	TagValue *string `json:"tagValue,omitempty"`

	// READ-ONLY; The tag value ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// Tags - A dictionary of name and value pairs.
type Tags struct {
	// Dictionary of
	Tags map[string]*string `json:"tags,omitempty"`
}

// TagsClientCreateOrUpdateAtScopeOptions contains the optional parameters for the TagsClient.CreateOrUpdateAtScope method.
type TagsClientCreateOrUpdateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsClientCreateOrUpdateOptions contains the optional parameters for the TagsClient.CreateOrUpdate method.
type TagsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TagsClientCreateOrUpdateValueOptions contains the optional parameters for the TagsClient.CreateOrUpdateValue method.
type TagsClientCreateOrUpdateValueOptions struct {
	// placeholder for future optional parameters
}

// TagsClientDeleteAtScopeOptions contains the optional parameters for the TagsClient.DeleteAtScope method.
type TagsClientDeleteAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsClientDeleteOptions contains the optional parameters for the TagsClient.Delete method.
type TagsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TagsClientDeleteValueOptions contains the optional parameters for the TagsClient.DeleteValue method.
type TagsClientDeleteValueOptions struct {
	// placeholder for future optional parameters
}

// TagsClientGetAtScopeOptions contains the optional parameters for the TagsClient.GetAtScope method.
type TagsClientGetAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsClientListOptions contains the optional parameters for the TagsClient.NewListPager method.
type TagsClientListOptions struct {
	// placeholder for future optional parameters
}

// TagsClientUpdateAtScopeOptions contains the optional parameters for the TagsClient.UpdateAtScope method.
type TagsClientUpdateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsListResult - List of subscription tags.
type TagsListResult struct {
	// An array of tags.
	Value []*TagDetails `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TagsPatchResource - Wrapper resource for tags patch API request only.
type TagsPatchResource struct {
	// The operation type for the patch API.
	Operation *TagsPatchOperation `json:"operation,omitempty"`

	// The set of tags.
	Properties *Tags `json:"properties,omitempty"`
}

// TagsResource - Wrapper resource for tags API requests and responses.
type TagsResource struct {
	// REQUIRED; The set of tags.
	Properties *Tags `json:"properties,omitempty"`

	// READ-ONLY; The ID of the tags wrapper resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the tags wrapper resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the tags wrapper resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TargetResource - Target resource.
type TargetResource struct {
	// The ID of the resource.
	ID *string `json:"id,omitempty"`

	// The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`

	// The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
}

// TemplateHashResult - Result of the request to calculate template hash. It contains a string of minified template and its
// hash.
type TemplateHashResult struct {
	// The minified template string.
	MinifiedTemplate *string `json:"minifiedTemplate,omitempty"`

	// The template hash.
	TemplateHash *string `json:"templateHash,omitempty"`
}

// TemplateLink - Entity representing the reference to the template.
type TemplateLink struct {
	// REQUIRED; The URI of the template to deploy.
	URI *string `json:"uri,omitempty"`

	// If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// WhatIfChange - Information about a single resource change predicted by What-If operation.
type WhatIfChange struct {
	// REQUIRED; Type of change that will be made to the resource when the deployment is executed.
	ChangeType *ChangeType `json:"changeType,omitempty"`

	// REQUIRED; Resource ID
	ResourceID *string `json:"resourceId,omitempty"`

	// The predicted snapshot of the resource after the deployment is executed.
	After any `json:"after,omitempty"`

	// The snapshot of the resource before the deployment is executed.
	Before any `json:"before,omitempty"`

	// The predicted changes to resource properties.
	Delta []*WhatIfPropertyChange `json:"delta,omitempty"`
}

// WhatIfOperationProperties - Deployment operation properties.
type WhatIfOperationProperties struct {
	// List of resource changes predicted by What-If operation.
	Changes []*WhatIfChange `json:"changes,omitempty"`
}

// WhatIfOperationResult - Result of the What-If operation. Contains a list of predicted changes and a URL link to get to
// the next set of results.
type WhatIfOperationResult struct {
	// Error when What-If operation fails.
	Error *ErrorResponse `json:"error,omitempty"`

	// What-If operation properties.
	Properties *WhatIfOperationProperties `json:"properties,omitempty"`

	// Status of the What-If operation.
	Status *string `json:"status,omitempty"`
}

// WhatIfPropertyChange - The predicted change to the resource property.
type WhatIfPropertyChange struct {
	// REQUIRED; The path of the property.
	Path *string `json:"path,omitempty"`

	// REQUIRED; The type of property change.
	PropertyChangeType *PropertyChangeType `json:"propertyChangeType,omitempty"`

	// The value of the property after the deployment is executed.
	After any `json:"after,omitempty"`

	// The value of the property before the deployment is executed.
	Before any `json:"before,omitempty"`

	// Nested property changes.
	Children []*WhatIfPropertyChange `json:"children,omitempty"`
}

type ZoneMapping struct {
	// The location of the zone mapping.
	Location *string   `json:"location,omitempty"`
	Zones    []*string `json:"zones,omitempty"`
}
