//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor

// AggregationType - the aggregation type of the metric.
type AggregationType string

const (
	AggregationTypeNone    AggregationType = "None"
	AggregationTypeAverage AggregationType = "Average"
	AggregationTypeCount   AggregationType = "Count"
	AggregationTypeMinimum AggregationType = "Minimum"
	AggregationTypeMaximum AggregationType = "Maximum"
	AggregationTypeTotal   AggregationType = "Total"
)

// PossibleAggregationTypeValues returns the possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{
		AggregationTypeNone,
		AggregationTypeAverage,
		AggregationTypeCount,
		AggregationTypeMinimum,
		AggregationTypeMaximum,
		AggregationTypeTotal,
	}
}

// CategoryType - The type of the diagnostic settings category.
type CategoryType string

const (
	CategoryTypeMetrics CategoryType = "Metrics"
	CategoryTypeLogs    CategoryType = "Logs"
)

// PossibleCategoryTypeValues returns the possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{
		CategoryTypeMetrics,
		CategoryTypeLogs,
	}
}

// MetricClass - The class of the metric.
type MetricClass string

const (
	MetricClassAvailability MetricClass = "Availability"
	MetricClassErrors       MetricClass = "Errors"
	MetricClassLatency      MetricClass = "Latency"
	MetricClassSaturation   MetricClass = "Saturation"
	MetricClassTransactions MetricClass = "Transactions"
)

// PossibleMetricClassValues returns the possible values for the MetricClass const type.
func PossibleMetricClassValues() []MetricClass {
	return []MetricClass{
		MetricClassAvailability,
		MetricClassErrors,
		MetricClassLatency,
		MetricClassSaturation,
		MetricClassTransactions,
	}
}

// MetricUnit - The unit of the metric.
type MetricUnit string

const (
	MetricUnitBitsPerSecond  MetricUnit = "BitsPerSecond"
	MetricUnitByteSeconds    MetricUnit = "ByteSeconds"
	MetricUnitBytes          MetricUnit = "Bytes"
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	MetricUnitCores          MetricUnit = "Cores"
	MetricUnitCount          MetricUnit = "Count"
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	MetricUnitMilliCores     MetricUnit = "MilliCores"
	MetricUnitMilliSeconds   MetricUnit = "MilliSeconds"
	MetricUnitNanoCores      MetricUnit = "NanoCores"
	MetricUnitPercent        MetricUnit = "Percent"
	MetricUnitSeconds        MetricUnit = "Seconds"
	MetricUnitUnspecified    MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBitsPerSecond,
		MetricUnitByteSeconds,
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCores,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitMilliCores,
		MetricUnitMilliSeconds,
		MetricUnitNanoCores,
		MetricUnitPercent,
		MetricUnitSeconds,
		MetricUnitUnspecified,
	}
}

type ResultType string

const (
	ResultTypeData     ResultType = "Data"
	ResultTypeMetadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns the possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{
		ResultTypeData,
		ResultTypeMetadata,
	}
}
