//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiothub

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Capacity.
func (c Capacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", c.Default)
	populate(objectMap, "maximum", c.Maximum)
	populate(objectMap, "minimum", c.Minimum)
	populate(objectMap, "scaleType", c.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Capacity.
func (c *Capacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &c.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &c.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &c.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &c.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateBodyDescription.
func (c CertificateBodyDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificate", c.Certificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateBodyDescription.
func (c *CertificateBodyDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateDescription.
func (c CertificateDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateDescription.
func (c *CertificateDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateListDescription.
func (c CertificateListDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateListDescription.
func (c *CertificateListDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateProperties.
func (c CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificate", c.Certificate)
	populateTimeRFC1123(objectMap, "created", c.Created)
	populateTimeRFC1123(objectMap, "expiry", c.Expiry)
	populate(objectMap, "isVerified", c.IsVerified)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "thumbprint", c.Thumbprint)
	populateTimeRFC1123(objectMap, "updated", c.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateProperties.
func (c *CertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC1123(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "expiry":
			err = unpopulateTimeRFC1123(val, "Expiry", &c.Expiry)
			delete(rawMsg, key)
		case "isVerified":
			err = unpopulate(val, "IsVerified", &c.IsVerified)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeRFC1123(val, "Updated", &c.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificatePropertiesWithNonce.
func (c CertificatePropertiesWithNonce) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificate", c.Certificate)
	populateTimeRFC1123(objectMap, "created", c.Created)
	populateTimeRFC1123(objectMap, "expiry", c.Expiry)
	populate(objectMap, "isVerified", c.IsVerified)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "thumbprint", c.Thumbprint)
	populateTimeRFC1123(objectMap, "updated", c.Updated)
	populate(objectMap, "verificationCode", c.VerificationCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificatePropertiesWithNonce.
func (c *CertificatePropertiesWithNonce) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC1123(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "expiry":
			err = unpopulateTimeRFC1123(val, "Expiry", &c.Expiry)
			delete(rawMsg, key)
		case "isVerified":
			err = unpopulate(val, "IsVerified", &c.IsVerified)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeRFC1123(val, "Updated", &c.Updated)
			delete(rawMsg, key)
		case "verificationCode":
			err = unpopulate(val, "VerificationCode", &c.VerificationCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateVerificationDescription.
func (c CertificateVerificationDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificate", c.Certificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateVerificationDescription.
func (c *CertificateVerificationDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateWithNonceDescription.
func (c CertificateWithNonceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateWithNonceDescription.
func (c *CertificateWithNonceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudToDeviceProperties.
func (c CloudToDeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultTtlAsIso8601", c.DefaultTTLAsIso8601)
	populate(objectMap, "feedback", c.Feedback)
	populate(objectMap, "maxDeliveryCount", c.MaxDeliveryCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudToDeviceProperties.
func (c *CloudToDeviceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultTtlAsIso8601":
			err = unpopulate(val, "DefaultTTLAsIso8601", &c.DefaultTTLAsIso8601)
			delete(rawMsg, key)
		case "feedback":
			err = unpopulate(val, "Feedback", &c.Feedback)
			delete(rawMsg, key)
		case "maxDeliveryCount":
			err = unpopulate(val, "MaxDeliveryCount", &c.MaxDeliveryCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Description.
func (d Description) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Description.
func (d *Description) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DescriptionListResult.
func (d DescriptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DescriptionListResult.
func (d *DescriptionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointHealthData.
func (e EndpointHealthData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointId", e.EndpointID)
	populate(objectMap, "healthStatus", e.HealthStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointHealthData.
func (e *EndpointHealthData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointId":
			err = unpopulate(val, "EndpointID", &e.EndpointID)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &e.HealthStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointHealthDataListResult.
func (e EndpointHealthDataListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointHealthDataListResult.
func (e *EndpointHealthDataListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrichmentProperties.
func (e EnrichmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointNames", e.EndpointNames)
	populate(objectMap, "key", e.Key)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrichmentProperties.
func (e *EnrichmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointNames":
			err = unpopulate(val, "EndpointNames", &e.EndpointNames)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &e.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "httpStatusCode", e.HTTPStatusCode)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "httpStatusCode":
			err = unpopulate(val, "HTTPStatusCode", &e.HTTPStatusCode)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubConsumerGroupInfo.
func (e EventHubConsumerGroupInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubConsumerGroupInfo.
func (e *EventHubConsumerGroupInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubConsumerGroupsListResult.
func (e EventHubConsumerGroupsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubConsumerGroupsListResult.
func (e *EventHubConsumerGroupsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubProperties.
func (e EventHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpoint", e.Endpoint)
	populate(objectMap, "partitionCount", e.PartitionCount)
	populate(objectMap, "partitionIds", e.PartitionIDs)
	populate(objectMap, "path", e.Path)
	populate(objectMap, "retentionTimeInDays", e.RetentionTimeInDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubProperties.
func (e *EventHubProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			err = unpopulate(val, "Endpoint", &e.Endpoint)
			delete(rawMsg, key)
		case "partitionCount":
			err = unpopulate(val, "PartitionCount", &e.PartitionCount)
			delete(rawMsg, key)
		case "partitionIds":
			err = unpopulate(val, "PartitionIDs", &e.PartitionIDs)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &e.Path)
			delete(rawMsg, key)
		case "retentionTimeInDays":
			err = unpopulate(val, "RetentionTimeInDays", &e.RetentionTimeInDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDevicesRequest.
func (e ExportDevicesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "excludeKeys", e.ExcludeKeys)
	populate(objectMap, "exportBlobContainerUri", e.ExportBlobContainerURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportDevicesRequest.
func (e *ExportDevicesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludeKeys":
			err = unpopulate(val, "ExcludeKeys", &e.ExcludeKeys)
			delete(rawMsg, key)
		case "exportBlobContainerUri":
			err = unpopulate(val, "ExportBlobContainerURI", &e.ExportBlobContainerURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverInput.
func (f FailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverRegion", f.FailoverRegion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverInput.
func (f *FailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverRegion":
			err = unpopulate(val, "FailoverRegion", &f.FailoverRegion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FallbackRouteProperties.
func (f FallbackRouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "condition", f.Condition)
	populate(objectMap, "endpointNames", f.EndpointNames)
	populate(objectMap, "isEnabled", f.IsEnabled)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "source", f.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FallbackRouteProperties.
func (f *FallbackRouteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "condition":
			err = unpopulate(val, "Condition", &f.Condition)
			delete(rawMsg, key)
		case "endpointNames":
			err = unpopulate(val, "EndpointNames", &f.EndpointNames)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &f.IsEnabled)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &f.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeedbackProperties.
func (f FeedbackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lockDurationAsIso8601", f.LockDurationAsIso8601)
	populate(objectMap, "maxDeliveryCount", f.MaxDeliveryCount)
	populate(objectMap, "ttlAsIso8601", f.TTLAsIso8601)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeedbackProperties.
func (f *FeedbackProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lockDurationAsIso8601":
			err = unpopulate(val, "LockDurationAsIso8601", &f.LockDurationAsIso8601)
			delete(rawMsg, key)
		case "maxDeliveryCount":
			err = unpopulate(val, "MaxDeliveryCount", &f.MaxDeliveryCount)
			delete(rawMsg, key)
		case "ttlAsIso8601":
			err = unpopulate(val, "TTLAsIso8601", &f.TTLAsIso8601)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPFilterRule.
func (i IPFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", i.Action)
	populate(objectMap, "filterName", i.FilterName)
	populate(objectMap, "ipMask", i.IPMask)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPFilterRule.
func (i *IPFilterRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "filterName":
			err = unpopulate(val, "FilterName", &i.FilterName)
			delete(rawMsg, key)
		case "ipMask":
			err = unpopulate(val, "IPMask", &i.IPMask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportDevicesRequest.
func (i ImportDevicesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inputBlobContainerUri", i.InputBlobContainerURI)
	populate(objectMap, "outputBlobContainerUri", i.OutputBlobContainerURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportDevicesRequest.
func (i *ImportDevicesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputBlobContainerUri":
			err = unpopulate(val, "InputBlobContainerURI", &i.InputBlobContainerURI)
			delete(rawMsg, key)
		case "outputBlobContainerUri":
			err = unpopulate(val, "OutputBlobContainerURI", &i.OutputBlobContainerURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResponse.
func (j JobResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeRFC1123(objectMap, "endTimeUtc", j.EndTimeUTC)
	populate(objectMap, "failureReason", j.FailureReason)
	populate(objectMap, "jobId", j.JobID)
	populate(objectMap, "parentJobId", j.ParentJobID)
	populateTimeRFC1123(objectMap, "startTimeUtc", j.StartTimeUTC)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "statusMessage", j.StatusMessage)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobResponse.
func (j *JobResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTimeUtc":
			err = unpopulateTimeRFC1123(val, "EndTimeUTC", &j.EndTimeUTC)
			delete(rawMsg, key)
		case "failureReason":
			err = unpopulate(val, "FailureReason", &j.FailureReason)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &j.JobID)
			delete(rawMsg, key)
		case "parentJobId":
			err = unpopulate(val, "ParentJobID", &j.ParentJobID)
			delete(rawMsg, key)
		case "startTimeUtc":
			err = unpopulateTimeRFC1123(val, "StartTimeUTC", &j.StartTimeUTC)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &j.StatusMessage)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResponseListResult.
func (j JobResponseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobResponseListResult.
func (j *JobResponseListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocationDescription.
func (l LocationDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "role", l.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocationDescription.
func (l *LocationDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &l.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MatchedRoute.
func (m MatchedRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MatchedRoute.
func (m *MatchedRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessagingEndpointProperties.
func (m MessagingEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lockDurationAsIso8601", m.LockDurationAsIso8601)
	populate(objectMap, "maxDeliveryCount", m.MaxDeliveryCount)
	populate(objectMap, "ttlAsIso8601", m.TTLAsIso8601)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessagingEndpointProperties.
func (m *MessagingEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lockDurationAsIso8601":
			err = unpopulate(val, "LockDurationAsIso8601", &m.LockDurationAsIso8601)
			delete(rawMsg, key)
		case "maxDeliveryCount":
			err = unpopulate(val, "MaxDeliveryCount", &m.MaxDeliveryCount)
			delete(rawMsg, key)
		case "ttlAsIso8601":
			err = unpopulate(val, "TTLAsIso8601", &m.TTLAsIso8601)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Name.
func (n Name) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", n.LocalizedValue)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Name.
func (n *Name) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &n.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameAvailabilityInfo.
func (n NameAvailabilityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", n.Message)
	populate(objectMap, "nameAvailable", n.NameAvailable)
	populate(objectMap, "reason", n.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameAvailabilityInfo.
func (n *NameAvailabilityInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &n.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &n.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &n.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationInputs.
func (o OperationInputs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationInputs.
func (o *OperationInputs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationPolicies", p.AuthorizationPolicies)
	populate(objectMap, "cloudToDevice", p.CloudToDevice)
	populate(objectMap, "comments", p.Comments)
	populate(objectMap, "deviceStreams", p.DeviceStreams)
	populate(objectMap, "enableFileUploadNotifications", p.EnableFileUploadNotifications)
	populate(objectMap, "eventHubEndpoints", p.EventHubEndpoints)
	populate(objectMap, "features", p.Features)
	populate(objectMap, "hostName", p.HostName)
	populate(objectMap, "ipFilterRules", p.IPFilterRules)
	populate(objectMap, "locations", p.Locations)
	populate(objectMap, "messagingEndpoints", p.MessagingEndpoints)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "routing", p.Routing)
	populate(objectMap, "state", p.State)
	populate(objectMap, "storageEndpoints", p.StorageEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Properties.
func (p *Properties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationPolicies":
			err = unpopulate(val, "AuthorizationPolicies", &p.AuthorizationPolicies)
			delete(rawMsg, key)
		case "cloudToDevice":
			err = unpopulate(val, "CloudToDevice", &p.CloudToDevice)
			delete(rawMsg, key)
		case "comments":
			err = unpopulate(val, "Comments", &p.Comments)
			delete(rawMsg, key)
		case "deviceStreams":
			err = unpopulate(val, "DeviceStreams", &p.DeviceStreams)
			delete(rawMsg, key)
		case "enableFileUploadNotifications":
			err = unpopulate(val, "EnableFileUploadNotifications", &p.EnableFileUploadNotifications)
			delete(rawMsg, key)
		case "eventHubEndpoints":
			err = unpopulate(val, "EventHubEndpoints", &p.EventHubEndpoints)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &p.Features)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &p.HostName)
			delete(rawMsg, key)
		case "ipFilterRules":
			err = unpopulate(val, "IPFilterRules", &p.IPFilterRules)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &p.Locations)
			delete(rawMsg, key)
		case "messagingEndpoints":
			err = unpopulate(val, "MessagingEndpoints", &p.MessagingEndpoints)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "routing":
			err = unpopulate(val, "Routing", &p.Routing)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "storageEndpoints":
			err = unpopulate(val, "StorageEndpoints", &p.StorageEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropertiesDeviceStreams.
func (p PropertiesDeviceStreams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "streamingEndpoints", p.StreamingEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropertiesDeviceStreams.
func (p *PropertiesDeviceStreams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "streamingEndpoints":
			err = unpopulate(val, "StreamingEndpoints", &p.StreamingEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaMetricInfo.
func (q QuotaMetricInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", q.CurrentValue)
	populate(objectMap, "maxValue", q.MaxValue)
	populate(objectMap, "name", q.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaMetricInfo.
func (q *QuotaMetricInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &q.CurrentValue)
			delete(rawMsg, key)
		case "maxValue":
			err = unpopulate(val, "MaxValue", &q.MaxValue)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaMetricInfoListResult.
func (q QuotaMetricInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaMetricInfoListResult.
func (q *QuotaMetricInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryStatistics.
func (r RegistryStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disabledDeviceCount", r.DisabledDeviceCount)
	populate(objectMap, "enabledDeviceCount", r.EnabledDeviceCount)
	populate(objectMap, "totalDeviceCount", r.TotalDeviceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryStatistics.
func (r *RegistryStatistics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disabledDeviceCount":
			err = unpopulate(val, "DisabledDeviceCount", &r.DisabledDeviceCount)
			delete(rawMsg, key)
		case "enabledDeviceCount":
			err = unpopulate(val, "EnabledDeviceCount", &r.EnabledDeviceCount)
			delete(rawMsg, key)
		case "totalDeviceCount":
			err = unpopulate(val, "TotalDeviceCount", &r.TotalDeviceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteCompilationError.
func (r RouteCompilationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "severity", r.Severity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteCompilationError.
func (r *RouteCompilationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &r.Severity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteErrorPosition.
func (r RouteErrorPosition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "column", r.Column)
	populate(objectMap, "line", r.Line)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteErrorPosition.
func (r *RouteErrorPosition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "column":
			err = unpopulate(val, "Column", &r.Column)
			delete(rawMsg, key)
		case "line":
			err = unpopulate(val, "Line", &r.Line)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteErrorRange.
func (r RouteErrorRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end", r.End)
	populate(objectMap, "start", r.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteErrorRange.
func (r *RouteErrorRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulate(val, "End", &r.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &r.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteProperties.
func (r RouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "endpointNames", r.EndpointNames)
	populate(objectMap, "isEnabled", r.IsEnabled)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "source", r.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteProperties.
func (r *RouteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "endpointNames":
			err = unpopulate(val, "EndpointNames", &r.EndpointNames)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &r.IsEnabled)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &r.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingEndpoints.
func (r RoutingEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventHubs", r.EventHubs)
	populate(objectMap, "serviceBusQueues", r.ServiceBusQueues)
	populate(objectMap, "serviceBusTopics", r.ServiceBusTopics)
	populate(objectMap, "storageContainers", r.StorageContainers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingEndpoints.
func (r *RoutingEndpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventHubs":
			err = unpopulate(val, "EventHubs", &r.EventHubs)
			delete(rawMsg, key)
		case "serviceBusQueues":
			err = unpopulate(val, "ServiceBusQueues", &r.ServiceBusQueues)
			delete(rawMsg, key)
		case "serviceBusTopics":
			err = unpopulate(val, "ServiceBusTopics", &r.ServiceBusTopics)
			delete(rawMsg, key)
		case "storageContainers":
			err = unpopulate(val, "StorageContainers", &r.StorageContainers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingEventHubProperties.
func (r RoutingEventHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", r.ConnectionString)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingEventHubProperties.
func (r *RoutingEventHubProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &r.ConnectionString)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingMessage.
func (r RoutingMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appProperties", r.AppProperties)
	populate(objectMap, "body", r.Body)
	populate(objectMap, "systemProperties", r.SystemProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingMessage.
func (r *RoutingMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appProperties":
			err = unpopulate(val, "AppProperties", &r.AppProperties)
			delete(rawMsg, key)
		case "body":
			err = unpopulate(val, "Body", &r.Body)
			delete(rawMsg, key)
		case "systemProperties":
			err = unpopulate(val, "SystemProperties", &r.SystemProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingProperties.
func (r RoutingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpoints", r.Endpoints)
	populate(objectMap, "enrichments", r.Enrichments)
	populate(objectMap, "fallbackRoute", r.FallbackRoute)
	populate(objectMap, "routes", r.Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingProperties.
func (r *RoutingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoints":
			err = unpopulate(val, "Endpoints", &r.Endpoints)
			delete(rawMsg, key)
		case "enrichments":
			err = unpopulate(val, "Enrichments", &r.Enrichments)
			delete(rawMsg, key)
		case "fallbackRoute":
			err = unpopulate(val, "FallbackRoute", &r.FallbackRoute)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &r.Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingServiceBusQueueEndpointProperties.
func (r RoutingServiceBusQueueEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", r.ConnectionString)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingServiceBusQueueEndpointProperties.
func (r *RoutingServiceBusQueueEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &r.ConnectionString)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingServiceBusTopicEndpointProperties.
func (r RoutingServiceBusTopicEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", r.ConnectionString)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingServiceBusTopicEndpointProperties.
func (r *RoutingServiceBusTopicEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &r.ConnectionString)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingStorageContainerProperties.
func (r RoutingStorageContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "batchFrequencyInSeconds", r.BatchFrequencyInSeconds)
	populate(objectMap, "connectionString", r.ConnectionString)
	populate(objectMap, "containerName", r.ContainerName)
	populate(objectMap, "encoding", r.Encoding)
	populate(objectMap, "fileNameFormat", r.FileNameFormat)
	populate(objectMap, "maxChunkSizeInBytes", r.MaxChunkSizeInBytes)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingStorageContainerProperties.
func (r *RoutingStorageContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "batchFrequencyInSeconds":
			err = unpopulate(val, "BatchFrequencyInSeconds", &r.BatchFrequencyInSeconds)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &r.ConnectionString)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &r.ContainerName)
			delete(rawMsg, key)
		case "encoding":
			err = unpopulate(val, "Encoding", &r.Encoding)
			delete(rawMsg, key)
		case "fileNameFormat":
			err = unpopulate(val, "FileNameFormat", &r.FileNameFormat)
			delete(rawMsg, key)
		case "maxChunkSizeInBytes":
			err = unpopulate(val, "MaxChunkSizeInBytes", &r.MaxChunkSizeInBytes)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingTwin.
func (r RoutingTwin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", &r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingTwin.
func (r *RoutingTwin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingTwinProperties.
func (r RoutingTwinProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "desired", &r.Desired)
	populate(objectMap, "reported", &r.Reported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingTwinProperties.
func (r *RoutingTwinProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "desired":
			err = unpopulate(val, "Desired", &r.Desired)
			delete(rawMsg, key)
		case "reported":
			err = unpopulate(val, "Reported", &r.Reported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUDescription.
func (s SKUDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "sku", s.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUDescription.
func (s *SKUDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUDescriptionListResult.
func (s SKUDescriptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUDescriptionListResult.
func (s *SKUDescriptionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUInfo.
func (s SKUInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUInfo.
func (s *SKUInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedAccessSignatureAuthorizationRule.
func (s SharedAccessSignatureAuthorizationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyName", s.KeyName)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "rights", s.Rights)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedAccessSignatureAuthorizationRule.
func (s *SharedAccessSignatureAuthorizationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &s.KeyName)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &s.PrimaryKey)
			delete(rawMsg, key)
		case "rights":
			err = unpopulate(val, "Rights", &s.Rights)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &s.SecondaryKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedAccessSignatureAuthorizationRuleListResult.
func (s SharedAccessSignatureAuthorizationRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedAccessSignatureAuthorizationRuleListResult.
func (s *SharedAccessSignatureAuthorizationRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageEndpointProperties.
func (s StorageEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", s.ConnectionString)
	populate(objectMap, "containerName", s.ContainerName)
	populate(objectMap, "sasTtlAsIso8601", s.SasTTLAsIso8601)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageEndpointProperties.
func (s *StorageEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &s.ConnectionString)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &s.ContainerName)
			delete(rawMsg, key)
		case "sasTtlAsIso8601":
			err = unpopulate(val, "SasTTLAsIso8601", &s.SasTTLAsIso8601)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsResource.
func (t TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsResource.
func (t *TagsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestAllRoutesInput.
func (t TestAllRoutesInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", t.Message)
	populate(objectMap, "routingSource", t.RoutingSource)
	populate(objectMap, "twin", t.Twin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestAllRoutesInput.
func (t *TestAllRoutesInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &t.Message)
			delete(rawMsg, key)
		case "routingSource":
			err = unpopulate(val, "RoutingSource", &t.RoutingSource)
			delete(rawMsg, key)
		case "twin":
			err = unpopulate(val, "Twin", &t.Twin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestAllRoutesResult.
func (t TestAllRoutesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "routes", t.Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestAllRoutesResult.
func (t *TestAllRoutesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "routes":
			err = unpopulate(val, "Routes", &t.Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestRouteInput.
func (t TestRouteInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", t.Message)
	populate(objectMap, "route", t.Route)
	populate(objectMap, "twin", t.Twin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestRouteInput.
func (t *TestRouteInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &t.Message)
			delete(rawMsg, key)
		case "route":
			err = unpopulate(val, "Route", &t.Route)
			delete(rawMsg, key)
		case "twin":
			err = unpopulate(val, "Twin", &t.Twin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestRouteResult.
func (t TestRouteResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", t.Details)
	populate(objectMap, "result", t.Result)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestRouteResult.
func (t *TestRouteResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &t.Details)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &t.Result)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestRouteResultDetails.
func (t TestRouteResultDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compilationErrors", t.CompilationErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestRouteResultDetails.
func (t *TestRouteResultDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compilationErrors":
			err = unpopulate(val, "CompilationErrors", &t.CompilationErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserSubscriptionQuota.
func (u UserSubscriptionQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "type", u.Type)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserSubscriptionQuota.
func (u *UserSubscriptionQuota) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserSubscriptionQuotaListResult.
func (u UserSubscriptionQuotaListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserSubscriptionQuotaListResult.
func (u *UserSubscriptionQuotaListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
