//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdataboxedge

import "time"

// ARMBaseModel - Represents the base class for all object models.
type ARMBaseModel struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Address - The shipping address of the customer.
type Address struct {
	// REQUIRED; The address line1.
	AddressLine1 *string `json:"addressLine1,omitempty"`

	// REQUIRED; The city name.
	City *string `json:"city,omitempty"`

	// REQUIRED; The country name.
	Country *string `json:"country,omitempty"`

	// REQUIRED; The postal code.
	PostalCode *string `json:"postalCode,omitempty"`

	// REQUIRED; The state name.
	State *string `json:"state,omitempty"`

	// The address line2.
	AddressLine2 *string `json:"addressLine2,omitempty"`

	// The address line3.
	AddressLine3 *string `json:"addressLine3,omitempty"`
}

// Alert on the data box edge/gateway device.
type Alert struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Properties of alert.
	Properties *AlertProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertErrorDetails - Error details for the alert.
type AlertErrorDetails struct {
	// READ-ONLY; Error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Error Message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Number of occurrences.
	Occurrences *int32 `json:"occurrences,omitempty" azure:"ro"`
}

// AlertList - Collection of alerts.
type AlertList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The value.
	Value []*Alert `json:"value,omitempty" azure:"ro"`
}

// AlertProperties - Properties of alert.
type AlertProperties struct {
	// READ-ONLY; Alert type.
	AlertType *string `json:"alertType,omitempty" azure:"ro"`

	// READ-ONLY; UTC time when the alert appeared.
	AppearedAtDateTime *time.Time `json:"appearedAtDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Alert details.
	DetailedInformation map[string]*string `json:"detailedInformation,omitempty" azure:"ro"`

	// READ-ONLY; Error details of the alert.
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; Alert recommendation.
	Recommendation *string `json:"recommendation,omitempty" azure:"ro"`

	// READ-ONLY; Severity of the alert.
	Severity *AlertSeverity `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; Alert title.
	Title *string `json:"title,omitempty" azure:"ro"`
}

// AlertsClientGetOptions contains the optional parameters for the AlertsClient.Get method.
type AlertsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the AlertsClient.NewListByDataBoxEdgeDevicePager
// method.
type AlertsClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// AsymmetricEncryptedSecret - Represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// REQUIRED; The algorithm used to encrypt "Value".
	EncryptionAlgorithm *EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The value of the secret.
	Value *string `json:"value,omitempty"`

	// Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
	EncryptionCertThumbprint *string `json:"encryptionCertThumbprint,omitempty"`
}

// Authentication mechanism for IoT devices.
type Authentication struct {
	// Symmetric key for authentication.
	SymmetricKey *SymmetricKey `json:"symmetricKey,omitempty"`
}

// AzureContainerInfo - Azure container mapping of the endpoint.
type AzureContainerInfo struct {
	// REQUIRED; Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; Storage format used for the file represented by the share.
	DataFormat *AzureContainerDataFormat `json:"dataFormat,omitempty"`

	// REQUIRED; ID of the storage account credential used to access storage.
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`
}

// BandwidthSchedule - The bandwidth schedule details.
type BandwidthSchedule struct {
	// REQUIRED; The properties of the bandwidth schedule.
	Properties *BandwidthScheduleProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BandwidthScheduleProperties - The properties of the bandwidth schedule.
type BandwidthScheduleProperties struct {
	// REQUIRED; The days of the week when this schedule is applicable.
	Days []*DayOfWeek `json:"days,omitempty"`

	// REQUIRED; The bandwidth rate in Mbps.
	RateInMbps *int32 `json:"rateInMbps,omitempty"`

	// REQUIRED; The start time of the schedule in UTC.
	Start *string `json:"start,omitempty"`

	// REQUIRED; The stop time of the schedule in UTC.
	Stop *string `json:"stop,omitempty"`
}

// BandwidthSchedulesClientBeginCreateOrUpdateOptions contains the optional parameters for the BandwidthSchedulesClient.BeginCreateOrUpdate
// method.
type BandwidthSchedulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BandwidthSchedulesClientBeginDeleteOptions contains the optional parameters for the BandwidthSchedulesClient.BeginDelete
// method.
type BandwidthSchedulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BandwidthSchedulesClientGetOptions contains the optional parameters for the BandwidthSchedulesClient.Get method.
type BandwidthSchedulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BandwidthSchedulesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the BandwidthSchedulesClient.NewListByDataBoxEdgeDevicePager
// method.
type BandwidthSchedulesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// BandwidthSchedulesList - The collection of bandwidth schedules.
type BandwidthSchedulesList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of bandwidth schedules.
	Value []*BandwidthSchedule `json:"value,omitempty" azure:"ro"`
}

// ClientAccessRight - The mapping between a particular client IP and the type of access client has on the NFS share.
type ClientAccessRight struct {
	// REQUIRED; Type of access to be allowed for the client.
	AccessPermission *ClientPermissionType `json:"accessPermission,omitempty"`

	// REQUIRED; IP of the client.
	Client *string `json:"client,omitempty"`
}

// ContactDetails - Contains all the contact details of the customer.
type ContactDetails struct {
	// REQUIRED; The name of the company.
	CompanyName *string `json:"companyName,omitempty"`

	// REQUIRED; The contact person name.
	ContactPerson *string `json:"contactPerson,omitempty"`

	// REQUIRED; The email list.
	EmailList []*string `json:"emailList,omitempty"`

	// REQUIRED; The phone number.
	Phone *string `json:"phone,omitempty"`
}

// Container - Represents a container on the Data Box Edge/Gateway device.
type Container struct {
	// REQUIRED; The container properties.
	Properties *ContainerProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerList - Collection of all the containers on the Data Box Edge/Gateway device.
type ContainerList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of containers.
	Value []*Container `json:"value,omitempty" azure:"ro"`
}

// ContainerProperties - The container properties.
type ContainerProperties struct {
	// REQUIRED; DataFormat for Container
	DataFormat *AzureContainerDataFormat `json:"dataFormat,omitempty"`

	// READ-ONLY; Current status of the container.
	ContainerStatus *ContainerStatus `json:"containerStatus,omitempty" azure:"ro"`

	// READ-ONLY; The UTC time when container got created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Details of the refresh job on this container.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty" azure:"ro"`
}

// ContainersClientBeginCreateOrUpdateOptions contains the optional parameters for the ContainersClient.BeginCreateOrUpdate
// method.
type ContainersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainersClientBeginDeleteOptions contains the optional parameters for the ContainersClient.BeginDelete method.
type ContainersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainersClientBeginRefreshOptions contains the optional parameters for the ContainersClient.BeginRefresh method.
type ContainersClientBeginRefreshOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainersClientGetOptions contains the optional parameters for the ContainersClient.Get method.
type ContainersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainersClientListByStorageAccountOptions contains the optional parameters for the ContainersClient.NewListByStorageAccountPager
// method.
type ContainersClientListByStorageAccountOptions struct {
	// placeholder for future optional parameters
}

// Device - The Data Box Edge/Gateway device.
type Device struct {
	// REQUIRED; The location of the device. This is a supported and registered Azure geographical region (for example, West US,
	// East US, or Southeast Asia). The geographical region of a device cannot be changed once
	// it is created, but if an identical geographical region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`

	// The etag for the devices.
	Etag *string `json:"etag,omitempty"`

	// The properties of the Data Box Edge/Gateway device.
	Properties *DeviceProperties `json:"properties,omitempty"`

	// The SKU type.
	SKU *SKUInfo `json:"sku,omitempty"`

	// The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceExtendedInfo - The extended Info of the Data Box Edge/Gateway device.
type DeviceExtendedInfo struct {
	// The extended info properties.
	Properties *DeviceExtendedInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceExtendedInfoProperties - The properties of the Data Box Edge/Gateway device extended info.
type DeviceExtendedInfoProperties struct {
	// The public part of the encryption certificate. Client uses this to encrypt any secret.
	EncryptionKey *string `json:"encryptionKey,omitempty"`

	// The digital signature of encrypted certificate.
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`

	// READ-ONLY; The Resource ID of the Resource.
	ResourceKey *string `json:"resourceKey,omitempty" azure:"ro"`
}

// DeviceList - The collection of Data Box Edge/Gateway devices.
type DeviceList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of Data Box Edge/Gateway devices.
	Value []*Device `json:"value,omitempty" azure:"ro"`
}

// DevicePatch - The Data Box Edge/Gateway device patch.
type DevicePatch struct {
	// The tags attached to the Data Box Edge/Gateway resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DeviceProperties - The properties of the Data Box Edge/Gateway device.
type DeviceProperties struct {
	// The status of the Data Box Edge/Gateway device.
	DataBoxEdgeDeviceStatus *DataBoxEdgeDeviceStatus `json:"dataBoxEdgeDeviceStatus,omitempty"`

	// The Description of the Data Box Edge/Gateway device.
	Description *string `json:"description,omitempty"`

	// The Data Box Edge/Gateway device name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The description of the Data Box Edge/Gateway device model.
	ModelDescription *string `json:"modelDescription,omitempty"`

	// READ-ONLY; Type of compute roles configured.
	ConfiguredRoleTypes []*RoleTypes `json:"configuredRoleTypes,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device culture.
	Culture *string `json:"culture,omitempty" azure:"ro"`

	// READ-ONLY; The device software version number of the device (eg: 1.2.18105.6).
	DeviceHcsVersion *string `json:"deviceHcsVersion,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device local capacity in MB.
	DeviceLocalCapacity *int64 `json:"deviceLocalCapacity,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device model.
	DeviceModel *string `json:"deviceModel,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device software version.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Data Box Edge/Gateway device.
	DeviceType *DeviceType `json:"deviceType,omitempty" azure:"ro"`

	// READ-ONLY; The number of nodes in the cluster.
	NodeCount *int32 `json:"nodeCount,omitempty" azure:"ro"`

	// READ-ONLY; The Serial Number of Data Box Edge/Gateway device.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device timezone.
	TimeZone *string `json:"timeZone,omitempty" azure:"ro"`
}

// DevicesClientBeginCreateOrUpdateOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdate method.
type DevicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginCreateOrUpdateSecuritySettingsOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdateSecuritySettings
// method.
type DevicesClientBeginCreateOrUpdateSecuritySettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDeleteOptions contains the optional parameters for the DevicesClient.BeginDelete method.
type DevicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDownloadUpdatesOptions contains the optional parameters for the DevicesClient.BeginDownloadUpdates method.
type DevicesClientBeginDownloadUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginInstallUpdatesOptions contains the optional parameters for the DevicesClient.BeginInstallUpdates method.
type DevicesClientBeginInstallUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginScanForUpdatesOptions contains the optional parameters for the DevicesClient.BeginScanForUpdates method.
type DevicesClientBeginScanForUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientGetExtendedInformationOptions contains the optional parameters for the DevicesClient.GetExtendedInformation
// method.
type DevicesClientGetExtendedInformationOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetNetworkSettingsOptions contains the optional parameters for the DevicesClient.GetNetworkSettings method.
type DevicesClientGetNetworkSettingsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
type DevicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetUpdateSummaryOptions contains the optional parameters for the DevicesClient.GetUpdateSummary method.
type DevicesClientGetUpdateSummaryOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListByResourceGroupOptions contains the optional parameters for the DevicesClient.NewListByResourceGroupPager
// method.
type DevicesClientListByResourceGroupOptions struct {
	// Specify $expand=details to populate additional fields related to the resource or Specify $skipToken= to populate the next
	// page in the list.
	Expand *string
}

// DevicesClientListBySubscriptionOptions contains the optional parameters for the DevicesClient.NewListBySubscriptionPager
// method.
type DevicesClientListBySubscriptionOptions struct {
	// Specify $expand=details to populate additional fields related to the resource or Specify $skipToken= to populate the next
	// page in the list.
	Expand *string
}

// DevicesClientUpdateOptions contains the optional parameters for the DevicesClient.Update method.
type DevicesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientUploadCertificateOptions contains the optional parameters for the DevicesClient.UploadCertificate method.
type DevicesClientUploadCertificateOptions struct {
	// placeholder for future optional parameters
}

// FileEventTrigger - Trigger details.
type FileEventTrigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType `json:"kind,omitempty"`

	// REQUIRED; File trigger properties.
	Properties *FileTriggerProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type FileEventTrigger.
func (f *FileEventTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Kind: f.Kind,
		ID:   f.ID,
		Name: f.Name,
		Type: f.Type,
	}
}

// FileSourceInfo - File source details.
type FileSourceInfo struct {
	// REQUIRED; File share ID.
	ShareID *string `json:"shareId,omitempty"`
}

// FileTriggerProperties - File trigger properties.
type FileTriggerProperties struct {
	// REQUIRED; Role sink info.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`

	// REQUIRED; File event source details.
	SourceInfo *FileSourceInfo `json:"sourceInfo,omitempty"`

	// A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger
	// is intended for certain specific IoT modules in the device, the tag can be the
	// name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// IPv4Config - Details related to the IPv4 address configuration.
type IPv4Config struct {
	// READ-ONLY; The IPv4 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty" azure:"ro"`

	// READ-ONLY; The IPv4 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`

	// READ-ONLY; The IPv4 subnet of the network adapter.
	Subnet *string `json:"subnet,omitempty" azure:"ro"`
}

// IPv6Config - Details related to the IPv6 address configuration.
type IPv6Config struct {
	// READ-ONLY; The IPv6 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 prefix of the network adapter.
	PrefixLength *int32 `json:"prefixLength,omitempty" azure:"ro"`
}

// IoTDeviceInfo - Metadata of IoT device/IoT Edge device to be configured.
type IoTDeviceInfo struct {
	// REQUIRED; ID of the IoT device/edge device.
	DeviceID *string `json:"deviceId,omitempty"`

	// REQUIRED; Host name for the IoT hub associated to the device.
	IoTHostHub *string `json:"ioTHostHub,omitempty"`

	// IoT device authentication info.
	Authentication *Authentication `json:"authentication,omitempty"`

	// Id for the IoT hub associated to the device.
	IoTHostHubID *string `json:"ioTHostHubId,omitempty"`
}

// IoTRole - Compute role.
type IoTRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes `json:"kind,omitempty"`

	// Properties specific to IoT role.
	Properties *IoTRoleProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetRole implements the RoleClassification interface for type IoTRole.
func (i *IoTRole) GetRole() *Role {
	return &Role{
		Kind: i.Kind,
		ID:   i.ID,
		Name: i.Name,
		Type: i.Type,
	}
}

// IoTRoleProperties - IoT role properties.
type IoTRoleProperties struct {
	// REQUIRED; Host OS supported by the IoT role.
	HostPlatform *PlatformType `json:"hostPlatform,omitempty"`

	// REQUIRED; IoT device metadata to which data box edge device needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo `json:"ioTDeviceDetails,omitempty"`

	// REQUIRED; IoT edge device to which the IoT role needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo `json:"ioTEdgeDeviceDetails,omitempty"`

	// REQUIRED; Role status.
	RoleStatus *RoleStatus `json:"roleStatus,omitempty"`

	// Mount points of shares in role(s).
	ShareMappings []*MountPointMap `json:"shareMappings,omitempty"`
}

// Job - A device job.
type Job struct {
	// READ-ONLY; The UTC date and time at which the job completed.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Error *JobErrorDetails `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of the job that is complete.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The properties of the job.
	Properties *JobProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time at which the job started.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the job.
	Status *JobStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobErrorDetails - The job error information containing the list of job errors.
type JobErrorDetails struct {
	// READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	ErrorDetails []*JobErrorItem `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// JobErrorItem - The job error items.
type JobErrorItem struct {
	// READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The recommended actions.
	Recommendations []*string `json:"recommendations,omitempty" azure:"ro"`
}

// JobProperties - The properties for the job.
type JobProperties struct {
	// If only subfolders need to be refreshed, then the subfolder path inside the share or container. (The path is empty if there
	// are no subfolders.)
	Folder *string `json:"folder,omitempty"`

	// READ-ONLY; Current stage of the update operation.
	CurrentStage *UpdateOperationStage `json:"currentStage,omitempty" azure:"ro"`

	// READ-ONLY; The download progress.
	DownloadProgress *UpdateDownloadProgress `json:"downloadProgress,omitempty" azure:"ro"`

	// READ-ONLY; Local share/remote container relative path to the error manifest file of the refresh.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty" azure:"ro"`

	// READ-ONLY; The install progress.
	InstallProgress *UpdateInstallProgress `json:"installProgress,omitempty" azure:"ro"`

	// READ-ONLY; The type of the job.
	JobType *JobType `json:"jobType,omitempty" azure:"ro"`

	// READ-ONLY; ARM ID of the entity that was refreshed.
	RefreshedEntityID *string `json:"refreshedEntityId,omitempty" azure:"ro"`

	// READ-ONLY; Total number of errors encountered during the refresh process.
	TotalRefreshErrors *int32 `json:"totalRefreshErrors,omitempty" azure:"ro"`
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MetricDimensionV1 - Metric Dimension v1.
type MetricDimensionV1 struct {
	// Display name of the metrics dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the metrics dimension.
	Name *string `json:"name,omitempty"`

	// To be exported to shoe box.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecificationV1 - Metric specification version 1.
type MetricSpecificationV1 struct {
	// Metric aggregation type.
	AggregationType *MetricAggregationType `json:"aggregationType,omitempty"`

	// Metric category.
	Category *MetricCategory `json:"category,omitempty"`

	// Metric dimensions, other than default dimension which is resource.
	Dimensions []*MetricDimensionV1 `json:"dimensions,omitempty"`

	// Description of the metric to be displayed.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`

	// Set true to fill the gaps with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of the metric.
	Name *string `json:"name,omitempty"`

	// Resource name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// Support metric aggregation type.
	SupportedAggregationTypes []*MetricAggregationType `json:"supportedAggregationTypes,omitempty"`

	// Support granularity of metrics.
	SupportedTimeGrainTypes []*TimeGrain `json:"supportedTimeGrainTypes,omitempty"`

	// Metric units.
	Unit *MetricUnit `json:"unit,omitempty"`
}

// MountPointMap - The share mount point.
type MountPointMap struct {
	// REQUIRED; ID of the share mounted to the role VM.
	ShareID *string `json:"shareId,omitempty"`

	// READ-ONLY; Mount point for the share.
	MountPoint *string `json:"mountPoint,omitempty" azure:"ro"`

	// READ-ONLY; ID of the role to which share is mounted.
	RoleID *string `json:"roleId,omitempty" azure:"ro"`

	// READ-ONLY; Role type.
	RoleType *RoleTypes `json:"roleType,omitempty" azure:"ro"`
}

// NetworkAdapter - Represents the networkAdapter on a device.
type NetworkAdapter struct {
	// Value indicating whether this adapter has DHCP enabled.
	DhcpStatus *NetworkAdapterDHCPStatus `json:"dhcpStatus,omitempty"`

	// Value indicating whether this adapter is RDMA capable.
	RdmaStatus *NetworkAdapterRDMAStatus `json:"rdmaStatus,omitempty"`

	// READ-ONLY; Instance ID of network adapter.
	AdapterID *string `json:"adapterId,omitempty" azure:"ro"`

	// READ-ONLY; Hardware position of network adapter.
	AdapterPosition *NetworkAdapterPosition `json:"adapterPosition,omitempty" azure:"ro"`

	// READ-ONLY; The list of DNS Servers of the device.
	DNSServers []*string `json:"dnsServers,omitempty" azure:"ro"`

	// READ-ONLY; The IPv4 configuration of the network adapter.
	IPv4Configuration *IPv4Config `json:"ipv4Configuration,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 configuration of the network adapter.
	IPv6Configuration *IPv6Config `json:"ipv6Configuration,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 local address.
	IPv6LinkLocalAddress *string `json:"ipv6LinkLocalAddress,omitempty" azure:"ro"`

	// READ-ONLY; Logical index of the adapter.
	Index *int32 `json:"index,omitempty" azure:"ro"`

	// READ-ONLY; Hardware label for the adapter.
	Label *string `json:"label,omitempty" azure:"ro"`

	// READ-ONLY; Link speed.
	LinkSpeed *int64 `json:"linkSpeed,omitempty" azure:"ro"`

	// READ-ONLY; MAC address.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; Network adapter name.
	NetworkAdapterName *string `json:"networkAdapterName,omitempty" azure:"ro"`

	// READ-ONLY; Node ID of the network adapter.
	NodeID *string `json:"nodeId,omitempty" azure:"ro"`

	// READ-ONLY; Value indicating whether this adapter is valid.
	Status *NetworkAdapterStatus `json:"status,omitempty" azure:"ro"`
}

// NetworkAdapterPosition - The network adapter position.
type NetworkAdapterPosition struct {
	// READ-ONLY; The network group.
	NetworkGroup *NetworkGroup `json:"networkGroup,omitempty" azure:"ro"`

	// READ-ONLY; The port.
	Port *int32 `json:"port,omitempty" azure:"ro"`
}

// NetworkSettings - The network settings of a device.
type NetworkSettings struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of network settings of a device.
	Properties *NetworkSettingsProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkSettingsProperties - The properties of network settings.
type NetworkSettingsProperties struct {
	// READ-ONLY; The network adapter list on the device.
	NetworkAdapters []*NetworkAdapter `json:"networkAdapters,omitempty" azure:"ro"`
}

// Node - Represents a single node in a Data box Edge/Gateway device Gateway devices, standalone Edge devices and a single
// node cluster Edge device will all have 1 node Multi-node Edge devices will have more
// than 1 nodes
type Node struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of the node
	Properties *NodeProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NodeList - Collection of Nodes.
type NodeList struct {
	// READ-ONLY; The list of Nodes.
	Value []*Node `json:"value,omitempty" azure:"ro"`
}

// NodeProperties - This class represents the nodes in a highly available cluster
type NodeProperties struct {
	// READ-ONLY; Serial number of the Chassis
	NodeChassisSerialNumber *string `json:"nodeChassisSerialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Display Name of the individual node
	NodeDisplayName *string `json:"nodeDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Friendly software version name that is currently installed on the node
	NodeFriendlySoftwareVersion *string `json:"nodeFriendlySoftwareVersion,omitempty" azure:"ro"`

	// READ-ONLY; HCS version that is currently installed on the node
	NodeHcsVersion *string `json:"nodeHcsVersion,omitempty" azure:"ro"`

	// READ-ONLY; Guid instance id of the node
	NodeInstanceID *string `json:"nodeInstanceId,omitempty" azure:"ro"`

	// READ-ONLY; Serial number of the individual node
	NodeSerialNumber *string `json:"nodeSerialNumber,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the individual node
	NodeStatus *NodeStatus `json:"nodeStatus,omitempty" azure:"ro"`
}

// NodesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the NodesClient.NewListByDataBoxEdgeDevicePager
// method.
type NodesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// Operations.
type Operation struct {
	// Properties displayed for the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Name of the operation.
	Name *string `json:"name,omitempty"`

	// Origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Operation properties.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - Operation display properties.
type OperationDisplay struct {
	// Description of the operation to be performed.
	Description *string `json:"description,omitempty"`

	// Operation to be performed on the resource.
	Operation *string `json:"operation,omitempty"`

	// Provider name.
	Provider *string `json:"provider,omitempty"`

	// The type of resource in which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationProperties - Operation properties.
type OperationProperties struct {
	// Service specification.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsList - The list of operations used for the discovery of available provider operations.
type OperationsList struct {
	// REQUIRED; The value.
	Value []*Operation `json:"value,omitempty"`

	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsStatusClientGetOptions contains the optional parameters for the OperationsStatusClient.Get method.
type OperationsStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// Order - The order details.
type Order struct {
	// The order properties.
	Properties *OrderProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OrderList - List of order entities.
type OrderList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of orders.
	Value []*Order `json:"value,omitempty" azure:"ro"`
}

// OrderProperties - Order properties.
type OrderProperties struct {
	// REQUIRED; The contact details.
	ContactInformation *ContactDetails `json:"contactInformation,omitempty"`

	// REQUIRED; The shipping address.
	ShippingAddress *Address `json:"shippingAddress,omitempty"`

	// Current status of the order.
	CurrentStatus *OrderStatus `json:"currentStatus,omitempty"`

	// READ-ONLY; Tracking information for the package delivered to the customer whether it has an original or a replacement device.
	DeliveryTrackingInfo []*TrackingInfo `json:"deliveryTrackingInfo,omitempty" azure:"ro"`

	// READ-ONLY; List of status changes in the order.
	OrderHistory []*OrderStatus `json:"orderHistory,omitempty" azure:"ro"`

	// READ-ONLY; Tracking information for the package returned from the customer whether it has an original or a replacement
	// device.
	ReturnTrackingInfo []*TrackingInfo `json:"returnTrackingInfo,omitempty" azure:"ro"`

	// READ-ONLY; Serial number of the device.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`
}

// OrderStatus - Represents a single status change.
type OrderStatus struct {
	// REQUIRED; Status of the order as per the allowed status types.
	Status *OrderState `json:"status,omitempty"`

	// Comments related to this status change.
	Comments *string `json:"comments,omitempty"`

	// READ-ONLY; Dictionary to hold generic information which is not stored by the already existing properties
	AdditionalOrderDetails map[string]*string `json:"additionalOrderDetails,omitempty" azure:"ro"`

	// READ-ONLY; Time of status update.
	UpdateDateTime *time.Time `json:"updateDateTime,omitempty" azure:"ro"`
}

// OrdersClientBeginCreateOrUpdateOptions contains the optional parameters for the OrdersClient.BeginCreateOrUpdate method.
type OrdersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OrdersClientBeginDeleteOptions contains the optional parameters for the OrdersClient.BeginDelete method.
type OrdersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OrdersClientGetOptions contains the optional parameters for the OrdersClient.Get method.
type OrdersClientGetOptions struct {
	// placeholder for future optional parameters
}

// OrdersClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the OrdersClient.NewListByDataBoxEdgeDevicePager
// method.
type OrdersClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// PeriodicTimerEventTrigger - Trigger details.
type PeriodicTimerEventTrigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType `json:"kind,omitempty"`

	// REQUIRED; Periodic timer trigger properties.
	Properties *PeriodicTimerProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type PeriodicTimerEventTrigger.
func (p *PeriodicTimerEventTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Kind: p.Kind,
		ID:   p.ID,
		Name: p.Name,
		Type: p.Type,
	}
}

// PeriodicTimerProperties - Periodic timer trigger properties.
type PeriodicTimerProperties struct {
	// REQUIRED; Role Sink information.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`

	// REQUIRED; Periodic timer details.
	SourceInfo *PeriodicTimerSourceInfo `json:"sourceInfo,omitempty"`

	// A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger
	// is intended for certain specific IoT modules in the device, the tag can be the
	// name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// PeriodicTimerSourceInfo - Periodic timer event source.
type PeriodicTimerSourceInfo struct {
	// REQUIRED; Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
	Schedule *string `json:"schedule,omitempty"`

	// REQUIRED; The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified
	// upto seconds. If timezone is not specified the time will considered to be in device
	// timezone. The value will always be returned as UTC time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Topic where periodic events are published to IoT device.
	Topic *string `json:"topic,omitempty"`
}

// RawCertificateData - Raw Certificate Data.
type RawCertificateData struct {
	// REQUIRED; The base64 encoded certificate raw data.
	Certificate *string `json:"certificate,omitempty"`

	// The authentication type.
	AuthenticationType *AuthenticationType `json:"authenticationType,omitempty"`
}

// RefreshDetails - Fields for tracking refresh job on the share or container.
type RefreshDetails struct {
	// Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This
	// could be a failed job or a successful job.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`

	// If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that
	// job. The field is empty if no job is in progress.
	InProgressRefreshJobID *string `json:"inProgressRefreshJobId,omitempty"`

	// Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed
	// job or a successful job.
	LastCompletedRefreshJobTimeInUTC *time.Time `json:"lastCompletedRefreshJobTimeInUTC,omitempty"`

	// Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a
	// successful job.
	LastJob *string `json:"lastJob,omitempty"`
}

// ResourceTypeSKU - SkuInformation object
type ResourceTypeSKU struct {
	// READ-ONLY; The API versions in which SKU is available
	APIVersions []*string `json:"apiVersions,omitempty" azure:"ro"`

	// READ-ONLY; The pricing info of the Sku.
	Costs []*SKUCost `json:"costs,omitempty" azure:"ro"`

	// READ-ONLY; The Sku family
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The Sku kind
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Availability of the SKU for the location/zone
	LocationInfo []*SKULocationInfo `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; Availability of the SKU for the region
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The Sku name
	Name *SKUName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Restrictions of the SKU availability.
	Restrictions []*SKURestriction `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The Sku tier
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// RoleClassification provides polymorphic access to related types.
// Call the interface's GetRole() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *IoTRole, *Role
type RoleClassification interface {
	// GetRole returns the Role content of the underlying type.
	GetRole() *Role
}

// Role - Compute role.
type Role struct {
	// REQUIRED; Role type.
	Kind *RoleTypes `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetRole implements the RoleClassification interface for type Role.
func (r *Role) GetRole() *Role { return r }

// RoleList - Collection of all the roles on the Data Box Edge device.
type RoleList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The Value.
	Value []RoleClassification `json:"value,omitempty" azure:"ro"`
}

// RoleSinkInfo - Compute role against which events will be raised.
type RoleSinkInfo struct {
	// REQUIRED; Compute role ID.
	RoleID *string `json:"roleId,omitempty"`
}

// RolesClientBeginCreateOrUpdateOptions contains the optional parameters for the RolesClient.BeginCreateOrUpdate method.
type RolesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RolesClientBeginDeleteOptions contains the optional parameters for the RolesClient.BeginDelete method.
type RolesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RolesClientGetOptions contains the optional parameters for the RolesClient.Get method.
type RolesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RolesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the RolesClient.NewListByDataBoxEdgeDevicePager
// method.
type RolesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// SKUCost - The metadata for retrieving price info.
type SKUCost struct {
	// READ-ONLY; Restriction of the SKU for the location/zone
	ExtendedUnit *string `json:"extendedUnit,omitempty" azure:"ro"`

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; The cost quantity.
	Quantity *int64 `json:"quantity,omitempty" azure:"ro"`
}

// SKUInfo - The SKU type.
type SKUInfo struct {
	// SKU name.
	Name *SKUName `json:"name,omitempty"`

	// The SKU tier. This is based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SKUInformationList - List of SKU Information objects
type SKUInformationList struct {
	// READ-ONLY; Links to the next set of results
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of ResourceType Sku
	Value []*ResourceTypeSKU `json:"value,omitempty" azure:"ro"`
}

// SKULocationInfo - The location info.
type SKULocationInfo struct {
	// READ-ONLY; The location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The sites.
	Sites []*string `json:"sites,omitempty" azure:"ro"`

	// READ-ONLY; The zones.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// SKURestriction - The restrictions because of which SKU cannot be used.
type SKURestriction struct {
	// READ-ONLY; The SKU restriction reason.
	ReasonCode *SKURestrictionReasonCode `json:"reasonCode,omitempty" azure:"ro"`

	// READ-ONLY; Restriction of the SKU for the location/zone
	RestrictionInfo *SKURestrictionInfo `json:"restrictionInfo,omitempty" azure:"ro"`

	// READ-ONLY; The type of the restriction.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The locations where sku is restricted.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// SKURestrictionInfo - The restriction info with locations and zones.
type SKURestrictionInfo struct {
	// READ-ONLY; The locations.
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The zones.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.NewListPager method.
type SKUsClientListOptions struct {
	// Specify $filter='location eq ' to filter on location.
	Filter *string
}

// SecuritySettings - The security settings of a device.
type SecuritySettings struct {
	// REQUIRED; Properties of the security settings.
	Properties *SecuritySettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecuritySettingsProperties - The properties of security settings.
type SecuritySettingsProperties struct {
	// REQUIRED; Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to sign into the local
	// web UI of the device. The Actual password should have at least 8 characters that are a
	// combination of uppercase, lowercase, numeric, and special characters.
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
}

// ServiceSpecification - Service specification.
type ServiceSpecification struct {
	// Metric specification as defined by shoebox.
	MetricSpecifications []*MetricSpecificationV1 `json:"metricSpecifications,omitempty"`
}

// Share - Represents a share on the Data Box Edge/Gateway device.
type Share struct {
	// REQUIRED; The share properties.
	Properties *ShareProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ShareAccessRight - Specifies the mapping between this particular user and the type of access he has on shares on this device.
type ShareAccessRight struct {
	// REQUIRED; Type of access to be allowed on the share for this user.
	AccessType *ShareAccessType `json:"accessType,omitempty"`

	// REQUIRED; The share ID.
	ShareID *string `json:"shareId,omitempty"`
}

// ShareList - Collection of all the shares on the Data Box Edge/Gateway device.
type ShareList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of shares.
	Value []*Share `json:"value,omitempty" azure:"ro"`
}

// ShareProperties - The share properties.
type ShareProperties struct {
	// REQUIRED; Access protocol to be used by the share.
	AccessProtocol *ShareAccessProtocol `json:"accessProtocol,omitempty"`

	// REQUIRED; Current monitoring status of the share.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`

	// REQUIRED; Current status of the share.
	ShareStatus *ShareStatus `json:"shareStatus,omitempty"`

	// Azure container mapping for the share.
	AzureContainerInfo *AzureContainerInfo `json:"azureContainerInfo,omitempty"`

	// List of IP addresses and corresponding access rights on the share(required for NFS protocol).
	ClientAccessRights []*ClientAccessRight `json:"clientAccessRights,omitempty"`

	// Data policy of the share.
	DataPolicy *DataPolicy `json:"dataPolicy,omitempty"`

	// Description for the share.
	Description *string `json:"description,omitempty"`

	// Details of the refresh job on this share.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty"`

	// Mapping of users and corresponding access rights on the share (required for SMB protocol).
	UserAccessRights []*UserAccessRight `json:"userAccessRights,omitempty"`

	// READ-ONLY; Share mount point to the role.
	ShareMappings []*MountPointMap `json:"shareMappings,omitempty" azure:"ro"`
}

// SharesClientBeginCreateOrUpdateOptions contains the optional parameters for the SharesClient.BeginCreateOrUpdate method.
type SharesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharesClientBeginDeleteOptions contains the optional parameters for the SharesClient.BeginDelete method.
type SharesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharesClientBeginRefreshOptions contains the optional parameters for the SharesClient.BeginRefresh method.
type SharesClientBeginRefreshOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharesClientGetOptions contains the optional parameters for the SharesClient.Get method.
type SharesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the SharesClient.NewListByDataBoxEdgeDevicePager
// method.
type SharesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// StorageAccount - Represents a Storage Account on the Data Box Edge/Gateway device.
type StorageAccount struct {
	// REQUIRED; The Storage Account properties.
	Properties *StorageAccountProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountCredential - The storage account credential.
type StorageAccountCredential struct {
	// REQUIRED; The storage account credential properties.
	Properties *StorageAccountCredentialProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountCredentialList - The collection of storage account credentials.
type StorageAccountCredentialList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The value.
	Value []*StorageAccountCredential `json:"value,omitempty" azure:"ro"`
}

// StorageAccountCredentialProperties - The storage account credential properties.
type StorageAccountCredentialProperties struct {
	// REQUIRED; Type of storage accessed on the storage account.
	AccountType *AccountType `json:"accountType,omitempty"`

	// REQUIRED; Alias for the storage account.
	Alias *string `json:"alias,omitempty"`

	// REQUIRED; Signifies whether SSL needs to be enabled or not.
	SSLStatus *SSLStatus `json:"sslStatus,omitempty"`

	// Encrypted storage key.
	AccountKey *AsymmetricEncryptedSecret `json:"accountKey,omitempty"`

	// Blob end point for private clouds.
	BlobDomainName *string `json:"blobDomainName,omitempty"`

	// Connection string for the storage account. Use this string if username and account key are not specified.
	ConnectionString *string `json:"connectionString,omitempty"`

	// Id of the storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// Username for the storage account.
	UserName *string `json:"userName,omitempty"`
}

// StorageAccountCredentialsClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginCreateOrUpdate
// method.
type StorageAccountCredentialsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientBeginDeleteOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginDelete
// method.
type StorageAccountCredentialsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientGetOptions contains the optional parameters for the StorageAccountCredentialsClient.Get
// method.
type StorageAccountCredentialsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountCredentialsClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the StorageAccountCredentialsClient.NewListByDataBoxEdgeDevicePager
// method.
type StorageAccountCredentialsClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountList - Collection of all the Storage Accounts on the Data Box Edge/Gateway device.
type StorageAccountList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of storageAccounts.
	Value []*StorageAccount `json:"value,omitempty" azure:"ro"`
}

// StorageAccountProperties - The storage account properties.
type StorageAccountProperties struct {
	// Data policy of the storage Account.
	DataPolicy *DataPolicy `json:"dataPolicy,omitempty"`

	// Description for the storage Account.
	Description *string `json:"description,omitempty"`

	// Storage Account Credential Id
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`

	// Current status of the storage account
	StorageAccountStatus *StorageAccountStatus `json:"storageAccountStatus,omitempty"`

	// READ-ONLY; BlobEndpoint of Storage Account
	BlobEndpoint *string `json:"blobEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The Container Count. Present only for Storage Accounts with DataPolicy set to Cloud.
	ContainerCount *int32 `json:"containerCount,omitempty" azure:"ro"`
}

// StorageAccountsClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageAccountsClient.BeginCreateOrUpdate
// method.
type StorageAccountsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountsClientBeginDeleteOptions contains the optional parameters for the StorageAccountsClient.BeginDelete method.
type StorageAccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountsClientGetOptions contains the optional parameters for the StorageAccountsClient.Get method.
type StorageAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the StorageAccountsClient.NewListByDataBoxEdgeDevicePager
// method.
type StorageAccountsClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// SymmetricKey - Symmetric key for authentication.
type SymmetricKey struct {
	// Connection string based on the symmetric key.
	ConnectionString *AsymmetricEncryptedSecret `json:"connectionString,omitempty"`
}

// TrackingInfo - Tracking courier information.
type TrackingInfo struct {
	// Name of the carrier used in the delivery.
	CarrierName *string `json:"carrierName,omitempty"`

	// Serial number of the device being tracked.
	SerialNumber *string `json:"serialNumber,omitempty"`

	// Tracking ID of the shipment.
	TrackingID *string `json:"trackingId,omitempty"`

	// Tracking URL of the shipment.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// TriggerClassification provides polymorphic access to related types.
// Call the interface's GetTrigger() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FileEventTrigger, *PeriodicTimerEventTrigger, *Trigger
type TriggerClassification interface {
	// GetTrigger returns the Trigger content of the underlying type.
	GetTrigger() *Trigger
}

// Trigger details.
type Trigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type Trigger.
func (t *Trigger) GetTrigger() *Trigger { return t }

// TriggerList - Collection of all trigger on the data box edge device.
type TriggerList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of triggers.
	Value []TriggerClassification `json:"value,omitempty" azure:"ro"`
}

// TriggersClientBeginCreateOrUpdateOptions contains the optional parameters for the TriggersClient.BeginCreateOrUpdate method.
type TriggersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TriggersClientBeginDeleteOptions contains the optional parameters for the TriggersClient.BeginDelete method.
type TriggersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TriggersClientGetOptions contains the optional parameters for the TriggersClient.Get method.
type TriggersClientGetOptions struct {
	// placeholder for future optional parameters
}

// TriggersClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the TriggersClient.NewListByDataBoxEdgeDevicePager
// method.
type TriggersClientListByDataBoxEdgeDeviceOptions struct {
	// Specify $filter='CustomContextTag eq ' to filter on custom context tag property
	Filter *string
}

// UpdateDownloadProgress - Details about the download progress of update.
type UpdateDownloadProgress struct {
	// READ-ONLY; The download phase.
	DownloadPhase *DownloadPhase `json:"downloadPhase,omitempty" azure:"ro"`

	// READ-ONLY; Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32 `json:"numberOfUpdatesDownloaded,omitempty" azure:"ro"`

	// READ-ONLY; Number of updates to download.
	NumberOfUpdatesToDownload *int32 `json:"numberOfUpdatesToDownload,omitempty" azure:"ro"`

	// READ-ONLY; Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; Total bytes downloaded.
	TotalBytesDownloaded *float64 `json:"totalBytesDownloaded,omitempty" azure:"ro"`

	// READ-ONLY; Total bytes to download.
	TotalBytesToDownload *float64 `json:"totalBytesToDownload,omitempty" azure:"ro"`
}

// UpdateInstallProgress - Progress details during installation of updates.
type UpdateInstallProgress struct {
	// READ-ONLY; Number of updates installed.
	NumberOfUpdatesInstalled *int32 `json:"numberOfUpdatesInstalled,omitempty" azure:"ro"`

	// READ-ONLY; Number of updates to install.
	NumberOfUpdatesToInstall *int32 `json:"numberOfUpdatesToInstall,omitempty" azure:"ro"`

	// READ-ONLY; Percentage completed.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`
}

// UpdateSummary - Details about ongoing updates and availability of updates on the device.
type UpdateSummary struct {
	// The device update information summary.
	Properties *UpdateSummaryProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateSummaryProperties - The device update information summary.
type UpdateSummaryProperties struct {
	// The last time when a scan was done on the device.
	DeviceLastScannedDateTime *time.Time `json:"deviceLastScannedDateTime,omitempty"`

	// The current version of the device in format: 1.2.17312.13.",
	DeviceVersionNumber *string `json:"deviceVersionNumber,omitempty"`

	// The current version of the device in text format.
	FriendlyDeviceVersionName *string `json:"friendlyDeviceVersionName,omitempty"`

	// The time when the last scan job was completed (success/cancelled/failed) on the appliance.
	LastCompletedScanJobDateTime *time.Time `json:"lastCompletedScanJobDateTime,omitempty"`

	// READ-ONLY; The job ID of the download job in progress.
	InProgressDownloadJobID *string `json:"inProgressDownloadJobId,omitempty" azure:"ro"`

	// READ-ONLY; The time when the currently running download (if any) started.
	InProgressDownloadJobStartedDateTime *time.Time `json:"inProgressDownloadJobStartedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The job ID of the install job in progress.
	InProgressInstallJobID *string `json:"inProgressInstallJobId,omitempty" azure:"ro"`

	// READ-ONLY; The time when the currently running install (if any) started.
	InProgressInstallJobStartedDateTime *time.Time `json:"inProgressInstallJobStartedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The time when the last Download job was completed (success/cancelled/failed) on the appliance.
	LastCompletedDownloadJobDateTime *time.Time `json:"lastCompletedDownloadJobDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The time when the last Install job was completed (success/cancelled/failed) on the appliance.
	LastCompletedInstallJobDateTime *time.Time `json:"lastCompletedInstallJobDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The current update operation.
	OngoingUpdateOperation *UpdateOperation `json:"ongoingUpdateOperation,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if updates are available and at least one of the updates needs a reboot.
	RebootBehavior *InstallRebootBehavior `json:"rebootBehavior,omitempty" azure:"ro"`

	// READ-ONLY; The number of updates available for the current device version as per the last device scan.
	TotalNumberOfUpdatesAvailable *int32 `json:"totalNumberOfUpdatesAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The total number of items pending download.
	TotalNumberOfUpdatesPendingDownload *int32 `json:"totalNumberOfUpdatesPendingDownload,omitempty" azure:"ro"`

	// READ-ONLY; The total number of items pending install.
	TotalNumberOfUpdatesPendingInstall *int32 `json:"totalNumberOfUpdatesPendingInstall,omitempty" azure:"ro"`

	// READ-ONLY; The total size of updates available for download in bytes.
	TotalUpdateSizeInBytes *float64 `json:"totalUpdateSizeInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The list of updates available for install.
	UpdateTitles []*string `json:"updateTitles,omitempty" azure:"ro"`
}

// UploadCertificateRequest - The upload certificate request.
type UploadCertificateRequest struct {
	// REQUIRED; The Base 64 encoded certificate raw data.
	Properties *RawCertificateData `json:"properties,omitempty"`
}

// UploadCertificateResponse - The upload registration certificate response.
type UploadCertificateResponse struct {
	// Specifies authentication type.
	AuthType *AuthenticationType `json:"authType,omitempty"`

	// READ-ONLY; Identifier of the target resource that is the recipient of the requested token.
	AADAudience *string `json:"aadAudience,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory tenant authority.
	AADAuthority *string `json:"aadAuthority,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory tenant ID.
	AADTenantID *string `json:"aadTenantId,omitempty" azure:"ro"`

	// READ-ONLY; The azure management endpoint audience.
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of the Data Box Edge/Gateway device.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory service principal client ID.
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory service principal object ID.
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty" azure:"ro"`
}

// User - Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
type User struct {
	// REQUIRED; The storage account credential properties.
	Properties *UserProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAccessRight - The mapping between a particular user and the access type on the SMB share.
type UserAccessRight struct {
	// REQUIRED; Type of access to be allowed for the user.
	AccessType *ShareAccessType `json:"accessType,omitempty"`

	// REQUIRED; User ID (already existing in the device).
	UserID *string `json:"userId,omitempty"`
}

// UserList - Collection of users.
type UserList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of users.
	Value []*User `json:"value,omitempty" azure:"ro"`
}

// UserProperties - The user properties.
type UserProperties struct {
	// REQUIRED; Type of the user.
	UserType *UserType `json:"userType,omitempty"`

	// The password details.
	EncryptedPassword *AsymmetricEncryptedSecret `json:"encryptedPassword,omitempty"`

	// List of shares that the user has rights on. This field should not be specified during user creation.
	ShareAccessRights []*ShareAccessRight `json:"shareAccessRights,omitempty"`
}

// UsersClientBeginCreateOrUpdateOptions contains the optional parameters for the UsersClient.BeginCreateOrUpdate method.
type UsersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientBeginDeleteOptions contains the optional parameters for the UsersClient.BeginDelete method.
type UsersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientGetOptions contains the optional parameters for the UsersClient.Get method.
type UsersClientGetOptions struct {
	// placeholder for future optional parameters
}

// UsersClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the UsersClient.NewListByDataBoxEdgeDevicePager
// method.
type UsersClientListByDataBoxEdgeDeviceOptions struct {
	// Specify $filter='UserType eq ' to filter on user type property
	Filter *string
}
