//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

// AccessControlEntryAction - Action object.
type AccessControlEntryAction string

const (
	AccessControlEntryActionPermit AccessControlEntryAction = "Permit"
	AccessControlEntryActionDeny   AccessControlEntryAction = "Deny"
)

// PossibleAccessControlEntryActionValues returns the possible values for the AccessControlEntryAction const type.
func PossibleAccessControlEntryActionValues() []AccessControlEntryAction {
	return []AccessControlEntryAction{
		AccessControlEntryActionPermit,
		AccessControlEntryActionDeny,
	}
}

// AppServicePlanRestrictions - App Service plans this offer is restricted to.
type AppServicePlanRestrictions string

const (
	AppServicePlanRestrictionsNone     AppServicePlanRestrictions = "None"
	AppServicePlanRestrictionsFree     AppServicePlanRestrictions = "Free"
	AppServicePlanRestrictionsShared   AppServicePlanRestrictions = "Shared"
	AppServicePlanRestrictionsBasic    AppServicePlanRestrictions = "Basic"
	AppServicePlanRestrictionsStandard AppServicePlanRestrictions = "Standard"
	AppServicePlanRestrictionsPremium  AppServicePlanRestrictions = "Premium"
)

// PossibleAppServicePlanRestrictionsValues returns the possible values for the AppServicePlanRestrictions const type.
func PossibleAppServicePlanRestrictionsValues() []AppServicePlanRestrictions {
	return []AppServicePlanRestrictions{
		AppServicePlanRestrictionsNone,
		AppServicePlanRestrictionsFree,
		AppServicePlanRestrictionsShared,
		AppServicePlanRestrictionsBasic,
		AppServicePlanRestrictionsStandard,
		AppServicePlanRestrictionsPremium,
	}
}

// AutoHealActionType - Predefined action to be taken.
type AutoHealActionType string

const (
	AutoHealActionTypeRecycle      AutoHealActionType = "Recycle"
	AutoHealActionTypeLogEvent     AutoHealActionType = "LogEvent"
	AutoHealActionTypeCustomAction AutoHealActionType = "CustomAction"
)

// PossibleAutoHealActionTypeValues returns the possible values for the AutoHealActionType const type.
func PossibleAutoHealActionTypeValues() []AutoHealActionType {
	return []AutoHealActionType{
		AutoHealActionTypeRecycle,
		AutoHealActionTypeLogEvent,
		AutoHealActionTypeCustomAction,
	}
}

// AzureResourceType - Azure resource type.
type AzureResourceType string

const (
	AzureResourceTypeWebsite        AzureResourceType = "Website"
	AzureResourceTypeTrafficManager AzureResourceType = "TrafficManager"
)

// PossibleAzureResourceTypeValues returns the possible values for the AzureResourceType const type.
func PossibleAzureResourceTypeValues() []AzureResourceType {
	return []AzureResourceType{
		AzureResourceTypeWebsite,
		AzureResourceTypeTrafficManager,
	}
}

// AzureStorageState - State of the storage account.
type AzureStorageState string

const (
	AzureStorageStateOk                 AzureStorageState = "Ok"
	AzureStorageStateInvalidCredentials AzureStorageState = "InvalidCredentials"
	AzureStorageStateInvalidShare       AzureStorageState = "InvalidShare"
)

// PossibleAzureStorageStateValues returns the possible values for the AzureStorageState const type.
func PossibleAzureStorageStateValues() []AzureStorageState {
	return []AzureStorageState{
		AzureStorageStateOk,
		AzureStorageStateInvalidCredentials,
		AzureStorageStateInvalidShare,
	}
}

// AzureStorageType - Type of storage.
type AzureStorageType string

const (
	AzureStorageTypeAzureFiles AzureStorageType = "AzureFiles"
	AzureStorageTypeAzureBlob  AzureStorageType = "AzureBlob"
)

// PossibleAzureStorageTypeValues returns the possible values for the AzureStorageType const type.
func PossibleAzureStorageTypeValues() []AzureStorageType {
	return []AzureStorageType{
		AzureStorageTypeAzureFiles,
		AzureStorageTypeAzureBlob,
	}
}

// BackupItemStatus - Backup status.
type BackupItemStatus string

const (
	BackupItemStatusInProgress         BackupItemStatus = "InProgress"
	BackupItemStatusFailed             BackupItemStatus = "Failed"
	BackupItemStatusSucceeded          BackupItemStatus = "Succeeded"
	BackupItemStatusTimedOut           BackupItemStatus = "TimedOut"
	BackupItemStatusCreated            BackupItemStatus = "Created"
	BackupItemStatusSkipped            BackupItemStatus = "Skipped"
	BackupItemStatusPartiallySucceeded BackupItemStatus = "PartiallySucceeded"
	BackupItemStatusDeleteInProgress   BackupItemStatus = "DeleteInProgress"
	BackupItemStatusDeleteFailed       BackupItemStatus = "DeleteFailed"
	BackupItemStatusDeleted            BackupItemStatus = "Deleted"
)

// PossibleBackupItemStatusValues returns the possible values for the BackupItemStatus const type.
func PossibleBackupItemStatusValues() []BackupItemStatus {
	return []BackupItemStatus{
		BackupItemStatusInProgress,
		BackupItemStatusFailed,
		BackupItemStatusSucceeded,
		BackupItemStatusTimedOut,
		BackupItemStatusCreated,
		BackupItemStatusSkipped,
		BackupItemStatusPartiallySucceeded,
		BackupItemStatusDeleteInProgress,
		BackupItemStatusDeleteFailed,
		BackupItemStatusDeleted,
	}
}

// BackupRestoreOperationType - Operation type.
type BackupRestoreOperationType string

const (
	BackupRestoreOperationTypeDefault    BackupRestoreOperationType = "Default"
	BackupRestoreOperationTypeClone      BackupRestoreOperationType = "Clone"
	BackupRestoreOperationTypeRelocation BackupRestoreOperationType = "Relocation"
	BackupRestoreOperationTypeSnapshot   BackupRestoreOperationType = "Snapshot"
	BackupRestoreOperationTypeCloudFS    BackupRestoreOperationType = "CloudFS"
)

// PossibleBackupRestoreOperationTypeValues returns the possible values for the BackupRestoreOperationType const type.
func PossibleBackupRestoreOperationTypeValues() []BackupRestoreOperationType {
	return []BackupRestoreOperationType{
		BackupRestoreOperationTypeDefault,
		BackupRestoreOperationTypeClone,
		BackupRestoreOperationTypeRelocation,
		BackupRestoreOperationTypeSnapshot,
		BackupRestoreOperationTypeCloudFS,
	}
}

// BuiltInAuthenticationProvider - The default authentication provider to use when multiple providers are configured. This
// setting is only needed if multiple providers are configured and the unauthenticated client action is set to
// "RedirectToLoginPage".
type BuiltInAuthenticationProvider string

const (
	BuiltInAuthenticationProviderAzureActiveDirectory BuiltInAuthenticationProvider = "AzureActiveDirectory"
	BuiltInAuthenticationProviderFacebook             BuiltInAuthenticationProvider = "Facebook"
	BuiltInAuthenticationProviderGoogle               BuiltInAuthenticationProvider = "Google"
	BuiltInAuthenticationProviderMicrosoftAccount     BuiltInAuthenticationProvider = "MicrosoftAccount"
	BuiltInAuthenticationProviderTwitter              BuiltInAuthenticationProvider = "Twitter"
)

// PossibleBuiltInAuthenticationProviderValues returns the possible values for the BuiltInAuthenticationProvider const type.
func PossibleBuiltInAuthenticationProviderValues() []BuiltInAuthenticationProvider {
	return []BuiltInAuthenticationProvider{
		BuiltInAuthenticationProviderAzureActiveDirectory,
		BuiltInAuthenticationProviderFacebook,
		BuiltInAuthenticationProviderGoogle,
		BuiltInAuthenticationProviderMicrosoftAccount,
		BuiltInAuthenticationProviderTwitter,
	}
}

// Channels - List of channels that this recommendation can apply.
type Channels string

const (
	ChannelsNotification Channels = "Notification"
	ChannelsAPI          Channels = "Api"
	ChannelsEmail        Channels = "Email"
	ChannelsWebhook      Channels = "Webhook"
	ChannelsAll          Channels = "All"
)

// PossibleChannelsValues returns the possible values for the Channels const type.
func PossibleChannelsValues() []Channels {
	return []Channels{
		ChannelsNotification,
		ChannelsAPI,
		ChannelsEmail,
		ChannelsWebhook,
		ChannelsAll,
	}
}

// CheckNameResourceTypes - Resource type used for verification.
type CheckNameResourceTypes string

const (
	CheckNameResourceTypesHostingEnvironment              CheckNameResourceTypes = "HostingEnvironment"
	CheckNameResourceTypesMicrosoftWebHostingEnvironments CheckNameResourceTypes = "Microsoft.Web/hostingEnvironments"
	CheckNameResourceTypesMicrosoftWebPublishingUsers     CheckNameResourceTypes = "Microsoft.Web/publishingUsers"
	CheckNameResourceTypesMicrosoftWebSites               CheckNameResourceTypes = "Microsoft.Web/sites"
	CheckNameResourceTypesMicrosoftWebSitesSlots          CheckNameResourceTypes = "Microsoft.Web/sites/slots"
	CheckNameResourceTypesPublishingUser                  CheckNameResourceTypes = "PublishingUser"
	CheckNameResourceTypesSite                            CheckNameResourceTypes = "Site"
	CheckNameResourceTypesSlot                            CheckNameResourceTypes = "Slot"
)

// PossibleCheckNameResourceTypesValues returns the possible values for the CheckNameResourceTypes const type.
func PossibleCheckNameResourceTypesValues() []CheckNameResourceTypes {
	return []CheckNameResourceTypes{
		CheckNameResourceTypesHostingEnvironment,
		CheckNameResourceTypesMicrosoftWebHostingEnvironments,
		CheckNameResourceTypesMicrosoftWebPublishingUsers,
		CheckNameResourceTypesMicrosoftWebSites,
		CheckNameResourceTypesMicrosoftWebSitesSlots,
		CheckNameResourceTypesPublishingUser,
		CheckNameResourceTypesSite,
		CheckNameResourceTypesSlot,
	}
}

// CloneAbilityResult - Name of app.
type CloneAbilityResult string

const (
	CloneAbilityResultCloneable          CloneAbilityResult = "Cloneable"
	CloneAbilityResultPartiallyCloneable CloneAbilityResult = "PartiallyCloneable"
	CloneAbilityResultNotCloneable       CloneAbilityResult = "NotCloneable"
)

// PossibleCloneAbilityResultValues returns the possible values for the CloneAbilityResult const type.
func PossibleCloneAbilityResultValues() []CloneAbilityResult {
	return []CloneAbilityResult{
		CloneAbilityResultCloneable,
		CloneAbilityResultPartiallyCloneable,
		CloneAbilityResultNotCloneable,
	}
}

// ComputeModeOptions - Shared/dedicated workers.
type ComputeModeOptions string

const (
	ComputeModeOptionsShared    ComputeModeOptions = "Shared"
	ComputeModeOptionsDedicated ComputeModeOptions = "Dedicated"
	ComputeModeOptionsDynamic   ComputeModeOptions = "Dynamic"
)

// PossibleComputeModeOptionsValues returns the possible values for the ComputeModeOptions const type.
func PossibleComputeModeOptionsValues() []ComputeModeOptions {
	return []ComputeModeOptions{
		ComputeModeOptionsShared,
		ComputeModeOptionsDedicated,
		ComputeModeOptionsDynamic,
	}
}

// ConnectionStringType - Type of database.
type ConnectionStringType string

const (
	ConnectionStringTypeMySQL           ConnectionStringType = "MySql"
	ConnectionStringTypeSQLServer       ConnectionStringType = "SQLServer"
	ConnectionStringTypeSQLAzure        ConnectionStringType = "SQLAzure"
	ConnectionStringTypeCustom          ConnectionStringType = "Custom"
	ConnectionStringTypeNotificationHub ConnectionStringType = "NotificationHub"
	ConnectionStringTypeServiceBus      ConnectionStringType = "ServiceBus"
	ConnectionStringTypeEventHub        ConnectionStringType = "EventHub"
	ConnectionStringTypeAPIHub          ConnectionStringType = "ApiHub"
	ConnectionStringTypeDocDb           ConnectionStringType = "DocDb"
	ConnectionStringTypeRedisCache      ConnectionStringType = "RedisCache"
	ConnectionStringTypePostgreSQL      ConnectionStringType = "PostgreSQL"
)

// PossibleConnectionStringTypeValues returns the possible values for the ConnectionStringType const type.
func PossibleConnectionStringTypeValues() []ConnectionStringType {
	return []ConnectionStringType{
		ConnectionStringTypeMySQL,
		ConnectionStringTypeSQLServer,
		ConnectionStringTypeSQLAzure,
		ConnectionStringTypeCustom,
		ConnectionStringTypeNotificationHub,
		ConnectionStringTypeServiceBus,
		ConnectionStringTypeEventHub,
		ConnectionStringTypeAPIHub,
		ConnectionStringTypeDocDb,
		ConnectionStringTypeRedisCache,
		ConnectionStringTypePostgreSQL,
	}
}

// ContinuousWebJobStatus - Job status.
type ContinuousWebJobStatus string

const (
	ContinuousWebJobStatusInitializing   ContinuousWebJobStatus = "Initializing"
	ContinuousWebJobStatusStarting       ContinuousWebJobStatus = "Starting"
	ContinuousWebJobStatusRunning        ContinuousWebJobStatus = "Running"
	ContinuousWebJobStatusPendingRestart ContinuousWebJobStatus = "PendingRestart"
	ContinuousWebJobStatusStopped        ContinuousWebJobStatus = "Stopped"
)

// PossibleContinuousWebJobStatusValues returns the possible values for the ContinuousWebJobStatus const type.
func PossibleContinuousWebJobStatusValues() []ContinuousWebJobStatus {
	return []ContinuousWebJobStatus{
		ContinuousWebJobStatusInitializing,
		ContinuousWebJobStatusStarting,
		ContinuousWebJobStatusRunning,
		ContinuousWebJobStatusPendingRestart,
		ContinuousWebJobStatusStopped,
	}
}

// CustomHostNameDNSRecordType - Custom DNS record type.
type CustomHostNameDNSRecordType string

const (
	CustomHostNameDNSRecordTypeCName CustomHostNameDNSRecordType = "CName"
	CustomHostNameDNSRecordTypeA     CustomHostNameDNSRecordType = "A"
)

// PossibleCustomHostNameDNSRecordTypeValues returns the possible values for the CustomHostNameDNSRecordType const type.
func PossibleCustomHostNameDNSRecordTypeValues() []CustomHostNameDNSRecordType {
	return []CustomHostNameDNSRecordType{
		CustomHostNameDNSRecordTypeCName,
		CustomHostNameDNSRecordTypeA,
	}
}

// DNSVerificationTestResult - DNS verification test result.
type DNSVerificationTestResult string

const (
	DNSVerificationTestResultPassed  DNSVerificationTestResult = "Passed"
	DNSVerificationTestResultFailed  DNSVerificationTestResult = "Failed"
	DNSVerificationTestResultSkipped DNSVerificationTestResult = "Skipped"
)

// PossibleDNSVerificationTestResultValues returns the possible values for the DNSVerificationTestResult const type.
func PossibleDNSVerificationTestResultValues() []DNSVerificationTestResult {
	return []DNSVerificationTestResult{
		DNSVerificationTestResultPassed,
		DNSVerificationTestResultFailed,
		DNSVerificationTestResultSkipped,
	}
}

// DatabaseType - Database type (e.g. SqlAzure / MySql).
type DatabaseType string

const (
	DatabaseTypeLocalMySQL DatabaseType = "LocalMySql"
	DatabaseTypeMySQL      DatabaseType = "MySql"
	DatabaseTypePostgreSQL DatabaseType = "PostgreSql"
	DatabaseTypeSQLAzure   DatabaseType = "SqlAzure"
)

// PossibleDatabaseTypeValues returns the possible values for the DatabaseType const type.
func PossibleDatabaseTypeValues() []DatabaseType {
	return []DatabaseType{
		DatabaseTypeLocalMySQL,
		DatabaseTypeMySQL,
		DatabaseTypePostgreSQL,
		DatabaseTypeSQLAzure,
	}
}

type Enum11 string

const (
	Enum11Linux            Enum11 = "Linux"
	Enum11LinuxFunctions   Enum11 = "LinuxFunctions"
	Enum11Windows          Enum11 = "Windows"
	Enum11WindowsFunctions Enum11 = "WindowsFunctions"
)

// PossibleEnum11Values returns the possible values for the Enum11 const type.
func PossibleEnum11Values() []Enum11 {
	return []Enum11{
		Enum11Linux,
		Enum11LinuxFunctions,
		Enum11Windows,
		Enum11WindowsFunctions,
	}
}

type Enum12 string

const (
	Enum12Linux            Enum12 = "Linux"
	Enum12LinuxFunctions   Enum12 = "LinuxFunctions"
	Enum12Windows          Enum12 = "Windows"
	Enum12WindowsFunctions Enum12 = "WindowsFunctions"
)

// PossibleEnum12Values returns the possible values for the Enum12 const type.
func PossibleEnum12Values() []Enum12 {
	return []Enum12{
		Enum12Linux,
		Enum12LinuxFunctions,
		Enum12Windows,
		Enum12WindowsFunctions,
	}
}

// FrequencyUnit - The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set
// to Day and FrequencyInterval should be set to 7)
type FrequencyUnit string

const (
	FrequencyUnitDay  FrequencyUnit = "Day"
	FrequencyUnitHour FrequencyUnit = "Hour"
)

// PossibleFrequencyUnitValues returns the possible values for the FrequencyUnit const type.
func PossibleFrequencyUnitValues() []FrequencyUnit {
	return []FrequencyUnit{
		FrequencyUnitDay,
		FrequencyUnitHour,
	}
}

// FtpsState - State of FTP / FTPS service
type FtpsState string

const (
	FtpsStateAllAllowed FtpsState = "AllAllowed"
	FtpsStateDisabled   FtpsState = "Disabled"
	FtpsStateFtpsOnly   FtpsState = "FtpsOnly"
)

// PossibleFtpsStateValues returns the possible values for the FtpsState const type.
func PossibleFtpsStateValues() []FtpsState {
	return []FtpsState{
		FtpsStateAllAllowed,
		FtpsStateDisabled,
		FtpsStateFtpsOnly,
	}
}

// HostNameType - Hostname type.
type HostNameType string

const (
	HostNameTypeVerified HostNameType = "Verified"
	HostNameTypeManaged  HostNameType = "Managed"
)

// PossibleHostNameTypeValues returns the possible values for the HostNameType const type.
func PossibleHostNameTypeValues() []HostNameType {
	return []HostNameType{
		HostNameTypeVerified,
		HostNameTypeManaged,
	}
}

// HostType - Indicates whether the hostname is a standard or repository hostname.
type HostType string

const (
	HostTypeStandard   HostType = "Standard"
	HostTypeRepository HostType = "Repository"
)

// PossibleHostTypeValues returns the possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{
		HostTypeStandard,
		HostTypeRepository,
	}
}

// HostingEnvironmentStatus - Current status of the App Service Environment.
type HostingEnvironmentStatus string

const (
	HostingEnvironmentStatusPreparing HostingEnvironmentStatus = "Preparing"
	HostingEnvironmentStatusReady     HostingEnvironmentStatus = "Ready"
	HostingEnvironmentStatusScaling   HostingEnvironmentStatus = "Scaling"
	HostingEnvironmentStatusDeleting  HostingEnvironmentStatus = "Deleting"
)

// PossibleHostingEnvironmentStatusValues returns the possible values for the HostingEnvironmentStatus const type.
func PossibleHostingEnvironmentStatusValues() []HostingEnvironmentStatus {
	return []HostingEnvironmentStatus{
		HostingEnvironmentStatusPreparing,
		HostingEnvironmentStatusReady,
		HostingEnvironmentStatusScaling,
		HostingEnvironmentStatusDeleting,
	}
}

// IPFilterTag - Defines what this IP filter will be used for. This is to support IP filtering on proxies.
type IPFilterTag string

const (
	IPFilterTagDefault  IPFilterTag = "Default"
	IPFilterTagXffProxy IPFilterTag = "XffProxy"
)

// PossibleIPFilterTagValues returns the possible values for the IPFilterTag const type.
func PossibleIPFilterTagValues() []IPFilterTag {
	return []IPFilterTag{
		IPFilterTagDefault,
		IPFilterTagXffProxy,
	}
}

// InAvailabilityReasonType - Invalid indicates the name provided does not match Azure App Service naming requirements. AlreadyExists
// indicates that the name is already in use and is therefore unavailable.
type InAvailabilityReasonType string

const (
	InAvailabilityReasonTypeAlreadyExists InAvailabilityReasonType = "AlreadyExists"
	InAvailabilityReasonTypeInvalid       InAvailabilityReasonType = "Invalid"
)

// PossibleInAvailabilityReasonTypeValues returns the possible values for the InAvailabilityReasonType const type.
func PossibleInAvailabilityReasonTypeValues() []InAvailabilityReasonType {
	return []InAvailabilityReasonType{
		InAvailabilityReasonTypeAlreadyExists,
		InAvailabilityReasonTypeInvalid,
	}
}

// InternalLoadBalancingMode - Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
type InternalLoadBalancingMode string

const (
	InternalLoadBalancingModeNone       InternalLoadBalancingMode = "None"
	InternalLoadBalancingModeWeb        InternalLoadBalancingMode = "Web"
	InternalLoadBalancingModePublishing InternalLoadBalancingMode = "Publishing"
)

// PossibleInternalLoadBalancingModeValues returns the possible values for the InternalLoadBalancingMode const type.
func PossibleInternalLoadBalancingModeValues() []InternalLoadBalancingMode {
	return []InternalLoadBalancingMode{
		InternalLoadBalancingModeNone,
		InternalLoadBalancingModeWeb,
		InternalLoadBalancingModePublishing,
	}
}

// KeyVaultSecretStatus - Status of the Key Vault secret.
type KeyVaultSecretStatus string

const (
	KeyVaultSecretStatusInitialized                              KeyVaultSecretStatus = "Initialized"
	KeyVaultSecretStatusWaitingOnCertificateOrder                KeyVaultSecretStatus = "WaitingOnCertificateOrder"
	KeyVaultSecretStatusSucceeded                                KeyVaultSecretStatus = "Succeeded"
	KeyVaultSecretStatusCertificateOrderFailed                   KeyVaultSecretStatus = "CertificateOrderFailed"
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault          KeyVaultSecretStatus = "OperationNotPermittedOnKeyVault"
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = "AzureServiceUnauthorizedToAccessKeyVault"
	KeyVaultSecretStatusKeyVaultDoesNotExist                     KeyVaultSecretStatus = "KeyVaultDoesNotExist"
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist               KeyVaultSecretStatus = "KeyVaultSecretDoesNotExist"
	KeyVaultSecretStatusUnknownError                             KeyVaultSecretStatus = "UnknownError"
	KeyVaultSecretStatusExternalPrivateKey                       KeyVaultSecretStatus = "ExternalPrivateKey"
	KeyVaultSecretStatusUnknown                                  KeyVaultSecretStatus = "Unknown"
)

// PossibleKeyVaultSecretStatusValues returns the possible values for the KeyVaultSecretStatus const type.
func PossibleKeyVaultSecretStatusValues() []KeyVaultSecretStatus {
	return []KeyVaultSecretStatus{
		KeyVaultSecretStatusInitialized,
		KeyVaultSecretStatusWaitingOnCertificateOrder,
		KeyVaultSecretStatusSucceeded,
		KeyVaultSecretStatusCertificateOrderFailed,
		KeyVaultSecretStatusOperationNotPermittedOnKeyVault,
		KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault,
		KeyVaultSecretStatusKeyVaultDoesNotExist,
		KeyVaultSecretStatusKeyVaultSecretDoesNotExist,
		KeyVaultSecretStatusUnknownError,
		KeyVaultSecretStatusExternalPrivateKey,
		KeyVaultSecretStatusUnknown,
	}
}

// LogLevel - Log level.
type LogLevel string

const (
	LogLevelOff         LogLevel = "Off"
	LogLevelVerbose     LogLevel = "Verbose"
	LogLevelInformation LogLevel = "Information"
	LogLevelWarning     LogLevel = "Warning"
	LogLevelError       LogLevel = "Error"
)

// PossibleLogLevelValues returns the possible values for the LogLevel const type.
func PossibleLogLevelValues() []LogLevel {
	return []LogLevel{
		LogLevelOff,
		LogLevelVerbose,
		LogLevelInformation,
		LogLevelWarning,
		LogLevelError,
	}
}

// MSDeployLogEntryType - Log entry type
type MSDeployLogEntryType string

const (
	MSDeployLogEntryTypeMessage MSDeployLogEntryType = "Message"
	MSDeployLogEntryTypeWarning MSDeployLogEntryType = "Warning"
	MSDeployLogEntryTypeError   MSDeployLogEntryType = "Error"
)

// PossibleMSDeployLogEntryTypeValues returns the possible values for the MSDeployLogEntryType const type.
func PossibleMSDeployLogEntryTypeValues() []MSDeployLogEntryType {
	return []MSDeployLogEntryType{
		MSDeployLogEntryTypeMessage,
		MSDeployLogEntryTypeWarning,
		MSDeployLogEntryTypeError,
	}
}

// MSDeployProvisioningState - Provisioning state
type MSDeployProvisioningState string

const (
	MSDeployProvisioningStateAccepted  MSDeployProvisioningState = "accepted"
	MSDeployProvisioningStateRunning   MSDeployProvisioningState = "running"
	MSDeployProvisioningStateSucceeded MSDeployProvisioningState = "succeeded"
	MSDeployProvisioningStateFailed    MSDeployProvisioningState = "failed"
	MSDeployProvisioningStateCanceled  MSDeployProvisioningState = "canceled"
)

// PossibleMSDeployProvisioningStateValues returns the possible values for the MSDeployProvisioningState const type.
func PossibleMSDeployProvisioningStateValues() []MSDeployProvisioningState {
	return []MSDeployProvisioningState{
		MSDeployProvisioningStateAccepted,
		MSDeployProvisioningStateRunning,
		MSDeployProvisioningStateSucceeded,
		MSDeployProvisioningStateFailed,
		MSDeployProvisioningStateCanceled,
	}
}

// ManagedPipelineMode - Managed pipeline mode.
type ManagedPipelineMode string

const (
	ManagedPipelineModeIntegrated ManagedPipelineMode = "Integrated"
	ManagedPipelineModeClassic    ManagedPipelineMode = "Classic"
)

// PossibleManagedPipelineModeValues returns the possible values for the ManagedPipelineMode const type.
func PossibleManagedPipelineModeValues() []ManagedPipelineMode {
	return []ManagedPipelineMode{
		ManagedPipelineModeIntegrated,
		ManagedPipelineModeClassic,
	}
}

// ManagedServiceIdentityType - Type of managed service identity.
type ManagedServiceIdentityType string

const (
	ManagedServiceIdentityTypeNone                       ManagedServiceIdentityType = "None"
	ManagedServiceIdentityTypeSystemAssigned             ManagedServiceIdentityType = "SystemAssigned"
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = "SystemAssigned, UserAssigned"
	ManagedServiceIdentityTypeUserAssigned               ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns the possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{
		ManagedServiceIdentityTypeNone,
		ManagedServiceIdentityTypeSystemAssigned,
		ManagedServiceIdentityTypeSystemAssignedUserAssigned,
		ManagedServiceIdentityTypeUserAssigned,
	}
}

// MySQLMigrationType - The type of migration operation to be done
type MySQLMigrationType string

const (
	MySQLMigrationTypeLocalToRemote MySQLMigrationType = "LocalToRemote"
	MySQLMigrationTypeRemoteToLocal MySQLMigrationType = "RemoteToLocal"
)

// PossibleMySQLMigrationTypeValues returns the possible values for the MySQLMigrationType const type.
func PossibleMySQLMigrationTypeValues() []MySQLMigrationType {
	return []MySQLMigrationType{
		MySQLMigrationTypeLocalToRemote,
		MySQLMigrationTypeRemoteToLocal,
	}
}

// NotificationLevel - Level indicating how critical this recommendation can impact.
type NotificationLevel string

const (
	NotificationLevelCritical            NotificationLevel = "Critical"
	NotificationLevelWarning             NotificationLevel = "Warning"
	NotificationLevelInformation         NotificationLevel = "Information"
	NotificationLevelNonUrgentSuggestion NotificationLevel = "NonUrgentSuggestion"
)

// PossibleNotificationLevelValues returns the possible values for the NotificationLevel const type.
func PossibleNotificationLevelValues() []NotificationLevel {
	return []NotificationLevel{
		NotificationLevelCritical,
		NotificationLevelWarning,
		NotificationLevelInformation,
		NotificationLevelNonUrgentSuggestion,
	}
}

// OperationStatus - Status of the migration task.
type OperationStatus string

const (
	OperationStatusInProgress OperationStatus = "InProgress"
	OperationStatusFailed     OperationStatus = "Failed"
	OperationStatusSucceeded  OperationStatus = "Succeeded"
	OperationStatusTimedOut   OperationStatus = "TimedOut"
	OperationStatusCreated    OperationStatus = "Created"
)

// PossibleOperationStatusValues returns the possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{
		OperationStatusInProgress,
		OperationStatusFailed,
		OperationStatusSucceeded,
		OperationStatusTimedOut,
		OperationStatusCreated,
	}
}

// ProvisioningState - Provisioning state of the App Service Environment.
type ProvisioningState string

const (
	ProvisioningStateSucceeded  ProvisioningState = "Succeeded"
	ProvisioningStateFailed     ProvisioningState = "Failed"
	ProvisioningStateCanceled   ProvisioningState = "Canceled"
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	ProvisioningStateDeleting   ProvisioningState = "Deleting"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateSucceeded,
		ProvisioningStateFailed,
		ProvisioningStateCanceled,
		ProvisioningStateInProgress,
		ProvisioningStateDeleting,
	}
}

// PublicCertificateLocation - Public Certificate Location
type PublicCertificateLocation string

const (
	PublicCertificateLocationCurrentUserMy  PublicCertificateLocation = "CurrentUserMy"
	PublicCertificateLocationLocalMachineMy PublicCertificateLocation = "LocalMachineMy"
	PublicCertificateLocationUnknown        PublicCertificateLocation = "Unknown"
)

// PossiblePublicCertificateLocationValues returns the possible values for the PublicCertificateLocation const type.
func PossiblePublicCertificateLocationValues() []PublicCertificateLocation {
	return []PublicCertificateLocation{
		PublicCertificateLocationCurrentUserMy,
		PublicCertificateLocationLocalMachineMy,
		PublicCertificateLocationUnknown,
	}
}

// PublishingProfileFormat - Name of the format. Valid values are: FileZilla3 WebDeploy -- default Ftp
type PublishingProfileFormat string

const (
	PublishingProfileFormatFileZilla3 PublishingProfileFormat = "FileZilla3"
	PublishingProfileFormatFtp        PublishingProfileFormat = "Ftp"
	PublishingProfileFormatWebDeploy  PublishingProfileFormat = "WebDeploy"
)

// PossiblePublishingProfileFormatValues returns the possible values for the PublishingProfileFormat const type.
func PossiblePublishingProfileFormatValues() []PublishingProfileFormat {
	return []PublishingProfileFormat{
		PublishingProfileFormatFileZilla3,
		PublishingProfileFormatFtp,
		PublishingProfileFormatWebDeploy,
	}
}

// RedundancyMode - Site redundancy mode
type RedundancyMode string

const (
	RedundancyModeNone         RedundancyMode = "None"
	RedundancyModeManual       RedundancyMode = "Manual"
	RedundancyModeFailover     RedundancyMode = "Failover"
	RedundancyModeActiveActive RedundancyMode = "ActiveActive"
	RedundancyModeGeoRedundant RedundancyMode = "GeoRedundant"
)

// PossibleRedundancyModeValues returns the possible values for the RedundancyMode const type.
func PossibleRedundancyModeValues() []RedundancyMode {
	return []RedundancyMode{
		RedundancyModeNone,
		RedundancyModeManual,
		RedundancyModeFailover,
		RedundancyModeActiveActive,
		RedundancyModeGeoRedundant,
	}
}

// ResourceScopeType - Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site.
type ResourceScopeType string

const (
	ResourceScopeTypeServerFarm   ResourceScopeType = "ServerFarm"
	ResourceScopeTypeSubscription ResourceScopeType = "Subscription"
	ResourceScopeTypeWebSite      ResourceScopeType = "WebSite"
)

// PossibleResourceScopeTypeValues returns the possible values for the ResourceScopeType const type.
func PossibleResourceScopeTypeValues() []ResourceScopeType {
	return []ResourceScopeType{
		ResourceScopeTypeServerFarm,
		ResourceScopeTypeSubscription,
		ResourceScopeTypeWebSite,
	}
}

// RouteType - The type of route this is: DEFAULT - By default, every app has routes to the local address ranges specified
// by RFC1918 INHERITED - Routes inherited from the real Virtual Network routes STATIC - Static
// route set on the app only
// These values will be used for syncing an app's routes with those from a Virtual Network.
type RouteType string

const (
	RouteTypeDEFAULT   RouteType = "DEFAULT"
	RouteTypeINHERITED RouteType = "INHERITED"
	RouteTypeSTATIC    RouteType = "STATIC"
)

// PossibleRouteTypeValues returns the possible values for the RouteType const type.
func PossibleRouteTypeValues() []RouteType {
	return []RouteType{
		RouteTypeDEFAULT,
		RouteTypeINHERITED,
		RouteTypeSTATIC,
	}
}

type SKUName string

const (
	SKUNameBasic           SKUName = "Basic"
	SKUNameDynamic         SKUName = "Dynamic"
	SKUNameElasticIsolated SKUName = "ElasticIsolated"
	SKUNameElasticPremium  SKUName = "ElasticPremium"
	SKUNameFree            SKUName = "Free"
	SKUNameIsolated        SKUName = "Isolated"
	SKUNamePremium         SKUName = "Premium"
	SKUNamePremiumV2       SKUName = "PremiumV2"
	SKUNameShared          SKUName = "Shared"
	SKUNameStandard        SKUName = "Standard"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameBasic,
		SKUNameDynamic,
		SKUNameElasticIsolated,
		SKUNameElasticPremium,
		SKUNameFree,
		SKUNameIsolated,
		SKUNamePremium,
		SKUNamePremiumV2,
		SKUNameShared,
		SKUNameStandard,
	}
}

// SSLState - SSL type
type SSLState string

const (
	SSLStateDisabled       SSLState = "Disabled"
	SSLStateSniEnabled     SSLState = "SniEnabled"
	SSLStateIPBasedEnabled SSLState = "IpBasedEnabled"
)

// PossibleSSLStateValues returns the possible values for the SSLState const type.
func PossibleSSLStateValues() []SSLState {
	return []SSLState{
		SSLStateDisabled,
		SSLStateSniEnabled,
		SSLStateIPBasedEnabled,
	}
}

// ScmType - SCM type.
type ScmType string

const (
	ScmTypeBitbucketGit ScmType = "BitbucketGit"
	ScmTypeBitbucketHg  ScmType = "BitbucketHg"
	ScmTypeCodePlexGit  ScmType = "CodePlexGit"
	ScmTypeCodePlexHg   ScmType = "CodePlexHg"
	ScmTypeDropbox      ScmType = "Dropbox"
	ScmTypeExternalGit  ScmType = "ExternalGit"
	ScmTypeExternalHg   ScmType = "ExternalHg"
	ScmTypeGitHub       ScmType = "GitHub"
	ScmTypeLocalGit     ScmType = "LocalGit"
	ScmTypeNone         ScmType = "None"
	ScmTypeOneDrive     ScmType = "OneDrive"
	ScmTypeTfs          ScmType = "Tfs"
	ScmTypeVSO          ScmType = "VSO"
)

// PossibleScmTypeValues returns the possible values for the ScmType const type.
func PossibleScmTypeValues() []ScmType {
	return []ScmType{
		ScmTypeBitbucketGit,
		ScmTypeBitbucketHg,
		ScmTypeCodePlexGit,
		ScmTypeCodePlexHg,
		ScmTypeDropbox,
		ScmTypeExternalGit,
		ScmTypeExternalHg,
		ScmTypeGitHub,
		ScmTypeLocalGit,
		ScmTypeNone,
		ScmTypeOneDrive,
		ScmTypeTfs,
		ScmTypeVSO,
	}
}

// SiteAvailabilityState - Management information availability state for the app.
type SiteAvailabilityState string

const (
	SiteAvailabilityStateNormal               SiteAvailabilityState = "Normal"
	SiteAvailabilityStateLimited              SiteAvailabilityState = "Limited"
	SiteAvailabilityStateDisasterRecoveryMode SiteAvailabilityState = "DisasterRecoveryMode"
)

// PossibleSiteAvailabilityStateValues returns the possible values for the SiteAvailabilityState const type.
func PossibleSiteAvailabilityStateValues() []SiteAvailabilityState {
	return []SiteAvailabilityState{
		SiteAvailabilityStateNormal,
		SiteAvailabilityStateLimited,
		SiteAvailabilityStateDisasterRecoveryMode,
	}
}

// SiteExtensionType - Site extension type.
type SiteExtensionType string

const (
	SiteExtensionTypeGallery SiteExtensionType = "Gallery"
	SiteExtensionTypeWebRoot SiteExtensionType = "WebRoot"
)

// PossibleSiteExtensionTypeValues returns the possible values for the SiteExtensionType const type.
func PossibleSiteExtensionTypeValues() []SiteExtensionType {
	return []SiteExtensionType{
		SiteExtensionTypeGallery,
		SiteExtensionTypeWebRoot,
	}
}

// SiteLoadBalancing - Site load balancing.
type SiteLoadBalancing string

const (
	SiteLoadBalancingWeightedRoundRobin   SiteLoadBalancing = "WeightedRoundRobin"
	SiteLoadBalancingLeastRequests        SiteLoadBalancing = "LeastRequests"
	SiteLoadBalancingLeastResponseTime    SiteLoadBalancing = "LeastResponseTime"
	SiteLoadBalancingWeightedTotalTraffic SiteLoadBalancing = "WeightedTotalTraffic"
	SiteLoadBalancingRequestHash          SiteLoadBalancing = "RequestHash"
)

// PossibleSiteLoadBalancingValues returns the possible values for the SiteLoadBalancing const type.
func PossibleSiteLoadBalancingValues() []SiteLoadBalancing {
	return []SiteLoadBalancing{
		SiteLoadBalancingWeightedRoundRobin,
		SiteLoadBalancingLeastRequests,
		SiteLoadBalancingLeastResponseTime,
		SiteLoadBalancingWeightedTotalTraffic,
		SiteLoadBalancingRequestHash,
	}
}

// StatusOptions - App Service plan status.
type StatusOptions string

const (
	StatusOptionsReady    StatusOptions = "Ready"
	StatusOptionsPending  StatusOptions = "Pending"
	StatusOptionsCreating StatusOptions = "Creating"
)

// PossibleStatusOptionsValues returns the possible values for the StatusOptions const type.
func PossibleStatusOptionsValues() []StatusOptions {
	return []StatusOptions{
		StatusOptionsReady,
		StatusOptionsPending,
		StatusOptionsCreating,
	}
}

// SupportedTLSVersions - MinTlsVersion: configures the minimum version of TLS required for SSL requests
type SupportedTLSVersions string

const (
	SupportedTLSVersionsOne0 SupportedTLSVersions = "1.0"
	SupportedTLSVersionsOne1 SupportedTLSVersions = "1.1"
	SupportedTLSVersionsOne2 SupportedTLSVersions = "1.2"
)

// PossibleSupportedTLSVersionsValues returns the possible values for the SupportedTLSVersions const type.
func PossibleSupportedTLSVersionsValues() []SupportedTLSVersions {
	return []SupportedTLSVersions{
		SupportedTLSVersionsOne0,
		SupportedTLSVersionsOne1,
		SupportedTLSVersionsOne2,
	}
}

// TriggeredWebJobStatus - Job status.
type TriggeredWebJobStatus string

const (
	TriggeredWebJobStatusSuccess TriggeredWebJobStatus = "Success"
	TriggeredWebJobStatusFailed  TriggeredWebJobStatus = "Failed"
	TriggeredWebJobStatusError   TriggeredWebJobStatus = "Error"
)

// PossibleTriggeredWebJobStatusValues returns the possible values for the TriggeredWebJobStatus const type.
func PossibleTriggeredWebJobStatusValues() []TriggeredWebJobStatus {
	return []TriggeredWebJobStatus{
		TriggeredWebJobStatusSuccess,
		TriggeredWebJobStatusFailed,
		TriggeredWebJobStatusError,
	}
}

// UnauthenticatedClientAction - The action to take when an unauthenticated client attempts to access the app.
type UnauthenticatedClientAction string

const (
	UnauthenticatedClientActionRedirectToLoginPage UnauthenticatedClientAction = "RedirectToLoginPage"
	UnauthenticatedClientActionAllowAnonymous      UnauthenticatedClientAction = "AllowAnonymous"
)

// PossibleUnauthenticatedClientActionValues returns the possible values for the UnauthenticatedClientAction const type.
func PossibleUnauthenticatedClientActionValues() []UnauthenticatedClientAction {
	return []UnauthenticatedClientAction{
		UnauthenticatedClientActionRedirectToLoginPage,
		UnauthenticatedClientActionAllowAnonymous,
	}
}

// UsageState - State indicating whether the app has exceeded its quota usage. Read-only.
type UsageState string

const (
	UsageStateNormal   UsageState = "Normal"
	UsageStateExceeded UsageState = "Exceeded"
)

// PossibleUsageStateValues returns the possible values for the UsageState const type.
func PossibleUsageStateValues() []UsageState {
	return []UsageState{
		UsageStateNormal,
		UsageStateExceeded,
	}
}

// ValidateResourceTypes - Resource type used for verification.
type ValidateResourceTypes string

const (
	ValidateResourceTypesServerFarm ValidateResourceTypes = "ServerFarm"
	ValidateResourceTypesSite       ValidateResourceTypes = "Site"
)

// PossibleValidateResourceTypesValues returns the possible values for the ValidateResourceTypes const type.
func PossibleValidateResourceTypesValues() []ValidateResourceTypes {
	return []ValidateResourceTypes{
		ValidateResourceTypesServerFarm,
		ValidateResourceTypesSite,
	}
}

// WebJobType - Job type.
type WebJobType string

const (
	WebJobTypeContinuous WebJobType = "Continuous"
	WebJobTypeTriggered  WebJobType = "Triggered"
)

// PossibleWebJobTypeValues returns the possible values for the WebJobType const type.
func PossibleWebJobTypeValues() []WebJobType {
	return []WebJobType{
		WebJobTypeContinuous,
		WebJobTypeTriggered,
	}
}

// WorkerSizeOptions - Size of the machines.
type WorkerSizeOptions string

const (
	WorkerSizeOptionsSmall   WorkerSizeOptions = "Small"
	WorkerSizeOptionsMedium  WorkerSizeOptions = "Medium"
	WorkerSizeOptionsLarge   WorkerSizeOptions = "Large"
	WorkerSizeOptionsD1      WorkerSizeOptions = "D1"
	WorkerSizeOptionsD2      WorkerSizeOptions = "D2"
	WorkerSizeOptionsD3      WorkerSizeOptions = "D3"
	WorkerSizeOptionsDefault WorkerSizeOptions = "Default"
)

// PossibleWorkerSizeOptionsValues returns the possible values for the WorkerSizeOptions const type.
func PossibleWorkerSizeOptionsValues() []WorkerSizeOptions {
	return []WorkerSizeOptions{
		WorkerSizeOptionsSmall,
		WorkerSizeOptionsMedium,
		WorkerSizeOptionsLarge,
		WorkerSizeOptionsD1,
		WorkerSizeOptionsD2,
		WorkerSizeOptionsD3,
		WorkerSizeOptionsDefault,
	}
}
