!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module mrtcal_user_feedback_tool
  use gbl_message
  !
  public :: user_feedback_t,user_feedback_format_onedouble
  public :: code_color_default
  public :: code_color_red
  public :: code_color_orange
  public :: code_color_green
  private
  !
  integer(kind=4), parameter :: code_color_default=0
  integer(kind=4), parameter :: code_color_red=1
  integer(kind=4), parameter :: code_color_orange=2
  integer(kind=4), parameter :: code_color_green=3
  !
  type user_feedback_t
     integer(kind=4)                            :: n = 0
     real(kind=8),                  allocatable :: freq(:)
     character(len=5),              allocatable :: idfe(:)
     integer(kind=4),               allocatable :: idx(:)
     real(kind=4),                  allocatable :: quadrant(:)
     character(len=message_length), allocatable :: result(:)
     integer(kind=4),               allocatable :: color(:)
   contains
     procedure, public  :: allocate_and_init           => user_feedback_allocate_and_init
     procedure, public  :: sort_by_freq_idfe           => user_feedback_sort_by_freq_idfe
     procedure, public  :: sort_by_freq_direction_idfe => user_feedback_sort_by_freq_direction_idfe
     generic,   public  :: fill                        => fill_idfe_freq,fill_idfe_freq_angle
     procedure, private :: fill_idfe_freq              => user_feedback_fill_idfe_freq
     procedure, private :: fill_idfe_freq_angle        => user_feedback_fill_idfe_freq_angle
     procedure, public  :: list                        => user_feedback_list
     procedure, public  :: tofile                      => user_feedback_tofile
  end type user_feedback_t
  !
contains
  !
  subroutine user_feedback_allocate_and_init(user,n,error)
    use gkernel_interfaces
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    class(user_feedback_t), intent(inout) :: user
    integer(kind=4),        intent(in)    :: n
    logical,                intent(inout) :: error
    !
    integer(kind=4) :: ier,iuser
    character(len=*), parameter :: rname='USER>FEEDBACK>ALLOCATE>AND>INIT'
    !
    allocate(user%idx(n),user%freq(n),user%idfe(n), &
             user%quadrant(n),user%result(n),user%color(n),stat=ier)
    if (failed_allocate(rname,'Result arrays',ier,error)) return
    ! Success => initialize
    user%n = n
    do iuser=1,user%n
       user%idx(iuser) = iuser
    enddo ! iuser
  end subroutine user_feedback_allocate_and_init
  !
  subroutine user_feedback_sort_by_freq_idfe(user,error)
    use gkernel_interfaces
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    class(user_feedback_t), intent(inout) :: user
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='USER>FEEDBACK>SORT>BY>FREQ>IDFE'
    !
    call gi4_quicksort_index_with_user_gtge(user%idx,user%n,&
         feedback_gt,feedback_ge,error)
    if (error) return
    !
  contains
    !
    ! Sorting functions: first by frequency, then by idFe
    function feedback_gt(m,l)
      logical :: feedback_gt
      integer(kind=4), intent(in) :: m,l
      if (user%freq(m).ne.user%freq(l)) then
         feedback_gt = user%freq(m).gt.user%freq(l)
         return
      endif
      feedback_gt = lgt(user%idfe(m),user%idfe(l))
    end function feedback_gt
    !
    function feedback_ge(m,l)
      logical :: feedback_ge
      integer(kind=4), intent(in) :: m,l
      if (user%freq(m).ne.user%freq(l)) then
         feedback_ge = user%freq(m).ge.user%freq(l)
         return
      endif
      feedback_ge = lge(user%idfe(m),user%idfe(l))
    end function feedback_ge
  end subroutine user_feedback_sort_by_freq_idfe
  !
  subroutine user_feedback_sort_by_freq_direction_idfe(user,error)
    use gkernel_interfaces
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    class(user_feedback_t), intent(inout) :: user
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='USER>FEEDBACK>SORT>BY>FREQ>DIRECTION>IDFE'
    !
    call gi4_quicksort_index_with_user_gtge(user%idx,user%n,&
         feedback_gt,feedback_ge,error)
    if (error) return
    !
  contains
    !
    ! Sorting functions: first by frequency, then by direction, then by idFe
    function feedback_gt(m,l)
      logical :: feedback_gt
      integer(kind=4), intent(in) :: m,l
      if (user%freq(m).ne.user%freq(l)) then
         feedback_gt = user%freq(m).gt.user%freq(l)
         return
      endif
      if (user%quadrant(m).ne.user%quadrant(l)) then
         feedback_gt = user%quadrant(m).gt.user%quadrant(l)
         return
      endif
      feedback_gt = lgt(user%idfe(m),user%idfe(l))
    end function feedback_gt
    !
    function feedback_ge(m,l)
      logical :: feedback_ge
      integer(kind=4), intent(in) :: m,l
      if (user%freq(m).ne.user%freq(l)) then
         feedback_ge = user%freq(m).ge.user%freq(l)
         return
      endif
      if (user%quadrant(m).ne.user%quadrant(l)) then
         feedback_ge = user%quadrant(m).ge.user%quadrant(l)
         return
      endif
      feedback_ge = lge(user%idfe(m),user%idfe(l))
    end function feedback_ge
  end subroutine user_feedback_sort_by_freq_direction_idfe
  !
  subroutine user_feedback_fill_idfe_freq(user,iuser,idfe,freq,result,color)
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(user_feedback_t),        intent(inout) :: user
    integer(kind=4),               intent(in)    :: iuser
    character(len=8),              intent(in)    :: idfe
    real(kind=8),                  intent(in)    :: freq
    character(len=message_length), intent(in)    :: result
    integer(kind=4),               intent(in)    :: color
    !
    user%idfe(iuser) = idfe
    user%freq(iuser) = freq
    user%quadrant(iuser) = 0  ! Useless
    user%result(iuser) = result
    user%color(iuser) = color
  end subroutine user_feedback_fill_idfe_freq
  !
  subroutine user_feedback_fill_idfe_freq_angle(user,iuser,idfe,freq,angle,result,color)
    use phys_const
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(user_feedback_t),        intent(inout) :: user
    integer(kind=4),               intent(in)    :: iuser
    character(len=8),              intent(in)    :: idfe
    real(kind=8),                  intent(in)    :: freq
    real(kind=8),                  intent(in)    :: angle  ! [deg] Drift angle
    character(len=message_length), intent(in)    :: result
    integer(kind=4),               intent(in)    :: color
    ! Local
    real(kind=8) :: myangle
    !
    user%idfe(iuser) = idfe
    user%freq(iuser) = freq
    user%result(iuser) = result
    user%color(iuser) = color
    ! Angles are divided in 4 quadrants (do not assume the angle is a multiple
    ! of 90 deg). The quadrants numbering is suited for simple sorting later on,
    ! so that 0, 180, 90, -90 appear in order.
    !  1:  315 to  405 (e.g.   0+360)
    !  2:  135 to  225 (e.g. 180)
    !  3:   45 to  135 (e.g.  90)
    !  4:  225 to  315 (e.g. -90+360)
    myangle = angle
    ! Do not assume range is [-180:180] or [0:360] -> modulo+360
    do while (myangle.lt.45.d0)
      myangle = myangle+360.d0
    enddo
        if (myangle.ge.7*45.d0) then
      user%quadrant(iuser) = 1
    elseif (myangle.ge.5*45.d0) then
      user%quadrant(iuser) = 4
    elseif (myangle.ge.3*45.d0) then
      user%quadrant(iuser) = 2
    else ! if (myangle.ge.45.d0) then
      user%quadrant(iuser) = 3
    endif
  end subroutine user_feedback_fill_idfe_freq_angle
  !
  subroutine user_feedback_list(user,error)
    use gbl_ansicodes
    !---------------------------------------------------------------------
    ! List in terminal following the idx order. Encode colors with ANSI
    ! codes if needed.
    !---------------------------------------------------------------------
    class(user_feedback_t), intent(inout) :: user
    logical,                intent(inout) :: error
    !
    integer(kind=4) :: iuser,iresult
    character(len=*), parameter :: rname='USER>FEEDBACK>LIST'
    !
    do iuser=1,user%n
      iresult = user%idx(iuser)
      select case (user%color(iresult))
      case (code_color_red)
        call mrtcal_message(seve%r,rname,user_feedback_format_color(c_red,user%result(iresult),c_clear))
      case (code_color_orange)
        call mrtcal_message(seve%r,rname,user_feedback_format_color(c_orange,user%result(iresult),c_clear))
      case (code_color_green)
        call mrtcal_message(seve%r,rname,user_feedback_format_color(c_green,user%result(iresult),c_clear))
      case default
        call mrtcal_message(seve%r,rname,user%result(iresult))
      end select
    enddo ! iuser
  end subroutine user_feedback_list
  !
  subroutine user_feedback_tofile(user,head,error)
    use gkernel_interfaces
    use mrtindex_types
    use mrtindex_interfaces_public
    !---------------------------------------------------------------------
    ! List in file following the idx order. Encode colors with HTML if
    ! needed.
    !---------------------------------------------------------------------
    class(user_feedback_t),  intent(inout) :: user
    type(mrtindex_header_t), intent(in)    :: head
    logical,                 intent(inout) :: error
    !
    integer(kind=4) :: ier,mylun
    integer(kind=4) :: iuser,iresult
    character(len=8) :: date
    character(len=16) :: obstype
    character(len=64) :: filename
    character(len=backname_length) :: backendname
    character(len=*), parameter :: rname='USER>FEEDBACK>TOFILE'
    !
    ! Build file name
    backendname = mrtindex_backend(head%key%backend)
    call gag_toyyyymmdd(head%key%dobs,date,error)
    if (error) return
    select case (head%key%obstype)
    case (obstype_pointing)
      obstype = 'pointing'
    case (obstype_calibrate)
      obstype = 'calibration'
    case default
      obstype = 'unknown'
    end select
    write(filename,'(a8,a,a1,a,a1,a8,a1,i0,a4)')  &
        'iram30m-',trim(obstype),'-',trim(backendname),'-',date,  &
        's',head%key%scan,'.dat'
    !
    ! Open file
    ier = sic_getlun(mylun)
    if (ier.ne.1) then
      error = .true.
      return
    endif
    ier = sic_open(mylun,filename,'REPLACE',.false.)
    if (ier.ne.0) then
      call mrtcal_message(seve%e,rname,'Cannot open new file '//filename)
      error = .true.
      call sic_frelun(mylun)
      return
    endif
    !
    ! Write lines
    do iuser=1,user%n
      iresult = user%idx(iuser)
      select case (user%color(iresult))
      case (code_color_red)
        write (mylun,'(A)') user_feedback_format_color('<font color="red">',   user%result(iresult),'</font>')
      case (code_color_orange)
        write (mylun,'(A)') user_feedback_format_color('<font color="orange">',user%result(iresult),'</font>')
      case (code_color_green)
        write (mylun,'(A)') user_feedback_format_color('<font color="green">', user%result(iresult),'</font>')
      case default
        write (mylun,'(A)') trim(user%result(iresult))
      end select
    enddo
    !
    ! Close file
    ier = sic_close(mylun)
    call sic_frelun(mylun)
  end subroutine user_feedback_tofile
  !
  function user_feedback_format_onedouble(nchar,oneformat,onevalue,bad) result(formatted)
    integer(kind=4),   intent(in) :: nchar
    character(len=*),  intent(in) :: oneformat
    real(kind=8),      intent(in) :: onevalue
    real(kind=8),      intent(in) :: bad
    character(len=32)             :: formatted ! intent(out)
    !
    character(len=*), parameter :: hyphens='--------------------------------'
    !
    if (onevalue.eq.bad) then 
      formatted=hyphens(1:nchar)
    else
       write(formatted,"("//oneformat//")") onevalue
    endif
  end function user_feedback_format_onedouble
  !
  function user_feedback_format_color(startcol,string,endcol) result(result)
    use gbl_ansicodes
    !-------------------------------------------------------------------
    !***JP: Duplicated from the cubetools library
    !-------------------------------------------------------------------
    character(len=*), intent(in) :: startcol
    character(len=*), intent(in) :: string
    character(len=*), intent(in) :: endcol
    !
    integer(kind=4) :: length
    character(len=:), allocatable :: result
    !
    length = len(startcol)+len_trim(string)+len(endcol)
    allocate(character(length)::result)
    write(result,'(3a)') startcol,trim(string),endcol
  end function user_feedback_format_color
end module mrtcal_user_feedback_tool
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
