module mrtcal_index_vars
  use mrtindex_types
  use mrtindex_parse_types
  !
  type(mrtindex_optimize_t), target :: ix,cx
  !
  ! Current idx number, header, and filename for
  !  READ Filename|FileNum|ZERO|FIRST|LAST|NEXT|PREV
  ! Positions: kcurr_ix can be derived from kcurr_cx, but not easily in the other way
  integer(kind=entry_length) :: kcurr_cx=0  ! Position in CX for current entry
  integer(kind=entry_length) :: kcurr_ix=0  ! Position in IX for current entry
  type(mrtindex_entry_t), save :: kentry
  integer(kind=entry_length), save :: mfound=0   ! CX size, support for MFOUND
  character(len=filename_length) :: filecurr=""  ! Duplicate of khead%key%filename (full path)
  !
  ! Mrtcal User Section: LAS\FIND /USER criteria:
  type(user_find_t) :: userfind
  !
contains
  !
  subroutine mrtcal_index_parse(caller,line,iopt,iarg,optx,optname,error)
    !-------------------------------------------------------------------
    ! Parse for the index-name argument in a command line
    !-------------------------------------------------------------------
    character(len=*),          intent(in)    :: caller
    character(len=*),          intent(in)    :: line
    integer(kind=4),           intent(in)    :: iopt
    integer(kind=4),           intent(in)    :: iarg
    type(mrtindex_optimize_t), pointer       :: optx
    character(len=*),          intent(out)   :: optname
    logical,                   intent(inout) :: error
    !
    integer(kind=4), parameter :: nwhat=2
    character(len=7), parameter :: what(nwhat) = (/ 'IN     ','CURRENT' /)
    character(len=7) :: argum,key
    integer(kind=4) :: nchar,ikey
    !
    argum = 'CURRENT'
    call sic_ke(line,0,1,argum,nchar,.false.,error)
    if (error)  return
    call sic_ambigs(caller,argum,key,ikey,what,nwhat,error)
    if (error)  return
    !
    if (ikey.eq.1) then
      optx => ix
      optname = 'In'
    else
      optx => cx
      optname = 'Current'
    endif
  end subroutine mrtcal_index_parse
  !
end module mrtcal_index_vars
