module cubelist_object_types
  !---------------------------------------------------------------------
  !
  !---------------------------------------------------------------------
  !
  public :: list_object_t
  private
  !
  ! Basic object type
  type, abstract :: list_object_t
     ! Empty
  contains
    procedure(final_interface), deferred, public :: final
  end type list_object_t
  !
  abstract interface
    subroutine final_interface(obj,error)
      import list_object_t
      !-----------------------------------------------------------------
      ! The 'list_object_t' must provide an explicit FINAL method. It
      ! can not be implicit because of the weird finalization of
      ! structure constructor in Fortran 2008/11). See also related bug
      ! in https://gcc.gnu.org/bugzilla/show_bug.cgi?id=112459
      !-----------------------------------------------------------------
      class(list_object_t), intent(inout) :: obj
      logical,              intent(inout) :: error
    end subroutine final_interface
  end interface
  !
end module cubelist_object_types
