/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.types.hfs.CdrThdRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogThread;

public abstract class CommonHFSCatalogFolderThread
implements PrintableStruct,
StructElements {
    public abstract CommonHFSCatalogNodeID getParentID();

    public abstract CommonHFSCatalogString getNodeName();

    public abstract int length();

    public abstract byte[] getBytes();

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogFolderThread.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public static CommonHFSCatalogFolderThread create(HFSPlusCatalogThread data) {
        return new HFSPlusImplementation(data);
    }

    public static CommonHFSCatalogFolderThread create(CdrThdRec data) {
        return new HFSImplementation(data);
    }

    private static class HFSImplementation
    extends CommonHFSCatalogFolderThread {
        private final CdrThdRec data;

        public HFSImplementation(CdrThdRec data) {
            this.data = data;
        }

        public CommonHFSCatalogNodeID getParentID() {
            return CommonHFSCatalogNodeID.create(this.data.getThdParID());
        }

        public CommonHFSCatalogString getNodeName() {
            return CommonHFSCatalogString.createHFS(this.data.getThdCName());
        }

        public int length() {
            HFSImplementation hFSImplementation = this;
            return hFSImplementation.data.length();
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }
    }

    private static class HFSPlusImplementation
    extends CommonHFSCatalogFolderThread {
        private final HFSPlusCatalogThread data;

        public HFSPlusImplementation(HFSPlusCatalogThread data) {
            this.data = data;
        }

        public CommonHFSCatalogNodeID getParentID() {
            return CommonHFSCatalogNodeID.create(this.data.getParentID());
        }

        public CommonHFSCatalogString getNodeName() {
            return CommonHFSCatalogString.createHFSPlus(this.data.getNodeName());
        }

        public int length() {
            return this.data.length();
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }
    }
}

