/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: pafchkCreate.c 250921 2014-01-26 22:50:54Z pbaksai $"
*
* who       when        what
* --------  ----------  --------------------------------------------------------
* pbaksai   2013/12/30  CCB-000579: FIMS support for 64 bits.
*                       - Made more compatible outside VLT
* mpruemm   2009/06/23  Fix rcsId for VLT2009.
* rschmutz  2004/07/11  Created
*
********************************************************************************
*   NAME
*	pafchkCreate - create PAF file checksum
* 
*   SYNOPSIS
*	pafchkCreate [-t] <filename> <progname>
* 
*   DESCRIPTION
*	Utility pafchkCreate adds a checksum to a PAF file.
*	This utility is supposed to be used only by other
*	programs that create (or modify) PAF files.
*
*	<filename>: PAF file
*	<progname>: name to be stored in PAF.CHCK.NAME, this is
*		    normally the name of the program calling
*		    pafchkCreate.
*	-t        : test flag used for tat tests.
*		    If this flag is present, then a fixed date
*		    is stored in keyword PAF.CHCK.DAYTIM.
*
*   RETURN VALUES
*	0 - SUCCESS
*	1 - FAILURE
*
*   CAUTIONS 
*
*   EXAMPLES
*	pafchkCreate B67.ins fposs
*
*   SEE ALSO
*	pafchkVerify(1)
*
*   BUGS   
* 
*-------------------------------------------------------------------------------
*/

#include "vltAttrib.h"
#define LINUX
#ifndef __cplusplus
#define _GNU_SOURCE
#endif

#include <stddef.h>
#include <sys/types.h>
#include <sys/time.h>
#include "vltPortGeneral.h"

ATTRIBUTE_UNUSED static const char *rcsId="@(#) $Id: pafchkCreate.c 250921 2014-01-26 22:50:54Z pbaksai $"; 

/* 
 * System Headers 
 */
#include <stdio.h>
#include <string.h>

/*
 * Local Headers 
 */
#include "pafchk.h"

/* 
 * Main
 */
int main (int argc, char *argv[])
{
    int   status;
    char* filename;
    char* progname = "pafchkCreate";
    int   flags;
    int   i;

    /*= 1. get arguments */
    i = 1;
    flags = 0;
    if (argc >= 2 && strcmp(argv[1], "-t") == 0)
    	{
	flags = PAFCHK_FLAG_NO_TIMESTAMP;
	i++;
	}
    if ((argc - i) == 0 || (argc - i) > 2)
	{
	printf("Usage: %s <filename>\n", argv[0]);
	printf("Note : This utility should not be used interactively.\n");
	return 1;
	}
    filename = argv[i++];
    if (i < argc)
    	progname = argv[i];

    /*= 2. create checksum */
    status = pafchkChecksumCreate(filename, progname, flags);

    return status;
}

    
/*___oOo___*/



