/*  SDS TCL module Include file                              */
/*                                                           */
/*  Tony Farrell      1998  Nov 3                            */
/*                                                           */
/* Sccs Id:     sdstcl.h, Release 1.1, 11/05/98                        */
/*                                                           */

#ifndef _SDSTCL_INCLUDE_
#define _SDSTCL_INCLUDE_ 1

#include "sds.h"
#ifdef VAXC
#pragma nostandard
#endif
#include <tcl.h>
#ifdef VAXC
#pragma standard
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  Typedef for routine arguments to SdsTclAddCommands.
 */
typedef int (*SdsTclCmdErrorRoutineType)(
    Tcl_Interp *interp,
    SDSCONST char *cmd,
    StatusType error);

typedef void (*SdsTclCreateCommandRoutineType)(
    Tcl_Interp *interp,
    SDSCONST char * SDSCONST name,
    Tcl_CmdProc *proc,
    ClientData * clientData,
    Tcl_CmdDeleteProc *deleteProc);



/*
 *  Function to create the SDS Tcl commands.  Can be invoked by either
 *  Sds_Init or Dtcl.
 */
SDSEXTERN void SdsTclAddCommands(  /* sdstcl.c */
    Tcl_Interp *interp,
    SdsTclCmdErrorRoutineType cmdError,
    SdsTclCreateCommandRoutineType createCmd);
    
/*
 *  Function to add Sds to a Tcl interpreter.
 */
SDSEXTERN int Sds_Init(            /* sdstclinit.c */
    Tcl_Interp *interp);


#ifdef __cplusplus
} /* extern "C" */
#endif
#endif


