#ifndef _FPCOLMDLCALMODEL_H_
#define _FPCOLMDLCALMODEL_H_

/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: fpcolMdlCalModel.h 74556 2002-11-24 09:25:26Z flamemgr $"
*
*
* who       when      what
* --------  --------  ----------------------------------------------
* tfarrell  27/06/02  Drop command line arguments to fpcolMdlCalModels().
* tfarrell  18/04/02  Renamed from fpcolMdlCalCreateModel to fpcolMdlCalModels and
*                     added many new functions.
* ssmedley  07/09/01  created
*
*/

/************************************************************************
*   NAME
*	Included file for fpcolMdlCalModel.c and the modules that use it.
*
*   SYNOPSIS
*       #include "fpcolMdlCalModel.h"
*
*
*------------------------------------------------------------------------
*/



#include "fpcolMdl.h"
#include "fpcolMdlCalLibs.h"

int fpcolMdlCalNewWavelength(double wavelength,
                             FpcalData *pFpcalData);

int fpcolMdlCalCreateModels(FpcalData *pFpcalData);
void fpcolMdlCalSetPars(const FpcalPars *newPars,FpcalMdl *model );
const FpcalPars * fpcolMdlCalGetPars(const FpcalMdl *model);
FpilModelType *fpcolMdlCalWaveModel(FpcalMdl *models, int waveIndex);
double fpcolMdlCalWavelength(FpcalMdl *models, int waveIndex);
void fpcolMdlCalShowModels(const FpcalMdl *model);

#endif
