/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.sample.extensions.processors;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.sample.extensions.processors.QualifiedNameProcessorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "()V", "onFinish", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "onProcess", "file", "ClassNameVisitor", "detekt-sample-extensions"})
public final class QualifiedNameProcessor
implements FileProcessListener {
    /*
     * WARNING - void declaration
     */
    public void onProcess(@NotNull KtFile file, @NotNull BindingContext bindingContext) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        String string = file.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.packageFqName.asString()");
        String packageName = string;
        ClassNameVisitor nameVisitor = new ClassNameVisitor();
        file.accept((PsiElementVisitor)nameVisitor);
        Iterable iterable = nameVisitor.getNames();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String string3 = packageName + '.' + (String)it;
            collection.add(string3);
        }
        HashSet fqNames = (HashSet)destination$iv;
        file.putUserData(QualifiedNameProcessorKt.getFqNamesKey(), (Object)fqNames);
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result, @NotNull BindingContext bindingContext) {
        void $this$flatMapTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Iterable iterable = files;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set set;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtFile it = (KtFile)element$iv$iv;
            boolean bl2 = false;
            if ((Set)it.getUserData(QualifiedNameProcessorKt.getFqNamesKey()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Set it$iv$iv = set;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet fqNames = (HashSet)destination$iv;
        result.addData(QualifiedNameProcessorKt.getFqNamesKey(), (Object)fqNames);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onFinish(files, result, bindingContext)", imports={}))
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result) {
        FileProcessListener.DefaultImpls.onFinish((FileProcessListener)this, files, (Detektion)result);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcess(file, bindingContext)", imports={}))
    public void onProcess(@NotNull KtFile file) {
        FileProcessListener.DefaultImpls.onProcess((FileProcessListener)this, (KtFile)file);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcessComplete(file, findings, bindingContext)", imports={}))
    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onStart(files, bindingContext)", imports={}))
    public void onStart(@NotNull List<? extends KtFile> files) {
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files);
    }

    public void init(@NotNull Config config) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (Config)config);
    }

    public void init(@NotNull SetupContext context) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (SetupContext)context);
    }

    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings, (BindingContext)bindingContext);
    }

    public void onStart(@NotNull List<? extends KtFile> files, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files, (BindingContext)bindingContext);
    }

    @NotNull
    public String getId() {
        return FileProcessListener.DefaultImpls.getId((FileProcessListener)this);
    }

    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority((FileProcessListener)this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor$ClassNameVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "()V", "names", "", "", "getNames", "()Ljava/util/Set;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "detekt-sample-extensions"})
    public static final class ClassNameVisitor
    extends DetektVisitor {
        @NotNull
        private final Set<String> names;

        public ClassNameVisitor() {
            boolean bl = false;
            this.names = new LinkedHashSet();
        }

        @NotNull
        public final Set<String> getNames() {
            return this.names;
        }

        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            String string = classOrObject.getNameAsSafeName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classOrObject.nameAsSafeName.asString()");
            this.names.add(string);
        }
    }
}

