//! Generated by `cargo xtask codegen assists-doc-tests`, do not edit by hand.

### `add_braces`
**Source:**  [add_braces.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_braces.rs#L8) 

Adds braces to lambda and match arm expressions.

#### Before
```rust
fn foo(n: i32) -> i32 {
    match n {
        1 =>┃ n + 1,
        _ => 0
    }
}
```

#### After
```rust
fn foo(n: i32) -> i32 {
    match n {
        1 => {
            n + 1
        },
        _ => 0
    }
}
```


### `add_explicit_type`
**Source:**  [add_explicit_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_explicit_type.rs#L7) 

Specify type for a let binding.

#### Before
```rust
fn main() {
    let x┃ = 92;
}
```

#### After
```rust
fn main() {
    let x: i32 = 92;
}
```


### `add_hash`
**Source:**  [raw_string.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/raw_string.rs#L89) 

Adds a hash to a raw string literal.

#### Before
```rust
fn main() {
    r#"Hello,┃ World!"#;
}
```

#### After
```rust
fn main() {
    r##"Hello, World!"##;
}
```


### `add_impl_default_members`
**Source:**  [add_missing_impl_members.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_missing_impl_members.rs#L58) 

Adds scaffold for overriding default impl members.

#### Before
```rust
trait Trait {
    type X;
    fn foo(&self);
    fn bar(&self) {}
}

impl Trait for () {
    type X = ();
    fn foo(&self) {}┃
}
```

#### After
```rust
trait Trait {
    type X;
    fn foo(&self);
    fn bar(&self) {}
}

impl Trait for () {
    type X = ();
    fn foo(&self) {}

    ┃fn bar(&self) {}
}
```


### `add_impl_missing_members`
**Source:**  [add_missing_impl_members.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_missing_impl_members.rs#L16) 

Adds scaffold for required impl members.

#### Before
```rust
trait Trait<T> {
    type X;
    fn foo(&self) -> T;
    fn bar(&self) {}
}

impl Trait<u32> for () {┃

}
```

#### After
```rust
trait Trait<T> {
    type X;
    fn foo(&self) -> T;
    fn bar(&self) {}
}

impl Trait<u32> for () {
    ┃type X;

    fn foo(&self) -> u32 {
        todo!()
    }
}
```


### `add_label_to_loop`
**Source:**  [add_label_to_loop.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_label_to_loop.rs#L9) 

Adds a label to a loop.

#### Before
```rust
fn main() {
    loop┃ {
        break;
        continue;
    }
}
```

#### After
```rust
fn main() {
    'l: loop {
        break 'l;
        continue 'l;
    }
}
```


### `add_lifetime_to_type`
**Source:**  [add_lifetime_to_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_lifetime_to_type.rs#L5) 

Adds a new lifetime to a struct, enum or union.

#### Before
```rust
struct Point {
    x: &┃u32,
    y: u32,
}
```

#### After
```rust
struct Point<'a> {
    x: &'a u32,
    y: u32,
}
```


### `add_missing_match_arms`
**Source:**  [add_missing_match_arms.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_missing_match_arms.rs#L16) 

Adds missing clauses to a `match` expression.

#### Before
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        ┃
    }
}
```

#### After
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move { distance } => ${1:todo!()},
        Action::Stop => ${2:todo!()},┃
    }
}
```


### `add_return_type`
**Source:**  [add_return_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_return_type.rs#L6) 

Adds the return type to a function or closure inferred from its tail expression if it doesn't have a return
type specified. This assists is useable in a functions or closures tail expression or return type position.

#### Before
```rust
fn foo() { 4┃2i32 }
```

#### After
```rust
fn foo() -> i32 { 42i32 }
```


### `add_turbo_fish`
**Source:**  [add_turbo_fish.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/add_turbo_fish.rs#L14) 

Adds `::<_>` to a call of a generic method or function.

#### Before
```rust
fn make<T>() -> T { todo!() }
fn main() {
    let x = make┃();
}
```

#### After
```rust
fn make<T>() -> T { todo!() }
fn main() {
    let x = make::<${0:_}>();
}
```


### `apply_demorgan`
**Source:**  [apply_demorgan.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/apply_demorgan.rs#L23) 

Apply [De Morgan's law](https://en.wikipedia.org/wiki/De_Morgan%27s_laws).
This transforms expressions of the form `!l || !r` into `!(l && r)`.
This also works with `&&`. This assist can only be applied with the cursor
on either `||` or `&&`.

#### Before
```rust
fn main() {
    if x != 4 ||┃ y < 3.14 {}
}
```

#### After
```rust
fn main() {
    if !(x == 4 && y >= 3.14) {}
}
```


### `apply_demorgan_iterator`
**Source:**  [apply_demorgan.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/apply_demorgan.rs#L154) 

Apply [De Morgan's law](https://en.wikipedia.org/wiki/De_Morgan%27s_laws) to
`Iterator::all` and `Iterator::any`.

This transforms expressions of the form `!iter.any(|x| predicate(x))` into
`iter.all(|x| !predicate(x))` and vice versa. This also works the other way for
`Iterator::all` into `Iterator::any`.

#### Before
```rust
fn main() {
    let arr = [1, 2, 3];
    if !arr.into_iter().┃any(|num| num == 4) {
        println!("foo");
    }
}
```

#### After
```rust
fn main() {
    let arr = [1, 2, 3];
    if arr.into_iter().all(|num| num != 4) {
        println!("foo");
    }
}
```


### `auto_import`
**Source:**  [auto_import.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/auto_import.rs#L73) 

If the name is unresolved, provides all possible imports for it.

#### Before
```rust
fn main() {
    let map = HashMap┃::new();
}
```

#### After
```rust
use std::collections::HashMap;

fn main() {
    let map = HashMap::new();
}
```


### `bind_unused_param`
**Source:**  [bind_unused_param.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/bind_unused_param.rs#L12) 

Binds unused function parameter to an underscore.

#### Before
```rust
fn some_function(x: i32┃) {}
```

#### After
```rust
fn some_function(x: i32) {
    let _ = x;
}
```


### `bool_to_enum`
**Source:**  [bool_to_enum.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/bool_to_enum.rs#L29) 

This converts boolean local variables, fields, constants, and statics into a new
enum with two variants `Bool::True` and `Bool::False`, as well as replacing
all assignments with the variants and replacing all usages with `== Bool::True` or
`== Bool::False`.

#### Before
```rust
fn main() {
    let ┃bool = true;

    if bool {
        println!("foo");
    }
}
```

#### After
```rust
#[derive(PartialEq, Eq)]
enum Bool { True, False }

fn main() {
    let bool = Bool::True;

    if bool == Bool::True {
        println!("foo");
    }
}
```


### `change_visibility`
**Source:**  [change_visibility.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/change_visibility.rs#L13) 

Adds or changes existing visibility specifier.

#### Before
```rust
┃fn frobnicate() {}
```

#### After
```rust
pub(crate) fn frobnicate() {}
```


### `comment_to_doc`
**Source:**  [convert_comment_from_or_to_doc.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_comment_from_or_to_doc.rs#L9) 

Converts comments to documentation.

#### Before
```rust
// Wow what ┃a nice module
// I sure hope this shows up when I hover over it
```

#### After
```rust
//! Wow what a nice module
//! I sure hope this shows up when I hover over it
```


### `convert_bool_then_to_if`
**Source:**  [convert_bool_then.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_bool_then.rs#L143) 

Converts a `bool::then` method call to an equivalent if expression.

#### Before
```rust
fn main() {
    (0 == 0).then┃(|| val)
}
```

#### After
```rust
fn main() {
    if 0 == 0 {
        Some(val)
    } else {
        None
    }
}
```


### `convert_closure_to_fn`
**Source:**  [convert_closure_to_fn.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_closure_to_fn.rs#L27) 

This converts a closure to a freestanding function, changing all captures to parameters.

#### Before
```rust
fn main() {
    let mut s = String::new();
    let closure = |┃a| s.push_str(a);
    closure("abc");
}
```

#### After
```rust
fn main() {
    let mut s = String::new();
    fn closure(a: &str, s: &mut String) {
        s.push_str(a)
    }
    closure("abc", &mut s);
}
```


### `convert_for_loop_with_for_each`
**Source:**  [convert_iter_for_each_to_for.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_iter_for_each_to_for.rs#L76) 

Converts a for loop into a for_each loop on the Iterator.

#### Before
```rust
fn main() {
    let x = vec![1, 2, 3];
    for┃ v in x {
        let y = v * 2;
    }
}
```

#### After
```rust
fn main() {
    let x = vec![1, 2, 3];
    x.into_iter().for_each(|v| {
        let y = v * 2;
    });
}
```


### `convert_from_to_tryfrom`
**Source:**  [convert_from_to_tryfrom.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_from_to_tryfrom.rs#L10) 

Converts a From impl to a TryFrom impl, wrapping returns in `Ok`.

#### Before
```rust
impl ┃From<usize> for Thing {
    fn from(val: usize) -> Self {
        Thing {
            b: val.to_string(),
            a: val
        }
    }
}
```

#### After
```rust
impl TryFrom<usize> for Thing {
    type Error = ${0:()};

    fn try_from(val: usize) -> Result<Self, Self::Error> {
        Ok(Thing {
            b: val.to_string(),
            a: val
        })
    }
}
```


### `convert_if_to_bool_then`
**Source:**  [convert_bool_then.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_bool_then.rs#L21) 

Converts an if expression into a corresponding `bool::then` call.

#### Before
```rust
fn main() {
    if┃ cond {
        Some(val)
    } else {
        None
    }
}
```

#### After
```rust
fn main() {
    cond.then(|| val)
}
```


### `convert_integer_literal`
**Source:**  [convert_integer_literal.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_integer_literal.rs#L5) 

Converts the base of integer literals to other bases.

#### Before
```rust
const _: i32 = 10┃;
```

#### After
```rust
const _: i32 = 0b1010;
```


### `convert_into_to_from`
**Source:**  [convert_into_to_from.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_into_to_from.rs#L8) 

Converts an Into impl to an equivalent From impl.

#### Before
```rust
impl ┃Into<Thing> for usize {
    fn into(self) -> Thing {
        Thing {
            b: self.to_string(),
            a: self
        }
    }
}
```

#### After
```rust
impl From<usize> for Thing {
    fn from(val: usize) -> Self {
        Thing {
            b: val.to_string(),
            a: val
        }
    }
}
```


### `convert_iter_for_each_to_for`
**Source:**  [convert_iter_for_each_to_for.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_iter_for_each_to_for.rs#L11) 

Converts an Iterator::for_each function into a for loop.

#### Before
```rust
fn main() {
    let iter = iter::repeat((9, 2));
    iter.for_each┃(|(x, y)| {
        println!("x: {}, y: {}", x, y);
    });
}
```

#### After
```rust
fn main() {
    let iter = iter::repeat((9, 2));
    for (x, y) in iter {
        println!("x: {}, y: {}", x, y);
    }
}
```


### `convert_let_else_to_match`
**Source:**  [convert_let_else_to_match.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_let_else_to_match.rs#L9) 

Converts let-else statement to let statement and match expression.

#### Before
```rust
fn main() {
    let Ok(mut x) = f() else┃ { return };
}
```

#### After
```rust
fn main() {
    let mut x = match f() {
        Ok(x) => x,
        _ => return,
    };
}
```


### `convert_match_to_let_else`
**Source:**  [convert_match_to_let_else.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_match_to_let_else.rs#L12) 

Converts let statement with match initializer to let-else statement.

#### Before
```rust
fn foo(opt: Option<()>) {
    let val┃ = match opt {
        Some(it) => it,
        None => return,
    };
}
```

#### After
```rust
fn foo(opt: Option<()>) {
    let Some(val) = opt else { return };
}
```


### `convert_named_struct_to_tuple_struct`
**Source:**  [convert_named_struct_to_tuple_struct.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_named_struct_to_tuple_struct.rs#L11) 

Converts struct with named fields to tuple struct, and analogously for enum variants with named
fields.

#### Before
```rust
struct Point┃ { x: f32, y: f32 }

impl Point {
    pub fn new(x: f32, y: f32) -> Self {
        Point { x, y }
    }

    pub fn x(&self) -> f32 {
        self.x
    }

    pub fn y(&self) -> f32 {
        self.y
    }
}
```

#### After
```rust
struct Point(f32, f32);

impl Point {
    pub fn new(x: f32, y: f32) -> Self {
        Point(x, y)
    }

    pub fn x(&self) -> f32 {
        self.0
    }

    pub fn y(&self) -> f32 {
        self.1
    }
}
```


### `convert_nested_function_to_closure`
**Source:**  [convert_nested_function_to_closure.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_nested_function_to_closure.rs#L7) 

Converts a function that is defined within the body of another function into a closure.

#### Before
```rust
fn main() {
    fn fo┃o(label: &str, number: u64) {
        println!("{}: {}", label, number);
    }

    foo("Bar", 100);
}
```

#### After
```rust
fn main() {
    let foo = |label: &str, number: u64| {
        println!("{}: {}", label, number);
    };

    foo("Bar", 100);
}
```


### `convert_to_guarded_return`
**Source:**  [convert_to_guarded_return.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_to_guarded_return.rs#L24) 

Replace a large conditional with a guarded return.

#### Before
```rust
fn main() {
    ┃if cond {
        foo();
        bar();
    }
}
```

#### After
```rust
fn main() {
    if !cond {
        return;
    }
    foo();
    bar();
}
```


### `convert_tuple_return_type_to_struct`
**Source:**  [convert_tuple_return_type_to_struct.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_tuple_return_type_to_struct.rs#L20) 

This converts the return type of a function from a tuple type
into a tuple struct and updates the body accordingly.

#### Before
```rust
fn bar() {
    let (a, b, c) = foo();
}

fn foo() -> (┃u32, u32, u32) {
    (1, 2, 3)
}
```

#### After
```rust
fn bar() {
    let FooResult(a, b, c) = foo();
}

struct FooResult(u32, u32, u32);

fn foo() -> FooResult {
    FooResult(1, 2, 3)
}
```


### `convert_tuple_struct_to_named_struct`
**Source:**  [convert_tuple_struct_to_named_struct.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_tuple_struct_to_named_struct.rs#L10) 

Converts tuple struct to struct with named fields, and analogously for tuple enum variants.

#### Before
```rust
struct Point┃(f32, f32);

impl Point {
    pub fn new(x: f32, y: f32) -> Self {
        Point(x, y)
    }

    pub fn x(&self) -> f32 {
        self.0
    }

    pub fn y(&self) -> f32 {
        self.1
    }
}
```

#### After
```rust
struct Point { field1: f32, field2: f32 }

impl Point {
    pub fn new(x: f32, y: f32) -> Self {
        Point { field1: x, field2: y }
    }

    pub fn x(&self) -> f32 {
        self.field1
    }

    pub fn y(&self) -> f32 {
        self.field2
    }
}
```


### `convert_two_arm_bool_match_to_matches_macro`
**Source:**  [convert_two_arm_bool_match_to_matches_macro.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_two_arm_bool_match_to_matches_macro.rs#L8) 

Convert 2-arm match that evaluates to a boolean into the equivalent matches! invocation.

#### Before
```rust
fn main() {
    match scrutinee┃ {
        Some(val) if val.cond() => true,
        _ => false,
    }
}
```

#### After
```rust
fn main() {
    matches!(scrutinee, Some(val) if val.cond())
}
```


### `convert_while_to_loop`
**Source:**  [convert_while_to_loop.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_while_to_loop.rs#L20) 

Replace a while with a loop.

#### Before
```rust
fn main() {
    ┃while cond {
        foo();
    }
}
```

#### After
```rust
fn main() {
    loop {
        if !cond {
            break;
        }
        foo();
    }
}
```


### `destructure_struct_binding`
**Source:**  [destructure_struct_binding.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/destructure_struct_binding.rs#L18) 

Destructures a struct binding in place.

#### Before
```rust
struct Foo {
    bar: i32,
    baz: i32,
}
fn main() {
    let ┃foo = Foo { bar: 1, baz: 2 };
    let bar2 = foo.bar;
    let baz2 = &foo.baz;
}
```

#### After
```rust
struct Foo {
    bar: i32,
    baz: i32,
}
fn main() {
    let Foo { bar, baz } = Foo { bar: 1, baz: 2 };
    let bar2 = bar;
    let baz2 = &baz;
}
```


### `destructure_tuple_binding`
**Source:**  [destructure_tuple_binding.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/destructure_tuple_binding.rs#L19) 

Destructures a tuple binding in place.

#### Before
```rust
fn main() {
    let ┃t = (1,2);
    let v = t.0;
}
```

#### After
```rust
fn main() {
    let (┃_0, _1) = (1,2);
    let v = _0;
}
```


### `desugar_async_into_impl_future`
**Source:**  [toggle_async_sugar.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/toggle_async_sugar.rs#L103) 

Rewrites asynchronous function from `async fn` into `-> impl Future`.
This action does not touch the function body and therefore `0`
block does not transform to `async { 0 }`.

#### Before
```rust
pub as┃ync fn foo() -> usize {
    0
}
```

#### After
```rust
pub fn foo() -> impl core::future::Future<Output = usize> {
    0
}
```


### `desugar_doc_comment`
**Source:**  [desugar_doc_comment.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/desugar_doc_comment.rs#L14) 

Desugars doc-comments to the attribute form.

#### Before
```rust
/// Multi-line┃
/// comment
```

#### After
```rust
#[doc = r"Multi-line
comment"]
```


### `expand_glob_import`
**Source:**  [expand_glob_import.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/expand_glob_import.rs#L19) 

Expands glob imports.

#### Before
```rust
mod foo {
    pub struct Bar;
    pub struct Baz;
}

use foo::*┃;

fn qux(bar: Bar, baz: Baz) {}
```

#### After
```rust
mod foo {
    pub struct Bar;
    pub struct Baz;
}

use foo::{Bar, Baz};

fn qux(bar: Bar, baz: Baz) {}
```


### `expand_glob_reexport`
**Source:**  [expand_glob_import.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/expand_glob_import.rs#L81) 

Expands non-private glob imports.

#### Before
```rust
mod foo {
    pub struct Bar;
    pub struct Baz;
}

pub use foo::*┃;
```

#### After
```rust
mod foo {
    pub struct Bar;
    pub struct Baz;
}

pub use foo::{Bar, Baz};
```


### `explicit_enum_discriminant`
**Source:**  [explicit_enum_discriminant.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/explicit_enum_discriminant.rs#L11) 

Adds explicit discriminant to all enum variants.

#### Before
```rust
enum TheEnum┃ {
    Foo,
    Bar,
    Baz = 42,
    Quux,
}
```

#### After
```rust
enum TheEnum {
    Foo = 0,
    Bar = 1,
    Baz = 42,
    Quux = 43,
}
```


### `extract_constant`
**Source:**  [extract_variable.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_variable.rs#L35) 

Extracts subexpression into a constant.

#### Before
```rust
fn main() {
    ┃(1 + 2)┃ * 4;
}
```

#### After
```rust
fn main() {
    const ┃VAR_NAME: i32 = 1 + 2;
    VAR_NAME * 4;
}
```


### `extract_expressions_from_format_string`
**Source:**  [extract_expressions_from_format_string.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_expressions_from_format_string.rs#L14) 

Move an expression out of a format string.

#### Before
```rust
fn main() {
    print!("{var} {x + 1}┃");
}
```

#### After
```rust
fn main() {
    print!("{var} {}"┃, x + 1);
}
```


### `extract_function`
**Source:**  [extract_function.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_function.rs#L39) 

Extracts selected statements and comments into new function.

#### Before
```rust
fn main() {
    let n = 1;
    ┃let m = n + 2;
    // calculate
    let k = m + n;┃
    let g = 3;
}
```

#### After
```rust
fn main() {
    let n = 1;
    fun_name(n);
    let g = 3;
}

fn ┃fun_name(n: i32) {
    let m = n + 2;
    // calculate
    let k = m + n;
}
```


### `extract_module`
**Source:**  [extract_module.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_module.rs#L29) 

Extracts a selected region as separate module. All the references, visibility and imports are
resolved.

#### Before
```rust
┃fn foo(name: i32) -> i32 {
    name + 1
}┃

fn bar(name: i32) -> i32 {
    name + 2
}
```

#### After
```rust
mod modname {
    pub(crate) fn foo(name: i32) -> i32 {
        name + 1
    }
}

fn bar(name: i32) -> i32 {
    name + 2
}
```


### `extract_static`
**Source:**  [extract_variable.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_variable.rs#L52) 

Extracts subexpression into a static.

#### Before
```rust
fn main() {
    ┃(1 + 2)┃ * 4;
}
```

#### After
```rust
fn main() {
    static ┃VAR_NAME: i32 = 1 + 2;
    VAR_NAME * 4;
}
```


### `extract_struct_from_enum_variant`
**Source:**  [extract_struct_from_enum_variant.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_struct_from_enum_variant.rs#L26) 

Extracts a struct from enum variant.

#### Before
```rust
enum A { ┃One(u32, u32) }
```

#### After
```rust
struct One(u32, u32);

enum A { One(One) }
```


### `extract_type_alias`
**Source:**  [extract_type_alias.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_type_alias.rs#L10) 

Extracts the selected type as a type alias.

#### Before
```rust
struct S {
    field: ┃(u8, u8, u8)┃,
}
```

#### After
```rust
type ┃Type = (u8, u8, u8);

struct S {
    field: Type,
}
```


### `extract_variable`
**Source:**  [extract_variable.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/extract_variable.rs#L18) 

Extracts subexpression into a variable.

#### Before
```rust
fn main() {
    ┃(1 + 2)┃ * 4;
}
```

#### After
```rust
fn main() {
    let ┃var_name = 1 + 2;
    var_name * 4;
}
```


### `fill_record_pattern_fields`
**Source:**  [fill_record_pattern_fields.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/fill_record_pattern_fields.rs#L8) 

Fills fields by replacing rest pattern in record patterns.

#### Before
```rust
struct Bar { y: Y, z: Z }

fn foo(bar: Bar) {
    let Bar { ..┃ } = bar;
}
```

#### After
```rust
struct Bar { y: Y, z: Z }

fn foo(bar: Bar) {
    let Bar { y, z  } = bar;
}
```


### `fix_visibility`
**Source:**  [fix_visibility.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/fix_visibility.rs#L14) 

Makes inaccessible item public.

#### Before
```rust
mod m {
    fn frobnicate() {}
}
fn main() {
    m::frobnicate┃();
}
```

#### After
```rust
mod m {
    ┃pub(crate) fn frobnicate() {}
}
fn main() {
    m::frobnicate();
}
```


### `flip_binexpr`
**Source:**  [flip_binexpr.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/flip_binexpr.rs#L8) 

Flips operands of a binary expression.

#### Before
```rust
fn main() {
    let _ = 90 +┃ 2;
}
```

#### After
```rust
fn main() {
    let _ = 2 + 90;
}
```


### `flip_comma`
**Source:**  [flip_comma.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/flip_comma.rs#L10) 

Flips two comma-separated items.

#### Before
```rust
fn main() {
    ((1, 2),┃ (3, 4));
}
```

#### After
```rust
fn main() {
    ((3, 4), (1, 2));
}
```


### `flip_or_pattern`
**Source:**  [flip_or_pattern.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/flip_or_pattern.rs#L9) 

Flips two trait bounds.

#### Before
```rust
fn foo() {
    let (a |┃ b) = 1;
}
```

#### After
```rust
fn foo() {
    let (b | a) = 1;
}
```


### `flip_trait_bound`
**Source:**  [flip_trait_bound.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/flip_trait_bound.rs#L9) 

Flips two trait bounds.

#### Before
```rust
fn foo<T: Clone +┃ Copy>() { }
```

#### After
```rust
fn foo<T: Copy + Clone>() { }
```


### `generate_constant`
**Source:**  [generate_constant.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_constant.rs#L14) 

Generate a named constant.

#### Before
```rust
struct S { i: usize }
impl S { pub fn new(n: usize) {} }
fn main() {
    let v = S::new(CAPA┃CITY);
}
```

#### After
```rust
struct S { i: usize }
impl S { pub fn new(n: usize) {} }
fn main() {
    const CAPACITY: usize = ┃;
    let v = S::new(CAPACITY);
}
```


### `generate_default_from_enum_variant`
**Source:**  [generate_default_from_enum_variant.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_default_from_enum_variant.rs#L6) 

Adds a Default impl for an enum using a variant.

#### Before
```rust
enum Version {
 Undefined,
 Minor┃,
 Major,
}
```

#### After
```rust
enum Version {
 Undefined,
 Minor,
 Major,
}

impl Default for Version {
    fn default() -> Self {
        Self::Minor
    }
}
```


### `generate_default_from_new`
**Source:**  [generate_default_from_new.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_default_from_new.rs#L13) 

Generates default implementation from new method.

#### Before
```rust
struct Example { _inner: () }

impl Example {
    pub fn n┃ew() -> Self {
        Self { _inner: () }
    }
}
```

#### After
```rust
struct Example { _inner: () }

impl Example {
    pub fn new() -> Self {
        Self { _inner: () }
    }
}

impl Default for Example {
    fn default() -> Self {
        Self::new()
    }
}
```


### `generate_delegate_methods`
**Source:**  [generate_delegate_methods.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_delegate_methods.rs#L15) 

Generate delegate methods.

#### Before
```rust
struct Age(u8);
impl Age {
    fn age(&self) -> u8 {
        self.0
    }
}

struct Person {
    ag┃e: Age,
}
```

#### After
```rust
struct Age(u8);
impl Age {
    fn age(&self) -> u8 {
        self.0
    }
}

struct Person {
    age: Age,
}

impl Person {
    ┃fn age(&self) -> u8 {
        self.age.age()
    }
}
```


### `generate_delegate_trait`
**Source:**  [generate_delegate_trait.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_delegate_trait.rs#L29) 

Generate delegate trait implementation for `StructField`s.

#### Before
```rust
trait SomeTrait {
    type T;
    fn fn_(arg: u32) -> u32;
    fn method_(&mut self) -> bool;
}
struct A;
impl SomeTrait for A {
    type T = u32;

    fn fn_(arg: u32) -> u32 {
        42
    }

    fn method_(&mut self) -> bool {
        false
    }
}
struct B {
    a┃: A,
}
```

#### After
```rust
trait SomeTrait {
    type T;
    fn fn_(arg: u32) -> u32;
    fn method_(&mut self) -> bool;
}
struct A;
impl SomeTrait for A {
    type T = u32;

    fn fn_(arg: u32) -> u32 {
        42
    }

    fn method_(&mut self) -> bool {
        false
    }
}
struct B {
    a: A,
}

impl SomeTrait for B {
    type T = <A as SomeTrait>::T;

    fn fn_(arg: u32) -> u32 {
        <A as SomeTrait>::fn_(arg)
    }

    fn method_(&mut self) -> bool {
        <A as SomeTrait>::method_(&mut self.a)
    }
}
```


### `generate_deref`
**Source:**  [generate_deref.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_deref.rs#L16) 

Generate `Deref` impl using the given struct field.

#### Before
```rust
struct A;
struct B {
   ┃a: A
}
```

#### After
```rust
struct A;
struct B {
   a: A
}

impl core::ops::Deref for B {
    type Target = A;

    fn deref(&self) -> &Self::Target {
        &self.a
    }
}
```


### `generate_derive`
**Source:**  [generate_derive.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_derive.rs#L8) 

Adds a new `#[derive()]` clause to a struct or enum.

#### Before
```rust
struct Point {
    x: u32,
    y: u32,┃
}
```

#### After
```rust
#[derive(┃)]
struct Point {
    x: u32,
    y: u32,
}
```


### `generate_doc_example`
**Source:**  [generate_documentation_template.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_documentation_template.rs#L76) 

Generates a rustdoc example when editing an item's documentation.

#### Before
```rust
/// Adds two numbers.┃
pub fn add(a: i32, b: i32) -> i32 { a + b }
```

#### After
```rust
/// Adds two numbers.
///
/// # Examples
///
/// ```
/// use ra_test_fixture::add;
///
/// assert_eq!(add(a, b), );
/// ```
pub fn add(a: i32, b: i32) -> i32 { a + b }
```


### `generate_documentation_template`
**Source:**  [generate_documentation_template.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_documentation_template.rs#L13) 

Adds a documentation template above a function definition / declaration.

#### Before
```rust
pub struct S;
impl S {
    pub unsafe fn set_len┃(&mut self, len: usize) -> Result<(), std::io::Error> {
        /* ... */
    }
}
```

#### After
```rust
pub struct S;
impl S {
    /// Sets the length of this [`S`].
    ///
    /// # Errors
    ///
    /// This function will return an error if .
    ///
    /// # Safety
    ///
    /// .
    pub unsafe fn set_len(&mut self, len: usize) -> Result<(), std::io::Error> {
        /* ... */
    }
}
```


### `generate_enum_as_method`
**Source:**  [generate_enum_projection_method.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_enum_projection_method.rs#L59) 

Generate an `as_` method for this enum variant.

#### Before
```rust
enum Value {
 Number(i32),
 Text(String)┃,
}
```

#### After
```rust
enum Value {
 Number(i32),
 Text(String),
}

impl Value {
    fn as_text(&self) -> Option<&String> {
        if let Self::Text(v) = self {
            Some(v)
        } else {
            None
        }
    }
}
```


### `generate_enum_is_method`
**Source:**  [generate_enum_is_method.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_enum_is_method.rs#L11) 

Generate an `is_` method for this enum variant.

#### Before
```rust
enum Version {
 Undefined,
 Minor┃,
 Major,
}
```

#### After
```rust
enum Version {
 Undefined,
 Minor,
 Major,
}

impl Version {
    /// Returns `true` if the version is [`Minor`].
    ///
    /// [`Minor`]: Version::Minor
    #[must_use]
    fn is_minor(&self) -> bool {
        matches!(self, Self::Minor)
    }
}
```


### `generate_enum_try_into_method`
**Source:**  [generate_enum_projection_method.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_enum_projection_method.rs#L12) 

Generate a `try_into_` method for this enum variant.

#### Before
```rust
enum Value {
 Number(i32),
 Text(String)┃,
}
```

#### After
```rust
enum Value {
 Number(i32),
 Text(String),
}

impl Value {
    fn try_into_text(self) -> Result<String, Self> {
        if let Self::Text(v) = self {
            Ok(v)
        } else {
            Err(self)
        }
    }
}
```


### `generate_enum_variant`
**Source:**  [generate_enum_variant.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_enum_variant.rs#L10) 

Adds a variant to an enum.

#### Before
```rust
enum Countries {
    Ghana,
}

fn main() {
    let country = Countries::Lesotho┃;
}
```

#### After
```rust
enum Countries {
    Ghana,
    Lesotho,
}

fn main() {
    let country = Countries::Lesotho;
}
```


### `generate_fn_type_alias_named`
**Source:**  [generate_fn_type_alias.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_fn_type_alias.rs#L10) 

Generate a type alias for the function with named parameters.

#### Before
```rust
unsafe fn fo┃o(n: i32) -> i32 { 42i32 }
```

#### After
```rust
type ${0:FooFn} = unsafe fn(n: i32) -> i32;

unsafe fn foo(n: i32) -> i32 { 42i32 }
```


### `generate_fn_type_alias_unnamed`
**Source:**  [generate_fn_type_alias.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_fn_type_alias.rs#L24) 

Generate a type alias for the function with unnamed parameters.

#### Before
```rust
unsafe fn fo┃o(n: i32) -> i32 { 42i32 }
```

#### After
```rust
type ${0:FooFn} = unsafe fn(i32) -> i32;

unsafe fn foo(n: i32) -> i32 { 42i32 }
```


### `generate_from_impl_for_enum`
**Source:**  [generate_from_impl_for_enum.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_from_impl_for_enum.rs#L8) 

Adds a From impl for this enum variant with one tuple field.

#### Before
```rust
enum A { ┃One(u32) }
```

#### After
```rust
enum A { One(u32) }

impl From<u32> for A {
    fn from(v: u32) -> Self {
        Self::One(v)
    }
}
```


### `generate_function`
**Source:**  [generate_function.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_function.rs#L28) 

Adds a stub function with a signature matching the function under the cursor.

#### Before
```rust
struct Baz;
fn baz() -> Baz { Baz }
fn foo() {
    bar┃("", baz());
}

```

#### After
```rust
struct Baz;
fn baz() -> Baz { Baz }
fn foo() {
    bar("", baz());
}

fn bar(arg: &str, baz: Baz) ${0:-> _} {
    todo!()
}

```


### `generate_getter`
**Source:**  [generate_getter_or_setter.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_getter_or_setter.rs#L73) 

Generate a getter method.

#### Before
```rust
struct Person {
    nam┃e: String,
}
```

#### After
```rust
struct Person {
    name: String,
}

impl Person {
    fn ┃name(&self) -> &str {
        &self.name
    }
}
```


### `generate_getter_mut`
**Source:**  [generate_getter_or_setter.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_getter_or_setter.rs#L127) 

Generate a mut getter method.

#### Before
```rust
struct Person {
    nam┃e: String,
}
```

#### After
```rust
struct Person {
    name: String,
}

impl Person {
    fn ┃name_mut(&mut self) -> &mut String {
        &mut self.name
    }
}
```


### `generate_impl`
**Source:**  [generate_impl.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_impl.rs#L20) 

Adds a new inherent impl for a type.

#### Before
```rust
struct Ctx┃<T: Clone> {
    data: T,
}
```

#### After
```rust
struct Ctx<T: Clone> {
    data: T,
}

impl<T: Clone> Ctx<T> {┃}
```


### `generate_is_empty_from_len`
**Source:**  [generate_is_empty_from_len.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_is_empty_from_len.rs#L12) 

Generates is_empty implementation from the len method.

#### Before
```rust
struct MyStruct { data: Vec<String> }

impl MyStruct {
    #[must_use]
    p┃ub fn len(&self) -> usize {
        self.data.len()
    }
}
```

#### After
```rust
struct MyStruct { data: Vec<String> }

impl MyStruct {
    #[must_use]
    pub fn len(&self) -> usize {
        self.data.len()
    }

    #[must_use]
    pub fn is_empty(&self) -> bool {
        self.len() == 0
    }
}
```


### `generate_mut_trait_impl`
**Source:**  [generate_mut_trait_impl.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_mut_trait_impl.rs#L12) 

Adds a IndexMut impl from the `Index` trait.

#### Before
```rust
pub enum Axis { X = 0, Y = 1, Z = 2 }

impl<T> core::ops::Index┃<Axis> for [T; 3] {
    type Output = T;

    fn index(&self, index: Axis) -> &Self::Output {
        &self[index as usize]
    }
}
```

#### After
```rust
pub enum Axis { X = 0, Y = 1, Z = 2 }

┃impl<T> core::ops::IndexMut<Axis> for [T; 3] {
    fn index_mut(&mut self, index: Axis) -> &mut Self::Output {
        &self[index as usize]
    }
}

impl<T> core::ops::Index<Axis> for [T; 3] {
    type Output = T;

    fn index(&self, index: Axis) -> &Self::Output {
        &self[index as usize]
    }
}
```


### `generate_new`
**Source:**  [generate_new.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_new.rs#L14) 

Adds a `fn new` for a type.

#### Before
```rust
struct Ctx<T: Clone> {
     data: T,┃
}
```

#### After
```rust
struct Ctx<T: Clone> {
     data: T,
}

impl<T: Clone> Ctx<T> {
    fn ┃new(data: T) -> Self {
        Self { data }
    }
}
```


### `generate_setter`
**Source:**  [generate_getter_or_setter.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_getter_or_setter.rs#L13) 

Generate a setter method.

#### Before
```rust
struct Person {
    nam┃e: String,
}
```

#### After
```rust
struct Person {
    name: String,
}

impl Person {
    fn ┃set_name(&mut self, name: String) {
        self.name = name;
    }
}
```


### `generate_trait_from_impl`
**Source:**  [generate_trait_from_impl.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_trait_from_impl.rs#L18) 

Generate trait for an already defined inherent impl and convert impl to a trait impl.

#### Before
```rust
struct Foo<const N: usize>([i32; N]);

macro_rules! const_maker {
    ($t:ty, $v:tt) => {
        const CONST: $t = $v;
    };
}

impl<const N: usize> Fo┃o<N> {
    // Used as an associated constant.
    const CONST_ASSOC: usize = N * 4;

    fn create() -> Option<()> {
        Some(())
    }

    const_maker! {i32, 7}
}
```

#### After
```rust
struct Foo<const N: usize>([i32; N]);

macro_rules! const_maker {
    ($t:ty, $v:tt) => {
        const CONST: $t = $v;
    };
}

trait ${0:NewTrait}<const N: usize> {
    // Used as an associated constant.
    const CONST_ASSOC: usize = N * 4;

    fn create() -> Option<()>;

    const_maker! {i32, 7}
}

impl<const N: usize> ${0:NewTrait}<N> for Foo<N> {
    // Used as an associated constant.
    const CONST_ASSOC: usize = N * 4;

    fn create() -> Option<()> {
        Some(())
    }

    const_maker! {i32, 7}
}
```


### `generate_trait_impl`
**Source:**  [generate_impl.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/generate_impl.rs#L66) 

Adds a new trait impl for a type.

#### Before
```rust
struct ┃Ctx<T: Clone> {
    data: T,
}
```

#### After
```rust
struct Ctx<T: Clone> {
    data: T,
}

impl<T: Clone> ${1:_} for Ctx<T> {┃}
```


### `inline_call`
**Source:**  [inline_call.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/inline_call.rs#L170) 

Inlines a function or method body creating a `let` statement per parameter unless the parameter
can be inlined. The parameter will be inlined either if it the supplied argument is a simple local
or if the parameter is only accessed inside the function body once.

#### Before
```rust
fn foo(name: Option<&str>) {
    let name = name.unwrap┃();
}
```

#### After
```rust
fn foo(name: Option<&str>) {
    let name = match name {
            Some(val) => val,
            None => panic!("called `Option::unwrap()` on a `None` value"),
        };
}
```


### `inline_const_as_literal`
**Source:**  [inline_const_as_literal.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/inline_const_as_literal.rs#L6) 

Evaluate and inline const variable as literal.

#### Before
```rust
const STRING: &str = "Hello, World!";

fn something() -> &'static str {
    STRING┃
}
```

#### After
```rust
const STRING: &str = "Hello, World!";

fn something() -> &'static str {
    "Hello, World!"
}
```


### `inline_into_callers`
**Source:**  [inline_call.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/inline_call.rs#L32) 

Inline a function or method body into all of its callers where possible, creating a `let` statement per parameter
unless the parameter can be inlined. The parameter will be inlined either if it the supplied argument is a simple local
or if the parameter is only accessed inside the function body once.
If all calls can be inlined the function will be removed.

#### Before
```rust
fn print(_: &str) {}
fn foo┃(word: &str) {
    if !word.is_empty() {
        print(word);
    }
}
fn bar() {
    foo("안녕하세요");
    foo("여러분");
}
```

#### After
```rust
fn print(_: &str) {}

fn bar() {
    {
        let word: &str = "안녕하세요";
        if !word.is_empty() {
            print(word);
        }
    };
    {
        let word: &str = "여러분";
        if !word.is_empty() {
            print(word);
        }
    };
}
```


### `inline_local_variable`
**Source:**  [inline_local_variable.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/inline_local_variable.rs#L21) 

Inlines a local variable.

#### Before
```rust
fn main() {
    let x┃ = 1 + 2;
    x * 4;
}
```

#### After
```rust
fn main() {
    (1 + 2) * 4;
}
```


### `inline_macro`
**Source:**  [inline_macro.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/inline_macro.rs#L7) 

Takes a macro and inlines it one step.

#### Before
```rust
macro_rules! num {
    (+$($t:tt)+) => (1 + num!($($t )+));
    (-$($t:tt)+) => (-1 + num!($($t )+));
    (+) => (1);
    (-) => (-1);
}

fn main() {
    let number = num┃!(+ + + - + +);
    println!("{number}");
}
```

#### After
```rust
macro_rules! num {
    (+$($t:tt)+) => (1 + num!($($t )+));
    (-$($t:tt)+) => (-1 + num!($($t )+));
    (+) => (1);
    (-) => (-1);
}

fn main() {
    let number = 1+num!(+ + - + +);
    println!("{number}");
}
```


### `inline_type_alias`
**Source:**  [inline_type_alias.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/inline_type_alias.rs#L106) 

Replace a type alias with its concrete type.

#### Before
```rust
type A<T = u32> = Vec<T>;

fn main() {
    let a: ┃A;
}
```

#### After
```rust
type A<T = u32> = Vec<T>;

fn main() {
    let a: Vec<u32>;
}
```


### `inline_type_alias_uses`
**Source:**  [inline_type_alias.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/inline_type_alias.rs#L24) 

Inline a type alias into all of its uses where possible.

#### Before
```rust
type ┃A = i32;
fn id(x: A) -> A {
    x
};
fn foo() {
    let _: A = 3;
}
```

#### After
```rust

fn id(x: i32) -> i32 {
    x
};
fn foo() {
    let _: i32 = 3;
}
```


### `into_to_qualified_from`
**Source:**  [into_to_qualified_from.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/into_to_qualified_from.rs#L10) 

Convert an `into` method call to a fully qualified `from` call.

#### Before
```rust
//- minicore: from
struct B;
impl From<i32> for B {
    fn from(a: i32) -> Self {
       B
    }
}

fn main() -> () {
    let a = 3;
    let b: B = a.in┃to();
}
```

#### After
```rust
struct B;
impl From<i32> for B {
    fn from(a: i32) -> Self {
       B
    }
}

fn main() -> () {
    let a = 3;
    let b: B = B::from(a);
}
```


### `introduce_named_generic`
**Source:**  [introduce_named_generic.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/introduce_named_generic.rs#L7) 

Replaces `impl Trait` function argument with the named generic.

#### Before
```rust
fn foo(bar: ┃impl Bar) {}
```

#### After
```rust
fn foo<┃B: Bar>(bar: B) {}
```


### `introduce_named_lifetime`
**Source:**  [introduce_named_lifetime.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/introduce_named_lifetime.rs#L13) 

Change an anonymous lifetime to a named lifetime.

#### Before
```rust
impl Cursor<'_┃> {
    fn node(self) -> &SyntaxNode {
        match self {
            Cursor::Replace(node) | Cursor::Before(node) => node,
        }
    }
}
```

#### After
```rust
impl<'a> Cursor<'a> {
    fn node(self) -> &SyntaxNode {
        match self {
            Cursor::Replace(node) | Cursor::Before(node) => node,
        }
    }
}
```


### `invert_if`
**Source:**  [invert_if.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/invert_if.rs#L13) 

This transforms if expressions of the form `if !x {A} else {B}` into `if x {B} else {A}`
This also works with `!=`. This assist can only be applied with the cursor on `if`.

#### Before
```rust
fn main() {
    if┃ !y { A } else { B }
}
```

#### After
```rust
fn main() {
    if y { B } else { A }
}
```


### `line_to_block`
**Source:**  [convert_comment_block.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/convert_comment_block.rs#L9) 

Converts comments between block and single-line form.

#### Before
```rust
   // Multi-line┃
   // comment
```

#### After
```rust
  /*
  Multi-line
  comment
  */
```


### `make_raw_string`
**Source:**  [raw_string.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/raw_string.rs#L7) 

Adds `r#` to a plain string literal.

#### Before
```rust
fn main() {
    "Hello,┃ World!";
}
```

#### After
```rust
fn main() {
    r#"Hello, World!"#;
}
```


### `make_usual_string`
**Source:**  [raw_string.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/raw_string.rs#L47) 

Turns a raw string into a plain string.

#### Before
```rust
fn main() {
    r#"Hello,┃ "World!""#;
}
```

#### After
```rust
fn main() {
    "Hello, \"World!\"";
}
```


### `merge_imports`
**Source:**  [merge_imports.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/merge_imports.rs#L21) 

Merges neighbor imports with a common prefix.

#### Before
```rust
use std::┃fmt::Formatter;
use std::io;
```

#### After
```rust
use std::{fmt::Formatter, io};
```


### `merge_match_arms`
**Source:**  [merge_match_arms.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/merge_match_arms.rs#L12) 

Merges the current match arm with the following if their bodies are identical.

#### Before
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        ┃Action::Move(..) => foo(),
        Action::Stop => foo(),
    }
}
```

#### After
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move(..) | Action::Stop => foo(),
    }
}
```


### `merge_nested_if`
**Source:**  [merge_nested_if.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/merge_nested_if.rs#L11) 

This transforms if expressions of the form `if x { if y {A} }` into `if x && y {A}`
This assist can only be applied with the cursor on `if`.

#### Before
```rust
fn main() {
   i┃f x == 3 { if y == 4 { 1 } }
}
```

#### After
```rust
fn main() {
   if x == 3 && y == 4 { 1 }
}
```


### `move_arm_cond_to_match_guard`
**Source:**  [move_guard.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/move_guard.rs#L69) 

Moves if expression from match arm body into a guard.

#### Before
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move { distance } => ┃if distance > 10 { foo() },
        _ => (),
    }
}
```

#### After
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move { distance } if distance > 10 => foo(),
        _ => (),
    }
}
```


### `move_bounds_to_where_clause`
**Source:**  [move_bounds.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/move_bounds.rs#L12) 

Moves inline type bounds to a where clause.

#### Before
```rust
fn apply<T, U, ┃F: FnOnce(T) -> U>(f: F, x: T) -> U {
    f(x)
}
```

#### After
```rust
fn apply<T, U, F>(f: F, x: T) -> U where F: FnOnce(T) -> U {
    f(x)
}
```


### `move_const_to_impl`
**Source:**  [move_const_to_impl.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/move_const_to_impl.rs#L14) 

Move a local constant item in a method to impl's associated constant. All the references will be
qualified with `Self::`.

#### Before
```rust
struct S;
impl S {
    fn foo() -> usize {
        /// The answer.
        const C┃: usize = 42;

        C * C
    }
}
```

#### After
```rust
struct S;
impl S {
    /// The answer.
    const C: usize = 42;

    fn foo() -> usize {
        Self::C * Self::C
    }
}
```


### `move_from_mod_rs`
**Source:**  [move_from_mod_rs.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/move_from_mod_rs.rs#L12) 

Moves xxx/mod.rs to xxx.rs.

#### Before
```rust
//- /main.rs
mod a;
//- /a/mod.rs
┃fn t() {}┃
```

#### After
```rust
fn t() {}
```


### `move_guard_to_arm_body`
**Source:**  [move_guard.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/move_guard.rs#L8) 

Moves match guard into match arm body.

#### Before
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move { distance } ┃if distance > 10 => foo(),
        _ => (),
    }
}
```

#### After
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move { distance } => if distance > 10 {
            foo()
        },
        _ => (),
    }
}
```


### `move_module_to_file`
**Source:**  [move_module_to_file.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/move_module_to_file.rs#L15) 

Moves inline module's contents to a separate file.

#### Before
```rust
mod ┃foo {
    fn t() {}
}
```

#### After
```rust
mod foo;
```


### `move_to_mod_rs`
**Source:**  [move_to_mod_rs.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/move_to_mod_rs.rs#L12) 

Moves xxx.rs to xxx/mod.rs.

#### Before
```rust
//- /main.rs
mod a;
//- /a.rs
┃fn t() {}┃
```

#### After
```rust
fn t() {}
```


### `normalize_import`
**Source:**  [normalize_import.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/normalize_import.rs#L9) 

Normalizes an import.

#### Before
```rust
use┃ std::{io, {fmt::Formatter}};
```

#### After
```rust
use std::{fmt::Formatter, io};
```


### `promote_local_to_const`
**Source:**  [promote_local_to_const.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/promote_local_to_const.rs#L17) 

Promotes a local variable to a const item changing its name to a `SCREAMING_SNAKE_CASE` variant
if the local uses no non-const expressions.

#### Before
```rust
fn main() {
    let foo┃ = true;

    if foo {
        println!("It's true");
    } else {
        println!("It's false");
    }
}
```

#### After
```rust
fn main() {
    const ┃FOO: bool = true;

    if FOO {
        println!("It's true");
    } else {
        println!("It's false");
    }
}
```


### `pull_assignment_up`
**Source:**  [pull_assignment_up.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/pull_assignment_up.rs#L11) 

Extracts variable assignment to outside an if or match statement.

#### Before
```rust
fn main() {
    let mut foo = 6;

    if true {
        ┃foo = 5;
    } else {
        foo = 4;
    }
}
```

#### After
```rust
fn main() {
    let mut foo = 6;

    foo = if true {
        5
    } else {
        4
    };
}
```


### `qualify_method_call`
**Source:**  [qualify_method_call.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/qualify_method_call.rs#L10) 

Replaces the method call with a qualified function call.

#### Before
```rust
struct Foo;
impl Foo {
    fn foo(&self) {}
}
fn main() {
    let foo = Foo;
    foo.fo┃o();
}
```

#### After
```rust
struct Foo;
impl Foo {
    fn foo(&self) {}
}
fn main() {
    let foo = Foo;
    Foo::foo(&foo);
}
```


### `qualify_path`
**Source:**  [qualify_path.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/qualify_path.rs#L24) 

If the name is unresolved, provides all possible qualified paths for it.

#### Before
```rust
fn main() {
    let map = HashMap┃::new();
}
```

#### After
```rust
fn main() {
    let map = std::collections::HashMap::new();
}
```


### `reformat_number_literal`
**Source:**  [number_representation.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/number_representation.rs#L7) 

Adds or removes separators from integer literal.

#### Before
```rust
const _: i32 = 1012345┃;
```

#### After
```rust
const _: i32 = 1_012_345;
```


### `remove_dbg`
**Source:**  [remove_dbg.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/remove_dbg.rs#L9) 

Removes `dbg!()` macro call.

#### Before
```rust
fn main() {
    let x = ┃dbg!(42 * dbg!(4 + 2));┃
}
```

#### After
```rust
fn main() {
    let x = 42 * (4 + 2);
}
```


### `remove_hash`
**Source:**  [raw_string.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/raw_string.rs#L117) 

Removes a hash from a raw string literal.

#### Before
```rust
fn main() {
    r#"Hello,┃ World!"#;
}
```

#### After
```rust
fn main() {
    r"Hello, World!";
}
```


### `remove_mut`
**Source:**  [remove_mut.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/remove_mut.rs#L5) 

Removes the `mut` keyword.

#### Before
```rust
impl Walrus {
    fn feed(&mut┃ self, amount: u32) {}
}
```

#### After
```rust
impl Walrus {
    fn feed(&self, amount: u32) {}
}
```


### `remove_parentheses`
**Source:**  [remove_parentheses.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/remove_parentheses.rs#L9) 

Removes redundant parentheses.

#### Before
```rust
fn main() {
    _ = ┃(2) + 2;
}
```

#### After
```rust
fn main() {
    _ = 2 + 2;
}
```


### `remove_unused_imports`
**Source:**  [remove_unused_imports.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/remove_unused_imports.rs#L17) 

Removes any use statements in the current selection that are unused.

#### Before
```rust
struct X();
mod foo {
    use super::X┃;
}
```

#### After
```rust
struct X();
mod foo {
}
```


### `remove_unused_param`
**Source:**  [remove_unused_param.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/remove_unused_param.rs#L16) 

Removes unused function parameter.

#### Before
```rust
fn frobnicate(x: i32┃) {}

fn main() {
    frobnicate(92);
}
```

#### After
```rust
fn frobnicate() {}

fn main() {
    frobnicate();
}
```


### `reorder_fields`
**Source:**  [reorder_fields.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/reorder_fields.rs#L8) 

Reorder the fields of record literals and record patterns in the same order as in
the definition.

#### Before
```rust
struct Foo {foo: i32, bar: i32};
const test: Foo = ┃Foo {bar: 0, foo: 1}
```

#### After
```rust
struct Foo {foo: i32, bar: i32};
const test: Foo = Foo {foo: 1, bar: 0}
```


### `reorder_impl_items`
**Source:**  [reorder_impl_items.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/reorder_impl_items.rs#L11) 

Reorder the items of an `impl Trait`. The items will be ordered
in the same order as in the trait definition.

#### Before
```rust
trait Foo {
    type A;
    const B: u8;
    fn c();
}

struct Bar;
┃impl Foo for Bar┃ {
    const B: u8 = 17;
    fn c() {}
    type A = String;
}
```

#### After
```rust
trait Foo {
    type A;
    const B: u8;
    fn c();
}

struct Bar;
impl Foo for Bar {
    type A = String;
    const B: u8 = 17;
    fn c() {}
}
```


### `replace_arith_with_checked`
**Source:**  [replace_arith_op.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_arith_op.rs#L9) 

Replaces arithmetic on integers with the `checked_*` equivalent.

#### Before
```rust
fn main() {
  let x = 1 ┃+ 2;
}
```

#### After
```rust
fn main() {
  let x = 1.checked_add(2);
}
```


### `replace_arith_with_saturating`
**Source:**  [replace_arith_op.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_arith_op.rs#L28) 

Replaces arithmetic on integers with the `saturating_*` equivalent.

#### Before
```rust
fn main() {
  let x = 1 ┃+ 2;
}
```

#### After
```rust
fn main() {
  let x = 1.saturating_add(2);
}
```


### `replace_arith_with_wrapping`
**Source:**  [replace_arith_op.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_arith_op.rs#L50) 

Replaces arithmetic on integers with the `wrapping_*` equivalent.

#### Before
```rust
fn main() {
  let x = 1 ┃+ 2;
}
```

#### After
```rust
fn main() {
  let x = 1.wrapping_add(2);
}
```


### `replace_char_with_string`
**Source:**  [replace_string_with_char.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_string_with_char.rs#L51) 

Replace a char literal with a string literal.

#### Before
```rust
fn main() {
    find('{┃');
}
```

#### After
```rust
fn main() {
    find("{");
}
```


### `replace_derive_with_manual_impl`
**Source:**  [replace_derive_with_manual_impl.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_derive_with_manual_impl.rs#L20) 

Converts a `derive` impl into a manual one.

#### Before
```rust
#[derive(Deb┃ug, Display)]
struct S;
```

#### After
```rust
#[derive(Display)]
struct S;

impl Debug for S {
    ┃fn fmt(&self, f: &mut Formatter) -> Result<()> {
        f.debug_struct("S").finish()
    }
}
```


### `replace_if_let_with_match`
**Source:**  [replace_if_let_with_match.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_if_let_with_match.rs#L20) 

Replaces a `if let` expression with a `match` expression.

#### Before
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    ┃if let Action::Move { distance } = action {
        foo(distance)
    } else {
        bar()
    }
}
```

#### After
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move { distance } => foo(distance),
        _ => bar(),
    }
}
```


### `replace_is_some_with_if_let_some`
**Source:**  [replace_is_method_with_if_let_method.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_is_method_with_if_let_method.rs#L9) 

Replace `if x.is_some()` with `if let Some(_tmp) = x` or `if x.is_ok()` with `if let Ok(_tmp) = x`.

#### Before
```rust
fn main() {
    let x = Some(1);
    if x.is_som┃e() {}
}
```

#### After
```rust
fn main() {
    let x = Some(1);
    if let Some(${0:x1}) = x {}
}
```


### `replace_let_with_if_let`
**Source:**  [replace_let_with_if_let.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_let_with_if_let.rs#L9) 

Replaces `let` with an `if let`.

#### Before
```rust

fn main(action: Action) {
    ┃let x = compute();
}

fn compute() -> Option<i32> { None }
```

#### After
```rust

fn main(action: Action) {
    if let Some(x) = compute() {
    }
}

fn compute() -> Option<i32> { None }
```


### `replace_match_with_if_let`
**Source:**  [replace_if_let_with_match.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_if_let_with_match.rs#L188) 

Replaces a binary `match` with a wildcard pattern and no guards with an `if let` expression.

#### Before
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    ┃match action {
        Action::Move { distance } => foo(distance),
        _ => bar(),
    }
}
```

#### After
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    if let Action::Move { distance } = action {
        foo(distance)
    } else {
        bar()
    }
}
```


### `replace_named_generic_with_impl`
**Source:**  [replace_named_generic_with_impl.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_named_generic_with_impl.rs#L18) 

Replaces named generic with an `impl Trait` in function argument.

#### Before
```rust
fn new<P┃: AsRef<Path>>(location: P) -> Self {}
```

#### After
```rust
fn new(location: impl AsRef<Path>) -> Self {}
```


### `replace_qualified_name_with_use`
**Source:**  [replace_qualified_name_with_use.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_qualified_name_with_use.rs#L13) 

Adds a use statement for a given fully-qualified name.

#### Before
```rust
fn process(map: std::collections::┃HashMap<String, String>) {}
```

#### After
```rust
use std::collections::HashMap;

fn process(map: HashMap<String, String>) {}
```


### `replace_string_with_char`
**Source:**  [replace_string_with_char.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_string_with_char.rs#L11) 

Replace string literal with char literal.

#### Before
```rust
fn main() {
    find("{┃");
}
```

#### After
```rust
fn main() {
    find('{');
}
```


### `replace_try_expr_with_match`
**Source:**  [replace_try_expr_with_match.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_try_expr_with_match.rs#L18) 

Replaces a `try` expression with a `match` expression.

#### Before
```rust
fn handle() {
    let pat = Some(true)┃?;
}
```

#### After
```rust
fn handle() {
    let pat = match Some(true) {
        Some(it) => it,
        None => return None,
    };
}
```


### `replace_turbofish_with_explicit_type`
**Source:**  [replace_turbofish_with_explicit_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_turbofish_with_explicit_type.rs#L12) 

Converts `::<_>` to an explicit type assignment.

#### Before
```rust
fn make<T>() -> T { ) }
fn main() {
    let a = make┃::<i32>();
}
```

#### After
```rust
fn make<T>() -> T { ) }
fn main() {
    let a: i32 = make();
}
```


### `replace_with_eager_method`
**Source:**  [replace_method_eager_lazy.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_method_eager_lazy.rs#L89) 

Replace `unwrap_or_else` with `unwrap_or` and `ok_or_else` with `ok_or`.

#### Before
```rust
fn foo() {
    let a = Some(1);
    a.unwra┃p_or_else(|| 2);
}
```

#### After
```rust
fn foo() {
    let a = Some(1);
    a.unwrap_or(2);
}
```


### `replace_with_lazy_method`
**Source:**  [replace_method_eager_lazy.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/replace_method_eager_lazy.rs#L9) 

Replace `unwrap_or` with `unwrap_or_else` and `ok_or` with `ok_or_else`.

#### Before
```rust
fn foo() {
    let a = Some(1);
    a.unwra┃p_or(2);
}
```

#### After
```rust
fn foo() {
    let a = Some(1);
    a.unwrap_or_else(|| 2);
}
```


### `sort_items`
**Source:**  [sort_items.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/sort_items.rs#L12) 

Sorts item members alphabetically: fields, enum variants and methods.

#### Before
```rust
struct ┃Foo┃ { second: u32, first: String }
```

#### After
```rust
struct Foo { first: String, second: u32 }
```

---

#### Before
```rust
trait ┃Bar┃ {
    fn second(&self) -> u32;
    fn first(&self) -> String;
}
```

#### After
```rust
trait Bar {
    fn first(&self) -> String;
    fn second(&self) -> u32;
}
```

---

#### Before
```rust
struct Baz;
impl ┃Baz┃ {
    fn second(&self) -> u32;
    fn first(&self) -> String;
}
```

#### After
```rust
struct Baz;
impl Baz {
    fn first(&self) -> String;
    fn second(&self) -> u32;
}
```

---
There is a difference between sorting enum variants:

#### Before
```rust
enum ┃Animal┃ {
  Dog(String, f64),
  Cat { weight: f64, name: String },
}
```

#### After
```rust
enum Animal {
  Cat { weight: f64, name: String },
  Dog(String, f64),
}
```

and sorting a single enum struct variant:

#### Before
```rust
enum Animal {
  Dog(String, f64),
  Cat ┃{ weight: f64, name: String }┃,
}
```

#### After
```rust
enum Animal {
  Dog(String, f64),
  Cat { name: String, weight: f64 },
}
```


### `split_import`
**Source:**  [split_import.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/split_import.rs#L5) 

Wraps the tail of import into braces.

#### Before
```rust
use std::┃collections::HashMap;
```

#### After
```rust
use std::{collections::HashMap};
```


### `sugar_impl_future_into_async`
**Source:**  [toggle_async_sugar.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/toggle_async_sugar.rs#L13) 

Rewrites asynchronous function from `-> impl Future` into `async fn`.
This action does not touch the function body and therefore `async { 0 }`
block does not transform to just `0`.

#### Before
```rust
pub fn foo() -> impl core::future::F┃uture<Output = usize> {
    async { 0 }
}
```

#### After
```rust
pub async fn foo() -> usize {
    async { 0 }
}
```


### `toggle_ignore`
**Source:**  [toggle_ignore.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/toggle_ignore.rs#L8) 

Adds `#[ignore]` attribute to the test.

#### Before
```rust
┃#[test]
fn arithmetics {
    assert_eq!(2 + 2, 5);
}
```

#### After
```rust
#[test]
#[ignore]
fn arithmetics {
    assert_eq!(2 + 2, 5);
}
```


### `toggle_macro_delimiter`
**Source:**  [toggle_macro_delimiter.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/toggle_macro_delimiter.rs#L9) 

Change macro delimiters in the order of `( -> { -> [ -> (`.

#### Before
```rust
macro_rules! sth {
    () => {};
}

sth!┃( );
```

#### After
```rust
macro_rules! sth {
    () => {};
}

sth!{ }
```


### `unmerge_match_arm`
**Source:**  [unmerge_match_arm.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unmerge_match_arm.rs#L10) 

Splits the current match with a `|` pattern into two arms with identical bodies.

#### Before
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move(..) ┃| Action::Stop => foo(),
    }
}
```

#### After
```rust
enum Action { Move { distance: u32 }, Stop }

fn handle(action: Action) {
    match action {
        Action::Move(..) => foo(),
        Action::Stop => foo(),
    }
}
```


### `unmerge_use`
**Source:**  [unmerge_use.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unmerge_use.rs#L12) 

Extracts single use item from use list.

#### Before
```rust
use std::fmt::{Debug, Display┃};
```

#### After
```rust
use std::fmt::{Debug};
use std::fmt::Display;
```


### `unnecessary_async`
**Source:**  [unnecessary_async.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unnecessary_async.rs#L17) 

Removes the `async` mark from functions which have no `.await` in their body.
Looks for calls to the functions and removes the `.await` on the call site.

#### Before
```rust
pub asy┃nc fn foo() {}
pub async fn bar() { foo().await }
```

#### After
```rust
pub fn foo() {}
pub async fn bar() { foo() }
```


### `unqualify_method_call`
**Source:**  [unqualify_method_call.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unqualify_method_call.rs#L9) 

Transforms universal function call syntax into a method call.

#### Before
```rust
fn main() {
    std::ops::Add::add┃(1, 2);
}
```

#### After
```rust
use std::ops::Add;

fn main() {
    1.add(2);
}
```


### `unwrap_block`
**Source:**  [unwrap_block.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unwrap_block.rs#L12) 

This assist removes if...else, for, while and loop control statements to just keep the body.

#### Before
```rust
fn foo() {
    if true {┃
        println!("foo");
    }
}
```

#### After
```rust
fn foo() {
    println!("foo");
}
```


### `unwrap_option_return_type`
**Source:**  [unwrap_return_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unwrap_return_type.rs#L13) 

Unwrap the function's return type.

#### Before
```rust
fn foo() -> Option<i32>┃ { Some(42i32) }
```

#### After
```rust
fn foo() -> i32 { 42i32 }
```


### `unwrap_result_return_type`
**Source:**  [unwrap_return_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unwrap_return_type.rs#L26) 

Unwrap the function's return type.

#### Before
```rust
fn foo() -> Result<i32>┃ { Ok(42i32) }
```

#### After
```rust
fn foo() -> i32 { 42i32 }
```


### `unwrap_tuple`
**Source:**  [unwrap_tuple.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/unwrap_tuple.rs#L8) 

Unwrap the tuple to different variables.

#### Before
```rust
fn main() {
    ┃let (foo, bar) = ("Foo", "Bar");
}
```

#### After
```rust
fn main() {
    let foo = "Foo";
    let bar = "Bar";
}
```


### `wrap_return_type_in_option`
**Source:**  [wrap_return_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/wrap_return_type.rs#L16) 

Wrap the function's return type into Option.

#### Before
```rust
fn foo() -> i32┃ { 42i32 }
```

#### After
```rust
fn foo() -> Option<i32> { Some(42i32) }
```


### `wrap_return_type_in_result`
**Source:**  [wrap_return_type.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/wrap_return_type.rs#L29) 

Wrap the function's return type into Result.

#### Before
```rust
fn foo() -> i32┃ { 42i32 }
```

#### After
```rust
fn foo() -> Result<i32, ${0:_}> { Ok(42i32) }
```


### `wrap_unwrap_cfg_attr`
**Source:**  [wrap_unwrap_cfg_attr.rs](https://github.com/rust-lang/rust-analyzer/blob/master/crates/ide-assists/src/handlers/wrap_unwrap_cfg_attr.rs#L12) 

Wraps an attribute to a cfg_attr attribute or unwraps a cfg_attr attribute to the inner attributes.

#### Before
```rust
#[derive┃(Debug)]
struct S {
   field: i32
}
```

#### After
```rust
#[cfg_attr(┃, derive(Debug))]
struct S {
   field: i32
}
```
