# Logic to build packages (RPM/DEB) using CPack; see https://cmake.org/Wiki/CMake:Packaging_With_CPack
# 

set(LINUX_NAME "")
set(IS_DEBIAN_PACKAGE FALSE)
if(EXISTS "/etc/redhat-release")
  file(READ "/etc/redhat-release" LINUX_ISSUE)
  if(LINUX_ISSUE MATCHES "CentOS")
    set(CPACK_GENERATOR "RPM")
    set(CPACK_SYSTEM_NAME "centos")
    set(CPACK_RPM_PACKAGE_REQUIRES   "centos-release-scl, epel-release, rh-python36, gmp, libuuid, sqlite, gtkmm30, boost-system, boost-filesystem, boost-program-options, boost-regex, libstdc++")
    message("-- This is a CentOS system")
  endif()
  if(LINUX_ISSUE MATCHES "Scientific Linux")
    set(CPACK_GENERATOR "RPM")
    set(CPACK_SYSTEM_NAME "scientific7x")
    set(CPACK_RPM_PACKAGE_REQUIRES   "yum-conf-softwarecollections, epel-release, rh-python36, gmp, libuuid, sqlite, gtkmm30, boost-system, boost-filesystem, boost-program-options, boost-regex, libstdc++")
    message("-- This is a CentOS system")
  endif()
  if(LINUX_ISSUE MATCHES "Fedora")
    set(CPACK_GENERATOR   "RPM")
    if(LINUX_ISSUE MATCHES "40")
      message("-- This is a Fedora 40 system")
      set(CPACK_RPM_PACKAGE_REQUIRES   "python3, python3-libs, gmp, libuuid, sqlite, gtkmm30, openssl, boost-system, boost-filesystem, boost-program-options, boost-regex, libstdc++, python3-matplotlib, python3-sympy")
      set(CPACK_SYSTEM_NAME "fedora40-${STANDARD_ARCH_NAME}")
    elseif(LINUX_ISSUE MATCHES "41")
      message("-- This is a Fedora 41 system")
      set(CPACK_RPM_PACKAGE_REQUIRES   "python3, python3-libs, gmp, libuuid, sqlite, gtkmm30, openssl, boost-system, boost-filesystem, boost-program-options, boost-regex, libstdc++, python3-matplotlib, python3-sympy")
      set(CPACK_SYSTEM_NAME "fedora41-${STANDARD_ARCH_NAME}")
    elseif(LINUX_ISSUE MATCHES "42")
      message("-- This is a Fedora 42 system")
      set(CPACK_RPM_PACKAGE_REQUIRES   "python3, python3-libs, gmp, libuuid, sqlite, gtkmm30, openssl, boost-system, boost-filesystem, boost-program-options, boost-regex, libstdc++, python3-matplotlib, python3-sympy")
      set(CPACK_SYSTEM_NAME "fedora42-${STANDARD_ARCH_NAME}")
    else()	
      message(FATAL_ERROR "-- This is an old Fedora system <40, we do not support packaging for this anymore.")
    endif()
  endif()
else()
  if(EXISTS "/etc/os-release")
    file(READ "/etc/os-release" LINUX_ISSUE)
    if(LINUX_ISSUE MATCHES "15.0")
      set(CPACK_SYSTEM_NAME "leap150")
      set(CPACK_GENERATOR   "RPM")
      message("-- This is an openSUSE Leap 15.0 system (UNSUPPORTED)")
      set(CPACK_RPM_PACKAGE_REQUIRES   "libpython3_6m1_0, libgmp10, libuuid1, libsqlite3-0, libgtkmm-3_0-1, libboost_system1_66_0, libboost_filesystem1_66_0, libboost_program_options1_66_0, libboost_regex1_66_0, libstdc++6, python3-matplotlib, python3-sympy")
    endif()
    if(LINUX_ISSUE MATCHES "Tumbleweed")
      set(CPACK_SYSTEM_NAME "tumbleweed")
      set(CPACK_GENERATOR   "RPM")
      message("-- This is an openSUSE Tumbleweed system")
      set(CPACK_RPM_PACKAGE_REQUIRES   "libpython3_13-1_0, libgmp10, libuuid1, libgtkmm-3_0-1, openssl, libboost_system1_87_0, libboost_filesystem1_87_0, libboost_program_options1_87_0, libboost_regex1_87_0, libstdc++6, python313-matplotlib, python313-sympy")
    endif()
  endif()
  if(EXISTS "/etc/issue")
    file(READ "/etc/issue" LINUX_ISSUE)
    if(LINUX_ISSUE MATCHES "openSUSE")
      if(LINUX_ISSUE MATCHES "42.1")
   	set(CPACK_SYSTEM_NAME "leap421")
	set(CPACK_GENERATOR   "RPM")
	message("-- This is an openSUSE Leap 42.1 system (UNSUPPORTED)")
	set(CPACK_RPM_PACKAGE_REQUIRES   "libpython3_4m1_0, libgmp10, libuuid1, libsqlite3-0, libgtkmm-3_0-1, libboost_system1_61_0, libboost_filesystem1_61_0, libboost_program_options1_61_0, libboost_regex1_61_0, libstdc++6, python3-matplotlib")
      endif()
    endif()
    if(LINUX_ISSUE MATCHES "Debian")
      set(CPACK_GENERATOR   "DEB")
      set(IS_DEBIAN_PACKAGE TRUE)
      if(PACKAGING_MODE)
	set(PYTHON_SITE_PATH  "/usr/lib/python3/dist-packages")
	set(INSTALL_LATEX_DIR  "/usr/share/texmf")
      endif()
      if(LINUX_ISSUE MATCHES "8")
   	set(CPACK_SYSTEM_NAME "jessie")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libboost-system1.55.0, libboost-filesystem1.55.0, libboost-program-options1.55.0, libboost-regex1.55.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
   	message("-- This is a Debian Jessie 8.x system")
      endif()
      if(LINUX_ISSUE MATCHES "9")
   	set(CPACK_SYSTEM_NAME "stretch")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libboost-system1.62.0, libboost-filesystem1.62.0, libboost-program-options1.62.0, libboost-regex1.62.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
   	message("-- This is a Debian Stretch 9.x system")
      endif()
      if(LINUX_ISSUE MATCHES "buster")
   	set(CPACK_SYSTEM_NAME "buster")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libboost-system1.67.0, libboost-filesystem1.67.0, libboost-program-options1.67.0, libboost-regex1.67.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
   	message("-- This is a Debian Buster 10.x system")
      endif()
      if(LINUX_ISSUE MATCHES "10")
   	set(CPACK_SYSTEM_NAME "buster")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libboost-system1.67.0, libboost-filesystem1.67.0, libboost-program-options1.67.0, libboost-regex1.67.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
   	message("-- This is a Debian Buster 10.x system")
      endif()
    endif()
    if(LINUX_ISSUE MATCHES "Ubuntu")
      set(CPACK_GENERATOR   "DEB")
      set(IS_DEBIAN_PACKAGE TRUE)
      if(PACKAGING_MODE)
	set(PYTHON_SITE_PATH  "/usr/lib/python3/dist-packages")
	set(INSTALL_LATEX_DIR  "/usr/share/texmf")
      endif()
      if(LINUX_ISSUE MATCHES "20.04")
   	set(CPACK_SYSTEM_NAME "focal-${STANDARD_ARCH_NAME}")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libssl3, libboost-system1.71.0, libboost-filesystem1.71.0, libboost-program-options1.71.0, libboost-regex1.71.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
   	message("-- This is an Ubuntu 20.04 system")
      endif()
      if(LINUX_ISSUE MATCHES "22.04")
   	set(CPACK_SYSTEM_NAME "ubuntu-22.04-jammy-${STANDARD_ARCH_NAME}")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libssl3, libboost-system1.74.0, libboost-filesystem1.74.0, libboost-program-options1.74.0, libboost-regex1.74.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
   	message("-- This is an Ubuntu 22.04 system")
      endif()
      if(LINUX_ISSUE MATCHES "24.04")
   	set(CPACK_SYSTEM_NAME "ubuntu-24.04-noble-${STANDARD_ARCH_NAME}")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libssl3, libboost-system1.83.0, libboost-filesystem1.83.0, libboost-program-options1.83.0, libboost-regex1.83.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1t64, librsvg2-2, librsvg2-common, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
   	message("-- This is an Ubuntu 24.04 system")
      endif()
    endif()
    if(LINUX_ISSUE MATCHES "Mint")
      set(CPACK_GENERATOR "DEB")
      set(IS_DEBIAN_PACKAGE TRUE)
      if(PACKAGING_MODE)
	set(PYTHON_SITE_PATH   "/usr/lib/python3/dist-packages")
	set(INSTALL_LATEX_DIR  "/usr/share/texmf")
      endif()
      if(LINUX_ISSUE MATCHES "19")
   	message("-- This is a Linux Mint 19 system")
   	set(CPACK_SYSTEM_NAME "tessa")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libboost-system1.65.1, libboost-filesystem1.65.1, libboost-program-options1.65.1, libboost-regex1.65.1, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
      endif()
      if(LINUX_ISSUE MATCHES "20")
   	message("-- This is a Linux Mint 20 system")
   	set(CPACK_SYSTEM_NAME "ulyana")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libboost-system1.71.0, libboost-filesystem1.71.0, libboost-program-options1.71.0, libboost-regex1.71.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
      endif()
      if(LINUX_ISSUE MATCHES "21")
   	message("-- This is a Linux Mint 21 system")
   	set(CPACK_SYSTEM_NAME "vanessa")
	set(CPACK_DEBIAN_PACKAGE_DEPENDS "python3, libgmpxx4ldbl, libboost-system1.74.0, libboost-filesystem1.74.0, libboost-program-options1.74.0, libboost-regex1.74.0, libstdc++6, uuid-runtime, libgtkmm-3.0-1v5, python3-matplotlib, python3-mpmath, python3-sympy, python3-gmpy2")
      endif()
    endif()
  endif()
endif()

if(WIN32)
  message("-- This is a Windows system, creating WIX installer")
  # A good resource (though not complete) for CPack on various platforms is
  # https://martin-fieber.de/blog/cmake-cpack-cross-platform-distributables/
  #   set(CPACK_GENERATOR NSIS)
  #   set(CPACK_PACKAGE_INSTALL_DIRECTORY "Cadabra")
  #   set(CPACK_NSIS_MODIFY_PATH OFF)
  #   set(CPACK_NSIS_EXECUTABLES_DIRECTORY .)
  #   set(CPACK_NSIS_URL_INFO_ABOUT "https://cadabra.science/")
  #   set(CPACK_NSIS_CONTACT "Kasper Peeters <info@cadabra.science>")
  set(CPACK_GENERATOR WIX)
  set(CPACK_WIX_ROOT "C:/WiX")
  set(CPACK_WIX_VERSION 4)
  set(CPACK_WIX_ARCHITECTURE "${WIX_SHORT_ARCH}")
  set(CPACK_WIX_LIGHT_EXTRA_FLAGS "-sw1076")
  set(CPACK_WIX_DESKTOP_SHORTCUTS TRUE)
  set(CPACK_WIX_PROGRAM_MENU_FOLDER "Cadabra")
  set(CPACK_PACKAGE_INSTALL_DIRECTORY "Cadabra")
  set(CPACK_WIX_PROPERTY_ARPURLINFOABOUT "https://cadabra.science/")
  set(CPACK_WIX_PROPERTY_ARPCONTACT "Kasper Peeters <info@cadabra.science>")
  set(CPACK_WIX_UPGRADE_GUID "7CD938BA-C9E0-4CF0-8649-B44F292C01B5")
  set(CPACK_WIX_UI_BANNER "${CMAKE_SOURCE_DIR}/doc/msi_banner.png")
  set(CPACK_WIX_UI_DIALOG "${CMAKE_SOURCE_DIR}/doc/msi_dialog.png")
  set(CPACK_WIX_PRODUCT_ICON "${CMAKE_SOURCE_DIR}/config/cadabra2.ico") 
  set(CPACK_PACKAGE_EXECUTABLES "cadabra2-gtk" "Cadabra") 
  set(CPACK_CREATE_DESKTOP_LINKS "cadabra2-gtk")
#  set(CPACK_WIX_EXTRA_SOURCES "${CMAKE_SOURCE_DIR}/config/shortcuts.wxs")
  set(CPACK_START_MENU_SHORTCUTS "Cadabra")
endif()

# Ensure that on Windows we also install the libraries provided
# by Visual Studio, e.g. MSVCnnn.DLL. This does mean that the installer
# will now contain both the normal and the debug libraries, but better
# to have both than to have none.
#   set(CMAKE_INSTALL_DEBUG_LIBRARIES TRUE)
# That didn't work... Commented out for future reference.

include (InstallRequiredSystemLibraries)

if(NOT WIN32)
  set(CPACK_SET_DESTDIR true)
endif()
set(CPACK_INSTALL_PREFIX /usr)
set(CPACK_PACKAGE_NAME           "cadabra2")
set(CPACK_RESOURCE_FILE_LICENSE  "${CMAKE_CURRENT_SOURCE_DIR}/doc/license.txt")
set(CPACK_RPM_PACKAGE_LICENSE    "GPLv3")
set(CPACK_PACKAGE_VERSION_MAJOR  "${CADABRA_VERSION_MAJOR}")
set(CPACK_PACKAGE_VERSION_MINOR  "${CADABRA_VERSION_MINOR}")
set(CPACK_PACKAGE_VERSION_PATCH  "${CADABRA_VERSION_PATCH}")
set(CPACK_PACKAGE_VERSION        "${CADABRA_VERSION_SEM}")
set(CPACK_PACKAGE_VENDOR         "Kasper Peeters")
set(CPACK_PACKAGE_CONTACT        "Kasper Peeters <info@cadabra.science>")
set(CPACK_STRIP_FILES            ON)
set(CPACK_DEBIAN_PACKAGE_CONTROL_EXTRA ${CMAKE_CURRENT_BINARY_DIR}/postinst)
set(CPACK_RPM_POST_INSTALL_SCRIPT_FILE ${CMAKE_CURRENT_BINARY_DIR}/postinst)
unset(CPACK_RPM_PACKAGE_RELOCATABLE)

#xdg-desktop-menu install <install>/share/applications/MyApp.desktop

set(CPACK_DEBIAN_PACKAGE_SECTION "math")
set(CPACK_RPM_PACKAGE_GROUP      "Applications/Productivity")

set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "field-theory motivated computer algebra system")
set(CPACK_PACKAGE_DESCRIPTION_FILE ${CMAKE_CURRENT_SOURCE_DIR}/doc/description)
include(CPack)
