;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Test --inline-max-combined-binary-size option suppresses inlining.

;; The expected behavior:
;;
;;   for $main,
;;     DEFAULT and IMCBS96 inline call-bar and call-foo.
;;     IMCBS90 and IMCBS0 don't inline them because inlining would make
;;     the (inliner's estimate of) size of $main exceed the specified limit.
;;
;;   for $small-main,
;;     DEFAULT, IMCBS96, and IMCBS90 inline call-foo.
;;     IMCBS0 doesn't inline it.

;; RUN: foreach %s %t wasm-opt -O3 -S -o - | filecheck %s --check-prefix=DEFAULT
;; RUN: foreach %s %t wasm-opt -O3 --inline-max-combined-binary-size=96 -S -o - | filecheck %s --check-prefix=IMCBS96
;; RUN: foreach %s %t wasm-opt -O3 --inline-max-combined-binary-size=90 -S -o - | filecheck %s --check-prefix=IMCBS90
;; RUN: foreach %s %t wasm-opt -O3 --inline-max-combined-binary-size=0 -S -o - | filecheck %s --check-prefix=IMCBS0

(module
 ;; DEFAULT:      (type $0 (func (param i32 i32 i32)))
 ;; IMCBS96:      (type $0 (func (param i32 i32 i32)))
 ;; IMCBS90:      (type $1 (func))

 ;; IMCBS90:      (type $0 (func (param i32 i32 i32)))
 ;; IMCBS0:      (type $1 (func))

 ;; IMCBS0:      (type $0 (func (param i32 i32 i32)))
 (type $0 (func (param i32 i32 i32)))

 ;; DEFAULT:      (type $1 (func))
 ;; IMCBS96:      (type $1 (func))
 (type $1 (func))

 (type $2 (func))

 ;; DEFAULT:      (import "env" "foo" (func $imported-foo (param i32 i32 i32)))
 ;; IMCBS96:      (import "env" "foo" (func $imported-foo (param i32 i32 i32)))
 ;; IMCBS90:      (import "env" "foo" (func $imported-foo (param i32 i32 i32)))
 ;; IMCBS0:      (import "env" "foo" (func $imported-foo (param i32 i32 i32)))
 (import "env" "foo" (func $imported-foo (type $0) (param i32 i32 i32)))

 ;; DEFAULT:      (import "env" "bar" (func $imported-bar (param i32 i32 i32)))
 ;; IMCBS96:      (import "env" "bar" (func $imported-bar (param i32 i32 i32)))
 ;; IMCBS90:      (import "env" "bar" (func $imported-bar (param i32 i32 i32)))
 ;; IMCBS0:      (import "env" "bar" (func $imported-bar (param i32 i32 i32)))
 (import "env" "bar" (func $imported-bar (type $0) (param i32 i32 i32)))

 ;; DEFAULT:      (export "main" (func $main))
 ;; IMCBS96:      (export "main" (func $main))
 ;; IMCBS90:      (export "main" (func $main))
 ;; IMCBS0:      (export "main" (func $main))
 (export "main" (func $main))

 ;; DEFAULT:      (export "small-main" (func $small-main))
 ;; IMCBS96:      (export "small-main" (func $small-main))
 ;; IMCBS90:      (export "small-main" (func $small-main))
 ;; IMCBS0:      (export "small-main" (func $small-main))
 (export "small-main" (func $small-main))

 ;; IMCBS90:      (func $call-foo
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT: )
 ;; IMCBS0:      (func $call-foo
 ;; IMCBS0-NEXT:  (call $imported-foo
 ;; IMCBS0-NEXT:   (i32.const 1)
 ;; IMCBS0-NEXT:   (i32.const 2)
 ;; IMCBS0-NEXT:   (i32.const 3)
 ;; IMCBS0-NEXT:  )
 ;; IMCBS0-NEXT: )
 (func $call-foo (type $1)
  (call $imported-foo
   (i32.const 1)
   (i32.const 2)
   (i32.const 3)))

 ;; IMCBS90:      (func $call-bar
 ;; IMCBS90-NEXT:  (call $imported-bar
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT: )
 ;; IMCBS0:      (func $call-bar
 ;; IMCBS0-NEXT:  (call $imported-bar
 ;; IMCBS0-NEXT:   (i32.const 1)
 ;; IMCBS0-NEXT:   (i32.const 2)
 ;; IMCBS0-NEXT:   (i32.const 3)
 ;; IMCBS0-NEXT:  )
 ;; IMCBS0-NEXT: )
 (func $call-bar (type $1)
  (call $imported-bar
   (i32.const 1)
   (i32.const 2)
   (i32.const 3)))

 ;; DEFAULT:      (func $main
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-bar
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT: )
 ;; IMCBS96:      (func $main
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-bar
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT: )
 ;; IMCBS90:      (func $main
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-foo)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT:  (call $call-bar)
 ;; IMCBS90-NEXT: )
 ;; IMCBS0:      (func $main
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT:  (call $call-bar)
 ;; IMCBS0-NEXT: )
 (func $main (type $2)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)

  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)

  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)

  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)

  (call $call-bar)
  (call $call-bar)
  (call $call-bar)
  (call $call-bar)

  (call $call-bar)
  (call $call-bar)
  (call $call-bar)
  (call $call-bar)

  (call $call-bar)
  (call $call-bar)
  (call $call-bar)
  (call $call-bar)

  (call $call-bar)
  (call $call-bar)
  (call $call-bar)
  (call $call-bar))

 ;; DEFAULT:      (func $small-main
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT:  (call $imported-foo
 ;; DEFAULT-NEXT:   (i32.const 1)
 ;; DEFAULT-NEXT:   (i32.const 2)
 ;; DEFAULT-NEXT:   (i32.const 3)
 ;; DEFAULT-NEXT:  )
 ;; DEFAULT-NEXT: )
 ;; IMCBS96:      (func $small-main
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT:  (call $imported-foo
 ;; IMCBS96-NEXT:   (i32.const 1)
 ;; IMCBS96-NEXT:   (i32.const 2)
 ;; IMCBS96-NEXT:   (i32.const 3)
 ;; IMCBS96-NEXT:  )
 ;; IMCBS96-NEXT: )
 ;; IMCBS90:      (func $small-main
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT:  (call $imported-foo
 ;; IMCBS90-NEXT:   (i32.const 1)
 ;; IMCBS90-NEXT:   (i32.const 2)
 ;; IMCBS90-NEXT:   (i32.const 3)
 ;; IMCBS90-NEXT:  )
 ;; IMCBS90-NEXT: )
 ;; IMCBS0:      (func $small-main
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT:  (call $call-foo)
 ;; IMCBS0-NEXT: )
 (func $small-main (type $2)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)

  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)

  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)

  (call $call-foo)
  (call $call-foo)
  (call $call-foo)
  (call $call-foo)))
