;; NOTE: Assertions have been generated by update_lit_checks.py --output=fuzz-exec and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --fuzz-exec-before -q -o /dev/null 2>&1 | filecheck %s

;; Three exports, one which suspends, another that does a resume-throw but
;; catches it, and another that does a suspend through a call to JS, then a
;; normal suspend. This is a regression test for a bug where the global state of
;; continuations got into a confused state in the middle, and asserted.

(module
 (type $func (func))
 (type $cont (cont $func))

 (import "fuzzing-support" "call-export-catch" (func $call-export-catch (param i32) (result i32)))

 (tag $tag (type $func))

 ;; CHECK:      [fuzz-exec] calling suspend
 ;; CHECK-NEXT: [exception thrown: unhandled suspend]
 (func $suspend (export "suspend")
  (suspend $tag)
 )

 ;; CHECK:      [fuzz-exec] calling try-resume
 (func $try-resume (export "try-resume")
  (block $block
   (try_table (catch_all $block)
    (resume_throw $cont $tag
     (cont.new $cont
      (ref.func $nop)
     )
    )
   )
  )
 )

 ;; CHECK:      [fuzz-exec] calling call-suspend
 ;; CHECK-NEXT: [exception thrown: unhandled suspend]
 (func $call-suspend (export "call-suspend")
  (drop
   (call $call-export-catch
    (i32.const 0)
   )
  )
  (suspend $tag)
 )

 (func $nop
 )
)

