/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.ee9.nested.AsyncContextEvent;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.CrossContextServletContext;
import org.eclipse.jetty.ee9.nested.ErrorHandler;
import org.eclipse.jetty.ee9.nested.HttpChannelListeners;
import org.eclipse.jetty.ee9.nested.HttpChannelState;
import org.eclipse.jetty.ee9.nested.HttpInput;
import org.eclipse.jetty.ee9.nested.HttpOutput;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.ee9.nested.Response;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannel
implements Runnable,
HttpOutput.Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannel.class);
    private final ContextHandler _contextHandler;
    private final ConnectionMetaData _connectionMetaData;
    private final AtomicLong _requests = new AtomicLong();
    private final Connector _connector;
    private final Executor _executor;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private final Listener _combinedListener;
    private final Dispatchable _requestDispatcher;
    private final Dispatchable _asyncDispatcher;
    private final DemandTask _needContentTask;
    @Deprecated
    private final List<Listener> _transientListeners = new ArrayList<Listener>();
    private MetaData.Response _committedMetaData;
    private long _oldIdleTimeout;
    private long _written;
    private ContextHandler.CoreContextRequest _coreRequest;
    private org.eclipse.jetty.server.Response _coreResponse;
    private Callback _coreCallback;

    public HttpChannel(ContextHandler contextHandler, ConnectionMetaData connectionMetaData) {
        this._contextHandler = contextHandler;
        this._connectionMetaData = connectionMetaData;
        this._connector = connectionMetaData.getConnector();
        this._configuration = Objects.requireNonNull(connectionMetaData.getHttpConfiguration());
        this._endPoint = connectionMetaData.getConnection().getEndPoint();
        this._state = new HttpChannelState(this);
        this._request = new Request(this, this.newHttpInput());
        this._response = new Response(this, this.newHttpOutput());
        this._executor = this._connector.getServer().getThreadPool();
        this._combinedListener = new HttpChannelListeners(this._connector.getBeans(Listener.class));
        this._requestDispatcher = new RequestDispatchable();
        this._asyncDispatcher = new AsyncDispatchable();
        this._needContentTask = new DemandTask();
        if (LOG.isDebugEnabled()) {
            LOG.debug("new {} -> {},{},{}", new Object[]{this, this._endPoint, this._endPoint == null ? null : this._endPoint.getConnection(), this._state});
        }
    }

    public ContextHandler getContextHandler() {
        return this._contextHandler;
    }

    public boolean isSendError() {
        return this._state.isSendError();
    }

    protected HttpInput newHttpInput() {
        return new HttpInput(this);
    }

    public ConnectionMetaData getConnectionMetaData() {
        return this._connectionMetaData;
    }

    public boolean needContent() {
        ContextHandler.CoreContextRequest coreContextRequest = this.getCoreRequest();
        if (coreContextRequest == null) {
            return true;
        }
        coreContextRequest.demand((Runnable)((Object)this._needContentTask));
        return false;
    }

    public HttpInput.Content produceContent() {
        ContextHandler.CoreContextRequest coreContextRequest = this.getCoreRequest();
        if (coreContextRequest == null) {
            return new HttpInput.ErrorContent(new IOException("Channel has been recycled"));
        }
        Content.Chunk chunk = coreContextRequest.read();
        if (chunk == null) {
            return null;
        }
        if (chunk.hasRemaining()) {
            this.onContent(chunk);
        }
        if (chunk instanceof Trailers) {
            Trailers trailers = (Trailers)chunk;
            this.onTrailers(trailers.getTrailers());
        }
        if (chunk.isLast()) {
            this.onContentComplete();
        }
        return HttpInput.Content.asChunk(chunk);
    }

    public boolean failAllContent(Throwable failure) {
        HttpInput.Content content;
        do {
            if ((content = this.produceContent()) == null) {
                return false;
            }
            if (content.isSpecial()) {
                return content.isEof();
            }
            content.failed(failure);
        } while (!content.isEof());
        return true;
    }

    public boolean failed(Throwable failure) {
        return true;
    }

    protected boolean eof() {
        return false;
    }

    protected HttpOutput newHttpOutput() {
        return new HttpOutput(this);
    }

    public HttpChannelState getState() {
        return this._state;
    }

    @Deprecated
    public boolean addListener(Listener listener) {
        return this._transientListeners.add(listener);
    }

    @Deprecated
    public boolean removeListener(Listener listener) {
        return this._transientListeners.remove(listener);
    }

    @Deprecated
    public List<Listener> getTransientListeners() {
        return this._transientListeners;
    }

    public long getBytesWritten() {
        return this._written;
    }

    public long getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public MetaData.Response getCommittedMetaData() {
        return this._committedMetaData;
    }

    public long getIdleTimeout() {
        return this._endPoint.getIdleTimeout();
    }

    public void setIdleTimeout(long timeoutMs) {
        this._endPoint.setIdleTimeout(timeoutMs);
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public ContextHandler.CoreContextRequest getCoreRequest() {
        return this._coreRequest;
    }

    public Request getRequest() {
        return this._request;
    }

    public org.eclipse.jetty.server.Response getCoreResponse() {
        return this._coreResponse;
    }

    public Response getResponse() {
        return this._response;
    }

    public Connection getConnection() {
        return this._endPoint.getConnection();
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public String getLocalName() {
        String string;
        SocketAddress socketAddress = this.getConnectionMetaData().getLocalSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            string = org.eclipse.jetty.server.Request.getHostName((InetSocketAddress)inetSocketAddress);
        } else {
            string = null;
        }
        return string;
    }

    public int getLocalPort() {
        int n;
        SocketAddress socketAddress = this.getConnectionMetaData().getLocalSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            n = inetSocketAddress.getPort();
        } else {
            n = 0;
        }
        return n;
    }

    public InetSocketAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress;
        SocketAddress socketAddress = this.getConnectionMetaData().getLocalSocketAddress();
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress inetSocketAddress;
        SocketAddress socketAddress = this.getConnectionMetaData().getRemoteSocketAddress();
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public HostPort getServerAuthority() {
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null) {
            return httpConfiguration.getServerAuthority();
        }
        return null;
    }

    public void send102Processing(HttpFields headers) throws IOException {
        try {
            this._coreResponse.writeInterim(102, headers).get();
        }
        catch (Throwable x) {
            throw IO.rethrow((Throwable)x);
        }
    }

    public void send103EarlyHints(HttpFields headers) throws IOException {
        try {
            this._coreResponse.writeInterim(103, headers).get();
        }
        catch (Throwable x) {
            throw IO.rethrow((Throwable)x);
        }
    }

    public void recycle() {
        this._request.recycle();
        this._response.recycle();
        this._committedMetaData = null;
        this._written = 0L;
        this._transientListeners.clear();
        this._coreRequest = null;
        this._coreResponse = null;
        this._coreCallback = null;
    }

    @Override
    public void run() {
        this.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle {} {} ", (Object)this._request.getHttpURI(), (Object)this);
        }
        HttpChannelState.Action action = this._state.handling();
        block20: while (!this.getServer().isStopped()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action {} {}", (Object)action, (Object)this);
                }
                switch (action) {
                    case TERMINATED: {
                        this.onCompleted();
                        break block20;
                    }
                    case WAIT: {
                        break block20;
                    }
                    case DISPATCH: {
                        if (!this._request.hasMetaData()) {
                            throw new IllegalStateException("state=" + String.valueOf(this._state));
                        }
                        String dispatchType = this._coreRequest.getContext().getCrossContextDispatchType((org.eclipse.jetty.server.Request)this._coreRequest);
                        this.dispatch(dispatchType == null ? DispatcherType.REQUEST : DispatcherType.valueOf((String)dispatchType), this._requestDispatcher);
                        break;
                    }
                    case ASYNC_DISPATCH: {
                        this.dispatch(DispatcherType.ASYNC, this._asyncDispatcher);
                        break;
                    }
                    case ASYNC_TIMEOUT: {
                        this._state.onTimeout();
                        break;
                    }
                    case SEND_ERROR: {
                        try {
                            this._response.resetContent();
                            Integer code = (Integer)this._request.getAttribute("jakarta.servlet.error.status_code");
                            if (code == null) {
                                code = 500;
                            }
                            this._response.setStatus(code);
                            this.ensureConsumeAllOrNotPersistent();
                            ContextHandler.APIContext context = (ContextHandler.APIContext)this._request.getAttribute("org.eclipse.jetty.server.error_context");
                            ErrorHandler errorHandler = ErrorHandler.getErrorHandler(this.getServer(), context == null ? null : context.getContextHandler());
                            if (HttpStatus.hasNoBody((int)this._response.getStatus()) || errorHandler == null || !errorHandler.errorPageForMethod(this._request.getMethod())) {
                                this.sendResponseAndComplete();
                            } else {
                                this.dispatch(DispatcherType.ERROR, new ErrorDispatchable(errorHandler));
                            }
                            break;
                        }
                        catch (Throwable x) {
                            if (LOG.isDebugEnabled()) {
                                LOG.atDebug().setCause(x).log("Could not perform ERROR dispatch, aborting");
                            }
                            this.abort(x);
                            break;
                        }
                        finally {
                            this._request.removeAttribute("org.eclipse.jetty.server.error_context");
                        }
                    }
                    case ASYNC_ERROR: {
                        throw this._state.getAsyncContextEvent().getThrowable();
                    }
                    case READ_CALLBACK: {
                        ContextHandler handler = this._state.getContextHandler();
                        if (handler != null) {
                            handler.handle(this._request, this._request.getHttpInput());
                            break;
                        }
                        this._request.getHttpInput().run();
                        break;
                    }
                    case WRITE_CALLBACK: {
                        ContextHandler handler = this._state.getContextHandler();
                        if (handler != null) {
                            handler.handle(this._request, this._response.getHttpOutput());
                            break;
                        }
                        this._response.getHttpOutput().run();
                        break;
                    }
                    case COMPLETE: {
                        if (!this._response.isCommitted()) {
                            if (!this._request.isHandled() && !this._response.getHttpOutput().isClosed()) {
                                this._response.sendError(404);
                                break;
                            }
                            if (this._response.getStatus() >= 200) {
                                this.ensureConsumeAllOrNotPersistent();
                            }
                        }
                        if (!this._request.isHead() && this._response.getStatus() != 304 && !this._response.isContentComplete(this._response.getHttpOutput().getWritten())) {
                            this.sendErrorOrAbort("Insufficient content written");
                            break;
                        }
                        this._response.completeOutput(Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> this._state.completed(null), this._state::completed));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.toString());
                    }
                }
            }
            catch (Throwable failure) {
                if ("org.eclipse.jetty.continuation.ContinuationThrowable".equals(failure.getClass().getName())) {
                    LOG.trace("IGNORED", failure);
                }
                this.handleException(failure);
            }
            action = this._state.unhandle();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!handle {} {}", (Object)action, (Object)this);
        }
        boolean suspended = action == HttpChannelState.Action.WAIT;
        return !suspended;
    }

    public void ensureConsumeAllOrNotPersistent() {
        if (this._request.getHttpInput().consumeAll()) {
            return;
        }
        if (this._coreRequest.getConnectionMetaData().isPersistent()) {
            this._response.getHttpFields().computeField(HttpHeader.CONNECTION, (h, l) -> {
                HttpField f;
                String v2;
                if (l == null || l.isEmpty()) {
                    return HttpFields.CONNECTION_CLOSE;
                }
                if (l.size() == 1 && (HttpHeaderValue.CLOSE.is(v2 = (f = (HttpField)l.get(0)).getValue()) || HttpHeaderValue.KEEP_ALIVE.is(v2))) {
                    return HttpFields.CONNECTION_CLOSE;
                }
                Object coalesced = l.stream().flatMap(field -> Stream.of(field.getValues())).filter(v -> !HttpHeaderValue.KEEP_ALIVE.is(v)).collect(Collectors.joining(", "));
                if (!HttpField.contains((String)coalesced, (String)HttpHeaderValue.CLOSE.asString())) {
                    coalesced = (String)coalesced + ", close";
                }
                return new HttpField(HttpHeader.CONNECTION, (String)coalesced);
            });
            this._response.getHttpFields().ensureField(HttpFields.CONNECTION_CLOSE);
        }
    }

    public boolean sendErrorOrAbort(String message) {
        try {
            if (this.isCommitted()) {
                this.abort(new IOException(message));
                return false;
            }
            this._response.sendError(500, message);
            return true;
        }
        catch (Throwable x) {
            LOG.trace("IGNORED", x);
            this.abort(x);
            return false;
        }
    }

    private void dispatch(DispatcherType type, Dispatchable dispatchable) throws IOException, ServletException {
        try {
            this._request.setHandled(false);
            this._response.reopen();
            this._request.setDispatcherType(type);
            this._combinedListener.onBeforeDispatch(this._request);
            dispatchable.dispatch();
        }
        catch (Throwable x) {
            this._combinedListener.onDispatchFailure(this._request, x);
            throw x;
        }
        finally {
            this._combinedListener.onAfterDispatch(this._request);
            this._request.setDispatcherType(null);
        }
    }

    protected void handleException(Throwable failure) {
        Throwable quiet = this.unwrap(failure, QuietException.class);
        Throwable noStack = this.unwrap(failure, BadMessageException.class, IOException.class, TimeoutException.class);
        if (quiet != null || !this.getServer().isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(failure).log(this._request.getRequestURI());
            }
        } else if (noStack != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("handleException {}", (Object)this._request.getRequestURI(), (Object)failure);
            } else {
                LOG.warn("handleException {} {}", (Object)this._request.getRequestURI(), (Object)noStack.toString());
            }
        } else {
            LOG.warn(this._request.getRequestURI(), failure);
        }
        try {
            boolean abort = this._state.onError(failure);
            if (abort) {
                this.abort(failure);
            }
        }
        catch (Throwable x) {
            this.abort(failure);
        }
    }

    protected Throwable unwrap(Throwable failure, Class<?> ... targets) {
        while (failure != null) {
            for (Class<?> x : targets) {
                if (!x.isInstance(failure)) continue;
                return failure;
            }
            failure = failure.getCause();
        }
        return null;
    }

    public void sendResponseAndComplete() {
        try {
            this._request.setHandled(true);
            this._state.completing();
            this.sendResponse(null, this._response.getHttpOutput().getByteBuffer(), true, Callback.from(() -> this._state.completed(null), this._state::completed));
        }
        catch (Throwable x) {
            this.abort(x);
        }
    }

    public String toString() {
        long timeStamp = this._request == null ? 0L : this._request.getTimeStamp();
        return String.format("%s@%x{s=%s,r=%s,c=%b/%b,a=%s,uri=%s,age=%d}", new Object[]{TypeUtil.toShortName(this.getClass()), this.hashCode(), this._state, this._requests, this.isRequestCompleted(), this.isResponseCompleted(), this._state.getState(), this._request == null ? null : this._request.getHttpURI(), timeStamp == 0L ? 0L : System.currentTimeMillis() - timeStamp});
    }

    public void onRequest(ContextHandler.CoreContextRequest coreRequest) {
        this._coreRequest = coreRequest;
        this._coreRequest.addIdleTimeoutListener(this._state::onIdleTimeout);
        this._requests.incrementAndGet();
        this._request.onRequest(coreRequest);
        long idleTO = this._configuration.getIdleTimeout();
        this._oldIdleTimeout = this.getIdleTimeout();
        if (idleTO >= 0L && this._oldIdleTimeout != idleTO) {
            this.setIdleTimeout(idleTO);
        }
        this._combinedListener.onRequestBegin(this._request);
        if (LOG.isDebugEnabled()) {
            MetaData.Request metaData = this._request.getMetaData();
            LOG.debug("onRequest for {} on {}{}{} {} {}{}{}", new Object[]{metaData.getHttpURI().toString(), this, System.lineSeparator(), metaData.getMethod(), metaData.getHttpURI().toString(), metaData.getHttpVersion(), System.lineSeparator(), metaData.getHttpFields()});
        }
    }

    public void onProcess(org.eclipse.jetty.server.Response coreResponse, Callback coreCallback) {
        this._coreResponse = coreResponse;
        this._coreCallback = coreCallback;
        this._response.onResponse(coreResponse.getHeaders());
        if (LOG.isDebugEnabled()) {
            MetaData.Request metaData = this._request.getMetaData();
            LOG.debug("onProcess for {} on {}{}{} {} {}{}{}", new Object[]{metaData.getHttpURI().toString(), this, System.lineSeparator(), metaData.getMethod(), metaData.getHttpURI().toString(), metaData.getHttpVersion(), System.lineSeparator(), metaData.getHttpFields()});
        }
    }

    void onContent(Content.Chunk content) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContent {} {}", (Object)this, (Object)content);
        }
        this._combinedListener.onRequestContent(this._request, content.getByteBuffer().slice());
    }

    void onContentComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContentComplete {}", (Object)this);
        }
        this._combinedListener.onRequestContentEnd(this._request);
    }

    void onTrailers(HttpFields trailers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTrailers {} {}", (Object)this, (Object)trailers);
        }
        this._request.setTrailerHttpFields(trailers);
        this._combinedListener.onRequestTrailers(this._request);
    }

    void onRequestComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onRequestComplete {}", (Object)this);
        }
        boolean result = this.eof();
        this._combinedListener.onRequestEnd(this._request);
    }

    public void onCompleted() {
        long idleTO;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onCompleted for {} written={}", (Object)this._request.getRequestURI(), (Object)this.getBytesWritten());
        }
        if ((idleTO = this._configuration.getIdleTimeout()) >= 0L && this.getIdleTimeout() != this._oldIdleTimeout) {
            this.setIdleTimeout(this._oldIdleTimeout);
        }
        if (CustomRequestLog.isLogDetailRequired((Server)this.getServer())) {
            CustomRequestLog.LogDetail logDetail = new CustomRequestLog.LogDetail(this._request.getServletName(), this._request.getLastContext().getRealPath(this._request.getLastPathInContext()));
            this._request.setAttribute(CustomRequestLog.LOG_DETAIL, logDetail);
        }
        this._request.onCompleted();
        this._combinedListener.onComplete(this._request);
        Callback callback = this._coreCallback;
        Throwable failure = this._state.completeResponse();
        if (failure == null) {
            callback.succeeded();
        } else {
            callback.failed(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBadMessage(BadMessageException failure) {
        HttpChannelState.Action action;
        int status = failure.getCode();
        String reason = failure.getReason();
        if (status < 400 || status > 599) {
            failure = new BadMessageException(reason, (Throwable)failure);
        }
        this._combinedListener.onRequestFailure(this._request, (Throwable)failure);
        try {
            action = this._state.handling();
        }
        catch (Throwable e) {
            this.abort(e);
            throw failure;
        }
        try {
            if (action == HttpChannelState.Action.DISPATCH) {
                ByteBuffer content = null;
                HttpFields.Mutable fields = HttpFields.build();
                ErrorHandler handler = (ErrorHandler)this.getServer().getBean(ErrorHandler.class);
                if (handler != null) {
                    content = handler.badMessageError(status, reason, fields);
                }
                this.sendResponse(new MetaData.Response(status, null, HttpVersion.HTTP_1_1, (HttpFields)fields, (long)BufferUtil.length((ByteBuffer)content)), content, true);
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to send bad message response", (Throwable)e);
            }
        }
        finally {
            try {
                this.onCompleted();
            }
            catch (Throwable e) {
                LOG.debug("Unable to complete bad message", e);
                this.abort(e);
            }
        }
    }

    protected boolean sendResponse(MetaData.Response response, ByteBuffer content, boolean complete, Callback callback) {
        boolean committing = this._state.commitResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendResponse info={} content={} complete={} committing={} callback={}", new Object[]{response, BufferUtil.toDetailString((ByteBuffer)content), complete, committing, callback});
        }
        if (committing) {
            this._combinedListener.onResponseBegin(this._request);
            if (response == null) {
                response = this._response.newResponseMetaData();
            }
            this.commit(response);
            int status = response.getStatus();
            SendCallback committed = HttpStatus.isInformational((int)status) ? new Send1XXCallback(callback) : new SendCallback(callback, content, true, complete);
            this.send(this._request.getMetaData(), response, content, complete, (Callback)committed);
        } else if (response == null) {
            this.send(this._request.getMetaData(), null, content, complete, (Callback)new SendCallback(callback, content, false, complete));
        } else {
            callback.failed((Throwable)new IllegalStateException("committed"));
        }
        return committing;
    }

    private void send(MetaData.Request ignored, MetaData.Response response, ByteBuffer content, boolean complete, Callback callback) {
        org.eclipse.jetty.server.Response coreResponse = this._coreResponse;
        if (coreResponse == null) {
            callback.failed((Throwable)new IOException());
            return;
        }
        if (response != null) {
            coreResponse.setStatus(response.getStatus());
            coreResponse.setTrailersSupplier(response.getTrailersSupplier());
        }
        coreResponse.write(complete, content, callback);
    }

    public boolean sendResponse(MetaData.Response info, ByteBuffer content, boolean complete) throws IOException {
        boolean bl;
        block9: {
            SharedBlockingCallback.Blocker blocker = this._response.getHttpOutput().acquireWriteBlockingCallback();
            try {
                boolean committing = this.sendResponse(info, content, complete, (Callback)blocker);
                blocker.block();
                bl = committing;
                if (blocker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (blocker != null) {
                        try {
                            blocker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable failure) {
                    if (LOG.isDebugEnabled()) {
                        LOG.atDebug().setCause(failure).log("Unable to send response");
                    }
                    this.abort(failure);
                    throw failure;
                }
            }
            blocker.close();
        }
        return bl;
    }

    protected void commit(MetaData.Response info) {
        this._committedMetaData = info;
        if (LOG.isDebugEnabled()) {
            LOG.debug("COMMIT for {} on {}{}{} {} {}{}{}", new Object[]{this.getRequest().getRequestURI(), this, System.lineSeparator(), info.getStatus(), info.getReason(), info.getHttpVersion(), System.lineSeparator(), info.getHttpFields()});
        }
    }

    public boolean isCommitted() {
        return this._state.isResponseCommitted();
    }

    public boolean isRequestCompleted() {
        return this._state.isCompleted();
    }

    public boolean isResponseCompleted() {
        return this._state.isResponseCompleted();
    }

    public boolean isPersistent() {
        return this._coreRequest.getConnectionMetaData().isPersistent();
    }

    @Override
    public void write(ByteBuffer content, boolean complete, Callback callback) {
        this.sendResponse(null, content, complete, callback);
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
    }

    @Override
    public HttpOutput.Interceptor getNextInterceptor() {
        return null;
    }

    protected void execute(Runnable task) {
        this._executor.execute(task);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.getHttpConfiguration().isUseOutputDirectByteBuffers();
    }

    public void abort(Throwable failure) {
        Boolean handle = this._state.abort(failure);
        if (handle == null) {
            return;
        }
        this._combinedListener.onResponseFailure(this._request, failure);
        if (handle.booleanValue()) {
            this._state.scheduleDispatch();
        }
    }

    public boolean isTunnellingSupported() {
        return false;
    }

    public EndPoint getTunnellingEndPoint() {
        throw new UnsupportedOperationException("Tunnelling not supported");
    }

    private void notifyEvent1(Function<Listener, Consumer<Request>> function, Request request) {
        for (Listener listener : this._transientListeners) {
            try {
                function.apply(listener).accept(request);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.atDebug().setCause(x).log("Failure invoking listener {}", (Object)listener);
            }
        }
    }

    private void notifyEvent2(Function<Listener, BiConsumer<Request, ByteBuffer>> function, Request request, ByteBuffer content) {
        for (Listener listener : this._transientListeners) {
            ByteBuffer view = content.slice();
            try {
                function.apply(listener).accept(request, view);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.atDebug().setCause(x).log("Failure invoking listener {}", (Object)listener);
            }
        }
    }

    private void notifyEvent2(Function<Listener, BiConsumer<Request, Throwable>> function, Request request, Throwable failure) {
        for (Listener listener : this._transientListeners) {
            try {
                function.apply(listener).accept(request, failure);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.atDebug().setCause(x).log("Failure invoking listener {}", (Object)listener);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        default public void onRequestBegin(Request request) {
        }

        default public void onBeforeDispatch(Request request) {
        }

        default public void onDispatchFailure(Request request, Throwable failure) {
        }

        default public void onAfterDispatch(Request request) {
        }

        default public void onRequestContent(Request request, ByteBuffer content) {
        }

        default public void onRequestContentEnd(Request request) {
        }

        default public void onRequestTrailers(Request request) {
        }

        default public void onRequestEnd(Request request) {
        }

        default public void onRequestFailure(Request request, Throwable failure) {
        }

        default public void onResponseBegin(Request request) {
        }

        default public void onResponseCommit(Request request) {
        }

        default public void onResponseContent(Request request, ByteBuffer content) {
        }

        default public void onResponseEnd(Request request) {
        }

        default public void onResponseFailure(Request request, Throwable failure) {
        }

        default public void onComplete(Request request) {
        }
    }

    private class RequestDispatchable
    implements Dispatchable {
        private RequestDispatchable() {
        }

        @Override
        public void dispatch() throws IOException, ServletException {
            HttpChannel.this._contextHandler.handle(HttpChannel.this);
        }
    }

    static interface Dispatchable {
        public void dispatch() throws IOException, ServletException;
    }

    private class AsyncDispatchable
    implements Dispatchable {
        private AsyncDispatchable() {
        }

        @Override
        public void dispatch() throws IOException, ServletException {
            AsyncContextEvent event = HttpChannel.this.getState().getAsyncContextEvent();
            if (event == null || event.getDispatchContext() == null || event.getDispatchContext() == HttpChannel.this._contextHandler.getServletContext()) {
                HttpChannel.this._contextHandler.handleAsync(HttpChannel.this);
            } else {
                ServletContext servletContext = event.getDispatchContext();
                if (servletContext instanceof CrossContextServletContext) {
                    CrossContextServletContext crossContextServletContext = (CrossContextServletContext)servletContext;
                    this.dispatchCrossContext(crossContextServletContext);
                } else {
                    ServletContext targetContext = HttpChannel.this._contextHandler.getServletContext().getContext(event.getDispatchContext().getContextPath());
                    if (targetContext instanceof CrossContextServletContext) {
                        CrossContextServletContext crossContextServletContext = (CrossContextServletContext)targetContext;
                        this.dispatchCrossContext(crossContextServletContext);
                    } else {
                        throw new IllegalStateException("Dispatch " + HttpChannel.this._contextHandler.getContextPath() + " -> non CrossContextServletContext" + event.getDispatchContext().getContextPath() + String.valueOf(event.getDispatchContext()));
                    }
                }
            }
        }

        private void dispatchCrossContext(CrossContextServletContext crossContextServletContext) throws ServletException, IOException {
            org.eclipse.jetty.server.handler.ContextHandler contextHandler = crossContextServletContext.getTargetContext().getContextHandler();
            if (contextHandler instanceof ContextHandler.CoreContextHandler) {
                ContextHandler.CoreContextHandler coreContextHandler = (ContextHandler.CoreContextHandler)contextHandler;
                coreContextHandler.getContextHandler().handleCrossContextAsync(HttpChannel.this);
            }
        }
    }

    private class DemandTask
    implements Invocable.Task {
        private DemandTask() {
        }

        public void run() {
            if (HttpChannel.this.getRequest().getHttpInput().onContentProducible()) {
                HttpChannel.this.handle();
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return HttpChannel.this.getRequest().getHttpInput().getInvocationType();
        }
    }

    private class ErrorDispatchable
    implements Dispatchable {
        private final ErrorHandler _errorHandler;

        public ErrorDispatchable(ErrorHandler errorHandler) {
            this._errorHandler = errorHandler;
        }

        @Override
        public void dispatch() throws IOException, ServletException {
            this._errorHandler.handle(null, HttpChannel.this._request, HttpChannel.this._request, HttpChannel.this._response);
            HttpChannel.this._request.setHandled(true);
        }
    }

    private class Send1XXCallback
    extends SendCallback {
        private Send1XXCallback(Callback callback) {
            super(callback, null, false, false);
        }

        @Override
        public void succeeded() {
            if (HttpChannel.this._state.partialResponse()) {
                super.succeeded();
            } else {
                super.failed(new IllegalStateException());
            }
        }
    }

    private class SendCallback
    extends Callback.Nested {
        private final ByteBuffer _content;
        private final int _length;
        private final boolean _commit;
        private final boolean _complete;

        private SendCallback(Callback callback, ByteBuffer content, boolean commit, boolean complete) {
            super(callback);
            this._content = content == null ? BufferUtil.EMPTY_BUFFER : content.slice();
            this._length = this._content.remaining();
            this._commit = commit;
            this._complete = complete;
        }

        public void succeeded() {
            HttpChannel.this._written += (long)this._length;
            if (this._commit) {
                HttpChannel.this._combinedListener.onResponseCommit(HttpChannel.this._request);
            }
            if (this._length > 0) {
                HttpChannel.this._combinedListener.onResponseContent(HttpChannel.this._request, this._content);
            }
            if (this._complete) {
                HttpChannel.this._combinedListener.onResponseEnd(HttpChannel.this._request);
            }
            super.succeeded();
        }

        public void failed(final Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("Commit failed");
            }
            if (x instanceof HttpException) {
                HttpException httpException = (HttpException)x;
                MetaData.Response responseMeta = new MetaData.Response(httpException.getCode(), httpException.getReason(), HttpVersion.HTTP_1_1, (HttpFields)HttpFields.build().add(HttpFields.CONNECTION_CLOSE), 0L);
                HttpChannel.this.send(HttpChannel.this._request.getMetaData(), responseMeta, null, true, (Callback)new Callback.Nested(this, this.getCallback()){
                    final /* synthetic */ SendCallback this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    public void succeeded() {
                        this.this$1.HttpChannel.this._response.getHttpOutput().completed(null);
                        super.failed(x);
                    }

                    public void failed(Throwable th) {
                        this.this$1.HttpChannel.this.abort(x);
                        super.failed(x);
                    }
                });
            } else {
                super.failed(x);
            }
        }
    }

    @Deprecated
    public static class TransientListeners
    implements Listener {
        @Override
        public void onRequestBegin(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onRequestBegin, request);
        }

        @Override
        public void onBeforeDispatch(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onBeforeDispatch, request);
        }

        @Override
        public void onDispatchFailure(Request request, Throwable failure) {
            request.getHttpChannel().notifyEvent2(listener -> listener::onDispatchFailure, request, failure);
        }

        @Override
        public void onAfterDispatch(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onAfterDispatch, request);
        }

        @Override
        public void onRequestContent(Request request, ByteBuffer content) {
            request.getHttpChannel().notifyEvent2(listener -> listener::onRequestContent, request, content);
        }

        @Override
        public void onRequestContentEnd(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onRequestContentEnd, request);
        }

        @Override
        public void onRequestTrailers(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onRequestTrailers, request);
        }

        @Override
        public void onRequestEnd(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onRequestEnd, request);
        }

        @Override
        public void onRequestFailure(Request request, Throwable failure) {
            request.getHttpChannel().notifyEvent2(listener -> listener::onRequestFailure, request, failure);
        }

        @Override
        public void onResponseBegin(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onResponseBegin, request);
        }

        @Override
        public void onResponseCommit(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onResponseCommit, request);
        }

        @Override
        public void onResponseContent(Request request, ByteBuffer content) {
            request.getHttpChannel().notifyEvent2(listener -> listener::onResponseContent, request, content);
        }

        @Override
        public void onResponseEnd(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onResponseEnd, request);
        }

        @Override
        public void onResponseFailure(Request request, Throwable failure) {
            request.getHttpChannel().notifyEvent2(listener -> listener::onResponseFailure, request, failure);
        }

        @Override
        public void onComplete(Request request) {
            request.getHttpChannel().notifyEvent1(listener -> listener::onComplete, request);
        }
    }
}

