/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.dictionary.build;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.reduls.igo.dictionary.CharCategory;
import net.reduls.igo.trie.Searcher;
import net.reduls.igo.util.FileMappedOutputStream;
import net.reduls.igo.util.ReadLine;

public final class CharCategory {
    public static final String KEY_PREFIX = "\u0002";
    private final String inputDir;
    private final String encoding;
    private final String outputDir;

    public CharCategory(String string, String string2, String string3) {
        this.inputDir = string;
        this.encoding = string2;
        this.outputDir = string3;
    }

    public void build() throws ParseException, IOException {
        Map<String, Category> map = this.parseCharCategoryDef();
        ArrayList<Category> arrayList = new ArrayList<Category>();
        for (Category category : map.values()) {
            arrayList.add(category);
        }
        this.saveCharCategoryMap(arrayList);
        this.buildCodeCategoryMap(map);
    }

    private Map<String, Category> parseCharCategoryDef() throws ParseException, IOException {
        String string = this.inputDir + "/char.def";
        ReadLine readLine = new ReadLine(string, this.encoding);
        Searcher searcher = new Searcher(this.outputDir + "/word2id");
        HashMap<String, Category> hashMap = new HashMap<String, Category>();
        try {
            String string2 = readLine.read();
            while (string2 != null) {
                if (!(string2.isEmpty() || string2.startsWith("#") || string2.startsWith("0"))) {
                    String[] stringArray = string2.split("\\s+");
                    if (stringArray.length < 4) {
                        throw CharCategory.parseException("Invalid char category definition (too few fields).", string, readLine);
                    }
                    if (!stringArray[1].matches("[01]")) {
                        throw CharCategory.parseException("Invalid char category definition (INVOKE must be '0' or '1').", string, readLine);
                    }
                    if (!stringArray[2].matches("[01]")) {
                        throw CharCategory.parseException("Invalid char category definition (GROUP must be '0' or '1').", string, readLine);
                    }
                    String string3 = stringArray[0];
                    boolean bl = stringArray[1].equals("1");
                    boolean bl2 = stringArray[2].equals("1");
                    int n = Integer.valueOf(stringArray[3]);
                    int n2 = searcher.search(KEY_PREFIX + string3);
                    if (n < 0) {
                        throw CharCategory.parseException("Invalid char category definition (LENGTH must be 0 or positive integer).", string, readLine);
                    }
                    if (n2 < 0) {
                        throw CharCategory.parseException("Category '" + string3 + "' is unregistered in trie", string, readLine);
                    }
                    hashMap.put(string3, new Category(n2, n, bl, bl2));
                }
                string2 = readLine.read();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw CharCategory.parseException("Parse integer failed. " + numberFormatException.getMessage(), string, readLine);
        }
        finally {
            readLine.close();
        }
        if (!hashMap.containsKey("DEFAULT")) {
            throw CharCategory.parseException("Missing mandatory category 'DEFAULT'.", string, readLine);
        }
        if (!hashMap.containsKey("SPACE")) {
            throw CharCategory.parseException("Missing mandatory category 'SPACE'.", string, readLine);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCharCategoryMap(List<Category> list) throws IOException {
        FileMappedOutputStream fileMappedOutputStream = new FileMappedOutputStream(this.outputDir + "/char.category", list.size() * 4 * 4);
        try {
            Collections.sort(list);
            for (Category category : list) {
                fileMappedOutputStream.putInt(category.id);
                fileMappedOutputStream.putInt(category.length);
                fileMappedOutputStream.putInt(category.invoke ? 1 : 0);
                fileMappedOutputStream.putInt(category.group ? 1 : 0);
            }
        }
        finally {
            fileMappedOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCodeCategoryMap(Map<String, Category> map) throws ParseException, IOException {
        Object object;
        CharId[] charIdArray = new CharId[65536];
        Object object2 = new CharId(map.get((Object)"DEFAULT").id);
        for (int i = 0; i < 65536; ++i) {
            charIdArray[i] = object2;
        }
        object2 = this.inputDir + "/char.def";
        ReadLine readLine = new ReadLine((String)object2, this.encoding);
        try {
            object = readLine.read();
            while (object != null) {
                if (((String)object).startsWith("0")) {
                    int n;
                    int n2;
                    Object[] objectArray = ((String)(object = ((String)object).replaceFirst("#.*$", ""))).split("\\s+");
                    if (objectArray[0].indexOf("..") != -1) {
                        String[] stringArray = objectArray[0].split("\\.\\.");
                        if (stringArray.length != 2) {
                            throw CharCategory.parseException("Invalid code to category mapping line.", (String)object2, readLine);
                        }
                        n2 = Integer.parseInt(stringArray[0].substring(2), 16);
                        n = Integer.parseInt(stringArray[1].substring(2), 16);
                    } else {
                        n2 = n = Integer.parseInt(objectArray[0].substring(2), 16);
                    }
                    if (0 > n2 || n2 > 65535 || 0 > n || n > 65535 || n2 > n) {
                        throw CharCategory.parseException("Wrong UCS2 code specified.", (String)object2, readLine);
                    }
                    String string = "";
                    try {
                        int n3;
                        Object object3 = objectArray[1];
                        CharId charId = new CharId(map.get((Object)object3).id);
                        for (n3 = 2; n3 < objectArray.length; ++n3) {
                            Object object4 = objectArray[n3];
                            charId.add(map.get((Object)object4).id);
                        }
                        for (n3 = n2; n3 <= n; ++n3) {
                            charIdArray[n3] = charId;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        throw CharCategory.parseException("Category '" + string + "' is undefined.", (String)object2, readLine);
                    }
                }
                object = readLine.read();
            }
            if (charIdArray[32].id != map.get((Object)"SPACE").id) {
                throw CharCategory.parseException("0x0020 is reserved for 'SPACE' category", (String)object2, readLine);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw CharCategory.parseException("Invalid code to category mapping line.", (String)object2, readLine);
        }
        catch (NumberFormatException numberFormatException) {
            throw CharCategory.parseException("Parse integer failed. " + numberFormatException.getMessage(), (String)object2, readLine);
        }
        finally {
            readLine.close();
        }
        object = new FileMappedOutputStream(this.outputDir + "/code2category", charIdArray.length * 4 * 2);
        try {
            for (CharId charId : charIdArray) {
                ((FileMappedOutputStream)object).putInt(charId.id);
            }
            for (CharId charId : charIdArray) {
                ((FileMappedOutputStream)object).putInt(charId.mask);
            }
        }
        finally {
            ((FileMappedOutputStream)object).close();
        }
    }

    private static ParseException parseException(String string, String string2, ReadLine readLine) {
        return new ParseException(string + "\t{file: " + string2 + ", line: " + readLine.lineNumber() + "}", readLine.lineNumber());
    }

    private static class CharId {
        public final int id;
        public int mask;

        public CharId(int n) {
            this.id = n;
            this.add(this.id);
        }

        public void add(int n) {
            this.mask |= 1 << n;
        }
    }

    private static class Category
    extends CharCategory.Category
    implements Comparable<Category> {
        public Category(int n, int n2, boolean bl, boolean bl2) {
            super(n, n2, bl, bl2);
        }

        @Override
        public int compareTo(Category category) {
            return this.id - category.id;
        }
    }
}

