/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.bin;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import net.reduls.igo.dictionary.build.CharCategory;
import net.reduls.igo.dictionary.build.Matrix;
import net.reduls.igo.dictionary.build.WordDic;

public final class BuildDic {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3 && stringArray.length != 4) {
            System.err.println("Usage: java net.reduls.igo.bin.BuildDic <output directory> <input directory> <encoding> [delimiter]");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray.length == 4 ? stringArray[3] : ",";
        new File(string).mkdirs();
        WordDic wordDic = new WordDic(string2, string3, string, string4);
        CharCategory charCategory = new CharCategory(string2, string3, string);
        try {
            System.err.println("### Build word trie");
            wordDic.buildWordIdMap();
            System.err.println("### Build word dictionary");
            wordDic.buildWordInfo();
            System.err.println("### Build matrix");
            Matrix.build(string2, string);
            System.err.println("### Build char-category dictionary");
            charCategory.build();
            System.err.println("DONE");
        }
        catch (ParseException parseException) {
            System.err.println("[PARSE ERROR] " + parseException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("[ERROR] " + iOException.getMessage());
            System.exit(1);
        }
    }
}

