/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.io.IO;
import org.basex.io.IOUrl;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Checks;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.http.HTTPText;
import org.basex.util.http.MediaType;
import org.basex.util.http.Part;
import org.basex.util.http.Request;
import org.basex.util.http.RequestAttribute;
import org.basex.util.http.RequestParser;
import org.basex.util.http.Response;
import org.basex.util.http.UserInfo;
import org.basex.util.options.Options;

public final class Client {
    private final InputInfo info;
    private final MainOptions options;

    public Client(InputInfo info, MainOptions options) {
        this.info = info;
        this.options = options;
    }

    public Value sendRequest(byte[] href, ANode request, Value bodies) throws QueryException {
        Request req = new RequestParser(this.info).parse(request, bodies);
        URI uri = this.uri(href, req);
        String mediaType = req.attribute(RequestAttribute.OVERRIDE_MEDIA_TYPE);
        String status = req.attribute(RequestAttribute.STATUS_ONLY);
        boolean body = status == null || Strings.isFalse(status);
        MainOptions mopts = new MainOptions(this.options);
        try {
            mopts.set(MainOptions.CSVPARSER, Client.assign(new CsvParserOptions(mopts.get(MainOptions.CSVPARSER)), req.attribute(RequestAttribute.CSV)));
            mopts.set(MainOptions.JSONPARSER, Client.assign(new JsonParserOptions(mopts.get(MainOptions.JSONPARSER)), req.attribute(RequestAttribute.JSON)));
            mopts.set(MainOptions.HTMLPARSER, Client.assign(new HtmlOptions(mopts.get(MainOptions.HTMLPARSER)), req.attribute(RequestAttribute.HTML)));
            return new Response(this.info, mopts).getResponse(Client.send(uri, req), body, mediaType);
        }
        catch (IOException ex) {
            throw QueryError.HC_ERROR_X.get(this.info, ex);
        }
    }

    private static <O extends Options> O assign(O opts, String value) throws IOException {
        if (value != null) {
            opts.assign(value);
        }
        return opts;
    }

    private URI uri(byte[] href, Request request) throws QueryException {
        String uri;
        String string = uri = href.length == 0 ? request.attribute(RequestAttribute.HREF) : Token.string(href);
        if (uri == null || uri.isEmpty()) {
            throw QueryError.HC_URL.get(this.info, new Object[0]);
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            Util.debug(ex);
            throw QueryError.HC_URI_X.get(this.info, uri);
        }
    }

    private static HttpResponse<InputStream> send(URI uri, Request request) throws IOException {
        HttpRequest.Builder rb;
        try {
            String method;
            rb = HttpRequest.newBuilder(uri);
            String timeout = request.attribute(RequestAttribute.TIMEOUT);
            if (timeout != null) {
                rb.timeout(Duration.ofSeconds(Strings.toInt(timeout)));
            }
            if ((method = request.attribute(RequestAttribute.METHOD)) != null) {
                HttpRequest.BodyPublisher publisher;
                if (request.payload.isEmpty() && request.parts.isEmpty()) {
                    publisher = HttpRequest.BodyPublishers.noBody();
                } else {
                    Client.setContentType(rb, request);
                    publisher = HttpRequest.BodyPublishers.ofByteArray(Client.payload(request));
                }
                rb.method(method, publisher);
            }
            request.headers.forEach(rb::header);
            if (((Checks<String>)name -> !name.equalsIgnoreCase("Accept")).all(request.headers.keySet())) {
                rb.header("Accept", MediaType.ALL_ALL.toString());
            }
        }
        catch (IllegalArgumentException ex) {
            Util.debug(ex);
            throw new IOException(ex.getMessage());
        }
        String fw = request.attribute(RequestAttribute.FOLLOW_REDIRECT);
        HttpClient client = IOUrl.client(fw == null || Strings.isTrue(fw));
        HttpResponse.BodyHandler<InputStream> handler = HttpResponse.BodyHandlers.ofInputStream();
        try {
            UserInfo ui = new UserInfo(uri, request);
            boolean sa = Strings.isTrue(request.attribute(RequestAttribute.SEND_AUTHORIZATION));
            if (sa && request.authMethod == StaticOptions.AuthMethod.BASIC) {
                ui.basic(rb);
            } else {
                HttpResponse<InputStream> response = client.send(rb.build(), handler);
                if (!ui.assign(rb, response)) {
                    return response;
                }
            }
            return client.send(rb.build(), handler);
        }
        catch (IllegalArgumentException | InterruptedException ex) {
            Util.debug(ex);
            throw new IOException(ex.getMessage());
        }
    }

    private static void setContentType(HttpRequest.Builder rb, Request request) {
        String ct;
        String contType = request.headers.get("Content-Type".toLowerCase(Locale.ENGLISH));
        if (contType != null) {
            ct = contType;
        } else {
            ct = request.payloadAtts.get(SerializerOptions.MEDIA_TYPE.name());
            if (request.isMultipart) {
                ct = Strings.concat(ct, "; ", "boundary", "=", request.boundary());
            }
        }
        rb.header("Content-Type", ct);
    }

    public static EnumMap<RequestAttribute, String> authHeaders(String auth) {
        EnumMap<RequestAttribute, String> values = new EnumMap<RequestAttribute, String>(RequestAttribute.class);
        if (auth != null) {
            String[] parts = Strings.split(auth, ' ', 2);
            values.put(RequestAttribute.AUTH_METHOD, parts[0]);
            if (parts.length > 1) {
                for (String header : Strings.split(parts[1], ',')) {
                    RequestAttribute r;
                    String[] kv = Strings.split(header, '=', 2);
                    String key = kv[0].trim();
                    if (key.isEmpty() || kv.length != 2 || (r = Enums.get(RequestAttribute.class, key)) == null) continue;
                    values.put(r, Strings.delete(kv[1], '\"').trim());
                }
            }
        }
        return values;
    }

    public static byte[] payload(Request request) throws IOException {
        ArrayOutput out = new ArrayOutput();
        if (request.isMultipart) {
            String boundary = request.boundary();
            for (Part part : request.parts) {
                ArrayOutput ao = new ArrayOutput();
                Client.writePayload(part.contents, part.attributes, ao);
                out.write(Token.concat("--", boundary, HTTPText.CRLF));
                for (Map.Entry<String, String> header : part.headers.entrySet()) {
                    Client.writeHeader(header.getKey(), header.getValue(), out);
                }
                if (!part.headers.containsKey("Content-Type")) {
                    Client.writeHeader("Content-Type", part.attributes.get(SerializerOptions.MEDIA_TYPE.name()), out);
                }
                out.write(HTTPText.CRLF);
                out.write(ao.finish());
                out.write(HTTPText.CRLF);
            }
            out.write(Token.concat("--", boundary, "--", HTTPText.CRLF));
        } else {
            Client.writePayload(request.payload, request.payloadAtts, out);
        }
        return out.finish();
    }

    private static void writeHeader(String key, String value, OutputStream out) throws IOException {
        out.write(Token.concat(key, ": ", value, HTTPText.CRLF));
    }

    private static void writePayload(ItemList payload, Map<String, String> atts, OutputStream out) throws IOException {
        boolean atom;
        SerializerOptions sopts = new SerializerOptions();
        sopts.set(SerializerOptions.NEWLINE, SerializerOptions.Newline.NL);
        String method = null;
        String type = null;
        for (Map.Entry<String, String> entry : atts.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("src")) {
                out.write(IO.get(value).read());
                return;
            }
            if (key.equals(SerializerOptions.METHOD.name())) {
                method = value.equals("binary") ? SerialMethod.BASEX.toString() : value;
                continue;
            }
            sopts.assign(key, value);
            if (!key.equals(SerializerOptions.MEDIA_TYPE.name())) continue;
            type = value;
        }
        if (method == null && type != null) {
            MediaType mt = new MediaType(type);
            if (mt.is(MediaType.APPLICATION_HTML_XML)) {
                method = SerialMethod.XHTML.toString();
            } else if (mt.is(MediaType.TEXT_HTML)) {
                method = SerialMethod.HTML.toString();
            } else if (mt.isXml()) {
                method = SerialMethod.XML.toString();
            } else if (mt.isJSON()) {
                method = SerialMethod.JSON.toString();
            } else if (mt.isCSV()) {
                method = SerialMethod.CSV.toString();
            } else if (mt.isText()) {
                method = SerialMethod.TEXT.toString();
            }
        }
        boolean bl = atom = method == null || method.equals("binary");
        if (atom) {
            method = SerialMethod.BASEX.toString();
        }
        sopts.assign(SerializerOptions.METHOD.name(), method);
        try (Serializer ser = Serializer.get(out, sopts);){
            for (Item item : payload) {
                ser.serialize(atom && item.type instanceof NodeType ? ((ANode)item).atomItem(null, null) : item);
            }
        }
    }
}

