/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.basex.util.Util;

public final class Reflect {
    private static final HashMap<String, Constructor<?>> CONSTRUCTORS = new HashMap();
    private static final HashMap<String, Class<?>> CLASSES = new HashMap();
    private static final HashMap<String, Field> FIELDS = new HashMap();

    private Reflect() {
    }

    public static boolean available(String pattern, Object ... ext) {
        try {
            Reflect.forName(Util.info(pattern, ext));
            return true;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return false;
        }
    }

    public static Class<?> find(String name) {
        try {
            return Reflect.forName(name);
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> c = CLASSES.get(name);
        if (c == null) {
            c = Class.forName(name);
            if (!Modifier.isPublic(c.getModifiers())) {
                throw new ClassNotFoundException(name);
            }
            CLASSES.put(name, c);
        }
        return c;
    }

    public static Field field(Class<?> clazz, String name) {
        String key = clazz.getName() + name;
        Field f = FIELDS.get(key);
        if (f == null) {
            try {
                f = clazz.getField(name);
                FIELDS.put(key, f);
            }
            catch (Throwable ex) {
                Util.debug(ex);
            }
        }
        return f;
    }

    public static Class<?> find(String pattern, Object ... ext) {
        return Reflect.find(Util.info(pattern, ext));
    }

    public static <O> Constructor<O> find(Class<O> clazz, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(clazz.getName());
        for (Class<?> c : types) {
            sb.append(c.getName());
        }
        String key = sb.toString();
        Constructor<Object> m = CONSTRUCTORS.get(key);
        if (m == null) {
            try {
                try {
                    m = clazz.getConstructor(types);
                }
                catch (Throwable ex) {
                    Util.debug(ex);
                    m = clazz.getDeclaredConstructor(types);
                    m.setAccessible(true);
                }
                CONSTRUCTORS.put(key, m);
            }
            catch (Throwable ex) {
                Util.debug(ex);
            }
        }
        return m;
    }

    public static Method method(Class<?> clazz, String name, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        Method m = null;
        try {
            try {
                m = clazz.getMethod(name, types);
            }
            catch (Throwable ex) {
                Util.debug(ex);
                m = clazz.getDeclaredMethod(name, types);
                m.setAccessible(true);
            }
        }
        catch (Throwable ex) {
            Util.debug(ex);
        }
        return m;
    }

    public static <O> O get(Class<O> clazz) {
        try {
            return clazz != null ? (O)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static <O> O get(Constructor<O> constructor, Object ... args) {
        try {
            return constructor != null ? (O)constructor.newInstance(args) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object invoke(Method method, Object object, Object ... args) {
        try {
            return method != null ? method.invoke(object, args) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object get(Field field, Object object) {
        try {
            return field != null ? field.get(object) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }
}

