/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.w3c.dom.Comment;

public final class FComm
extends FNode {
    private static final byte[] DASHES = new byte[]{45, 45};
    private final byte[] value;

    public FComm(byte[] value) {
        super(NodeType.COMMENT);
        this.value = value;
    }

    public FComm(Comment comment) {
        this(Token.token(comment.getData()));
    }

    @Override
    public byte[] string() {
        return this.value;
    }

    @Override
    public FComm materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) {
        return this.materialized(test, ii) ? this : new FComm(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FComm)) return false;
        FComm fcomm = (FComm)obj;
        if (!Token.eq(this.value, fcomm.value)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        qs.concat("<!--", QueryString.toValue(this.value), "-->");
    }

    public static byte[] parse(byte[] str, InputInfo info) throws QueryException {
        if (Token.contains(str, DASHES) || Token.endsWith(str, 45)) {
            throw QueryError.COMINVALID.get(info, new Object[0]);
        }
        return str;
    }
}

