/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.index;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.util.index.IndexPred;
import org.basex.query.util.list.ExprList;

class IndexPath
extends IndexPred {
    private final AxisPath path;

    IndexPath(AxisPath path, IndexInfo info) {
        super(info);
        this.path = path;
    }

    @Override
    Step step() {
        if (this.path.root != null) {
            return null;
        }
        int sl = this.path.steps.length;
        for (int s = 0; s < sl; ++s) {
            if (!this.path.step(s).mayBePositional()) continue;
            return null;
        }
        return this.path.step(sl - 1);
    }

    @Override
    Step qname() {
        int s = this.path.steps.length - 1;
        Step st = this.step(s);
        return this.info.text && st.axis == Axis.CHILD && st.test == KindTest.TEXT ? this.step(s - 1) : st;
    }

    @Override
    Expr invert(Expr root) throws QueryException {
        Step st;
        Expr rt;
        CompileContext cc = this.info.cc;
        ExprList steps = new ExprList();
        int s = this.path.steps.length - 1;
        Step last = this.step(s);
        Expr expr = rt = last.exprs.length > 0 ? Filter.get(cc, this.path.info(), root, last.exprs) : root;
        if (!this.info.text && (last.test instanceof NameTest || last.test instanceof UnionTest)) {
            steps.add(Step.self(cc, rt, last.info(), last.test, new Expr[0]));
        }
        while (--s >= 0) {
            st = this.step(s);
            steps.add(Step.get(cc, rt, st.info(), this.step((int)(s + 1)).axis.invert(), st.test, st.exprs));
        }
        st = this.step(s);
        steps.add(Step.get(cc, rt, st.info(), this.step((int)(s + 1)).axis.invert(), st.test, new Expr[0]));
        return Path.get(cc, this.path.info(), rt, (Expr[])steps.finish());
    }

    private Step step(int index) {
        return index < 0 ? this.info.step : this.path.step(index);
    }
}

