/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.LinkedList;
import java.util.List;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.UserUpdate;

final class UserUpdates {
    private final List<UserUpdate> userUpdates = new LinkedList<UserUpdate>();

    UserUpdates() {
    }

    void add(UserUpdate up) throws QueryException {
        boolean alter = up.type == UpdateType.USERALTER;
        boolean drop = up.type == UpdateType.USERDROP;
        for (UserUpdate o : this.userUpdates) {
            if (o.type == up.type) {
                o.merge(up);
            }
            if ((!drop || o.type != UpdateType.USERALTER) && (!alter || o.type != UpdateType.USERDROP)) continue;
            throw QueryError.USER_CONFLICT_X.get(o.info(), o.name());
        }
        this.userUpdates.add(up);
    }

    void apply() {
        for (UserUpdate up : this.userUpdates) {
            up.apply();
        }
    }

    int size() {
        int size = 0;
        for (UserUpdate up : this.userUpdates) {
            size += up.size();
        }
        return size;
    }
}

