/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.util.Checks;
import org.basex.util.Enums;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;

public abstract class PlanFn
extends StandardFunc {
    static final Str CONTENT = Str.get("#content");
    static final Str COMMENT = Str.get("#comment");
    static final Str PI = Str.get("#processing-instruction");
    static final Str DATA = Str.get("#data");
    static final Str LAYOUT = Str.get("layout");
    static final Str TYPE = Str.get("type");
    static final Str CHILD = Str.get("child");

    final PlanEntry entry(ANode node, Plan plan) {
        PlanEntry pe = plan.entries.get(node.qname());
        if (pe == null) {
            pe = plan.entries.get(QNm.EMPTY);
        }
        return pe != null ? pe : this.entry(node);
    }

    final PlanEntry entry(ANode ... nodes) {
        PlanEntry pe = new PlanEntry();
        ANodeList attributes = PlanFn.children(NodeType.ATTRIBUTE, nodes);
        ANodeList elements = PlanFn.children(NodeType.ELEMENT, nodes);
        ANodeList texts = PlanFn.children(NodeType.TEXT, nodes);
        if (elements.isEmpty() && texts.isEmpty()) {
            pe.layout = attributes.isEmpty() ? PlanLayout.EMPTY : PlanLayout.EMPTY_PLUS;
        } else if (elements.isEmpty()) {
            pe.layout = attributes.isEmpty() ? PlanLayout.SIMPLE : PlanLayout.SIMPLE_PLUS;
            pe.type = PlanType.get(nodes);
        } else if (PlanFn.empty(texts)) {
            if (PlanFn.equalNames(elements) && ((Checks<ANode>)node -> PlanFn.children(NodeType.ELEMENT, node).size() > 1).any((ANode[])nodes)) {
                pe.layout = attributes.isEmpty() ? PlanLayout.LIST : PlanLayout.LIST_PLUS;
                pe.child = ((ANode)elements.get(0)).qname();
            } else {
                pe.layout = ((Checks<ANode>)PlanFn::differentNames).all((ANode[])nodes) ? PlanLayout.RECORD : PlanLayout.SEQUENCE;
            }
        } else {
            pe.layout = PlanLayout.MIXED;
        }
        return pe;
    }

    static boolean empty(ANodeList nodes) {
        return ((Checks<ANode>)node -> Token.normalize(node.string()).length == 0).all(nodes);
    }

    static ANodeList children(NodeType type, ANode ... nodes) {
        ANodeList list = new ANodeList();
        for (ANode node : nodes) {
            if (type == NodeType.ATTRIBUTE) {
                for (ANode child : node.attributeIter()) {
                    if (Token.eq(child.qname().uri(), QueryText.XSI_URI)) continue;
                    list.add(child.finish());
                }
                continue;
            }
            for (ANode child : node.childIter()) {
                if (child.type != type) continue;
                list.add(child.finish());
            }
        }
        return list;
    }

    private static boolean differentNames(ANode node) {
        QNmSet names = new QNmSet();
        for (ANode child : PlanFn.children(NodeType.ELEMENT, node)) {
            if (child.type != NodeType.ELEMENT || names.add(child.qname())) continue;
            return false;
        }
        return !names.isEmpty();
    }

    private static boolean equalNames(ANodeList nodes) {
        QNm name = null;
        for (ANode node : nodes) {
            if (node.type != NodeType.ELEMENT) continue;
            if (name == null) {
                name = node.qname();
                continue;
            }
            if (name.eq(node.qname())) continue;
            return false;
        }
        return true;
    }

    private MapBuilder attributes(ANode node, Plan plan, QueryContext qc) throws QueryException {
        ANodeList attributes = PlanFn.children(NodeType.ATTRIBUTE, node);
        MapBuilder mb = new MapBuilder(attributes.size());
        for (ANode attr : attributes) {
            PlanEntry entry = plan.entries.get(attr.qname());
            Str value = Str.get(attr.string());
            mb.put(PlanFn.nodeName(attr, node, plan, qc), (Value)(entry != null ? entry.cast(value) : value));
        }
        return mb;
    }

    static byte[] nodeName(ANode node, ANode parent, Plan plan, QueryContext qc) {
        return PlanFn.nodeName(node.qname(), node.type == NodeType.ELEMENT, parent, plan, qc);
    }

    static byte[] nodeName(QNm qnm, boolean element, ANode parent, Plan plan, QueryContext qc) {
        byte[] name = switch (plan.name) {
            case NameFormat.EQNAME -> {
                if (qnm.uri().length != 0) {
                    yield qnm.eqName();
                }
                yield qnm.local();
            }
            case NameFormat.LEXICAL -> qnm.string();
            case NameFormat.LOCAL -> qnm.local();
            default -> (element ? (parent == null ? qnm.uri().length == 0 : Token.eq(parent.qname().uri(), qnm.uri())) : qnm.uri().length == 0) ? qnm.local() : (Token.eq(qnm.uri(), QueryText.XML_URI) ? qnm.string() : qnm.eqName());
        };
        return qc.shared.token(!element && plan.marker != null ? Token.concat(plan.marker, name) : name);
    }

    private XQArray list(ANode node, Plan plan, QueryContext qc) throws QueryException {
        ANodeList children = PlanFn.children(NodeType.ELEMENT, node);
        ArrayBuilder ab = new ArrayBuilder(qc, children.size());
        for (ANode ch : children) {
            ab.add(this.entry(ch, plan).apply(ch, null, plan, qc));
        }
        return ab.array();
    }

    private XQMap record(ANode node, Plan plan, QueryContext qc) throws QueryException {
        MapBuilder map = this.attributes(node, plan, qc);
        TokenObjectMap<ANodeList> cache = new TokenObjectMap<ANodeList>();
        for (ANode ch : PlanFn.children(NodeType.ELEMENT, node)) {
            cache.computeIfAbsent(PlanFn.nodeName(ch, node, plan, qc), ANodeList::new).add(ch);
        }
        for (byte[] name : cache) {
            ANodeList children = (ANodeList)cache.get(name);
            PlanEntry pe = this.entry((ANode)children.get(0), plan);
            if (pe.layout == PlanLayout.DEEP_SKIP) continue;
            ArrayBuilder ab = new ArrayBuilder(qc, children.size());
            for (ANode ch : children) {
                ab.add(pe.apply(ch, node, plan, qc));
            }
            XQArray array = ab.array();
            map.put(name, array.structSize() == 1L ? array.memberAt(0L) : array);
        }
        return map.map();
    }

    private XQArray mixed(ANode node, ANode parent, Plan plan, QueryContext qc, boolean ignoreEmpty) throws QueryException {
        ArrayBuilder ab = new ArrayBuilder();
        for (ANode attr : PlanFn.children(NodeType.ATTRIBUTE, node)) {
            ab.add(new MapBuilder().put(PlanFn.nodeName(attr, node, plan, qc), attr.string()).map());
        }
        for (ANode child : node.childIter()) {
            Str item;
            if ((item = (switch ((NodeType)child.type) {
                case NodeType.COMMENT -> new MapBuilder().put((Item)COMMENT, child.string()).map();
                case NodeType.ELEMENT -> new MapBuilder().put(PlanFn.nodeName(child, parent, plan, qc), (Value)this.entry(child, plan).apply(child, node, plan, qc)).map();
                case NodeType.PROCESSING_INSTRUCTION -> new MapBuilder().put((Item)PI, child.name()).put((Item)DATA, child.string()).map();
                case NodeType.TEXT -> {
                    byte[] text = child.string();
                    if (ignoreEmpty && Token.normalize(text).length == 0) {
                        yield null;
                    }
                    yield Str.get(text);
                }
                default -> null;
            })) == null) continue;
            ab.add(item);
        }
        return ab.array();
    }

    private static Str xml(ANode node) throws QueryException {
        try {
            return Str.get(node.serialize(new SerializerOptions()).finish());
        }
        catch (QueryIOException ex) {
            throw ex.getCause(null);
        }
    }

    static final class Plan {
        final QNmMap<PlanEntry> entries = new QNmMap();
        NameFormat name;
        String marker;

        Plan() {
        }
    }

    final class PlanEntry {
        boolean attribute;
        PlanLayout layout;
        PlanType type;
        QNm child;

        PlanEntry() {
        }

        Item cast(Item item) {
            if (this.type != null && this.type.type != null) {
                try {
                    return this.type.type.cast(item, null, PlanFn.this.info);
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                }
            }
            return item;
        }

        Item apply(ANode node, ANode parent, Plan plan, QueryContext qc) throws QueryException {
            PlanEntry pe;
            PlanEntry planEntry = pe = this.valid(node) ? this : plan.entries.get(QNm.EMPTY);
            if (pe != null) {
                try {
                    return pe.create(node, parent, plan, qc);
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                }
            }
            throw QueryError.PLAN_X_X.get(PlanFn.this.info, new Object[]{this.layout, node});
        }

        private boolean valid(ANode node) {
            return switch (this.layout) {
                case PlanLayout.EMPTY, PlanLayout.EMPTY_PLUS -> {
                    if (PlanFn.children(NodeType.ELEMENT, node).isEmpty() && PlanFn.empty(PlanFn.children(NodeType.TEXT, node))) {
                        yield true;
                    }
                    yield false;
                }
                case PlanLayout.SIMPLE, PlanLayout.SIMPLE_PLUS -> PlanFn.children(NodeType.ELEMENT, node).isEmpty();
                case PlanLayout.LIST, PlanLayout.LIST_PLUS -> {
                    ANodeList children = PlanFn.children(NodeType.ELEMENT, node);
                    if (PlanFn.empty(PlanFn.children(NodeType.TEXT, node)) && PlanFn.equalNames(children) && (children.isEmpty() || ((ANode)children.get(0)).qname().eq(this.child))) {
                        yield true;
                    }
                    yield false;
                }
                case PlanLayout.RECORD, PlanLayout.SEQUENCE -> PlanFn.empty(PlanFn.children(NodeType.TEXT, node));
                default -> true;
            };
        }

        private Item create(ANode node, ANode parent, Plan plan, QueryContext qc) throws QueryException {
            return switch (this.layout) {
                case PlanLayout.EMPTY -> Str.EMPTY;
                case PlanLayout.EMPTY_PLUS -> PlanFn.this.attributes(node, plan, qc).map();
                case PlanLayout.SIMPLE -> this.cast(Str.get(node.string()));
                case PlanLayout.SIMPLE_PLUS -> PlanFn.this.attributes(node, plan, qc).put((Item)CONTENT, (Value)this.cast(Str.get(node.string()))).map();
                case PlanLayout.LIST -> PlanFn.this.list(node, plan, qc);
                case PlanLayout.LIST_PLUS -> PlanFn.this.attributes(node, plan, qc).put(PlanFn.nodeName(this.child, true, node, plan, qc), (Value)PlanFn.this.list(node, plan, qc)).map();
                case PlanLayout.RECORD -> PlanFn.this.record(node, plan, qc);
                case PlanLayout.SEQUENCE -> PlanFn.this.mixed(node, parent, plan, qc, true);
                case PlanLayout.MIXED -> PlanFn.this.mixed(node, parent, plan, qc, false);
                case PlanLayout.XML -> PlanFn.xml(node);
                case PlanLayout.DEEP_SKIP -> Empty.VALUE;
                default -> throw QueryError.PLAN_X_X.get(null, this, node);
            };
        }
    }

    static enum PlanLayout {
        EMPTY,
        EMPTY_PLUS,
        SIMPLE,
        SIMPLE_PLUS,
        LIST,
        LIST_PLUS,
        RECORD,
        SEQUENCE,
        MIXED,
        XML,
        DEEP_SKIP,
        ERROR;


        public String toString() {
            return Enums.string(this);
        }
    }

    static enum PlanType {
        BOOLEAN(AtomType.BOOLEAN),
        NUMERIC(AtomType.NUMERIC),
        STRING(AtomType.STRING),
        SKIP(null);

        final AtomType type;

        private PlanType(AtomType type) {
            this.type = type;
        }

        static PlanType get(ANode ... nodes) {
            PlanType type = BOOLEAN;
            for (ANode node : nodes) {
                byte[] value = node.string();
                if (type == BOOLEAN && Bln.parse(value) == null) {
                    type = NUMERIC;
                }
                if (type != NUMERIC) continue;
                try {
                    Dbl.parse(value, null);
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                    type = STRING;
                    break;
                }
            }
            return type;
        }

        public String toString() {
            return Enums.string(this);
        }
    }

    static enum NameFormat {
        LEXICAL,
        LOCAL,
        EQNAME,
        DEFAULT;


        public String toString() {
            return Enums.string(this);
        }
    }
}

