/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.list.LongList;

public final class FnRemove
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final Iter input = this.arg(0).iter(qc);
        final LongList pos = this.positions(qc);
        if (input.valueIter() || pos.size() > 1) {
            return FnRemove.value(input.value(qc, null), pos, qc).iter();
        }
        final long size = input.size();
        return new Iter(){
            final long p;
            long c;
            {
                this.p = pos.get(0);
            }

            @Override
            public Item next() throws QueryException {
                return this.c++ != this.p || input.next() != null ? input.next() : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return input.get(i + 1L < this.p ? i : i + 1L);
            }

            @Override
            public long size() {
                return Math.max(-1L, size - 1L);
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value input = this.arg(0).value(qc);
        LongList positions = this.positions(qc);
        return FnRemove.value(input, positions, qc);
    }

    private static Value value(Value value, LongList positions, QueryContext qc) {
        Value val = value;
        for (int l = positions.size() - 1; l >= 0 && !val.isEmpty(); --l) {
            boolean last;
            long pos = positions.get(l);
            long size = val.size();
            boolean first = pos == 0L;
            boolean bl = last = pos == size - 1L;
            if (first || last) {
                val = val.subsequence(first ? 1L : 0L, size - 1L, qc);
                continue;
            }
            if (pos <= 0L || pos >= size) continue;
            val = val.removeItem(pos, qc);
        }
        return val;
    }

    private LongList positions(QueryContext qc) throws QueryException {
        Item item;
        LongList pos = new LongList();
        Iter iter = this.arg(1).iter(qc);
        while ((item = qc.next(iter)) != null) {
            pos.add(this.toLong(item) - 1L);
        }
        return pos.ddo();
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        if (this.values(false, cc)) {
            return this.value(cc.qc);
        }
        Expr input = this.arg(0);
        Expr pos = this.arg(1);
        SeqType st = input.seqType();
        if (st.zero()) {
            return input;
        }
        long sz = -1L;
        if (pos instanceof Item && pos.size() == 1L) {
            long p = this.toLong(pos, cc.qc);
            long size = input.size();
            if (p < 1L || size > 0L && p > size) {
                return input;
            }
            if (p == 1L) {
                return cc.function(Function.TAIL, this.info, input);
            }
            if (p == size) {
                return cc.function(Function.TRUNK, this.info, input);
            }
            --sz;
        }
        this.exprType.assign(st.union(Occ.ZERO), sz).data(input);
        return this;
    }

    @Override
    public boolean ddo() {
        return this.arg(0).ddo();
    }
}

