/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;

public final class ArchiveEntries
extends ArchiveFn {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Bin archive = this.toArchive(this.arg(0), qc);
        ValueBuilder vb = new ValueBuilder(qc);
        try (BufferInput bi = archive.input(this.info);){
            ArchiveIn in = ArchiveIn.get(bi, this.info);
            try {
                while (in.more()) {
                    ZipEntry ze = in.entry();
                    if (ze.isDirectory()) continue;
                    FBuilder elem = FElem.build(ArchiveText.Q_ENTRY).declareNS();
                    long size = ze.getSize();
                    if (size != -1L) {
                        elem.add(ArchiveText.Q_SIZE, size);
                    }
                    if ((size = ze.getTime()) != -1L) {
                        elem.add(ArchiveText.Q_LAST_MODIFIED, Dtm.get(size).string(this.info));
                    }
                    if ((size = ze.getCompressedSize()) != -1L) {
                        elem.add(ArchiveText.Q_COMPRESSED_SIZE, size);
                    }
                    vb.add(elem.add(ze.getName()).finish());
                }
                Value value = vb.value(this);
                if (in != null) {
                    in.close();
                }
                return value;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
    }
}

