/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.gui.text.SearchBar;
import org.basex.util.InterruptibleString;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class SearchContext {
    private static final int MAX = 10000000;
    final SearchBar bar;
    final boolean mcase;
    final boolean regex;
    final boolean multi;
    final boolean word;
    final String string;
    int nr;

    SearchContext(SearchBar bar, String text) {
        Object srch;
        this.bar = bar;
        this.mcase = bar.mcase.isSelected();
        this.word = bar.word.isSelected();
        this.regex = bar.regex.isSelected();
        this.multi = bar.multi.isSelected();
        Object object = srch = this.mcase ? text : text.toLowerCase(Locale.ENGLISH);
        if (this.regex && (((String)srch).startsWith(".*") || ((String)srch).startsWith("(.*") || ((String)srch).startsWith(".+") || ((String)srch).startsWith("(.+"))) {
            srch = "^" + (String)srch;
        }
        this.string = srch;
    }

    IntList[] search(byte[] txt, boolean jump) {
        IntList start = new IntList();
        IntList end = new IntList();
        if (!this.string.isEmpty()) {
            if (this.regex) {
                this.searchRegEx(start, end, txt);
            } else {
                this.searchSimple(start, end, txt);
            }
        }
        InterruptibleString.checkStop();
        this.nr = start.size();
        this.bar.refresh(this, jump);
        return new IntList[]{start, end};
    }

    private void searchRegEx(IntList start, IntList end, byte[] text) {
        int flags = 32;
        if (!this.mcase) {
            flags |= 2;
        }
        Pattern pattern = Pattern.compile(this.string, flags);
        if (this.multi) {
            int c = 0;
            int p = 0;
            Matcher m = pattern.matcher(new InterruptibleString(Token.string(text)));
            while (m.find()) {
                int s = m.start();
                int e = m.end();
                while (c < s) {
                    p += Token.cl(text, p);
                    ++c;
                }
                start.add(p);
                while (c < e) {
                    p += Token.cl(text, p);
                    ++c;
                }
                end.add(p);
                if (start.size() < 10000000) continue;
                return;
            }
        } else {
            int os = text.length;
            TokenBuilder tb = new TokenBuilder(os);
            int t = 0;
            for (int o = 0; o <= os; ++o) {
                InterruptibleString.checkStop();
                if (!(o < os ? text[o] == 10 : o != t)) continue;
                int c = 0;
                int p = t;
                Matcher m = pattern.matcher(new InterruptibleString(Token.string(text, t, o - t)));
                while (m.find()) {
                    int s = m.start();
                    int e = m.end();
                    while (c < s) {
                        p += Token.cl(text, p);
                        ++c;
                    }
                    start.add(p);
                    while (c < e) {
                        p += Token.cl(text, p);
                        ++c;
                    }
                    end.add(p);
                    if (start.size() < 10000000) continue;
                    return;
                }
                if (o < os) {
                    tb.add(10);
                }
                t = o + 1;
            }
        }
    }

    private void searchSimple(IntList start, IntList end, byte[] text) {
        byte[] srch = Token.token(this.string);
        int sl = srch.length;
        int tl = text.length;
        boolean s = true;
        int t = 0;
        while (t < tl) {
            int sp;
            InterruptibleString.checkStop();
            if (t + sl <= tl && s) {
                if (this.mcase) {
                    for (sp = 0; sp < sl && text[t + sp] == srch[sp]; ++sp) {
                    }
                } else {
                    while (sp < sl && Token.lc(Token.cp(text, t + sp)) == Token.cp(srch, sp)) {
                        sp += Token.cl(srch, sp);
                    }
                }
            }
            if (!(sp != sl || this.word && t + sl != tl && Character.isLetterOrDigit(Token.cp(text, t + sl)))) {
                start.add(t);
                end.add(t + sl);
                if (start.size() >= 10000000) {
                    return;
                }
                t += sl;
                s = !this.word;
                continue;
            }
            if (this.word) {
                s = !Character.isLetterOrDigit(Token.cp(text, t));
                t += Token.cl(text, t);
                continue;
            }
            ++t;
        }
    }

    boolean matches(String str) {
        if (str.isEmpty() || str.contains("\n")) {
            return true;
        }
        if (this.regex) {
            try {
                int flags = 32;
                if (!this.mcase) {
                    flags |= 2;
                }
                Pattern pattern = Pattern.compile(this.string, flags);
                return pattern.matcher(str).matches();
            }
            catch (Exception ex) {
                Util.debug(ex);
                return false;
            }
        }
        return this.mcase ? this.string.equals(str) : this.string.equalsIgnoreCase(str);
    }

    int nr() {
        return this.nr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SearchContext)) return false;
        SearchContext sc = (SearchContext)obj;
        if (this.mcase != sc.mcase) return false;
        if (this.word != sc.word) return false;
        if (this.regex != sc.regex) return false;
        if (this.multi != sc.multi) return false;
        if (!Strings.eq(this.string, sc.string)) return false;
        return true;
    }
}

