/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;

public final class GUIMenu
extends JMenuBar {
    private final JMenuItem[] items;
    private final GUI gui;

    GUIMenu(GUI gui) {
        this.gui = gui;
        int c = 0;
        for (GUICommand[] cmds : GUIConstants.MENUITEMS) {
            c += cmds.length;
        }
        this.items = new JMenuItem[c];
        c = 0;
        StringBuilder gmnem = new StringBuilder();
        int bl = GUIConstants.MENUBAR.length;
        for (int b = 0; b < bl; ++b) {
            JMenu menu = new JMenu(GUIConstants.MENUBAR[b]);
            BaseXLayout.setMnemonic(menu, gmnem);
            StringBuilder mnemCache = new StringBuilder();
            for (GUICommand cmd : GUIConstants.MENUITEMS[b]) {
                if (cmd == GUICommand.SEPARATOR) {
                    menu.addSeparator();
                    continue;
                }
                if (cmd == null) continue;
                JMenuItem item = GUIMenu.newItem(cmd, gui, mnemCache);
                item.setAccelerator(BaseXLayout.keyStroke(cmd));
                this.items[c++] = item;
                menu.add(item);
            }
            this.add(menu);
        }
    }

    public static JMenuItem newItem(GUICommand cmd, GUI gui, StringBuilder mnem) {
        String label = cmd.label();
        JMenuItem item = cmd.toggle() ? new JCheckBoxMenuItem(label) : new JMenuItem(label);
        item.addActionListener(e -> {
            if (!gui.updating) {
                cmd.execute(gui);
            }
        });
        BaseXLayout.setMnemonic(item, mnem);
        return item;
    }

    void refresh() {
        int c = 0;
        GUICommand[][] gUICommandArray = GUIConstants.MENUITEMS;
        int n = gUICommandArray.length;
        for (int i = 0; i < n; ++i) {
            GUICommand[] cmds;
            for (GUICommand cmd : cmds = gUICommandArray[i]) {
                if (cmd == GUICommand.SEPARATOR || cmd == null) continue;
                this.items[c].setEnabled(cmd.enabled(this.gui));
                this.items[c++].setSelected(cmd.selected(this.gui));
            }
        }
    }
}

