/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.util.Date;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.util.DateTime;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MetaProp {
    NAME(false){

        @Override
        public String value(MetaData meta) {
            return meta.name;
        }
    }
    ,
    SIZE(false){

        @Override
        public Long value(MetaData meta) {
            return meta.dbSize();
        }
    }
    ,
    NODES(false){

        @Override
        public Integer value(MetaData meta) {
            return meta.size;
        }
    }
    ,
    DOCUMENTS(false){

        @Override
        public Integer value(MetaData meta) {
            return meta.ndocs;
        }
    }
    ,
    BINARIES(false){

        @Override
        public Integer value(MetaData meta) {
            IOFile dir = meta.dir(ResourceType.BINARY);
            return dir != null ? dir.descendants().size() : 0;
        }
    }
    ,
    VALUES(false){

        @Override
        public Integer value(MetaData meta) {
            IOFile dir = meta.dir(ResourceType.VALUE);
            return dir != null ? dir.descendants().size() : 0;
        }
    }
    ,
    TIMESTAMP(false){

        @Override
        public String value(MetaData meta) {
            return DateTime.format(new Date(meta.dbTime()));
        }
    }
    ,
    UPTODATE(false){

        @Override
        public Boolean value(MetaData meta) {
            return meta.uptodate;
        }
    }
    ,
    INPUTPATH(false){

        @Override
        public String value(MetaData meta) {
            return meta.original;
        }
    }
    ,
    INPUTSIZE(false){

        @Override
        public Long value(MetaData meta) {
            return meta.inputsize;
        }
    }
    ,
    INPUTDATE(false){

        @Override
        public String value(MetaData meta) {
            return DateTime.format(new Date(meta.time));
        }
    }
    ,
    TEXTINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.textindex;
        }
    }
    ,
    ATTRINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.attrindex;
        }
    }
    ,
    TOKENINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.tokenindex;
        }
    }
    ,
    FTINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.ftindex;
        }
    }
    ,
    TEXTINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.textinclude;
        }
    }
    ,
    ATTRINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.attrinclude;
        }
    }
    ,
    TOKENINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.tokeninclude;
        }
    }
    ,
    FTINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.ftinclude;
        }
    }
    ,
    LANGUAGE(true){

        @Override
        public String value(MetaData meta) {
            return meta.language.toString();
        }
    }
    ,
    STEMMING(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.stemming;
        }
    }
    ,
    CASESENS(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.casesens;
        }
    }
    ,
    DIACRITICS(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.diacritics;
        }
    }
    ,
    STOPWORDS(true){

        @Override
        public String value(MetaData meta) {
            return meta.stopwords;
        }
    }
    ,
    UPDINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.updindex;
        }
    }
    ,
    AUTOOPTIMIZE(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.autooptimize;
        }
    }
    ,
    MAXCATS(true){

        @Override
        public Integer value(MetaData meta) {
            return meta.maxcats;
        }
    }
    ,
    MAXLEN(true){

        @Override
        public Integer value(MetaData meta) {
            return meta.maxlen;
        }
    }
    ,
    SPLITSIZE(true){

        @Override
        public Integer value(MetaData meta) {
            return meta.splitsize;
        }
    };

    public final boolean index;

    private MetaProp(boolean index) {
        this.index = index;
    }

    public abstract Object value(MetaData var1);
}

