/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.StringList;

public final class Lang {
    private static final String SUFFIX = "lang";
    private static final HashMap<String, String> TEXTS = new HashMap();
    private static final HashMap<String, Boolean> CHECK = new HashMap();

    private Lang() {
    }

    private static synchronized void read(String lang) {
        TEXTS.clear();
        CHECK.clear();
        String path = "lang/" + lang + ".lang";
        TokenObjectMap<byte[]> map = Util.properties(path);
        for (byte[] key : map) {
            String val;
            String name = Token.string(key);
            if (TEXTS.put(name, (val = Token.string(map.get(key))).replace("\n", Prop.NL)) != null) {
                Util.errln("%.lang: '%' is declared twice", lang, name);
            }
            CHECK.put(name, true);
        }
    }

    static synchronized String lang(String key) {
        if (key == null) {
            for (String s : CHECK.keySet()) {
                Util.errln("%.lang: '%' can be removed", Prop.language, s);
            }
            return "---";
        }
        String val = TEXTS.get(key);
        if (val == null) {
            Util.errln("%.lang: '%' is missing", Prop.language, key);
            return "[" + key + "]";
        }
        CHECK.remove(key);
        return val;
    }

    static synchronized String lang(String key, Object ... ext) {
        return Util.info(Lang.lang(key), ext);
    }

    public static synchronized String[][] parse() {
        StringList langs = new StringList();
        StringList creds = new StringList();
        try {
            URL url = Lang.class.getResource("/lang");
            if ("jar".equals(url.getProtocol())) {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                String pre = conn.getEntryName();
                JarFile jar = conn.getJarFile();
                for (JarEntry entry : Collections.list(jar.entries())) {
                    String name = entry.getName();
                    if (!name.startsWith(pre) || !name.endsWith(SUFFIX)) continue;
                    langs.add(name.replaceAll(".*/|.lang", ""));
                    creds.add(Lang.credits(new IOStream(jar.getInputStream(entry)).read()));
                }
            } else {
                for (IOFile file : ((IOFile)IO.get(url.toString())).children()) {
                    langs.add(file.name().replace(".lang", ""));
                    creds.add(Lang.credits(((IO)file).read()));
                }
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
        return new String[][]{(String[])langs.finish(), (String[])creds.finish()};
    }

    private static synchronized String credits(byte[] content) {
        StringTokenizer st = new StringTokenizer(Token.string(content), "\n");
        st.nextToken();
        return st.nextToken().replace("# ", "");
    }

    static void check() {
        IOFile[] files;
        Lang.read(Prop.language);
        StringBuilder sb = new StringBuilder();
        HashSet<String> set = new HashSet<String>(TEXTS.keySet());
        for (IOFile file : files = new IOFile("src/main/resources/lang").children()) {
            String lang = file.name().replace(".lang", "");
            if (lang.equals(Prop.language)) continue;
            Lang.read(lang);
            for (String text : (String[])set.toArray(String[]::new)) {
                if (TEXTS.remove(text) != null) continue;
                sb.append("- ").append(text).append('\n');
            }
            if (!sb.isEmpty()) {
                Util.err("Missing in %.lang:\n%", lang, sb);
                sb.setLength(0);
            }
            for (String s : TEXTS.keySet()) {
                sb.append("- ").append(s).append('\n');
            }
            if (sb.isEmpty()) continue;
            Util.err("Not defined in %.lang:\n%", lang, sb);
            sb.setLength(0);
        }
    }

    static {
        Lang.read(Prop.language);
    }
}

