/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.xquery.XQException;
import net.xqj.core.Factory;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.StringWriter;
import net.xqj.core.xqitem.XQItemBase;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class DocumentXQItem
extends XQItemBase
implements Cloneable {
    private XQItemBase child;
    private boolean isElement;

    private DocumentXQItem(XQItemBase child, boolean isElement) throws XQException {
        this.child = child;
        this.isElement = isElement;
    }

    public void setValue(XQItemBase child, boolean isElement) {
        this.child = child;
        this.isElement = isElement;
    }

    static DocumentXQItem newInstance(XQItemBase child, boolean isElement) throws XQException {
        return new DocumentXQItem(child, isElement);
    }

    @Override
    public void writeItem(OutputStream out, Properties properties) throws XQException {
        this.writeItem(Factory.newWriter(out, properties == null ? null : properties.getProperty("encoding"), properties == null ? false : "yes".equals(properties.getProperty("byte-order-mark"))), properties);
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        if (!XQToolkit.isToWriteXQuery(properties)) {
            this.child.writeItem(writer, properties);
        } else {
            try {
                writer.write("document { ");
            }
            catch (IOException e) {
                throw new XQExceptionImpl("Encountered write error.", "XQJDI002", e);
            }
            this.child.writeItem(writer, properties);
            try {
                writer.write(" }");
            }
            catch (IOException e) {
                throw new XQExceptionImpl("Encountered write error.", "XQJDI003", e);
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJDI006", e);
        }
    }

    @Override
    public Node getNode() throws XQException {
        if (this.isElement) {
            return this.child.getNode().getOwnerDocument();
        }
        DocumentFragment fragment = Factory.newDocumentFragment();
        fragment.appendChild(this.child.getNode());
        return fragment;
    }

    @Override
    public Object getObject() throws XQException {
        return this.getNode();
    }

    @Override
    public XMLStreamReader getItemAsStream() throws XQException {
        return this.child.getItemAsStream();
    }

    @Override
    public String getItemAsString(Properties properties) throws XQException {
        if (!XQToolkit.isToWriteXQuery(properties)) {
            return this.child.getItemAsString(properties);
        }
        StringWriter writer = new StringWriter();
        try {
            writer.write("document { ");
            writer.write(this.child.getItemAsString(properties));
            writer.write(" }");
            return writer.toString();
        }
        catch (IOException e) {
            throw new XQExceptionImpl("Encountered write error.", "XQJDI001", e);
        }
    }

    @Override
    public void writeItemToSAX(ContentHandler contenthandler) throws XQException {
        this.child.writeItemToSAX(contenthandler);
    }

    @Override
    public void writeItemToResult(Result result) throws XQException {
        this.child.writeItemToResult(result);
    }
}

