/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.ws;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.basex.http.ws.WebSocket;
import org.basex.http.ws.WsResponse;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.list.TokenList;
import org.eclipse.jetty.ee9.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.ee9.websocket.api.WriteCallback;

public final class WsPool {
    private static final ConcurrentHashMap<String, WebSocket> CLIENTS = new ConcurrentHashMap();
    private static final String PREFIX = "websocket";
    private static long websocketId = -1L;

    private WsPool() {
    }

    public static TokenList ids() {
        TokenList ids = new TokenList((long)CLIENTS.size());
        for (String key : CLIENTS.keySet()) {
            ids.add(key);
        }
        return ids;
    }

    static String add(WebSocket socket) {
        String id = WsPool.createId();
        CLIENTS.put(id, socket);
        return id;
    }

    static void remove(String id) {
        CLIENTS.remove(id);
    }

    public static void emit(Item message) throws QueryException {
        WsPool.send((Value)message, new ArrayList<WebSocket>(CLIENTS.values()));
    }

    public static void broadcast(Item message, String client) throws QueryException {
        ArrayList<WebSocket> list = new ArrayList<WebSocket>();
        for (Map.Entry<String, WebSocket> entry : CLIENTS.entrySet()) {
            if (client.equals(entry.getKey())) continue;
            list.add(entry.getValue());
        }
        WsPool.send((Value)message, list);
    }

    public static void send(Value message, String ... ids) throws QueryException {
        ArrayList<WebSocket> list = new ArrayList<WebSocket>(ids.length);
        for (String id : ids) {
            WebSocket ws = CLIENTS.get(id);
            if (ws == null) continue;
            list.add(ws);
        }
        WsPool.send(message, list);
    }

    public static WebSocket get(String id) {
        return CLIENTS.get(id);
    }

    private static void send(Value message, List<WebSocket> websockets) throws QueryException {
        ArrayList<Object> values;
        try {
            values = WsResponse.serialize((Iter)message.iter(), new SerializerOptions());
        }
        catch (QueryIOException ex) {
            throw ex.getCause();
        }
        for (WebSocket ws : websockets) {
            if (!ws.isConnected()) continue;
            RemoteEndpoint remote = ws.getSession().getRemote();
            for (Object e : values) {
                if (e instanceof ByteBuffer) {
                    ByteBuffer bb = (ByteBuffer)e;
                    remote.sendBytes(bb, WriteCallback.NOOP);
                    continue;
                }
                remote.sendString((String)e, WriteCallback.NOOP);
            }
        }
    }

    private static synchronized String createId() {
        websocketId = Math.max(0L, websocketId + 1L);
        return PREFIX + websocketId;
    }
}

