% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MedianCI.R
\name{MedianCI}
\alias{MedianCI}
\title{Confidence Interval for the Median}
\usage{
MedianCI(
  x,
  conf.level = 0.95,
  sides = c("two.sided", "left", "right"),
  method = c("exact", "boot"),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{conf.level}{confidence level of the interval}

\item{sides}{a character string specifying the side of the confidence
interval, must be one of \code{"two.sided"} (default), \code{"left"} or
\code{"right"}. You can specify just the initial letter. \code{"left"} would
be analogue to a hypothesis of \code{"greater"} in a \code{t.test}.}

\item{method}{defining the type of interval that should be calculated (one
out of \code{"exact"}, \code{"boot"}). Default is \code{"exact"}. See
Details.}

\item{na.rm}{logical. Should missing values be removed? Defaults to
\code{FALSE}.}

\item{\dots}{the dots are passed on to \code{\link[boot]{boot.ci}}. In particular,
the type of bootstrap confidence interval can be defined via this. The
defaults are \code{R=999} and \code{type="perc"}.}
}
\value{
a numeric vector with 3 elements: \item{median}{median}
\item{lwr.ci}{lower bound of the confidence interval} \item{upr.ci}{upper
bound of the confidence interval}
}
\description{
Calculate the confidence interval for the median.
}
\details{
The \code{"exact"} method is the way SAS is said to calculate the confidence
interval. This is also implemented in \code{\link{SignTest}}. The boot
confidence interval type is calculated by means of \code{\link[boot]{boot.ci}}
with default type \code{"perc"}.\cr Use \code{\link{sapply}},
resp.\code{\link{apply}}, to get the confidence intervals from a data.frame
or from a matrix.
}
\examples{

MedianCI(d.pizza$price, na.rm=TRUE)
MedianCI(d.pizza$price, conf.level=0.99, na.rm=TRUE)

t(round(sapply(d.pizza[,c("delivery_min","temperature","price")], MedianCI, na.rm=TRUE), 3))

MedianCI(d.pizza$price, na.rm=TRUE, method="exact")
MedianCI(d.pizza$price, na.rm=TRUE, method="boot")


x <- runif(100)

set.seed(448)
MedianCI(x, method="boot")

# ... the same as
set.seed(448)
MedianCI(x, method="boot", type="bca")

MedianCI(x, method="boot", type="basic")
MedianCI(x, method="boot", type="perc")
MedianCI(x, method="boot", type="norm", R=499)
# not supported:
MedianCI(x, method="boot", type="stud")

MedianCI(x, method="boot", sides="right")


}
\seealso{
\code{\link{wilcox.test}}, \code{\link{MeanCI}},
\code{\link{median}}, \code{\link{HodgesLehmann}}
}
\author{
Andri Signorell \href{mailto:andri@signorell.net}{andri@signorell.net}
}
\keyword{univar}
