/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.markup;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.languagetool.markup.TextPart;

public class AnnotatedText {
    private final List<TextPart> parts;
    private final Map<Integer, Integer> mapping;

    AnnotatedText(List<TextPart> parts, Map<Integer, Integer> mapping) {
        this.parts = Objects.requireNonNull(parts);
        this.mapping = Objects.requireNonNull(mapping);
    }

    public String getPlainText() {
        StringBuilder sb = new StringBuilder();
        for (TextPart part : this.parts) {
            if (part.getType() != TextPart.Type.TEXT) continue;
            sb.append(part.getPart());
        }
        return sb.toString();
    }

    public int getOriginalTextPositionFor(int plainTextPosition) {
        if (plainTextPosition < 0) {
            throw new RuntimeException("plainTextPosition must be >= 0: " + plainTextPosition);
        }
        Integer origPosition = this.mapping.get(plainTextPosition);
        if (origPosition != null) {
            return origPosition;
        }
        int minDiff = Integer.MAX_VALUE;
        Integer bestMatch = null;
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            int diff;
            int maybeClosePosition = entry.getKey();
            if (plainTextPosition <= maybeClosePosition || (diff = plainTextPosition - maybeClosePosition) < 0 || diff >= minDiff) continue;
            bestMatch = entry.getValue();
            minDiff = diff;
        }
        if (bestMatch == null) {
            throw new RuntimeException("Could not map " + plainTextPosition + " to original position");
        }
        return bestMatch + minDiff;
    }

    public String toString() {
        return StringUtils.join(this.parts, (String)"");
    }
}

