/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import net.loomchild.maligna.util.ResourceNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Version {
    private static final Log log = LogFactory.getLog(Version.class);
    public static final String VERSION_ATTRIBUTE = "Implementation-Version";
    public static final String DATE_ATTRIBUTE = "Build-Date";
    private static final String MANIFEST_PATH = "/META-INF/MANIFEST.MF";
    private static Version instance = new Version();
    private String version;
    private String date;

    public static Version getInstance() {
        return instance;
    }

    private Version() {
        try {
            Manifest manifest = this.getJarManifest(Version.class);
            this.version = manifest.getMainAttributes().getValue(VERSION_ATTRIBUTE);
            this.date = manifest.getMainAttributes().getValue(DATE_ATTRIBUTE);
        }
        catch (ResourceNotFoundException e) {
            log.debug((Object)"Version number cannot be retrieved.");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    private Manifest getJarManifest(Class<?> klass) {
        URL classUrl = klass.getResource(klass.getSimpleName() + ".class");
        if (classUrl == null) {
            throw new IllegalArgumentException("Class not found: " + klass.getName() + ".");
        }
        String classPath = classUrl.toString();
        int jarIndex = classPath.indexOf(33);
        if (jarIndex != -1) {
            String manifestPath = classPath.substring(0, jarIndex + 1) + MANIFEST_PATH;
            try {
                URL manifestUrl = new URL(manifestPath);
                InputStream manifestStream = manifestUrl.openStream();
                Manifest manifest = new Manifest(manifestStream);
                return manifest;
            }
            catch (IOException e) {
                throw new ResourceNotFoundException("IO Error retrieving manifest.", e);
            }
        }
        throw new ResourceNotFoundException("Class is not in a JAR archive " + klass.getName() + ".");
    }
}

